/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.function.Consumer;

public abstract class AbstractList<E>
extends AbstractCollection<E>
implements List<E> {
    protected transient int modCount = 0;

    protected AbstractList() {
    }

    @Override
    public boolean add(E e) {
        this.add(this.size(), e);
        return true;
    }

    @Override
    public abstract E get(int var1);

    @Override
    public E set(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object o) {
        ListIterator<E> it = this.listIterator();
        if (o == null) {
            while (it.hasNext()) {
                if (it.next() != null) continue;
                return it.previousIndex();
            }
        } else {
            while (it.hasNext()) {
                if (!o.equals(it.next())) continue;
                return it.previousIndex();
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        ListIterator<E> it = this.listIterator(this.size());
        if (o == null) {
            while (it.hasPrevious()) {
                if (it.previous() != null) continue;
                return it.nextIndex();
            }
        } else {
            while (it.hasPrevious()) {
                if (!o.equals(it.previous())) continue;
                return it.nextIndex();
            }
        }
        return -1;
    }

    @Override
    public void clear() {
        this.removeRange(0, this.size());
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        this.rangeCheckForAdd(index);
        boolean modified = false;
        for (E e : c) {
            this.add(index++, e);
            modified = true;
        }
        return modified;
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        this.rangeCheckForAdd(index);
        return new ListItr(index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        AbstractList.subListRangeCheck(fromIndex, toIndex, this.size());
        return this instanceof RandomAccess ? new RandomAccessSubList(this, fromIndex, toIndex) : new SubList(this, fromIndex, toIndex);
    }

    static void subListRangeCheck(int fromIndex, int toIndex, int size) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
        if (toIndex > size) {
            throw new IndexOutOfBoundsException("toIndex = " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        ListIterator<E> e1 = this.listIterator();
        ListIterator e2 = ((List)o).listIterator();
        while (e1.hasNext() && e2.hasNext()) {
            E o1 = e1.next();
            Object o2 = e2.next();
            if (o1 != null ? o1.equals(o2) : o2 == null) continue;
            return false;
        }
        return !e1.hasNext() && !e2.hasNext();
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (E e : this) {
            hashCode = 31 * hashCode + (e == null ? 0 : e.hashCode());
        }
        return hashCode;
    }

    protected void removeRange(int fromIndex, int toIndex) {
        ListIterator<E> it = this.listIterator(fromIndex);
        int n = toIndex - fromIndex;
        for (int i = 0; i < n; ++i) {
            it.next();
            it.remove();
        }
    }

    private void rangeCheckForAdd(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
        }
    }

    private String outOfBoundsMsg(int index) {
        return "Index: " + index + ", Size: " + this.size();
    }

    private class Itr
    implements Iterator<E> {
        int cursor = 0;
        int lastRet = -1;
        int expectedModCount;

        private Itr() {
            this.expectedModCount = AbstractList.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != AbstractList.this.size();
        }

        @Override
        public E next() {
            this.checkForComodification();
            try {
                int i = this.cursor;
                Object next = AbstractList.this.get(i);
                this.lastRet = i;
                this.cursor = i + 1;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkForComodification();
                throw new NoSuchElementException(e);
            }
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                AbstractList.this.remove(this.lastRet);
                if (this.lastRet < this.cursor) {
                    --this.cursor;
                }
                this.lastRet = -1;
                this.expectedModCount = AbstractList.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        final void checkForComodification() {
            if (AbstractList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator<E> {
        ListItr(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public E previous() {
            this.checkForComodification();
            try {
                int i = this.cursor - 1;
                Object previous = AbstractList.this.get(i);
                this.lastRet = this.cursor = i;
                return previous;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkForComodification();
                throw new NoSuchElementException(e);
            }
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void set(E e) {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                AbstractList.this.set(this.lastRet, e);
                this.expectedModCount = AbstractList.this.modCount;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void add(E e) {
            this.checkForComodification();
            try {
                int i = this.cursor;
                AbstractList.this.add(i, e);
                this.lastRet = -1;
                this.cursor = i + 1;
                this.expectedModCount = AbstractList.this.modCount;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private static class RandomAccessSubList<E>
    extends SubList<E>
    implements RandomAccess {
        RandomAccessSubList(AbstractList<E> root, int fromIndex, int toIndex) {
            super(root, fromIndex, toIndex);
        }

        RandomAccessSubList(RandomAccessSubList<E> parent, int fromIndex, int toIndex) {
            super(parent, fromIndex, toIndex);
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            RandomAccessSubList.subListRangeCheck(fromIndex, toIndex, this.size);
            return new RandomAccessSubList<E>(this, fromIndex, toIndex);
        }
    }

    private static class SubList<E>
    extends AbstractList<E> {
        private final AbstractList<E> root;
        private final SubList<E> parent;
        private final int offset;
        protected int size;

        public SubList(AbstractList<E> root, int fromIndex, int toIndex) {
            this.root = root;
            this.parent = null;
            this.offset = fromIndex;
            this.size = toIndex - fromIndex;
            this.modCount = root.modCount;
        }

        protected SubList(SubList<E> parent, int fromIndex, int toIndex) {
            this.root = parent.root;
            this.parent = parent;
            this.offset = parent.offset + fromIndex;
            this.size = toIndex - fromIndex;
            this.modCount = this.root.modCount;
        }

        @Override
        public E set(int index, E element) {
            Objects.checkIndex(index, this.size);
            this.checkForComodification();
            return this.root.set(this.offset + index, element);
        }

        @Override
        public E get(int index) {
            Objects.checkIndex(index, this.size);
            this.checkForComodification();
            return this.root.get(this.offset + index);
        }

        @Override
        public int size() {
            this.checkForComodification();
            return this.size;
        }

        @Override
        public void add(int index, E element) {
            this.rangeCheckForAdd(index);
            this.checkForComodification();
            this.root.add(this.offset + index, element);
            this.updateSizeAndModCount(1);
        }

        @Override
        public E remove(int index) {
            Objects.checkIndex(index, this.size);
            this.checkForComodification();
            E result = this.root.remove(this.offset + index);
            this.updateSizeAndModCount(-1);
            return result;
        }

        @Override
        protected void removeRange(int fromIndex, int toIndex) {
            this.checkForComodification();
            this.root.removeRange(this.offset + fromIndex, this.offset + toIndex);
            this.updateSizeAndModCount(fromIndex - toIndex);
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            return this.addAll(this.size, c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            this.rangeCheckForAdd(index);
            int cSize = c.size();
            if (cSize == 0) {
                return false;
            }
            this.checkForComodification();
            this.root.addAll(this.offset + index, c);
            this.updateSizeAndModCount(cSize);
            return true;
        }

        @Override
        public Iterator<E> iterator() {
            return this.listIterator();
        }

        @Override
        public ListIterator<E> listIterator(final int index) {
            this.checkForComodification();
            this.rangeCheckForAdd(index);
            return new ListIterator<E>(){
                private final ListIterator<E> i;
                {
                    this.i = root.listIterator(offset + index);
                }

                @Override
                public boolean hasNext() {
                    return this.nextIndex() < size;
                }

                @Override
                public E next() {
                    if (this.hasNext()) {
                        return this.i.next();
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public boolean hasPrevious() {
                    return this.previousIndex() >= 0;
                }

                @Override
                public E previous() {
                    if (this.hasPrevious()) {
                        return this.i.previous();
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public int nextIndex() {
                    return this.i.nextIndex() - offset;
                }

                @Override
                public int previousIndex() {
                    return this.i.previousIndex() - offset;
                }

                @Override
                public void remove() {
                    this.i.remove();
                    this.updateSizeAndModCount(-1);
                }

                @Override
                public void set(E e) {
                    this.i.set(e);
                }

                @Override
                public void add(E e) {
                    this.i.add(e);
                    this.updateSizeAndModCount(1);
                }
            };
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            SubList.subListRangeCheck(fromIndex, toIndex, this.size);
            return new SubList<E>(this, fromIndex, toIndex);
        }

        @Override
        private void rangeCheckForAdd(int index) {
            if (index < 0 || index > this.size) {
                throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
            }
        }

        @Override
        private String outOfBoundsMsg(int index) {
            return "Index: " + index + ", Size: " + this.size;
        }

        private void checkForComodification() {
            if (this.root.modCount != this.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        private void updateSizeAndModCount(int sizeChange) {
            SubList<E> slist = this;
            do {
                slist.size += sizeChange;
                slist.modCount = this.root.modCount;
            } while ((slist = slist.parent) != null);
        }
    }

    static final class RandomAccessSpliterator<E>
    implements Spliterator<E> {
        private final List<E> list;
        private int index;
        private int fence;
        private final AbstractList<E> alist;
        private int expectedModCount;

        RandomAccessSpliterator(List<E> list) {
            assert (list instanceof RandomAccess);
            this.list = list;
            this.index = 0;
            this.fence = -1;
            this.alist = list instanceof AbstractList ? (AbstractList)list : null;
            this.expectedModCount = this.alist != null ? this.alist.modCount : 0;
        }

        private RandomAccessSpliterator(RandomAccessSpliterator<E> parent, int origin, int fence) {
            this.list = parent.list;
            this.index = origin;
            this.fence = fence;
            this.alist = parent.alist;
            this.expectedModCount = parent.expectedModCount;
        }

        private int getFence() {
            List<E> lst = this.list;
            int hi = this.fence;
            if (hi < 0) {
                if (this.alist != null) {
                    this.expectedModCount = this.alist.modCount;
                }
                hi = this.fence = lst.size();
            }
            return hi;
        }

        @Override
        public Spliterator<E> trySplit() {
            RandomAccessSpliterator<E> randomAccessSpliterator;
            int lo = this.index;
            int hi = this.getFence();
            int mid = lo + hi >>> 1;
            if (lo >= mid) {
                randomAccessSpliterator = null;
            } else {
                this.index = mid;
                RandomAccessSpliterator<E> randomAccessSpliterator2 = new RandomAccessSpliterator<E>(this, lo, this.index);
                randomAccessSpliterator = randomAccessSpliterator2;
            }
            return randomAccessSpliterator;
        }

        @Override
        public boolean tryAdvance(Consumer<? super E> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int i = this.index;
            int hi = this.getFence();
            if (i < hi) {
                this.index = i + 1;
                action.accept(RandomAccessSpliterator.get(this.list, i));
                RandomAccessSpliterator.checkAbstractListModCount(this.alist, this.expectedModCount);
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            Objects.requireNonNull(action);
            List<E> lst = this.list;
            int hi = this.getFence();
            this.index = hi;
            for (int i = this.index; i < hi; ++i) {
                action.accept(RandomAccessSpliterator.get(lst, i));
            }
            RandomAccessSpliterator.checkAbstractListModCount(this.alist, this.expectedModCount);
        }

        @Override
        public long estimateSize() {
            return this.getFence() - this.index;
        }

        @Override
        public int characteristics() {
            return 16464;
        }

        private static <E> E get(List<E> list, int i) {
            try {
                return list.get(i);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }

        static void checkAbstractListModCount(AbstractList<?> alist, int expectedModCount) {
            if (alist != null && alist.modCount != expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

