/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.CollSer;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.KeyValueHolder;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import jdk.internal.ValueBased;
import jdk.internal.access.JavaUtilCollectionAccess;
import jdk.internal.access.SharedSecrets;
import jdk.internal.misc.CDS;
import jdk.internal.vm.annotation.Stable;

class ImmutableCollections {
    private static final long SALT32L;
    private static final boolean REVERSE;
    private static Object[] archivedObjects;
    private static final Object EMPTY;
    static final ListN<?> EMPTY_LIST;
    static final ListN<?> EMPTY_LIST_NULLS;
    static final SetN<?> EMPTY_SET;
    static final MapN<?, ?> EMPTY_MAP;
    static final int EXPAND_FACTOR = 2;

    private ImmutableCollections() {
    }

    static UnsupportedOperationException uoe() {
        return new UnsupportedOperationException();
    }

    static <E> List<E> listCopy(Collection<? extends E> coll) {
        if (coll instanceof List12 || coll instanceof ListN && !((ListN)coll).allowNulls) {
            return (List)coll;
        }
        return List.of(coll.toArray());
    }

    @SafeVarargs
    static <E> List<E> listFromArray(E ... input) {
        Object[] tmp = new Object[input.length];
        for (int i = 0; i < input.length; ++i) {
            tmp[i] = Objects.requireNonNull(input[i]);
        }
        return new ListN<Object>(tmp, false);
    }

    static <E> List<E> listFromTrustedArray(Object ... input) {
        assert (input.getClass() == Object[].class);
        for (Object o : input) {
            Objects.requireNonNull(o);
        }
        return switch (input.length) {
            case 0 -> EMPTY_LIST;
            case 1 -> new List12<Object>(input[0]);
            case 2 -> new List12<Object>(input[0], input[1]);
            default -> new ListN<Object>(input, false);
        };
    }

    static <E> List<E> listFromTrustedArrayNullsAllowed(Object ... input) {
        assert (input.getClass() == Object[].class);
        if (input.length == 0) {
            return EMPTY_LIST_NULLS;
        }
        return new ListN<Object>(input, true);
    }

    static {
        long color = 2611923443488327891L;
        long seed = CDS.getRandomSeedForDumping();
        if (seed == 0L) {
            seed = System.nanoTime();
        }
        REVERSE = ((SALT32L = (long)((int)(color * seed >> 16)) & 0xFFFFFFFFL) & 1L) == 0L;
        CDS.initializeFromArchive(ImmutableCollections.class);
        if (archivedObjects == null) {
            EMPTY = new Object();
            EMPTY_LIST = new ListN<Object>(new Object[0], false);
            EMPTY_LIST_NULLS = new ListN<Object>(new Object[0], true);
            EMPTY_SET = new SetN<Object>(new Object[0]);
            EMPTY_MAP = new MapN(new Object[0]);
            archivedObjects = new Object[]{EMPTY, EMPTY_LIST, EMPTY_LIST_NULLS, EMPTY_SET, EMPTY_MAP};
        } else {
            EMPTY = archivedObjects[0];
            EMPTY_LIST = (ListN)archivedObjects[1];
            EMPTY_LIST_NULLS = (ListN)archivedObjects[2];
            EMPTY_SET = (SetN)archivedObjects[3];
            EMPTY_MAP = (MapN)archivedObjects[4];
        }
    }

    @ValueBased
    static final class List12<E>
    extends AbstractImmutableList<E>
    implements Serializable {
        @Stable
        private final E e0;
        @Stable
        private final Object e1;

        List12(E e0) {
            this.e0 = Objects.requireNonNull(e0);
            this.e1 = EMPTY;
        }

        List12(E e0, E e1) {
            this.e0 = Objects.requireNonNull(e0);
            this.e1 = Objects.requireNonNull(e1);
        }

        @Override
        public int size() {
            return this.e1 != EMPTY ? 2 : 1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public E get(int index) {
            if (index == 0) {
                return this.e0;
            }
            if (index == 1 && this.e1 != EMPTY) {
                return (E)this.e1;
            }
            throw this.outOfBounds(index);
        }

        @Override
        public int indexOf(Object o) {
            Objects.requireNonNull(o);
            if (o.equals(this.e0)) {
                return 0;
            }
            if (this.e1 != EMPTY && o.equals(this.e1)) {
                return 1;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            Objects.requireNonNull(o);
            if (this.e1 != EMPTY && o.equals(this.e1)) {
                return 1;
            }
            if (o.equals(this.e0)) {
                return 0;
            }
            return -1;
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw new InvalidObjectException("not serial proxy");
        }

        private Object writeReplace() {
            if (this.e1 == EMPTY) {
                return new CollSer(1, this.e0);
            }
            return new CollSer(1, this.e0, this.e1);
        }

        @Override
        public Object[] toArray() {
            if (this.e1 == EMPTY) {
                return new Object[]{this.e0};
            }
            return new Object[]{this.e0, this.e1};
        }

        @Override
        public <T> T[] toArray(T[] a) {
            int size = this.size();
            T[] array = a.length >= size ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), size);
            array[0] = this.e0;
            if (size == 2) {
                array[1] = this.e1;
            }
            if (array.length > size) {
                array[size] = null;
            }
            return array;
        }
    }

    @ValueBased
    static final class ListN<E>
    extends AbstractImmutableList<E>
    implements Serializable {
        @Stable
        private final E[] elements;
        @Stable
        private final boolean allowNulls;

        private ListN(E[] elements, boolean allowNulls) {
            this.elements = elements;
            this.allowNulls = allowNulls;
        }

        @Override
        public boolean isEmpty() {
            return this.elements.length == 0;
        }

        @Override
        public int size() {
            return this.elements.length;
        }

        @Override
        public E get(int index) {
            return this.elements[index];
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw new InvalidObjectException("not serial proxy");
        }

        private Object writeReplace() {
            return new CollSer(this.allowNulls ? 4 : 1, this.elements);
        }

        @Override
        public Object[] toArray() {
            return Arrays.copyOf(this.elements, this.elements.length);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            int size = this.elements.length;
            if (a.length < size) {
                return Arrays.copyOf(this.elements, size, a.getClass());
            }
            System.arraycopy(this.elements, 0, a, 0, size);
            if (a.length > size) {
                a[size] = null;
            }
            return a;
        }

        @Override
        public int indexOf(Object o) {
            if (!this.allowNulls && o == null) {
                throw new NullPointerException();
            }
            E[] es = this.elements;
            for (int i = 0; i < es.length; ++i) {
                if (!Objects.equals(o, es[i])) continue;
                return i;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            if (!this.allowNulls && o == null) {
                throw new NullPointerException();
            }
            E[] es = this.elements;
            for (int i = es.length - 1; i >= 0; --i) {
                if (!Objects.equals(o, es[i])) continue;
                return i;
            }
            return -1;
        }
    }

    @ValueBased
    static final class SetN<E>
    extends AbstractImmutableSet<E>
    implements Serializable {
        @Stable
        final E[] elements;
        @Stable
        final int size;

        @SafeVarargs
        SetN(E ... input) {
            this.size = input.length;
            this.elements = new Object[2 * input.length];
            for (int i = 0; i < input.length; ++i) {
                E e = input[i];
                int idx = this.probe(e);
                if (idx >= 0) {
                    throw new IllegalArgumentException("duplicate element: " + e);
                }
                this.elements[-(idx + 1)] = e;
            }
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean isEmpty() {
            return this.size == 0;
        }

        @Override
        public boolean contains(Object o) {
            Objects.requireNonNull(o);
            return this.size > 0 && this.probe(o) >= 0;
        }

        @Override
        public Iterator<E> iterator() {
            return new SetNIterator();
        }

        @Override
        public int hashCode() {
            int h = 0;
            for (E e : this.elements) {
                if (e == null) continue;
                h += e.hashCode();
            }
            return h;
        }

        private int probe(Object pe) {
            int idx = Math.floorMod(pe.hashCode(), this.elements.length);
            E ee;
            while ((ee = this.elements[idx]) != null) {
                if (pe.equals(ee)) {
                    return idx;
                }
                if (++idx != this.elements.length) continue;
                idx = 0;
            }
            return -idx - 1;
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw new InvalidObjectException("not serial proxy");
        }

        private Object writeReplace() {
            Object[] array = new Object[this.size];
            int dest = 0;
            for (E o : this.elements) {
                if (o == null) continue;
                array[dest++] = o;
            }
            return new CollSer(2, array);
        }

        @Override
        public Object[] toArray() {
            Object[] array = new Object[this.size];
            Iterator<E> it = this.iterator();
            for (int i = 0; i < this.size; ++i) {
                array[i] = it.next();
            }
            return array;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            T[] array = a.length >= this.size ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
            Iterator<E> it = this.iterator();
            for (int i = 0; i < this.size; ++i) {
                array[i] = it.next();
            }
            if (array.length > this.size) {
                array[this.size] = null;
            }
            return array;
        }

        private final class SetNIterator
        implements Iterator<E> {
            private int remaining;
            private int idx;

            SetNIterator() {
                this.remaining = SetN.this.size;
                this.idx = (int)(SALT32L * (long)SetN.this.elements.length >>> 32);
            }

            @Override
            public boolean hasNext() {
                return this.remaining > 0;
            }

            @Override
            public E next() {
                if (this.remaining > 0) {
                    Object element;
                    int idx = this.idx;
                    int len = SetN.this.elements.length;
                    do {
                        if (REVERSE) {
                            if (++idx < len) continue;
                            idx = 0;
                            continue;
                        }
                        if (--idx >= 0) continue;
                        idx = len - 1;
                    } while ((element = SetN.this.elements[idx]) == null);
                    this.idx = idx;
                    --this.remaining;
                    return element;
                }
                throw new NoSuchElementException();
            }
        }
    }

    @ValueBased
    static final class MapN<K, V>
    extends AbstractImmutableMap<K, V> {
        @Stable
        final Object[] table;
        @Stable
        final int size;

        MapN(Object ... input) {
            if ((input.length & 1) != 0) {
                throw new InternalError("length is odd");
            }
            this.size = input.length >> 1;
            int len = 2 * input.length;
            len = len + 1 & 0xFFFFFFFE;
            this.table = new Object[len];
            for (int i = 0; i < input.length; i += 2) {
                Object k = Objects.requireNonNull(input[i]);
                Object v = Objects.requireNonNull(input[i + 1]);
                int idx = this.probe(k);
                if (idx >= 0) {
                    throw new IllegalArgumentException("duplicate key: " + k);
                }
                int dest = -(idx + 1);
                this.table[dest] = k;
                this.table[dest + 1] = v;
            }
        }

        @Override
        public boolean containsKey(Object o) {
            Objects.requireNonNull(o);
            return this.size > 0 && this.probe(o) >= 0;
        }

        @Override
        public boolean containsValue(Object o) {
            Objects.requireNonNull(o);
            for (int i = 1; i < this.table.length; i += 2) {
                Object v = this.table[i];
                if (v == null || !o.equals(v)) continue;
                return true;
            }
            return false;
        }

        @Override
        public int hashCode() {
            int hash = 0;
            for (int i = 0; i < this.table.length; i += 2) {
                Object k = this.table[i];
                if (k == null) continue;
                hash += k.hashCode() ^ this.table[i + 1].hashCode();
            }
            return hash;
        }

        @Override
        public V get(Object o) {
            if (this.size == 0) {
                Objects.requireNonNull(o);
                return null;
            }
            int i = this.probe(o);
            if (i >= 0) {
                return (V)this.table[i + 1];
            }
            return null;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean isEmpty() {
            return this.size == 0;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public int size() {
                    return size;
                }

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return new MapNIterator();
                }
            };
        }

        private int probe(Object pk) {
            int idx = Math.floorMod(pk.hashCode(), this.table.length >> 1) << 1;
            Object ek;
            while ((ek = this.table[idx]) != null) {
                if (pk.equals(ek)) {
                    return idx;
                }
                if ((idx += 2) != this.table.length) continue;
                idx = 0;
            }
            return -idx - 1;
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw new InvalidObjectException("not serial proxy");
        }

        private Object writeReplace() {
            Object[] array = new Object[2 * this.size];
            int len = this.table.length;
            int dest = 0;
            for (int i = 0; i < len; i += 2) {
                if (this.table[i] == null) continue;
                array[dest++] = this.table[i];
                array[dest++] = this.table[i + 1];
            }
            return new CollSer(3, array);
        }

        class MapNIterator
        implements Iterator<Map.Entry<K, V>> {
            private int remaining;
            private int idx;

            MapNIterator() {
                this.remaining = MapN.this.size;
                this.idx = (int)(SALT32L * (long)(MapN.this.table.length >> 1) >>> 32) << 1;
            }

            @Override
            public boolean hasNext() {
                return this.remaining > 0;
            }

            private int nextIndex() {
                int idx = this.idx;
                if (REVERSE) {
                    if ((idx += 2) >= MapN.this.table.length) {
                        idx = 0;
                    }
                } else if ((idx -= 2) < 0) {
                    idx = MapN.this.table.length - 2;
                }
                this.idx = idx;
                return this.idx;
            }

            @Override
            public Map.Entry<K, V> next() {
                if (this.remaining > 0) {
                    int idx;
                    while (MapN.this.table[idx = this.nextIndex()] == null) {
                    }
                    KeyValueHolder<Object, Object> e = new KeyValueHolder<Object, Object>(MapN.this.table[idx], MapN.this.table[idx + 1]);
                    --this.remaining;
                    return e;
                }
                throw new NoSuchElementException();
            }
        }
    }

    @ValueBased
    static final class Map1<K, V>
    extends AbstractImmutableMap<K, V> {
        @Stable
        private final K k0;
        @Stable
        private final V v0;

        Map1(K k0, V v0) {
            this.k0 = Objects.requireNonNull(k0);
            this.v0 = Objects.requireNonNull(v0);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return Set.of(new KeyValueHolder<K, V>(this.k0, this.v0));
        }

        @Override
        public V get(Object o) {
            return o.equals(this.k0) ? (V)this.v0 : null;
        }

        @Override
        public boolean containsKey(Object o) {
            return o.equals(this.k0);
        }

        @Override
        public boolean containsValue(Object o) {
            return o.equals(this.v0);
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw new InvalidObjectException("not serial proxy");
        }

        private Object writeReplace() {
            return new CollSer(3, this.k0, this.v0);
        }

        @Override
        public int hashCode() {
            return this.k0.hashCode() ^ this.v0.hashCode();
        }
    }

    @ValueBased
    static abstract class AbstractImmutableMap<K, V>
    extends AbstractMap<K, V>
    implements Serializable {
        AbstractImmutableMap() {
        }

        @Override
        public void clear() {
            throw ImmutableCollections.uoe();
        }

        @Override
        public V compute(K key, BiFunction<? super K, ? super V, ? extends V> rf) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public V computeIfAbsent(K key, Function<? super K, ? extends V> mf) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> rf) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> rf) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public V put(K key, V value) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public V putIfAbsent(K key, V value) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public V remove(Object key) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean remove(Object key, Object value) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public V replace(K key, V value) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean replace(K key, V oldValue, V newValue) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public void replaceAll(BiFunction<? super K, ? super V, ? extends V> f) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public V getOrDefault(Object key, V defaultValue) {
            Object v = this.get(key);
            return v != null ? v : defaultValue;
        }
    }

    @ValueBased
    static final class Set12<E>
    extends AbstractImmutableSet<E>
    implements Serializable {
        @Stable
        private final E e0;
        @Stable
        private final Object e1;

        Set12(E e0) {
            this.e0 = Objects.requireNonNull(e0);
            this.e1 = EMPTY;
        }

        Set12(E e0, E e1) {
            if (e0.equals(Objects.requireNonNull(e1))) {
                throw new IllegalArgumentException("duplicate element: " + e0);
            }
            this.e0 = e0;
            this.e1 = e1;
        }

        @Override
        public int size() {
            return this.e1 == EMPTY ? 1 : 2;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean contains(Object o) {
            return o.equals(this.e0) || this.e1.equals(o);
        }

        @Override
        public int hashCode() {
            return this.e0.hashCode() + (this.e1 == EMPTY ? 0 : this.e1.hashCode());
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator<E>(){
                private int idx;
                {
                    this.idx = e1 == EMPTY ? 1 : 2;
                }

                @Override
                public boolean hasNext() {
                    return this.idx > 0;
                }

                @Override
                public E next() {
                    if (this.idx == 1) {
                        this.idx = 0;
                        return REVERSE || e1 == EMPTY ? e0 : e1;
                    }
                    if (this.idx == 2) {
                        this.idx = 1;
                        return REVERSE ? e1 : e0;
                    }
                    throw new NoSuchElementException();
                }
            };
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw new InvalidObjectException("not serial proxy");
        }

        private Object writeReplace() {
            if (this.e1 == EMPTY) {
                return new CollSer(2, this.e0);
            }
            return new CollSer(2, this.e0, this.e1);
        }

        @Override
        public Object[] toArray() {
            if (this.e1 == EMPTY) {
                return new Object[]{this.e0};
            }
            if (REVERSE) {
                return new Object[]{this.e1, this.e0};
            }
            return new Object[]{this.e0, this.e1};
        }

        @Override
        public <T> T[] toArray(T[] a) {
            T[] array;
            int size = this.size();
            Object[] objectArray = array = a.length >= size ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), size);
            if (size == 1) {
                array[0] = this.e0;
            } else if (REVERSE) {
                array[0] = this.e1;
                array[1] = this.e0;
            } else {
                array[0] = this.e0;
                array[1] = this.e1;
            }
            if (array.length > size) {
                array[size] = null;
            }
            return array;
        }
    }

    @ValueBased
    static abstract class AbstractImmutableSet<E>
    extends AbstractImmutableCollection<E>
    implements Set<E> {
        AbstractImmutableSet() {
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Set)) {
                return false;
            }
            Collection c = (Collection)o;
            if (c.size() != this.size()) {
                return false;
            }
            for (Object e : c) {
                if (e != null && this.contains(e)) continue;
                return false;
            }
            return true;
        }

        @Override
        public abstract int hashCode();
    }

    static final class SubList<E>
    extends AbstractImmutableList<E>
    implements RandomAccess {
        @Stable
        private final AbstractImmutableList<E> root;
        @Stable
        private final int offset;
        @Stable
        private final int size;

        private SubList(AbstractImmutableList<E> root, int offset, int size) {
            assert (root instanceof List12 || root instanceof ListN);
            this.root = root;
            this.offset = offset;
            this.size = size;
        }

        static <E> SubList<E> fromSubList(SubList<E> parent, int fromIndex, int toIndex) {
            return new SubList<E>(parent.root, parent.offset + fromIndex, toIndex - fromIndex);
        }

        static <E> SubList<E> fromList(AbstractImmutableList<E> list, int fromIndex, int toIndex) {
            return new SubList<E>(list, fromIndex, toIndex - fromIndex);
        }

        @Override
        public E get(int index) {
            Objects.checkIndex(index, this.size);
            return this.root.get(this.offset + index);
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public Iterator<E> iterator() {
            return new ListItr(this, this.size());
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            this.rangeCheck(index);
            return new ListItr(this, this.size(), index);
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            SubList.subListRangeCheck(fromIndex, toIndex, this.size);
            return SubList.fromSubList(this, fromIndex, toIndex);
        }

        private void rangeCheck(int index) {
            if (index < 0 || index > this.size) {
                throw this.outOfBounds(index);
            }
        }

        private boolean allowNulls() {
            return this.root instanceof ListN && ((ListN)this.root).allowNulls;
        }

        @Override
        public int indexOf(Object o) {
            if (!this.allowNulls() && o == null) {
                throw new NullPointerException();
            }
            int s = this.size();
            for (int i = 0; i < s; ++i) {
                if (!Objects.equals(o, this.get(i))) continue;
                return i;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            if (!this.allowNulls() && o == null) {
                throw new NullPointerException();
            }
            for (int i = this.size() - 1; i >= 0; --i) {
                if (!Objects.equals(o, this.get(i))) continue;
                return i;
            }
            return -1;
        }

        @Override
        public Object[] toArray() {
            Object[] array = new Object[this.size];
            for (int i = 0; i < this.size; ++i) {
                array[i] = this.get(i);
            }
            return array;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            T[] array = a.length >= this.size ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
            for (int i = 0; i < this.size; ++i) {
                array[i] = this.get(i);
            }
            if (array.length > this.size) {
                array[this.size] = null;
            }
            return array;
        }
    }

    static final class ListItr<E>
    implements ListIterator<E> {
        @Stable
        private final List<E> list;
        @Stable
        private final int size;
        @Stable
        private final boolean isListIterator;
        private int cursor;

        ListItr(List<E> list, int size) {
            this.list = list;
            this.size = size;
            this.cursor = 0;
            this.isListIterator = false;
        }

        ListItr(List<E> list, int size, int index) {
            this.list = list;
            this.size = size;
            this.cursor = index;
            this.isListIterator = true;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != this.size;
        }

        @Override
        public E next() {
            try {
                int i = this.cursor;
                E next = this.list.get(i);
                this.cursor = i + 1;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean hasPrevious() {
            if (!this.isListIterator) {
                throw ImmutableCollections.uoe();
            }
            return this.cursor != 0;
        }

        @Override
        public E previous() {
            if (!this.isListIterator) {
                throw ImmutableCollections.uoe();
            }
            try {
                int i = this.cursor - 1;
                E previous = this.list.get(i);
                this.cursor = i;
                return previous;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public int nextIndex() {
            if (!this.isListIterator) {
                throw ImmutableCollections.uoe();
            }
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            if (!this.isListIterator) {
                throw ImmutableCollections.uoe();
            }
            return this.cursor - 1;
        }

        @Override
        public void set(E e) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public void add(E e) {
            throw ImmutableCollections.uoe();
        }
    }

    @ValueBased
    static abstract class AbstractImmutableList<E>
    extends AbstractImmutableCollection<E>
    implements List<E>,
    RandomAccess {
        AbstractImmutableList() {
        }

        @Override
        public void add(int index, E element) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public E remove(int index) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public void replaceAll(UnaryOperator<E> operator) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public E set(int index, E element) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public void sort(Comparator<? super E> c) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            int size = this.size();
            AbstractImmutableList.subListRangeCheck(fromIndex, toIndex, size);
            return SubList.fromList(this, fromIndex, toIndex);
        }

        static void subListRangeCheck(int fromIndex, int toIndex, int size) {
            if (fromIndex < 0) {
                throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
            }
            if (toIndex > size) {
                throw new IndexOutOfBoundsException("toIndex = " + toIndex);
            }
            if (fromIndex > toIndex) {
                throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
            }
        }

        @Override
        public Iterator<E> iterator() {
            return new ListItr(this, this.size());
        }

        @Override
        public ListIterator<E> listIterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            int size = this.size();
            if (index < 0 || index > size) {
                throw this.outOfBounds(index);
            }
            return new ListItr(this, size, index);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof List)) {
                return false;
            }
            Iterator oit = ((List)o).iterator();
            int s = this.size();
            for (int i = 0; i < s; ++i) {
                if (oit.hasNext() && Objects.equals(this.get(i), oit.next())) continue;
                return false;
            }
            return !oit.hasNext();
        }

        @Override
        public int hashCode() {
            int hash = 1;
            int s = this.size();
            for (int i = 0; i < s; ++i) {
                hash = 31 * hash + Objects.hashCode(this.get(i));
            }
            return hash;
        }

        @Override
        public boolean contains(Object o) {
            return this.indexOf(o) >= 0;
        }

        IndexOutOfBoundsException outOfBounds(int index) {
            return new IndexOutOfBoundsException("Index: " + index + " Size: " + this.size());
        }
    }

    @ValueBased
    static abstract class AbstractImmutableCollection<E>
    extends AbstractCollection<E> {
        AbstractImmutableCollection() {
        }

        @Override
        public boolean add(E e) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public void clear() {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean remove(Object o) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean removeIf(Predicate<? super E> filter) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw ImmutableCollections.uoe();
        }
    }

    static class Access {
        Access() {
        }

        static {
            SharedSecrets.setJavaUtilCollectionAccess(new JavaUtilCollectionAccess(){

                @Override
                public <E> List<E> listFromTrustedArray(Object[] array) {
                    return ImmutableCollections.listFromTrustedArray(array);
                }

                @Override
                public <E> List<E> listFromTrustedArrayNullsAllowed(Object[] array) {
                    return ImmutableCollections.listFromTrustedArrayNullsAllowed(array);
                }
            });
        }
    }
}

