/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;

public class LinkedHashMap<K, V>
extends HashMap<K, V>
implements Map<K, V> {
    private static final long serialVersionUID = 3801124242820219131L;
    transient Entry<K, V> head;
    transient Entry<K, V> tail;
    final boolean accessOrder;

    private void linkNodeLast(Entry<K, V> p) {
        Entry<K, V> last = this.tail;
        this.tail = p;
        if (last == null) {
            this.head = p;
        } else {
            p.before = last;
            last.after = p;
        }
    }

    private void transferLinks(Entry<K, V> src, Entry<K, V> dst) {
        Entry b = dst.before = src.before;
        Entry a = dst.after = src.after;
        if (b == null) {
            this.head = dst;
        } else {
            b.after = dst;
        }
        if (a == null) {
            this.tail = dst;
        } else {
            a.before = dst;
        }
    }

    @Override
    void reinitialize() {
        super.reinitialize();
        this.tail = null;
        this.head = null;
    }

    @Override
    HashMap.Node<K, V> newNode(int hash, K key, V value, HashMap.Node<K, V> e) {
        Entry<K, V> p = new Entry<K, V>(hash, key, value, e);
        this.linkNodeLast(p);
        return p;
    }

    @Override
    HashMap.Node<K, V> replacementNode(HashMap.Node<K, V> p, HashMap.Node<K, V> next) {
        Entry q = (Entry)p;
        Entry<Object, Object> t = new Entry<Object, Object>(q.hash, q.key, q.value, next);
        this.transferLinks(q, t);
        return t;
    }

    @Override
    HashMap.TreeNode<K, V> newTreeNode(int hash, K key, V value, HashMap.Node<K, V> next) {
        HashMap.TreeNode<K, V> p = new HashMap.TreeNode<K, V>(hash, key, value, next);
        this.linkNodeLast(p);
        return p;
    }

    @Override
    HashMap.TreeNode<K, V> replacementTreeNode(HashMap.Node<K, V> p, HashMap.Node<K, V> next) {
        Entry q = (Entry)p;
        HashMap.TreeNode<Object, Object> t = new HashMap.TreeNode<Object, Object>(q.hash, q.key, q.value, next);
        this.transferLinks(q, t);
        return t;
    }

    @Override
    void afterNodeRemoval(HashMap.Node<K, V> e) {
        Entry p = (Entry)e;
        Entry b = p.before;
        Entry a = p.after;
        p.after = null;
        p.before = null;
        if (b == null) {
            this.head = a;
        } else {
            b.after = a;
        }
        if (a == null) {
            this.tail = b;
        } else {
            a.before = b;
        }
    }

    @Override
    void afterNodeInsertion(boolean evict) {
        Entry<K, V> first;
        if (evict && (first = this.head) != null && this.removeEldestEntry(first)) {
            Object key = first.key;
            this.removeNode(LinkedHashMap.hash(key), key, null, false, true);
        }
    }

    @Override
    void afterNodeAccess(HashMap.Node<K, V> e) {
        Entry<K, V> last;
        if (this.accessOrder && (last = this.tail) != e) {
            Entry p = (Entry)e;
            Entry b = p.before;
            Entry a = p.after;
            p.after = null;
            if (b == null) {
                this.head = a;
            } else {
                b.after = a;
            }
            if (a != null) {
                a.before = b;
            } else {
                last = b;
            }
            if (last == null) {
                this.head = p;
            } else {
                p.before = last;
                last.after = p;
            }
            this.tail = p;
            ++this.modCount;
        }
    }

    @Override
    void internalWriteEntries(ObjectOutputStream s) throws IOException {
        Entry<K, V> e = this.head;
        while (e != null) {
            s.writeObject(e.key);
            s.writeObject(e.value);
            e = e.after;
        }
    }

    public LinkedHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this.accessOrder = false;
    }

    public LinkedHashMap(int initialCapacity) {
        super(initialCapacity);
        this.accessOrder = false;
    }

    public LinkedHashMap() {
        this.accessOrder = false;
    }

    public LinkedHashMap(Map<? extends K, ? extends V> m) {
        this.accessOrder = false;
        this.putMapEntries(m, false);
    }

    public LinkedHashMap(int initialCapacity, float loadFactor, boolean accessOrder) {
        super(initialCapacity, loadFactor);
        this.accessOrder = accessOrder;
    }

    @Override
    public boolean containsValue(Object value) {
        Entry<K, V> e = this.head;
        while (e != null) {
            Object v = e.value;
            if (v == value || value != null && value.equals(v)) {
                return true;
            }
            e = e.after;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        HashMap.Node e = this.getNode(key);
        if (e == null) {
            return null;
        }
        if (this.accessOrder) {
            this.afterNodeAccess(e);
        }
        return e.value;
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        HashMap.Node e = this.getNode(key);
        if (e == null) {
            return defaultValue;
        }
        if (this.accessOrder) {
            this.afterNodeAccess(e);
        }
        return e.value;
    }

    @Override
    public void clear() {
        super.clear();
        this.tail = null;
        this.head = null;
    }

    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return false;
    }

    @Override
    public Set<K> keySet() {
        Set ks = this.keySet;
        if (ks == null) {
            this.keySet = ks = new LinkedKeySet();
        }
        return ks;
    }

    @Override
    final <T> T[] keysToArray(T[] a) {
        T[] r = a;
        int idx = 0;
        Entry<K, V> e = this.head;
        while (e != null) {
            r[idx++] = e.key;
            e = e.after;
        }
        return a;
    }

    @Override
    final <T> T[] valuesToArray(T[] a) {
        T[] r = a;
        int idx = 0;
        Entry<K, V> e = this.head;
        while (e != null) {
            r[idx++] = e.value;
            e = e.after;
        }
        return a;
    }

    @Override
    public Collection<V> values() {
        Collection vs = this.values;
        if (vs == null) {
            this.values = vs = new LinkedValues();
        }
        return vs;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set es = this.entrySet;
        return es == null ? (this.entrySet = new LinkedEntrySet()) : es;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        int mc = this.modCount;
        Entry<K, V> e = this.head;
        while (e != null) {
            action.accept(e.key, e.value);
            e = e.after;
        }
        if (this.modCount != mc) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        int mc = this.modCount;
        Entry<K, V> e = this.head;
        while (e != null) {
            e.value = function.apply(e.key, e.value);
            e = e.after;
        }
        if (this.modCount != mc) {
            throw new ConcurrentModificationException();
        }
    }

    static class Entry<K, V>
    extends HashMap.Node<K, V> {
        Entry<K, V> before;
        Entry<K, V> after;

        Entry(int hash, K key, V value, HashMap.Node<K, V> next) {
            super(hash, key, value, next);
        }
    }

    final class LinkedKeySet
    extends AbstractSet<K> {
        LinkedKeySet() {
        }

        @Override
        public final int size() {
            return LinkedHashMap.this.size;
        }

        @Override
        public final void clear() {
            LinkedHashMap.this.clear();
        }

        @Override
        public final Iterator<K> iterator() {
            return new LinkedKeyIterator();
        }

        @Override
        public final boolean contains(Object o) {
            return LinkedHashMap.this.containsKey(o);
        }

        @Override
        public final boolean remove(Object key) {
            return LinkedHashMap.this.removeNode(HashMap.hash(key), key, null, false, true) != null;
        }

        @Override
        public final Spliterator<K> spliterator() {
            return Spliterators.spliterator(this, 81);
        }

        @Override
        public Object[] toArray() {
            return LinkedHashMap.this.keysToArray(new Object[LinkedHashMap.this.size]);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return LinkedHashMap.this.keysToArray(LinkedHashMap.this.prepareArray(a));
        }

        @Override
        public final void forEach(Consumer<? super K> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = LinkedHashMap.this.modCount;
            Entry e = LinkedHashMap.this.head;
            while (e != null) {
                action.accept(e.key);
                e = e.after;
            }
            if (LinkedHashMap.this.modCount != mc) {
                throw new ConcurrentModificationException();
            }
        }
    }

    final class LinkedValues
    extends AbstractCollection<V> {
        LinkedValues() {
        }

        @Override
        public final int size() {
            return LinkedHashMap.this.size;
        }

        @Override
        public final void clear() {
            LinkedHashMap.this.clear();
        }

        @Override
        public final Iterator<V> iterator() {
            return new LinkedValueIterator();
        }

        @Override
        public final boolean contains(Object o) {
            return LinkedHashMap.this.containsValue(o);
        }

        @Override
        public final Spliterator<V> spliterator() {
            return Spliterators.spliterator(this, 80);
        }

        @Override
        public Object[] toArray() {
            return LinkedHashMap.this.valuesToArray(new Object[LinkedHashMap.this.size]);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return LinkedHashMap.this.valuesToArray(LinkedHashMap.this.prepareArray(a));
        }

        @Override
        public final void forEach(Consumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = LinkedHashMap.this.modCount;
            Entry e = LinkedHashMap.this.head;
            while (e != null) {
                action.accept(e.value);
                e = e.after;
            }
            if (LinkedHashMap.this.modCount != mc) {
                throw new ConcurrentModificationException();
            }
        }
    }

    final class LinkedEntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        LinkedEntrySet() {
        }

        @Override
        public final int size() {
            return LinkedHashMap.this.size;
        }

        @Override
        public final void clear() {
            LinkedHashMap.this.clear();
        }

        @Override
        public final Iterator<Map.Entry<K, V>> iterator() {
            return new LinkedEntryIterator();
        }

        @Override
        public final boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            HashMap.Node candidate = LinkedHashMap.this.getNode(key);
            return candidate != null && candidate.equals(e);
        }

        @Override
        public final boolean remove(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                Object key = e.getKey();
                Object value = e.getValue();
                return LinkedHashMap.this.removeNode(HashMap.hash(key), key, value, true, true) != null;
            }
            return false;
        }

        @Override
        public final Spliterator<Map.Entry<K, V>> spliterator() {
            return Spliterators.spliterator(this, 81);
        }

        @Override
        public final void forEach(Consumer<? super Map.Entry<K, V>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = LinkedHashMap.this.modCount;
            Entry e = LinkedHashMap.this.head;
            while (e != null) {
                action.accept(e);
                e = e.after;
            }
            if (LinkedHashMap.this.modCount != mc) {
                throw new ConcurrentModificationException();
            }
        }
    }

    final class LinkedEntryIterator
    extends LinkedHashIterator
    implements Iterator<Map.Entry<K, V>> {
        LinkedEntryIterator() {
        }

        @Override
        public final Map.Entry<K, V> next() {
            return this.nextNode();
        }
    }

    final class LinkedValueIterator
    extends LinkedHashIterator
    implements Iterator<V> {
        LinkedValueIterator() {
        }

        @Override
        public final V next() {
            return this.nextNode().value;
        }
    }

    final class LinkedKeyIterator
    extends LinkedHashIterator
    implements Iterator<K> {
        LinkedKeyIterator() {
        }

        @Override
        public final K next() {
            return this.nextNode().getKey();
        }
    }

    abstract class LinkedHashIterator {
        Entry<K, V> next;
        Entry<K, V> current;
        int expectedModCount;

        LinkedHashIterator() {
            this.next = LinkedHashMap.this.head;
            this.expectedModCount = LinkedHashMap.this.modCount;
            this.current = null;
        }

        public final boolean hasNext() {
            return this.next != null;
        }

        final Entry<K, V> nextNode() {
            Entry e = this.next;
            if (LinkedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.current = e;
            this.next = e.after;
            return e;
        }

        public final void remove() {
            Entry p = this.current;
            if (p == null) {
                throw new IllegalStateException();
            }
            if (LinkedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.current = null;
            LinkedHashMap.this.removeNode(p.hash, p.key, null, false, false);
            this.expectedModCount = LinkedHashMap.this.modCount;
        }
    }
}

