/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.ImmutableCollections;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.UnaryOperator;

public interface List<E>
extends Collection<E> {
    @Override
    public int size();

    @Override
    public boolean isEmpty();

    @Override
    public boolean contains(Object var1);

    @Override
    public Iterator<E> iterator();

    @Override
    public Object[] toArray();

    @Override
    public <T> T[] toArray(T[] var1);

    @Override
    public boolean add(E var1);

    @Override
    public boolean remove(Object var1);

    @Override
    public boolean containsAll(Collection<?> var1);

    @Override
    public boolean addAll(Collection<? extends E> var1);

    public boolean addAll(int var1, Collection<? extends E> var2);

    @Override
    public boolean removeAll(Collection<?> var1);

    @Override
    public boolean retainAll(Collection<?> var1);

    default public void replaceAll(UnaryOperator<E> operator) {
        Objects.requireNonNull(operator);
        ListIterator li = this.listIterator();
        while (li.hasNext()) {
            li.set(operator.apply(li.next()));
        }
    }

    default public void sort(Comparator<? super E> c) {
        Object[] a = this.toArray();
        Arrays.sort(a, c);
        ListIterator<Object> i = this.listIterator();
        for (Object e : a) {
            i.next();
            i.set(e);
        }
    }

    @Override
    public void clear();

    @Override
    public boolean equals(Object var1);

    @Override
    public int hashCode();

    public E get(int var1);

    public E set(int var1, E var2);

    public void add(int var1, E var2);

    public E remove(int var1);

    public int indexOf(Object var1);

    public int lastIndexOf(Object var1);

    public ListIterator<E> listIterator();

    public ListIterator<E> listIterator(int var1);

    public List<E> subList(int var1, int var2);

    @Override
    default public Spliterator<E> spliterator() {
        if (this instanceof RandomAccess) {
            return new AbstractList.RandomAccessSpliterator(this);
        }
        return Spliterators.spliterator(this, 16);
    }

    public static <E> List<E> of() {
        return ImmutableCollections.EMPTY_LIST;
    }

    public static <E> List<E> of(E e1) {
        return new ImmutableCollections.List12<E>(e1);
    }

    public static <E> List<E> of(E e1, E e2) {
        return new ImmutableCollections.List12<E>(e1, e2);
    }

    public static <E> List<E> of(E e1, E e2, E e3) {
        return ImmutableCollections.listFromTrustedArray(e1, e2, e3);
    }

    public static <E> List<E> of(E e1, E e2, E e3, E e4) {
        return ImmutableCollections.listFromTrustedArray(e1, e2, e3, e4);
    }

    public static <E> List<E> of(E e1, E e2, E e3, E e4, E e5) {
        return ImmutableCollections.listFromTrustedArray(e1, e2, e3, e4, e5);
    }

    public static <E> List<E> of(E e1, E e2, E e3, E e4, E e5, E e6) {
        return ImmutableCollections.listFromTrustedArray(e1, e2, e3, e4, e5, e6);
    }

    public static <E> List<E> of(E e1, E e2, E e3, E e4, E e5, E e6, E e7) {
        return ImmutableCollections.listFromTrustedArray(e1, e2, e3, e4, e5, e6, e7);
    }

    public static <E> List<E> of(E e1, E e2, E e3, E e4, E e5, E e6, E e7, E e8) {
        return ImmutableCollections.listFromTrustedArray(e1, e2, e3, e4, e5, e6, e7, e8);
    }

    public static <E> List<E> of(E e1, E e2, E e3, E e4, E e5, E e6, E e7, E e8, E e9) {
        return ImmutableCollections.listFromTrustedArray(e1, e2, e3, e4, e5, e6, e7, e8, e9);
    }

    public static <E> List<E> of(E e1, E e2, E e3, E e4, E e5, E e6, E e7, E e8, E e9, E e10) {
        return ImmutableCollections.listFromTrustedArray(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10);
    }

    @SafeVarargs
    public static <E> List<E> of(E ... elements) {
        switch (elements.length) {
            case 0: {
                ImmutableCollections.ListN<?> list = ImmutableCollections.EMPTY_LIST;
                return list;
            }
            case 1: {
                return new ImmutableCollections.List12<E>(elements[0]);
            }
            case 2: {
                return new ImmutableCollections.List12<E>(elements[0], elements[1]);
            }
        }
        return ImmutableCollections.listFromArray(elements);
    }

    public static <E> List<E> copyOf(Collection<? extends E> coll) {
        return ImmutableCollections.listCopy(coll);
    }
}

