/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StreamCorruptedException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.HexFormat;
import java.util.InvalidPropertiesFormatException;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import jdk.internal.access.SharedSecrets;
import jdk.internal.misc.Unsafe;
import jdk.internal.util.ArraysSupport;
import jdk.internal.util.xml.PropertiesDefaultHandler;
import sun.nio.cs.ISO_8859_1;
import sun.nio.cs.UTF_8;

public class Properties
extends Hashtable<Object, Object> {
    private static final long serialVersionUID = 4112578634029874840L;
    private static final Unsafe UNSAFE = Unsafe.getUnsafe();
    protected volatile Properties defaults;
    private volatile transient ConcurrentHashMap<Object, Object> map;

    public Properties() {
        this(null, 8);
    }

    public Properties(int initialCapacity) {
        this(null, initialCapacity);
    }

    public Properties(Properties defaults) {
        this(defaults, 8);
    }

    private Properties(Properties defaults, int initialCapacity) {
        super((Void)null);
        this.map = new ConcurrentHashMap(initialCapacity);
        this.defaults = defaults;
        UNSAFE.storeFence();
    }

    public synchronized Object setProperty(String key, String value) {
        return this.put(key, value);
    }

    public synchronized void load(Reader reader) throws IOException {
        Objects.requireNonNull(reader, "reader parameter is null");
        this.load0(new LineReader(reader));
    }

    public synchronized void load(InputStream inStream) throws IOException {
        Objects.requireNonNull(inStream, "inStream parameter is null");
        this.load0(new LineReader(inStream));
    }

    private void load0(LineReader lr) throws IOException {
        int limit;
        StringBuilder outBuffer = new StringBuilder();
        while ((limit = lr.readLine()) >= 0) {
            char c;
            int keyLen;
            int valueStart = limit;
            boolean hasSep = false;
            boolean precedingBackslash = false;
            for (keyLen = 0; keyLen < limit; ++keyLen) {
                c = lr.lineBuf[keyLen];
                if (!(c != '=' && c != ':' || precedingBackslash)) {
                    valueStart = keyLen + 1;
                    hasSep = true;
                    break;
                }
                if (!(c != ' ' && c != '\t' && c != '\f' || precedingBackslash)) {
                    valueStart = keyLen + 1;
                    break;
                }
                precedingBackslash = c == '\\' ? !precedingBackslash : false;
            }
            while (valueStart < limit) {
                c = lr.lineBuf[valueStart];
                if (c != ' ' && c != '\t' && c != '\f') {
                    if (hasSep || c != '=' && c != ':') break;
                    hasSep = true;
                }
                ++valueStart;
            }
            String key = this.loadConvert(lr.lineBuf, 0, keyLen, outBuffer);
            String value = this.loadConvert(lr.lineBuf, valueStart, limit - valueStart, outBuffer);
            this.put(key, value);
        }
    }

    private String loadConvert(char[] in, int off, int len, StringBuilder out) {
        int aChar;
        int end = off + len;
        int start = off;
        while (off < end && (aChar = in[off++]) != 92) {
        }
        if (off == end) {
            return new String(in, start, len);
        }
        out.setLength(0);
        out.append(in, start, --off - start);
        while (off < end) {
            if ((aChar = in[off++]) == 92) {
                if ((aChar = in[off++]) == 117) {
                    if (off > end - 4) {
                        throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                    }
                    int value = 0;
                    for (int i = 0; i < 4; ++i) {
                        aChar = in[off++];
                        value = switch (aChar) {
                            case 48, 49, 50, 51, 52, 53, 54, 55, 56, 57 -> (value << 4) + aChar - 48;
                            case 97, 98, 99, 100, 101, 102 -> (value << 4) + 10 + aChar - 97;
                            case 65, 66, 67, 68, 69, 70 -> (value << 4) + 10 + aChar - 65;
                            default -> throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                        };
                    }
                    out.append((char)value);
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                out.append((char)aChar);
                continue;
            }
            out.append((char)aChar);
        }
        return out.toString();
    }

    private String saveConvert(String theString, boolean escapeSpace, boolean escapeUnicode) {
        int len = theString.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuilder outBuffer = new StringBuilder(bufLen);
        HexFormat hex = HexFormat.of().withUpperCase();
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue;
                }
                outBuffer.append(aChar);
                continue;
            }
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    outBuffer.append('\\');
                    outBuffer.append(aChar);
                    continue block8;
                }
                default: {
                    if ((aChar < ' ' || aChar > '~') & escapeUnicode) {
                        outBuffer.append("\\u");
                        outBuffer.append(hex.toHexDigits(aChar));
                        continue block8;
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    private static void writeComments(BufferedWriter bw, String comments) throws IOException {
        int current;
        HexFormat hex = HexFormat.of().withUpperCase();
        bw.write("#");
        int len = comments.length();
        int last = 0;
        for (current = 0; current < len; ++current) {
            char c = comments.charAt(current);
            if (c <= '\u00ff' && c != '\n' && c != '\r') continue;
            if (last != current) {
                bw.write(comments.substring(last, current));
            }
            if (c > '\u00ff') {
                bw.write("\\u");
                bw.write(hex.toHexDigits(c));
            } else {
                bw.newLine();
                if (c == '\r' && current != len - 1 && comments.charAt(current + 1) == '\n') {
                    ++current;
                }
                if (current == len - 1 || comments.charAt(current + 1) != '#' && comments.charAt(current + 1) != '!') {
                    bw.write("#");
                }
            }
            last = current + 1;
        }
        if (last != current) {
            bw.write(comments.substring(last, current));
        }
        bw.newLine();
    }

    @Deprecated
    public void save(OutputStream out, String comments) {
        try {
            this.store(out, comments);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void store(Writer writer, String comments) throws IOException {
        this.store0(writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer), comments, false);
    }

    public void store(OutputStream out, String comments) throws IOException {
        this.store0(new BufferedWriter(new OutputStreamWriter(out, ISO_8859_1.INSTANCE)), comments, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store0(BufferedWriter bw, String comments, boolean escUnicode) throws IOException {
        if (comments != null) {
            Properties.writeComments(bw, comments);
        }
        bw.write("#" + new Date().toString());
        bw.newLine();
        Properties properties = this;
        synchronized (properties) {
            for (Map.Entry<Object, Object> e : this.entrySet()) {
                String key = (String)e.getKey();
                String val = (String)e.getValue();
                key = this.saveConvert(key, true, escUnicode);
                val = this.saveConvert(val, false, escUnicode);
                bw.write(key + "=" + val);
                bw.newLine();
            }
        }
        bw.flush();
    }

    public synchronized void loadFromXML(InputStream in) throws IOException, InvalidPropertiesFormatException {
        Objects.requireNonNull(in);
        PropertiesDefaultHandler handler = new PropertiesDefaultHandler();
        handler.load(this, in);
        in.close();
    }

    public void storeToXML(OutputStream os, String comment) throws IOException {
        this.storeToXML(os, comment, UTF_8.INSTANCE);
    }

    public void storeToXML(OutputStream os, String comment, String encoding) throws IOException {
        Objects.requireNonNull(os);
        Objects.requireNonNull(encoding);
        try {
            Charset charset = Charset.forName(encoding);
            this.storeToXML(os, comment, charset);
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
            throw new UnsupportedEncodingException(encoding);
        }
    }

    public void storeToXML(OutputStream os, String comment, Charset charset) throws IOException {
        Objects.requireNonNull(os, "OutputStream");
        Objects.requireNonNull(charset, "Charset");
        PropertiesDefaultHandler handler = new PropertiesDefaultHandler();
        handler.store(this, os, comment, charset);
    }

    public String getProperty(String key) {
        Properties defaults;
        Object oval = this.map.get(key);
        String sval = oval instanceof String ? (String)oval : null;
        return sval == null && (defaults = this.defaults) != null ? defaults.getProperty(key) : sval;
    }

    public String getProperty(String key, String defaultValue) {
        String val = this.getProperty(key);
        return val == null ? defaultValue : val;
    }

    public Enumeration<?> propertyNames() {
        Hashtable<String, Object> h = new Hashtable<String, Object>();
        this.enumerate(h);
        return h.keys();
    }

    public Set<String> stringPropertyNames() {
        HashMap<String, String> h = new HashMap<String, String>();
        this.enumerateStringProperties(h);
        return Collections.unmodifiableSet(h.keySet());
    }

    public void list(PrintStream out) {
        out.println("-- listing properties --");
        HashMap<String, Object> h = new HashMap<String, Object>();
        this.enumerate(h);
        for (Map.Entry e : h.entrySet()) {
            String key = (String)e.getKey();
            String val = (String)e.getValue();
            if (val.length() > 40) {
                val = val.substring(0, 37) + "...";
            }
            out.println(key + "=" + val);
        }
    }

    public void list(PrintWriter out) {
        out.println("-- listing properties --");
        HashMap<String, Object> h = new HashMap<String, Object>();
        this.enumerate(h);
        for (Map.Entry e : h.entrySet()) {
            String key = (String)e.getKey();
            String val = (String)e.getValue();
            if (val.length() > 40) {
                val = val.substring(0, 37) + "...";
            }
            out.println(key + "=" + val);
        }
    }

    private void enumerate(Map<String, Object> h) {
        if (this.defaults != null) {
            this.defaults.enumerate(h);
        }
        for (Map.Entry<Object, Object> e : this.entrySet()) {
            String key = (String)e.getKey();
            h.put(key, e.getValue());
        }
    }

    private void enumerateStringProperties(Map<String, String> h) {
        if (this.defaults != null) {
            this.defaults.enumerateStringProperties(h);
        }
        for (Map.Entry<Object, Object> e : this.entrySet()) {
            Object k = e.getKey();
            Object v = e.getValue();
            if (!(k instanceof String) || !(v instanceof String)) continue;
            h.put((String)k, (String)v);
        }
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Enumeration<Object> keys() {
        return Collections.enumeration(this.map.keySet());
    }

    @Override
    public Enumeration<Object> elements() {
        return Collections.enumeration(this.map.values());
    }

    @Override
    public boolean contains(Object value) {
        return this.map.contains(value);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public Object get(Object key) {
        return this.map.get(key);
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        return this.map.put(key, value);
    }

    @Override
    public synchronized Object remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public synchronized void putAll(Map<?, ?> t) {
        this.map.putAll(t);
    }

    @Override
    public synchronized void clear() {
        this.map.clear();
    }

    @Override
    public synchronized String toString() {
        return this.map.toString();
    }

    @Override
    public Set<Object> keySet() {
        return Collections.synchronizedSet(this.map.keySet(), this);
    }

    @Override
    public Collection<Object> values() {
        return Collections.synchronizedCollection(this.map.values(), this);
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        return Collections.synchronizedSet(new EntrySet(this.map.entrySet()), this);
    }

    @Override
    public synchronized boolean equals(Object o) {
        return this.map.equals(o);
    }

    @Override
    public synchronized int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public Object getOrDefault(Object key, Object defaultValue) {
        return this.map.getOrDefault(key, defaultValue);
    }

    @Override
    public synchronized void forEach(BiConsumer<? super Object, ? super Object> action) {
        this.map.forEach(action);
    }

    @Override
    public synchronized void replaceAll(BiFunction<? super Object, ? super Object, ?> function) {
        this.map.replaceAll(function);
    }

    @Override
    public synchronized Object putIfAbsent(Object key, Object value) {
        return this.map.putIfAbsent(key, value);
    }

    @Override
    public synchronized boolean remove(Object key, Object value) {
        return this.map.remove(key, value);
    }

    @Override
    public synchronized boolean replace(Object key, Object oldValue, Object newValue) {
        return this.map.replace(key, oldValue, newValue);
    }

    @Override
    public synchronized Object replace(Object key, Object value) {
        return this.map.replace(key, value);
    }

    @Override
    public synchronized Object computeIfAbsent(Object key, Function<? super Object, ?> mappingFunction) {
        return this.map.computeIfAbsent(key, mappingFunction);
    }

    @Override
    public synchronized Object computeIfPresent(Object key, BiFunction<? super Object, ? super Object, ?> remappingFunction) {
        return this.map.computeIfPresent(key, remappingFunction);
    }

    @Override
    public synchronized Object compute(Object key, BiFunction<? super Object, ? super Object, ?> remappingFunction) {
        return this.map.compute(key, remappingFunction);
    }

    @Override
    public synchronized Object merge(Object key, Object value, BiFunction<? super Object, ? super Object, ?> remappingFunction) {
        return this.map.merge(key, value, remappingFunction);
    }

    @Override
    protected void rehash() {
    }

    @Override
    public synchronized Object clone() {
        Properties clone = (Properties)this.cloneHashtable();
        clone.map = new ConcurrentHashMap<Object, Object>(this.map);
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void writeHashtable(ObjectOutputStream s) throws IOException {
        ConcurrentHashMap<Object, Object> map = this.map;
        ArrayList<Object> entryStack = new ArrayList<Object>(map.size() * 2);
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            entryStack.add(entry.getValue());
            entryStack.add(entry.getKey());
        }
        float loadFactor = 0.75f;
        int count = entryStack.size() / 2;
        int length = (int)((float)count / loadFactor) + count / 20 + 3;
        if (length > count && (length & 1) == 0) {
            --length;
        }
        ConcurrentHashMap<Object, Object> concurrentHashMap = map;
        synchronized (concurrentHashMap) {
            this.defaultWriteHashtable(s, length, loadFactor);
        }
        s.writeInt(length);
        s.writeInt(count);
        for (int i = entryStack.size() - 1; i >= 0; --i) {
            s.writeObject(entryStack.get(i));
        }
    }

    @Override
    void readHashtable(ObjectInputStream s) throws IOException, ClassNotFoundException {
        int elements;
        s.defaultReadObject();
        int origlength = s.readInt();
        if (elements < 0) {
            throw new StreamCorruptedException("Illegal # of Elements: " + elements);
        }
        SharedSecrets.getJavaObjectInputStreamAccess().checkArray(s, Map.Entry[].class, HashMap.tableSizeFor((int)((double)elements / 0.75)));
        ConcurrentHashMap<Object, Object> map = new ConcurrentHashMap<Object, Object>(elements);
        for (elements = s.readInt(); elements > 0; --elements) {
            Object key = s.readObject();
            Object value = s.readObject();
            map.put(key, value);
        }
        this.map = map;
    }

    private static class LineReader {
        char[] lineBuf = new char[1024];
        private byte[] inByteBuf;
        private char[] inCharBuf;
        private int inLimit = 0;
        private int inOff = 0;
        private InputStream inStream;
        private Reader reader;

        LineReader(InputStream inStream) {
            this.inStream = inStream;
            this.inByteBuf = new byte[8192];
        }

        LineReader(Reader reader) {
            this.reader = reader;
            this.inCharBuf = new char[8192];
        }

        int readLine() throws IOException {
            int len = 0;
            int off = this.inOff;
            int limit = this.inLimit;
            boolean skipWhiteSpace = true;
            boolean appendedLineBegin = false;
            boolean precedingBackslash = false;
            boolean fromStream = this.inStream != null;
            byte[] byteBuf = this.inByteBuf;
            char[] charBuf = this.inCharBuf;
            char[] lineBuf = this.lineBuf;
            while (true) {
                char c;
                if (off >= limit) {
                    limit = fromStream ? this.inStream.read(byteBuf) : this.reader.read(charBuf);
                    this.inLimit = limit;
                    if (limit <= 0) {
                        if (len == 0) {
                            return -1;
                        }
                        return precedingBackslash ? len - 1 : len;
                    }
                    off = 0;
                }
                char c2 = c = fromStream ? (char)(byteBuf[off++] & 0xFF) : charBuf[off++];
                if (skipWhiteSpace) {
                    if (c == ' ' || c == '\t' || c == '\f' || !appendedLineBegin && (c == '\r' || c == '\n')) continue;
                    skipWhiteSpace = false;
                    appendedLineBegin = false;
                }
                if (len == 0 && (c == '#' || c == '!')) {
                    block1: while (true) {
                        if (fromStream) {
                            while (off < limit) {
                                byte b;
                                if ((b = byteBuf[off++]) > 13 || b != 13 && b != 10) continue;
                                break block1;
                            }
                            if (off != limit) continue;
                            this.inLimit = limit = this.inStream.read(byteBuf);
                            if (limit <= 0) {
                                return -1;
                            }
                            off = 0;
                            continue;
                        }
                        while (off < limit) {
                            if ((c = charBuf[off++]) > '\r' || c != '\r' && c != '\n') continue;
                            break block1;
                        }
                        if (off != limit) continue;
                        this.inLimit = limit = this.reader.read(charBuf);
                        if (limit <= 0) {
                            return -1;
                        }
                        off = 0;
                    }
                    skipWhiteSpace = true;
                    continue;
                }
                if (c != '\n' && c != '\r') {
                    lineBuf[len++] = c;
                    if (len == lineBuf.length) {
                        lineBuf = new char[ArraysSupport.newLength(len, 1, len)];
                        System.arraycopy(this.lineBuf, 0, lineBuf, 0, len);
                        this.lineBuf = lineBuf;
                    }
                    precedingBackslash = c == '\\' ? !precedingBackslash : false;
                    continue;
                }
                if (len == 0) {
                    skipWhiteSpace = true;
                    continue;
                }
                if (off >= limit) {
                    limit = fromStream ? this.inStream.read(byteBuf) : this.reader.read(charBuf);
                    this.inLimit = limit;
                    off = 0;
                    if (limit <= 0) {
                        return precedingBackslash ? len - 1 : len;
                    }
                }
                if (!precedingBackslash) break;
                --len;
                skipWhiteSpace = true;
                appendedLineBegin = true;
                precedingBackslash = false;
                if (c != '\r') continue;
                if (fromStream) {
                    if (byteBuf[off] != 10) continue;
                    ++off;
                    continue;
                }
                if (charBuf[off] != '\n') continue;
                ++off;
            }
            this.inOff = off;
            return len;
        }
    }

    private static class EntrySet
    implements Set<Map.Entry<Object, Object>> {
        private Set<Map.Entry<Object, Object>> entrySet;

        private EntrySet(Set<Map.Entry<Object, Object>> entrySet) {
            this.entrySet = entrySet;
        }

        @Override
        public int size() {
            return this.entrySet.size();
        }

        @Override
        public boolean isEmpty() {
            return this.entrySet.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.entrySet.contains(o);
        }

        @Override
        public Object[] toArray() {
            return this.entrySet.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.entrySet.toArray(a);
        }

        @Override
        public void clear() {
            this.entrySet.clear();
        }

        @Override
        public boolean remove(Object o) {
            return this.entrySet.remove(o);
        }

        @Override
        public boolean add(Map.Entry<Object, Object> e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<Object, Object>> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.entrySet.containsAll(c);
        }

        @Override
        public boolean equals(Object o) {
            return o == this || this.entrySet.equals(o);
        }

        @Override
        public int hashCode() {
            return this.entrySet.hashCode();
        }

        public String toString() {
            return this.entrySet.toString();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.entrySet.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.entrySet.retainAll(c);
        }

        @Override
        public Iterator<Map.Entry<Object, Object>> iterator() {
            return this.entrySet.iterator();
        }
    }
}

