/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.random.RandomGenerator;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import jdk.internal.misc.Unsafe;
import jdk.internal.util.random.RandomSupport;

@RandomSupport.RandomGeneratorProperties(name="Random", i=48, j=0, k=0, equidistribution=0)
public class Random
implements RandomGenerator,
Serializable {
    static final long serialVersionUID = 3905348978240129619L;
    private final AtomicLong seed;
    private static final long multiplier = 25214903917L;
    private static final long addend = 11L;
    private static final long mask = 0xFFFFFFFFFFFFL;
    private static final double DOUBLE_UNIT = (double)1.110223E-16f;
    private static final AtomicLong seedUniquifier = new AtomicLong(8682522807148012L);
    private double nextNextGaussian;
    private boolean haveNextNextGaussian = false;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("seed", Long.TYPE), new ObjectStreamField("nextNextGaussian", Double.TYPE), new ObjectStreamField("haveNextNextGaussian", Boolean.TYPE)};
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final long seedOffset;

    public Random() {
        this(Random.seedUniquifier() ^ System.nanoTime());
    }

    private static long seedUniquifier() {
        long next;
        long current;
        while (!seedUniquifier.compareAndSet(current = seedUniquifier.get(), next = current * 1181783497276652981L)) {
        }
        return next;
    }

    public Random(long seed) {
        if (this.getClass() == Random.class) {
            this.seed = new AtomicLong(Random.initialScramble(seed));
        } else {
            this.seed = new AtomicLong();
            this.setSeed(seed);
        }
    }

    private static long initialScramble(long seed) {
        return (seed ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
    }

    public synchronized void setSeed(long seed) {
        this.seed.set(Random.initialScramble(seed));
        this.haveNextNextGaussian = false;
    }

    protected int next(int bits) {
        long nextseed;
        long oldseed;
        AtomicLong seed = this.seed;
        while (!seed.compareAndSet(oldseed = seed.get(), nextseed = oldseed * 25214903917L + 11L & 0xFFFFFFFFFFFFL)) {
        }
        return (int)(nextseed >>> 48 - bits);
    }

    @Override
    public void nextBytes(byte[] bytes) {
        int i = 0;
        int len = bytes.length;
        while (i < len) {
            int rnd = this.nextInt();
            int n = Math.min(len - i, 4);
            while (n-- > 0) {
                bytes[i++] = (byte)rnd;
                rnd >>= 8;
            }
        }
    }

    @Override
    public int nextInt() {
        return this.next(32);
    }

    @Override
    public int nextInt(int bound) {
        if (bound <= 0) {
            throw new IllegalArgumentException("bound must be positive");
        }
        int r = this.next(31);
        int m = bound - 1;
        if ((bound & m) == 0) {
            r = (int)((long)bound * (long)r >> 31);
        } else {
            int u = r;
            while (u - (r = u % bound) + m < 0) {
                u = this.next(31);
            }
        }
        return r;
    }

    @Override
    public long nextLong() {
        return ((long)this.next(32) << 32) + (long)this.next(32);
    }

    @Override
    public boolean nextBoolean() {
        return this.next(1) != 0;
    }

    @Override
    public float nextFloat() {
        return (float)this.next(24) / 1.6777216E7f;
    }

    @Override
    public double nextDouble() {
        return (double)(((long)this.next(26) << 27) + (long)this.next(27)) * (double)1.110223E-16f;
    }

    @Override
    public synchronized double nextGaussian() {
        double v2;
        double v1;
        double s;
        if (this.haveNextNextGaussian) {
            this.haveNextNextGaussian = false;
            return this.nextNextGaussian;
        }
        while ((s = (v1 = 2.0 * this.nextDouble() - 1.0) * v1 + (v2 = 2.0 * this.nextDouble() - 1.0) * v2) >= 1.0 || s == 0.0) {
        }
        double multiplier = StrictMath.sqrt(-2.0 * StrictMath.log(s) / s);
        this.nextNextGaussian = v2 * multiplier;
        this.haveNextNextGaussian = true;
        return v1 * multiplier;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = s.readFields();
        long seedVal = fields.get("seed", -1L);
        if (seedVal < 0L) {
            throw new StreamCorruptedException("Random: invalid seed");
        }
        this.resetSeed(seedVal);
        this.nextNextGaussian = fields.get("nextNextGaussian", 0.0);
        this.haveNextNextGaussian = fields.get("haveNextNextGaussian", false);
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        ObjectOutputStream.PutField fields = s.putFields();
        fields.put("seed", this.seed.get());
        fields.put("nextNextGaussian", this.nextNextGaussian);
        fields.put("haveNextNextGaussian", this.haveNextNextGaussian);
        s.writeFields();
    }

    private void resetSeed(long seedVal) {
        unsafe.putReferenceVolatile(this, seedOffset, new AtomicLong(seedVal));
    }

    @Override
    public IntStream ints(long streamSize) {
        return RandomSupport.AbstractSpliteratorGenerator.ints(this, streamSize);
    }

    @Override
    public IntStream ints() {
        return RandomSupport.AbstractSpliteratorGenerator.ints(this);
    }

    @Override
    public IntStream ints(long streamSize, int randomNumberOrigin, int randomNumberBound) {
        return RandomSupport.AbstractSpliteratorGenerator.ints(this, streamSize, randomNumberOrigin, randomNumberBound);
    }

    @Override
    public IntStream ints(int randomNumberOrigin, int randomNumberBound) {
        return RandomSupport.AbstractSpliteratorGenerator.ints(this, randomNumberOrigin, randomNumberBound);
    }

    @Override
    public LongStream longs(long streamSize) {
        return RandomSupport.AbstractSpliteratorGenerator.longs(this, streamSize);
    }

    @Override
    public LongStream longs() {
        return RandomSupport.AbstractSpliteratorGenerator.longs(this);
    }

    @Override
    public LongStream longs(long streamSize, long randomNumberOrigin, long randomNumberBound) {
        return RandomSupport.AbstractSpliteratorGenerator.longs(this, streamSize, randomNumberOrigin, randomNumberBound);
    }

    @Override
    public LongStream longs(long randomNumberOrigin, long randomNumberBound) {
        return RandomSupport.AbstractSpliteratorGenerator.longs(this, randomNumberOrigin, randomNumberBound);
    }

    @Override
    public DoubleStream doubles(long streamSize) {
        return RandomSupport.AbstractSpliteratorGenerator.doubles(this, streamSize);
    }

    @Override
    public DoubleStream doubles() {
        return RandomSupport.AbstractSpliteratorGenerator.doubles(this);
    }

    @Override
    public DoubleStream doubles(long streamSize, double randomNumberOrigin, double randomNumberBound) {
        return RandomSupport.AbstractSpliteratorGenerator.doubles(this, streamSize, randomNumberOrigin, randomNumberBound);
    }

    @Override
    public DoubleStream doubles(double randomNumberOrigin, double randomNumberBound) {
        return RandomSupport.AbstractSpliteratorGenerator.doubles(this, randomNumberOrigin, randomNumberBound);
    }

    static {
        try {
            seedOffset = unsafe.objectFieldOffset(Random.class.getDeclaredField("seed"));
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }
}

