/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Deque;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceConfigurationError;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import jdk.internal.access.JavaLangAccess;
import jdk.internal.access.SharedSecrets;
import jdk.internal.loader.BootLoader;
import jdk.internal.loader.ClassLoaders;
import jdk.internal.misc.VM;
import jdk.internal.module.ServicesCatalog;
import jdk.internal.reflect.CallerSensitive;
import jdk.internal.reflect.Reflection;
import sun.nio.cs.UTF_8;

public final class ServiceLoader<S>
implements Iterable<S> {
    private final Class<S> service;
    private final String serviceName;
    private final ModuleLayer layer;
    private final ClassLoader loader;
    private final AccessControlContext acc;
    private Iterator<Provider<S>> lookupIterator1;
    private final List<S> instantiatedProviders = new ArrayList<S>();
    private Iterator<Provider<S>> lookupIterator2;
    private final List<Provider<S>> loadedProviders = new ArrayList<Provider<S>>();
    private boolean loadedAllProviders;
    private int reloadCount;
    private static JavaLangAccess LANG_ACCESS = SharedSecrets.getJavaLangAccess();

    private ServiceLoader(Class<?> caller, ModuleLayer layer, Class<S> svc) {
        Objects.requireNonNull(caller);
        Objects.requireNonNull(layer);
        Objects.requireNonNull(svc);
        ServiceLoader.checkCaller(caller, svc);
        this.service = svc;
        this.serviceName = svc.getName();
        this.layer = layer;
        this.loader = null;
        this.acc = System.getSecurityManager() != null ? AccessController.getContext() : null;
    }

    private ServiceLoader(Class<?> caller, Class<S> svc, ClassLoader cl) {
        Objects.requireNonNull(svc);
        if (VM.isBooted()) {
            ServiceLoader.checkCaller(caller, svc);
            if (cl == null) {
                cl = ClassLoader.getSystemClassLoader();
            }
        } else {
            Module callerModule = caller.getModule();
            Module base = Object.class.getModule();
            Module svcModule = svc.getModule();
            if (callerModule != base || svcModule != base) {
                ServiceLoader.fail(svc, "not accessible to " + callerModule + " during VM init");
            }
            cl = null;
        }
        this.service = svc;
        this.serviceName = svc.getName();
        this.layer = null;
        this.loader = cl;
        this.acc = System.getSecurityManager() != null ? AccessController.getContext() : null;
    }

    private ServiceLoader(Module callerModule, Class<S> svc, ClassLoader cl) {
        if (!callerModule.canUse(svc)) {
            ServiceLoader.fail(svc, callerModule + " does not declare `uses`");
        }
        this.service = Objects.requireNonNull(svc);
        this.serviceName = svc.getName();
        this.layer = null;
        this.loader = cl;
        this.acc = System.getSecurityManager() != null ? AccessController.getContext() : null;
    }

    private static void checkCaller(Class<?> caller, Class<?> svc) {
        if (caller == null) {
            ServiceLoader.fail(svc, "no caller to check if it declares `uses`");
        }
        Module callerModule = caller.getModule();
        int mods = svc.getModifiers();
        if (!Reflection.verifyMemberAccess(caller, svc, null, mods)) {
            ServiceLoader.fail(svc, "service type not accessible to " + callerModule);
        }
        if (!callerModule.canUse(svc)) {
            ServiceLoader.fail(svc, callerModule + " does not declare `uses`");
        }
    }

    private static void fail(Class<?> service, String msg, Throwable cause) throws ServiceConfigurationError {
        throw new ServiceConfigurationError(service.getName() + ": " + msg, cause);
    }

    private static void fail(Class<?> service, String msg) throws ServiceConfigurationError {
        throw new ServiceConfigurationError(service.getName() + ": " + msg);
    }

    private static void fail(Class<?> service, URL u, int line, String msg) throws ServiceConfigurationError {
        ServiceLoader.fail(service, u + ":" + line + ": " + msg);
    }

    private boolean inExplicitModule(Class<?> clazz) {
        Module module = clazz.getModule();
        return module.isNamed() && !module.getDescriptor().isAutomatic();
    }

    private Method findStaticProviderMethod(Class<?> clazz) {
        List<Method> methods = null;
        try {
            methods = LANG_ACCESS.getDeclaredPublicMethods(clazz, "provider", new Class[0]);
        }
        catch (Throwable x) {
            ServiceLoader.fail(this.service, "Unable to get public provider() method", x);
        }
        if (methods.isEmpty()) {
            return null;
        }
        Method result = null;
        for (Method method : methods) {
            int mods = method.getModifiers();
            assert (Modifier.isPublic(mods));
            if (!Modifier.isStatic(mods)) continue;
            if (result != null) {
                ServiceLoader.fail(this.service, clazz + " declares more than one public static provider() method");
            }
            result = method;
        }
        if (result != null) {
            Method m = result;
            PrivilegedAction<Void> pa = () -> {
                m.setAccessible(true);
                return null;
            };
            AccessController.doPrivileged(pa);
        }
        return result;
    }

    private Constructor<?> getConstructor(final Class<?> clazz) {
        PrivilegedExceptionAction pa = new PrivilegedExceptionAction<Constructor<?>>(){

            @Override
            public Constructor<?> run() throws Exception {
                Constructor ctor = clazz.getConstructor(new Class[0]);
                if (ServiceLoader.this.inExplicitModule(clazz)) {
                    ctor.setAccessible(true);
                }
                return ctor;
            }
        };
        Constructor ctor = null;
        try {
            ctor = (Constructor)AccessController.doPrivileged(pa);
        }
        catch (Throwable x) {
            if (x instanceof PrivilegedActionException) {
                x = x.getCause();
            }
            String cn = clazz.getName();
            ServiceLoader.fail(this.service, cn + " Unable to get public no-arg constructor", x);
        }
        return ctor;
    }

    private Provider<S> loadProvider(ServicesCatalog.ServiceProvider provider) {
        Method factoryMethod;
        int mods;
        Module module = provider.module();
        if (!module.canRead(this.service.getModule())) {
            return null;
        }
        String cn = provider.providerName();
        Class clazz = null;
        if (this.acc == null) {
            try {
                clazz = Class.forName(module, cn);
            }
            catch (LinkageError e) {
                ServiceLoader.fail(this.service, "Unable to load " + cn, e);
            }
        } else {
            PrivilegedExceptionAction<Class> pa = () -> Class.forName(module, cn);
            try {
                clazz = AccessController.doPrivileged(pa);
            }
            catch (Throwable x) {
                if (x instanceof PrivilegedActionException) {
                    x = x.getCause();
                }
                ServiceLoader.fail(this.service, "Unable to load " + cn, x);
                return null;
            }
        }
        if (clazz == null) {
            ServiceLoader.fail(this.service, "Provider " + cn + " not found");
        }
        if (!Modifier.isPublic(mods = clazz.getModifiers())) {
            ServiceLoader.fail(this.service, clazz + " is not public");
        }
        if (this.inExplicitModule(clazz) && (factoryMethod = this.findStaticProviderMethod(clazz)) != null) {
            Class<?> returnType = factoryMethod.getReturnType();
            if (!this.service.isAssignableFrom(returnType)) {
                ServiceLoader.fail(this.service, factoryMethod + " return type not a subtype");
            }
            Class<?> type = returnType;
            return new ProviderImpl<S>(this.service, type, factoryMethod, this.acc);
        }
        if (!this.service.isAssignableFrom(clazz)) {
            ServiceLoader.fail(this.service, clazz.getName() + " not a subtype");
        }
        Class type = clazz;
        Constructor<?> ctor = this.getConstructor(clazz);
        return new ProviderImpl<S>(this.service, type, ctor, this.acc);
    }

    private Iterator<Provider<S>> newLookupIterator() {
        assert (this.layer == null || this.loader == null);
        if (this.layer != null) {
            return new LayerLookupIterator();
        }
        final ModuleServicesLookupIterator first = new ModuleServicesLookupIterator();
        final LazyClassPathLookupIterator second = new LazyClassPathLookupIterator();
        return new Iterator<Provider<S>>(){

            @Override
            public boolean hasNext() {
                return first.hasNext() || second.hasNext();
            }

            @Override
            public Provider<S> next() {
                if (first.hasNext()) {
                    return (Provider)first.next();
                }
                if (second.hasNext()) {
                    return (Provider)second.next();
                }
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    public Iterator<S> iterator() {
        if (this.lookupIterator1 == null) {
            this.lookupIterator1 = this.newLookupIterator();
        }
        return new Iterator<S>(){
            final int expectedReloadCount;
            int index;
            {
                this.expectedReloadCount = ServiceLoader.this.reloadCount;
            }

            private void checkReloadCount() {
                if (ServiceLoader.this.reloadCount != this.expectedReloadCount) {
                    throw new ConcurrentModificationException();
                }
            }

            @Override
            public boolean hasNext() {
                this.checkReloadCount();
                if (this.index < ServiceLoader.this.instantiatedProviders.size()) {
                    return true;
                }
                return ServiceLoader.this.lookupIterator1.hasNext();
            }

            @Override
            public S next() {
                Object next;
                this.checkReloadCount();
                if (this.index < ServiceLoader.this.instantiatedProviders.size()) {
                    next = ServiceLoader.this.instantiatedProviders.get(this.index);
                } else {
                    next = ServiceLoader.this.lookupIterator1.next().get();
                    ServiceLoader.this.instantiatedProviders.add(next);
                }
                ++this.index;
                return next;
            }
        };
    }

    public Stream<Provider<S>> stream() {
        if (this.loadedAllProviders) {
            return this.loadedProviders.stream();
        }
        if (this.lookupIterator2 == null) {
            this.lookupIterator2 = this.newLookupIterator();
        }
        ProviderSpliterator s = new ProviderSpliterator(this.lookupIterator2);
        return StreamSupport.stream(s, false);
    }

    static <S> ServiceLoader<S> load(Class<S> service, ClassLoader loader, Module callerModule) {
        return new ServiceLoader<S>(callerModule, service, loader);
    }

    @CallerSensitive
    public static <S> ServiceLoader<S> load(Class<S> service, ClassLoader loader) {
        return new ServiceLoader<S>(Reflection.getCallerClass(), service, loader);
    }

    @CallerSensitive
    public static <S> ServiceLoader<S> load(Class<S> service) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return new ServiceLoader<S>(Reflection.getCallerClass(), service, cl);
    }

    @CallerSensitive
    public static <S> ServiceLoader<S> loadInstalled(Class<S> service) {
        ClassLoader cl = ClassLoader.getPlatformClassLoader();
        return new ServiceLoader<S>(Reflection.getCallerClass(), service, cl);
    }

    @CallerSensitive
    public static <S> ServiceLoader<S> load(ModuleLayer layer, Class<S> service) {
        return new ServiceLoader<S>(Reflection.getCallerClass(), layer, service);
    }

    public Optional<S> findFirst() {
        Iterator<S> iterator = this.iterator();
        if (iterator.hasNext()) {
            return Optional.of(iterator.next());
        }
        return Optional.empty();
    }

    public void reload() {
        this.lookupIterator1 = null;
        this.instantiatedProviders.clear();
        this.lookupIterator2 = null;
        this.loadedProviders.clear();
        this.loadedAllProviders = false;
        ++this.reloadCount;
    }

    public String toString() {
        return "java.util.ServiceLoader[" + this.service.getName() + "]";
    }

    private static class ProviderImpl<S>
    implements Provider<S> {
        final Class<S> service;
        final Class<? extends S> type;
        final Method factoryMethod;
        final Constructor<? extends S> ctor;
        final AccessControlContext acc;

        ProviderImpl(Class<S> service, Class<? extends S> type, Method factoryMethod, AccessControlContext acc) {
            this.service = service;
            this.type = type;
            this.factoryMethod = factoryMethod;
            this.ctor = null;
            this.acc = acc;
        }

        ProviderImpl(Class<S> service, Class<? extends S> type, Constructor<? extends S> ctor, AccessControlContext acc) {
            this.service = service;
            this.type = type;
            this.factoryMethod = null;
            this.ctor = ctor;
            this.acc = acc;
        }

        @Override
        public Class<? extends S> type() {
            return this.type;
        }

        @Override
        public S get() {
            if (this.factoryMethod != null) {
                return this.invokeFactoryMethod();
            }
            return this.newInstance();
        }

        private S invokeFactoryMethod() {
            Object result = null;
            Throwable exc = null;
            if (this.acc == null) {
                try {
                    result = this.factoryMethod.invoke(null, new Object[0]);
                }
                catch (Throwable x) {
                    exc = x;
                }
            } else {
                PrivilegedExceptionAction<Object> pa = new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        return factoryMethod.invoke(null, new Object[0]);
                    }
                };
                try {
                    result = AccessController.doPrivileged(pa, this.acc);
                }
                catch (Throwable x) {
                    if (x instanceof PrivilegedActionException) {
                        x = x.getCause();
                    }
                    exc = x;
                }
            }
            if (exc != null) {
                if (exc instanceof InvocationTargetException) {
                    exc = exc.getCause();
                }
                ServiceLoader.fail(this.service, this.factoryMethod + " failed", exc);
            }
            if (result == null) {
                ServiceLoader.fail(this.service, this.factoryMethod + " returned null");
            }
            Object p = result;
            return (S)p;
        }

        private S newInstance() {
            S p = null;
            Throwable exc = null;
            if (this.acc == null) {
                try {
                    p = this.ctor.newInstance(new Object[0]);
                }
                catch (Throwable x) {
                    exc = x;
                }
            } else {
                PrivilegedExceptionAction pa = new PrivilegedExceptionAction<S>(){

                    @Override
                    public S run() throws Exception {
                        return ctor.newInstance(new Object[0]);
                    }
                };
                try {
                    p = (S)AccessController.doPrivileged(pa, this.acc);
                }
                catch (Throwable x) {
                    if (x instanceof PrivilegedActionException) {
                        x = x.getCause();
                    }
                    exc = x;
                }
            }
            if (exc != null) {
                if (exc instanceof InvocationTargetException) {
                    exc = exc.getCause();
                }
                String cn = this.ctor.getDeclaringClass().getName();
                ServiceLoader.fail(this.service, "Provider " + cn + " could not be instantiated", exc);
            }
            return p;
        }

        public int hashCode() {
            return Objects.hash(this.service, this.type, this.acc);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object ob) {
            if (!(ob instanceof ProviderImpl)) return false;
            ProviderImpl that = (ProviderImpl)ob;
            if (this.service != that.service) return false;
            if (this.type != that.type) return false;
            if (!Objects.equals(this.acc, that.acc)) return false;
            return true;
        }
    }

    private final class LayerLookupIterator<T>
    implements Iterator<Provider<T>> {
        Deque<ModuleLayer> stack = new ArrayDeque<ModuleLayer>();
        Set<ModuleLayer> visited = new HashSet<ModuleLayer>();
        Iterator<ServicesCatalog.ServiceProvider> iterator;
        Provider<T> nextProvider;
        ServiceConfigurationError nextError;

        LayerLookupIterator() {
            this.visited.add(ServiceLoader.this.layer);
            this.stack.push(ServiceLoader.this.layer);
        }

        private Iterator<ServicesCatalog.ServiceProvider> providers(ModuleLayer layer) {
            ServicesCatalog catalog = LANG_ACCESS.getServicesCatalog(layer);
            return catalog.findServices(ServiceLoader.this.serviceName).iterator();
        }

        @Override
        public boolean hasNext() {
            while (this.nextProvider == null && this.nextError == null) {
                while (this.iterator == null || !this.iterator.hasNext()) {
                    if (this.stack.isEmpty()) {
                        return false;
                    }
                    ModuleLayer layer = this.stack.pop();
                    List<ModuleLayer> parents = layer.parents();
                    for (int i = parents.size() - 1; i >= 0; --i) {
                        ModuleLayer parent = parents.get(i);
                        if (!this.visited.add(parent)) continue;
                        this.stack.push(parent);
                    }
                    this.iterator = this.providers(layer);
                }
                ServicesCatalog.ServiceProvider provider = this.iterator.next();
                try {
                    Provider next = ServiceLoader.this.loadProvider(provider);
                    this.nextProvider = next;
                }
                catch (ServiceConfigurationError e) {
                    this.nextError = e;
                }
            }
            return true;
        }

        @Override
        public Provider<T> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Provider<T> provider = this.nextProvider;
            if (provider != null) {
                this.nextProvider = null;
                return provider;
            }
            ServiceConfigurationError e = this.nextError;
            assert (e != null);
            this.nextError = null;
            throw e;
        }
    }

    private final class ModuleServicesLookupIterator<T>
    implements Iterator<Provider<T>> {
        ClassLoader currentLoader;
        Iterator<ServicesCatalog.ServiceProvider> iterator;
        Provider<T> nextProvider;
        ServiceConfigurationError nextError;

        ModuleServicesLookupIterator() {
            this.currentLoader = ServiceLoader.this.loader;
            this.iterator = this.iteratorFor(ServiceLoader.this.loader);
        }

        private List<ServicesCatalog.ServiceProvider> providers(ModuleLayer layer) {
            ServicesCatalog catalog = LANG_ACCESS.getServicesCatalog(layer);
            return catalog.findServices(ServiceLoader.this.serviceName);
        }

        private ClassLoader loaderFor(Module module) {
            SecurityManager sm = System.getSecurityManager();
            if (sm == null) {
                return module.getClassLoader();
            }
            PrivilegedAction<ClassLoader> pa = module::getClassLoader;
            return AccessController.doPrivileged(pa);
        }

        private Iterator<ServicesCatalog.ServiceProvider> iteratorFor(ClassLoader loader) {
            ServicesCatalog catalog = loader == null ? BootLoader.getServicesCatalog() : ServicesCatalog.getServicesCatalogOrNull(loader);
            List<Object> providers = catalog == null ? List.of() : catalog.findServices(ServiceLoader.this.serviceName);
            ClassLoader platformClassLoader = ClassLoaders.platformClassLoader();
            if (loader == null || loader == platformClassLoader) {
                return providers.iterator();
            }
            ArrayList<Object> allProviders = new ArrayList<Object>(providers);
            Iterator iterator = LANG_ACCESS.layers(loader).iterator();
            while (iterator.hasNext()) {
                ModuleLayer layer = (ModuleLayer)iterator.next();
                for (ServicesCatalog.ServiceProvider sp : this.providers(layer)) {
                    ClassLoader l = this.loaderFor(sp.module());
                    if (l == null || l == platformClassLoader) continue;
                    allProviders.add(sp);
                }
            }
            return allProviders.iterator();
        }

        @Override
        public boolean hasNext() {
            while (this.nextProvider == null && this.nextError == null) {
                while (!this.iterator.hasNext()) {
                    if (this.currentLoader == null) {
                        return false;
                    }
                    this.currentLoader = this.currentLoader.getParent();
                    this.iterator = this.iteratorFor(this.currentLoader);
                }
                ServicesCatalog.ServiceProvider provider = this.iterator.next();
                try {
                    Provider next = ServiceLoader.this.loadProvider(provider);
                    this.nextProvider = next;
                }
                catch (ServiceConfigurationError e) {
                    this.nextError = e;
                }
            }
            return true;
        }

        @Override
        public Provider<T> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Provider<T> provider = this.nextProvider;
            if (provider != null) {
                this.nextProvider = null;
                return provider;
            }
            ServiceConfigurationError e = this.nextError;
            assert (e != null);
            this.nextError = null;
            throw e;
        }
    }

    private final class LazyClassPathLookupIterator<T>
    implements Iterator<Provider<T>> {
        static final String PREFIX = "META-INF/services/";
        Set<String> providerNames = new HashSet<String>();
        Enumeration<URL> configs;
        Iterator<String> pending;
        Provider<T> nextProvider;
        ServiceConfigurationError nextError;

        LazyClassPathLookupIterator() {
        }

        private int parseLine(URL u, BufferedReader r, int lc, Set<String> names) throws IOException {
            int n;
            String ln = r.readLine();
            if (ln == null) {
                return -1;
            }
            int ci = ln.indexOf(35);
            if (ci >= 0) {
                ln = ln.substring(0, ci);
            }
            if ((n = (ln = ln.trim()).length()) != 0) {
                int start;
                int cp;
                if (ln.indexOf(32) >= 0 || ln.indexOf(9) >= 0) {
                    ServiceLoader.fail(ServiceLoader.this.service, u, lc, "Illegal configuration-file syntax");
                }
                if (!Character.isJavaIdentifierStart(cp = ln.codePointAt(0))) {
                    ServiceLoader.fail(ServiceLoader.this.service, u, lc, "Illegal provider-class name: " + ln);
                }
                for (int i = start = Character.charCount(cp); i < n; i += Character.charCount(cp)) {
                    cp = ln.codePointAt(i);
                    if (Character.isJavaIdentifierPart(cp) || cp == 46) continue;
                    ServiceLoader.fail(ServiceLoader.this.service, u, lc, "Illegal provider-class name: " + ln);
                }
                if (this.providerNames.add(ln)) {
                    names.add(ln);
                }
            }
            return lc + 1;
        }

        private Iterator<String> parse(URL u) {
            LinkedHashSet<String> names = new LinkedHashSet<String>();
            try {
                URLConnection uc = u.openConnection();
                uc.setUseCaches(false);
                try (InputStream in = uc.getInputStream();
                     BufferedReader r = new BufferedReader(new InputStreamReader(in, UTF_8.INSTANCE));){
                    int lc = 1;
                    while ((lc = this.parseLine(u, r, lc, names)) >= 0) {
                    }
                }
            }
            catch (IOException x) {
                ServiceLoader.fail(ServiceLoader.this.service, "Error accessing configuration file", x);
            }
            return names.iterator();
        }

        private Class<?> nextProviderClass() {
            if (this.configs == null) {
                try {
                    String fullName = PREFIX + ServiceLoader.this.service.getName();
                    this.configs = ServiceLoader.this.loader == null ? ClassLoader.getSystemResources(fullName) : (ServiceLoader.this.loader == ClassLoaders.platformClassLoader() ? (BootLoader.hasClassPath() ? BootLoader.findResources(fullName) : Collections.emptyEnumeration()) : ServiceLoader.this.loader.getResources(fullName));
                }
                catch (IOException x) {
                    ServiceLoader.fail(ServiceLoader.this.service, "Error locating configuration files", x);
                }
            }
            while (this.pending == null || !this.pending.hasNext()) {
                if (!this.configs.hasMoreElements()) {
                    return null;
                }
                this.pending = this.parse(this.configs.nextElement());
            }
            String cn = this.pending.next();
            try {
                return Class.forName(cn, false, ServiceLoader.this.loader);
            }
            catch (ClassNotFoundException x) {
                ServiceLoader.fail(ServiceLoader.this.service, "Provider " + cn + " not found");
                return null;
            }
        }

        private boolean hasNextService() {
            while (this.nextProvider == null && this.nextError == null) {
                try {
                    Class<?> clazz = this.nextProviderClass();
                    if (clazz == null) {
                        return false;
                    }
                    if (clazz.getModule().isNamed()) continue;
                    if (ServiceLoader.this.service.isAssignableFrom(clazz)) {
                        Class<?> type = clazz;
                        Constructor<?> ctor = ServiceLoader.this.getConstructor(clazz);
                        ProviderImpl<T> p = new ProviderImpl<T>(ServiceLoader.this.service, type, ctor, ServiceLoader.this.acc);
                        this.nextProvider = p;
                        continue;
                    }
                    ServiceLoader.fail(ServiceLoader.this.service, clazz.getName() + " not a subtype");
                }
                catch (ServiceConfigurationError e) {
                    this.nextError = e;
                }
            }
            return true;
        }

        private Provider<T> nextService() {
            if (!this.hasNextService()) {
                throw new NoSuchElementException();
            }
            Provider<T> provider = this.nextProvider;
            if (provider != null) {
                this.nextProvider = null;
                return provider;
            }
            ServiceConfigurationError e = this.nextError;
            assert (e != null);
            this.nextError = null;
            throw e;
        }

        @Override
        public boolean hasNext() {
            if (ServiceLoader.this.acc == null) {
                return this.hasNextService();
            }
            PrivilegedAction<Boolean> action = new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return LazyClassPathLookupIterator.this.hasNextService();
                }
            };
            return AccessController.doPrivileged(action, ServiceLoader.this.acc);
        }

        @Override
        public Provider<T> next() {
            if (ServiceLoader.this.acc == null) {
                return this.nextService();
            }
            PrivilegedAction action = new PrivilegedAction<Provider<T>>(){

                @Override
                public Provider<T> run() {
                    return LazyClassPathLookupIterator.this.nextService();
                }
            };
            return (Provider)AccessController.doPrivileged(action, ServiceLoader.this.acc);
        }
    }

    private class ProviderSpliterator<T>
    implements Spliterator<Provider<T>> {
        final int expectedReloadCount;
        final Iterator<Provider<T>> iterator;
        int index;

        ProviderSpliterator(Iterator<Provider<T>> iterator) {
            this.expectedReloadCount = ServiceLoader.this.reloadCount;
            this.iterator = iterator;
        }

        @Override
        public Spliterator<Provider<T>> trySplit() {
            return null;
        }

        @Override
        public boolean tryAdvance(Consumer<? super Provider<T>> action) {
            if (ServiceLoader.this.reloadCount != this.expectedReloadCount) {
                throw new ConcurrentModificationException();
            }
            Provider<Object> next = null;
            if (this.index < ServiceLoader.this.loadedProviders.size()) {
                next = ServiceLoader.this.loadedProviders.get(this.index++);
            } else if (this.iterator.hasNext()) {
                next = this.iterator.next();
                ServiceLoader.this.loadedProviders.add(next);
                ++this.index;
            } else {
                ServiceLoader.this.loadedAllProviders = true;
            }
            if (next != null) {
                action.accept(next);
                return true;
            }
            return false;
        }

        @Override
        public int characteristics() {
            return 16;
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }
    }

    public static interface Provider<S>
    extends Supplier<S> {
        public Class<? extends S> type();

        @Override
        public S get();
    }
}

