/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.TimeZone;
import sun.util.calendar.AbstractCalendar;
import sun.util.calendar.BaseCalendar;
import sun.util.calendar.CalendarSystem;
import sun.util.calendar.CalendarUtils;
import sun.util.calendar.Gregorian;

public class SimpleTimeZone
extends TimeZone {
    private int startMonth;
    private int startDay;
    private int startDayOfWeek;
    private int startTime;
    private int startTimeMode;
    private int endMonth;
    private int endDay;
    private int endDayOfWeek;
    private int endTime;
    private int endTimeMode;
    private int startYear;
    private int rawOffset;
    private boolean useDaylight = false;
    private static final int millisPerHour = 3600000;
    private static final int millisPerDay = 86400000;
    private final byte[] monthLength = staticMonthLength;
    private static final byte[] staticMonthLength = new byte[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final byte[] staticLeapMonthLength = new byte[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private int startMode;
    private int endMode;
    private int dstSavings;
    private static final Gregorian gcal = CalendarSystem.getGregorianCalendar();
    private volatile transient Cache cache;
    private static final int DOM_MODE = 1;
    private static final int DOW_IN_MONTH_MODE = 2;
    private static final int DOW_GE_DOM_MODE = 3;
    private static final int DOW_LE_DOM_MODE = 4;
    public static final int WALL_TIME = 0;
    public static final int STANDARD_TIME = 1;
    public static final int UTC_TIME = 2;
    static final long serialVersionUID = -403250971215465050L;
    static final int currentSerialVersion = 2;
    private int serialVersionOnStream = 2;
    private static final int MAX_RULE_NUM = 6;

    public SimpleTimeZone(int rawOffset, String ID) {
        this.rawOffset = rawOffset;
        this.setID(ID);
        this.dstSavings = 3600000;
    }

    public SimpleTimeZone(int rawOffset, String ID, int startMonth, int startDay, int startDayOfWeek, int startTime, int endMonth, int endDay, int endDayOfWeek, int endTime) {
        this(rawOffset, ID, startMonth, startDay, startDayOfWeek, startTime, 0, endMonth, endDay, endDayOfWeek, endTime, 0, 3600000);
    }

    public SimpleTimeZone(int rawOffset, String ID, int startMonth, int startDay, int startDayOfWeek, int startTime, int endMonth, int endDay, int endDayOfWeek, int endTime, int dstSavings) {
        this(rawOffset, ID, startMonth, startDay, startDayOfWeek, startTime, 0, endMonth, endDay, endDayOfWeek, endTime, 0, dstSavings);
    }

    public SimpleTimeZone(int rawOffset, String ID, int startMonth, int startDay, int startDayOfWeek, int startTime, int startTimeMode, int endMonth, int endDay, int endDayOfWeek, int endTime, int endTimeMode, int dstSavings) {
        this.setID(ID);
        this.rawOffset = rawOffset;
        this.startMonth = startMonth;
        this.startDay = startDay;
        this.startDayOfWeek = startDayOfWeek;
        this.startTime = startTime;
        this.startTimeMode = startTimeMode;
        this.endMonth = endMonth;
        this.endDay = endDay;
        this.endDayOfWeek = endDayOfWeek;
        this.endTime = endTime;
        this.endTimeMode = endTimeMode;
        this.dstSavings = dstSavings;
        this.decodeRules();
        if (dstSavings <= 0) {
            throw new IllegalArgumentException("Illegal daylight saving value: " + dstSavings);
        }
    }

    public void setStartYear(int year) {
        this.startYear = year;
        this.invalidateCache();
    }

    public void setStartRule(int startMonth, int startDay, int startDayOfWeek, int startTime) {
        this.startMonth = startMonth;
        this.startDay = startDay;
        this.startDayOfWeek = startDayOfWeek;
        this.startTime = startTime;
        this.startTimeMode = 0;
        this.decodeStartRule();
        this.invalidateCache();
    }

    public void setStartRule(int startMonth, int startDay, int startTime) {
        this.setStartRule(startMonth, startDay, 0, startTime);
    }

    public void setStartRule(int startMonth, int startDay, int startDayOfWeek, int startTime, boolean after) {
        if (after) {
            this.setStartRule(startMonth, startDay, -startDayOfWeek, startTime);
        } else {
            this.setStartRule(startMonth, -startDay, -startDayOfWeek, startTime);
        }
    }

    public void setEndRule(int endMonth, int endDay, int endDayOfWeek, int endTime) {
        this.endMonth = endMonth;
        this.endDay = endDay;
        this.endDayOfWeek = endDayOfWeek;
        this.endTime = endTime;
        this.endTimeMode = 0;
        this.decodeEndRule();
        this.invalidateCache();
    }

    public void setEndRule(int endMonth, int endDay, int endTime) {
        this.setEndRule(endMonth, endDay, 0, endTime);
    }

    public void setEndRule(int endMonth, int endDay, int endDayOfWeek, int endTime, boolean after) {
        if (after) {
            this.setEndRule(endMonth, endDay, -endDayOfWeek, endTime);
        } else {
            this.setEndRule(endMonth, -endDay, -endDayOfWeek, endTime);
        }
    }

    @Override
    public int getOffset(long date) {
        return this.getOffsets(date, null);
    }

    @Override
    int getOffsets(long date, int[] offsets) {
        int offset = this.rawOffset;
        if (this.useDaylight) {
            Cache cache = this.cache;
            if (cache != null && date >= cache.start && date < cache.end) {
                offset += this.dstSavings;
            } else {
                Gregorian cal = date >= -12219292800000L ? gcal : (BaseCalendar)CalendarSystem.forName("julian");
                BaseCalendar.Date cdate = (BaseCalendar.Date)((CalendarSystem)cal).newCalendarDate(TimeZone.NO_TIMEZONE);
                ((AbstractCalendar)cal).getCalendarDate(date + (long)this.rawOffset, cdate);
                int year = cdate.getNormalizedYear();
                if (year >= this.startYear) {
                    cdate.setTimeOfDay(0, 0, 0, 0);
                    offset = this.getOffset(cal, cdate, year, date);
                }
            }
        }
        if (offsets != null) {
            offsets[0] = this.rawOffset;
            offsets[1] = offset - this.rawOffset;
        }
        return offset;
    }

    @Override
    public int getOffset(int era, int year, int month, int day, int dayOfWeek, int millis) {
        if (era != 1 && era != 0) {
            throw new IllegalArgumentException("Illegal era " + era);
        }
        int y = year;
        if (era == 0) {
            y = 1 - y;
        }
        if (y >= 292278994) {
            y = 2800 + y % 2800;
        } else if (y <= -292269054) {
            y = (int)CalendarUtils.mod((long)y, 28L);
        }
        int m = month + 1;
        BaseCalendar cal = gcal;
        BaseCalendar.Date cdate = (BaseCalendar.Date)cal.newCalendarDate(TimeZone.NO_TIMEZONE);
        cdate.setDate(y, m, day);
        long time = cal.getTime(cdate);
        if ((time += (long)(millis - this.rawOffset)) < -12219292800000L) {
            cal = (BaseCalendar)CalendarSystem.forName("julian");
            cdate = (BaseCalendar.Date)cal.newCalendarDate(TimeZone.NO_TIMEZONE);
            cdate.setNormalizedDate(y, m, day);
            time = cal.getTime(cdate) + (long)millis - (long)this.rawOffset;
        }
        if (cdate.getNormalizedYear() != y || cdate.getMonth() != m || cdate.getDayOfMonth() != day || dayOfWeek < 1 || dayOfWeek > 7 || millis < 0 || millis >= 86400000) {
            throw new IllegalArgumentException();
        }
        if (!this.useDaylight || year < this.startYear || era != 1) {
            return this.rawOffset;
        }
        return this.getOffset(cal, cdate, y, time);
    }

    private int getOffset(BaseCalendar cal, BaseCalendar.Date cdate, int year, long time) {
        Cache cache = this.cache;
        if (cache != null) {
            if (time >= cache.start && time < cache.end) {
                return this.rawOffset + this.dstSavings;
            }
            if ((long)year == cache.year) {
                return this.rawOffset;
            }
        }
        long start = this.getStart(cal, cdate, year);
        long end = this.getEnd(cal, cdate, year);
        int offset = this.rawOffset;
        if (start <= end) {
            if (time >= start && time < end) {
                offset += this.dstSavings;
            }
            this.cache = new Cache(year, start, end);
        } else {
            if (time < end) {
                start = this.getStart(cal, cdate, year - 1);
                if (time >= start) {
                    offset += this.dstSavings;
                }
            } else if (time >= start && time < (end = this.getEnd(cal, cdate, year + 1))) {
                offset += this.dstSavings;
            }
            if (start <= end) {
                this.cache = new Cache((long)this.startYear - 1L, start, end);
            }
        }
        return offset;
    }

    private long getStart(BaseCalendar cal, BaseCalendar.Date cdate, int year) {
        int time = this.startTime;
        if (this.startTimeMode != 2) {
            time -= this.rawOffset;
        }
        return this.getTransition(cal, cdate, this.startMode, year, this.startMonth, this.startDay, this.startDayOfWeek, time);
    }

    private long getEnd(BaseCalendar cal, BaseCalendar.Date cdate, int year) {
        int time = this.endTime;
        if (this.endTimeMode != 2) {
            time -= this.rawOffset;
        }
        if (this.endTimeMode == 0) {
            time -= this.dstSavings;
        }
        return this.getTransition(cal, cdate, this.endMode, year, this.endMonth, this.endDay, this.endDayOfWeek, time);
    }

    private long getTransition(BaseCalendar cal, BaseCalendar.Date cdate, int mode, int year, int month, int dayOfMonth, int dayOfWeek, int timeOfDay) {
        cdate.setNormalizedYear(year);
        cdate.setMonth(month + 1);
        switch (mode) {
            case 1: {
                cdate.setDayOfMonth(dayOfMonth);
                break;
            }
            case 2: {
                cdate.setDayOfMonth(1);
                if (dayOfMonth < 0) {
                    cdate.setDayOfMonth(cal.getMonthLength(cdate));
                }
                cdate = (BaseCalendar.Date)cal.getNthDayOfWeek(dayOfMonth, dayOfWeek, cdate);
                break;
            }
            case 3: {
                cdate.setDayOfMonth(dayOfMonth);
                cdate = (BaseCalendar.Date)cal.getNthDayOfWeek(1, dayOfWeek, cdate);
                break;
            }
            case 4: {
                cdate.setDayOfMonth(dayOfMonth);
                cdate = (BaseCalendar.Date)cal.getNthDayOfWeek(-1, dayOfWeek, cdate);
            }
        }
        return cal.getTime(cdate) + (long)timeOfDay;
    }

    @Override
    public int getRawOffset() {
        return this.rawOffset;
    }

    @Override
    public void setRawOffset(int offsetMillis) {
        this.rawOffset = offsetMillis;
    }

    public void setDSTSavings(int millisSavedDuringDST) {
        if (millisSavedDuringDST <= 0) {
            throw new IllegalArgumentException("Illegal daylight saving value: " + millisSavedDuringDST);
        }
        this.dstSavings = millisSavedDuringDST;
    }

    @Override
    public int getDSTSavings() {
        return this.useDaylight ? this.dstSavings : 0;
    }

    @Override
    public boolean useDaylightTime() {
        return this.useDaylight;
    }

    @Override
    public boolean observesDaylightTime() {
        return this.useDaylightTime();
    }

    @Override
    public boolean inDaylightTime(Date date) {
        return this.getOffset(date.getTime()) != this.rawOffset;
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    public int hashCode() {
        return this.startMonth ^ this.startDay ^ this.startDayOfWeek ^ this.startTime ^ this.endMonth ^ this.endDay ^ this.endDayOfWeek ^ this.endTime ^ this.rawOffset;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SimpleTimeZone)) return false;
        SimpleTimeZone that = (SimpleTimeZone)obj;
        if (!this.getID().equals(that.getID())) return false;
        if (!this.hasSameRules(that)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasSameRules(TimeZone other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SimpleTimeZone)) return false;
        SimpleTimeZone that = (SimpleTimeZone)other;
        if (this.rawOffset != that.rawOffset) return false;
        if (this.useDaylight != that.useDaylight) return false;
        if (!this.useDaylight) return true;
        if (this.dstSavings != that.dstSavings) return false;
        if (this.startMode != that.startMode) return false;
        if (this.startMonth != that.startMonth) return false;
        if (this.startDay != that.startDay) return false;
        if (this.startDayOfWeek != that.startDayOfWeek) return false;
        if (this.startTime != that.startTime) return false;
        if (this.startTimeMode != that.startTimeMode) return false;
        if (this.endMode != that.endMode) return false;
        if (this.endMonth != that.endMonth) return false;
        if (this.endDay != that.endDay) return false;
        if (this.endDayOfWeek != that.endDayOfWeek) return false;
        if (this.endTime != that.endTime) return false;
        if (this.endTimeMode != that.endTimeMode) return false;
        if (this.startYear != that.startYear) return false;
        return true;
    }

    public String toString() {
        return this.getClass().getName() + "[id=" + this.getID() + ",offset=" + this.rawOffset + ",dstSavings=" + this.dstSavings + ",useDaylight=" + this.useDaylight + ",startYear=" + this.startYear + ",startMode=" + this.startMode + ",startMonth=" + this.startMonth + ",startDay=" + this.startDay + ",startDayOfWeek=" + this.startDayOfWeek + ",startTime=" + this.startTime + ",startTimeMode=" + this.startTimeMode + ",endMode=" + this.endMode + ",endMonth=" + this.endMonth + ",endDay=" + this.endDay + ",endDayOfWeek=" + this.endDayOfWeek + ",endTime=" + this.endTime + ",endTimeMode=" + this.endTimeMode + ']';
    }

    private void invalidateCache() {
        this.cache = null;
    }

    private void decodeRules() {
        this.decodeStartRule();
        this.decodeEndRule();
    }

    private void decodeStartRule() {
        boolean bl = this.useDaylight = this.startDay != 0 && this.endDay != 0;
        if (this.startDay != 0) {
            if (this.startMonth < 0 || this.startMonth > 11) {
                throw new IllegalArgumentException("Illegal start month " + this.startMonth);
            }
            if (this.startTime < 0 || this.startTime > 86400000) {
                throw new IllegalArgumentException("Illegal start time " + this.startTime);
            }
            if (this.startDayOfWeek == 0) {
                this.startMode = 1;
            } else {
                if (this.startDayOfWeek > 0) {
                    this.startMode = 2;
                } else {
                    this.startDayOfWeek = -this.startDayOfWeek;
                    if (this.startDay > 0) {
                        this.startMode = 3;
                    } else {
                        this.startDay = -this.startDay;
                        this.startMode = 4;
                    }
                }
                if (this.startDayOfWeek > 7) {
                    throw new IllegalArgumentException("Illegal start day of week " + this.startDayOfWeek);
                }
            }
            if (this.startMode == 2) {
                if (this.startDay < -5 || this.startDay > 5) {
                    throw new IllegalArgumentException("Illegal start day of week in month " + this.startDay);
                }
            } else if (this.startDay < 1 || this.startDay > staticMonthLength[this.startMonth]) {
                throw new IllegalArgumentException("Illegal start day " + this.startDay);
            }
        }
    }

    private void decodeEndRule() {
        boolean bl = this.useDaylight = this.startDay != 0 && this.endDay != 0;
        if (this.endDay != 0) {
            if (this.endMonth < 0 || this.endMonth > 11) {
                throw new IllegalArgumentException("Illegal end month " + this.endMonth);
            }
            if (this.endTime < 0 || this.endTime > 86400000) {
                throw new IllegalArgumentException("Illegal end time " + this.endTime);
            }
            if (this.endDayOfWeek == 0) {
                this.endMode = 1;
            } else {
                if (this.endDayOfWeek > 0) {
                    this.endMode = 2;
                } else {
                    this.endDayOfWeek = -this.endDayOfWeek;
                    if (this.endDay > 0) {
                        this.endMode = 3;
                    } else {
                        this.endDay = -this.endDay;
                        this.endMode = 4;
                    }
                }
                if (this.endDayOfWeek > 7) {
                    throw new IllegalArgumentException("Illegal end day of week " + this.endDayOfWeek);
                }
            }
            if (this.endMode == 2) {
                if (this.endDay < -5 || this.endDay > 5) {
                    throw new IllegalArgumentException("Illegal end day of week in month " + this.endDay);
                }
            } else if (this.endDay < 1 || this.endDay > staticMonthLength[this.endMonth]) {
                throw new IllegalArgumentException("Illegal end day " + this.endDay);
            }
        }
    }

    private void makeRulesCompatible() {
        switch (this.startMode) {
            case 1: {
                this.startDay = 1 + this.startDay / 7;
                this.startDayOfWeek = 1;
                break;
            }
            case 3: {
                if (this.startDay == 1) break;
                this.startDay = 1 + this.startDay / 7;
                break;
            }
            case 4: {
                this.startDay = this.startDay >= 30 ? -1 : 1 + this.startDay / 7;
            }
        }
        switch (this.endMode) {
            case 1: {
                this.endDay = 1 + this.endDay / 7;
                this.endDayOfWeek = 1;
                break;
            }
            case 3: {
                if (this.endDay == 1) break;
                this.endDay = 1 + this.endDay / 7;
                break;
            }
            case 4: {
                this.endDay = this.endDay >= 30 ? -1 : 1 + this.endDay / 7;
            }
        }
        switch (this.startTimeMode) {
            case 2: {
                this.startTime += this.rawOffset;
            }
        }
        while (this.startTime < 0) {
            this.startTime += 86400000;
            this.startDayOfWeek = 1 + (this.startDayOfWeek + 5) % 7;
        }
        while (this.startTime >= 86400000) {
            this.startTime -= 86400000;
            this.startDayOfWeek = 1 + this.startDayOfWeek % 7;
        }
        switch (this.endTimeMode) {
            case 2: {
                this.endTime += this.rawOffset + this.dstSavings;
                break;
            }
            case 1: {
                this.endTime += this.dstSavings;
            }
        }
        while (this.endTime < 0) {
            this.endTime += 86400000;
            this.endDayOfWeek = 1 + (this.endDayOfWeek + 5) % 7;
        }
        while (this.endTime >= 86400000) {
            this.endTime -= 86400000;
            this.endDayOfWeek = 1 + this.endDayOfWeek % 7;
        }
    }

    private byte[] packRules() {
        byte[] rules = new byte[]{(byte)this.startDay, (byte)this.startDayOfWeek, (byte)this.endDay, (byte)this.endDayOfWeek, (byte)this.startTimeMode, (byte)this.endTimeMode};
        return rules;
    }

    private void unpackRules(byte[] rules) {
        this.startDay = rules[0];
        this.startDayOfWeek = rules[1];
        this.endDay = rules[2];
        this.endDayOfWeek = rules[3];
        if (rules.length >= 6) {
            this.startTimeMode = rules[4];
            this.endTimeMode = rules[5];
        }
    }

    private int[] packTimes() {
        int[] times = new int[]{this.startTime, this.endTime};
        return times;
    }

    private void unpackTimes(int[] times) {
        this.startTime = times[0];
        this.endTime = times[1];
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        byte[] rules = this.packRules();
        int[] times = this.packTimes();
        this.makeRulesCompatible();
        stream.defaultWriteObject();
        stream.writeInt(rules.length);
        stream.write(rules);
        stream.writeObject(times);
        this.unpackRules(rules);
        this.unpackTimes(times);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.serialVersionOnStream < 1) {
            if (this.startDayOfWeek == 0) {
                this.startDayOfWeek = 1;
            }
            if (this.endDayOfWeek == 0) {
                this.endDayOfWeek = 1;
            }
            this.endMode = 2;
            this.startMode = 2;
            this.dstSavings = 3600000;
        } else {
            int length = stream.readInt();
            if (length <= 6) {
                byte[] rules = new byte[length];
                stream.readFully(rules);
                this.unpackRules(rules);
            } else {
                throw new InvalidObjectException("Too many rules: " + length);
            }
        }
        if (this.serialVersionOnStream >= 2) {
            int[] times = (int[])stream.readObject();
            this.unpackTimes(times);
        }
        this.serialVersionOnStream = 2;
    }

    private static final class Cache {
        final long year;
        final long start;
        final long end;

        Cache(long year, long start, long end) {
            this.year = year;
            this.start = start;
            this.end = end;
        }
    }
}

