/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.concurrent.atomic.AtomicLong;
import java.util.random.RandomGenerator;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import jdk.internal.util.random.RandomSupport;

@RandomSupport.RandomGeneratorProperties(name="SplittableRandom", i=64, j=0, k=0, equidistribution=1)
public final class SplittableRandom
implements RandomGenerator,
RandomGenerator.SplittableGenerator {
    private static final long GOLDEN_GAMMA = -7046029254386353131L;
    private long seed;
    private final long gamma;
    private AbstractSplittableGeneratorProxy proxy;
    private static final AtomicLong defaultGen = new AtomicLong(RandomSupport.initialSeed());

    private SplittableRandom(long seed, long gamma) {
        this.seed = seed;
        this.gamma = gamma;
        this.proxy = new AbstractSplittableGeneratorProxy();
    }

    private static long mix64(long z) {
        z = (z ^ z >>> 30) * -4658895280553007687L;
        z = (z ^ z >>> 27) * -7723592293110705685L;
        return z ^ z >>> 31;
    }

    private static int mix32(long z) {
        z = (z ^ z >>> 33) * 7109453100751455733L;
        return (int)((z ^ z >>> 28) * -3808689974395783757L >>> 32);
    }

    private static long mixGamma(long z) {
        z = (z ^ z >>> 33) * -49064778989728563L;
        z = (z ^ z >>> 33) * -4265267296055464877L;
        int n = Long.bitCount((z = z ^ z >>> 33 | 1L) ^ z >>> 1);
        return n < 24 ? z ^ 0xAAAAAAAAAAAAAAAAL : z;
    }

    private long nextSeed() {
        return this.seed += this.gamma;
    }

    public SplittableRandom(long seed) {
        this(seed, -7046029254386353131L);
    }

    public SplittableRandom() {
        long s = defaultGen.getAndAdd(4354685564936845354L);
        this.seed = SplittableRandom.mix64(s);
        this.gamma = SplittableRandom.mixGamma(s + -7046029254386353131L);
        this.proxy = new AbstractSplittableGeneratorProxy();
    }

    @Override
    public SplittableRandom split() {
        return new SplittableRandom(this.nextLong(), SplittableRandom.mixGamma(this.nextSeed()));
    }

    @Override
    public SplittableRandom split(RandomGenerator.SplittableGenerator source) {
        return new SplittableRandom(source.nextLong(), SplittableRandom.mixGamma(source.nextLong()));
    }

    @Override
    public int nextInt() {
        return SplittableRandom.mix32(this.nextSeed());
    }

    @Override
    public long nextLong() {
        return SplittableRandom.mix64(this.nextSeed());
    }

    @Override
    public void nextBytes(byte[] bytes) {
        this.proxy.nextBytes(bytes);
    }

    @Override
    public Stream<RandomGenerator.SplittableGenerator> splits() {
        return this.proxy.splits();
    }

    @Override
    public Stream<RandomGenerator.SplittableGenerator> splits(long streamSize) {
        return this.proxy.splits(streamSize, this);
    }

    @Override
    public Stream<RandomGenerator.SplittableGenerator> splits(RandomGenerator.SplittableGenerator source) {
        return this.proxy.splits(Long.MAX_VALUE, source);
    }

    @Override
    public Stream<RandomGenerator.SplittableGenerator> splits(long streamSize, RandomGenerator.SplittableGenerator source) {
        return this.proxy.splits(streamSize, source);
    }

    @Override
    public IntStream ints(long streamSize) {
        return this.proxy.ints(streamSize);
    }

    @Override
    public IntStream ints() {
        return this.proxy.ints();
    }

    @Override
    public IntStream ints(long streamSize, int randomNumberOrigin, int randomNumberBound) {
        return this.proxy.ints(streamSize, randomNumberOrigin, randomNumberBound);
    }

    @Override
    public IntStream ints(int randomNumberOrigin, int randomNumberBound) {
        return this.proxy.ints(randomNumberOrigin, randomNumberBound);
    }

    @Override
    public LongStream longs(long streamSize) {
        return this.proxy.longs(streamSize);
    }

    @Override
    public LongStream longs() {
        return this.proxy.longs();
    }

    @Override
    public LongStream longs(long streamSize, long randomNumberOrigin, long randomNumberBound) {
        return this.proxy.longs(streamSize, randomNumberOrigin, randomNumberBound);
    }

    @Override
    public LongStream longs(long randomNumberOrigin, long randomNumberBound) {
        return this.proxy.longs(randomNumberOrigin, randomNumberBound);
    }

    @Override
    public DoubleStream doubles(long streamSize) {
        return this.proxy.doubles(streamSize);
    }

    @Override
    public DoubleStream doubles() {
        return this.proxy.doubles();
    }

    @Override
    public DoubleStream doubles(long streamSize, double randomNumberOrigin, double randomNumberBound) {
        return this.proxy.doubles(streamSize, randomNumberOrigin, randomNumberBound);
    }

    @Override
    public DoubleStream doubles(double randomNumberOrigin, double randomNumberBound) {
        return this.proxy.doubles(randomNumberOrigin, randomNumberBound);
    }

    private class AbstractSplittableGeneratorProxy
    extends RandomSupport.AbstractSplittableGenerator {
        private AbstractSplittableGeneratorProxy() {
        }

        @Override
        public int nextInt() {
            return SplittableRandom.this.nextInt();
        }

        @Override
        public long nextLong() {
            return SplittableRandom.this.nextLong();
        }

        @Override
        public SplittableRandom split(RandomGenerator.SplittableGenerator source) {
            return new SplittableRandom(source.nextLong(), SplittableRandom.mixGamma(source.nextLong()));
        }
    }
}

