/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Iterator;
import org.qbicc.runtime.Build;
import org.qbicc.runtime.CNative;
import org.qbicc.runtime.stdc.Time;

public class TimeZone$_native {
    private static String getSystemTimeZoneID(String javaHome) {
        String tz = System.getenv("TZ");
        if (tz == null || tz.isEmpty()) {
            tz = TimeZone$_native.getPlatformTimeZoneID();
        }
        if (tz == null) {
            return null;
        }
        if (tz.startsWith(":")) {
            tz = tz.substring(1);
        }
        if (Build.Target.isLinux() && tz.startsWith("posix/")) {
            tz = tz.substring(6);
        }
        if (Build.Target.isAix()) {
            throw new UnsupportedOperationException();
        }
        return tz;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getPlatformTimeZoneID() {
        Path localTimePath;
        if (Build.Target.isLinux()) {
            try (BufferedReader br2222 = Files.newBufferedReader(Path.of("/etc/timezone", new String[0]), StandardCharsets.UTF_8);){
                String line = br2222.readLine();
                if (line != null) {
                    String string = line.trim();
                    return string;
                }
            }
            catch (IOException br2222) {
                // empty catch block
            }
        }
        if (Files.isSymbolicLink(localTimePath = Path.of("/etc/localtime", new String[0]))) {
            try {
                Path linkPath = Files.readSymbolicLink(localTimePath);
                String str = linkPath.toString();
                int idx = str.indexOf("zoneinfo/");
                if (idx != -1) {
                    return str.substring(idx);
                }
            }
            catch (IOException linkPath) {
                // empty catch block
            }
        }
        try {
            byte[] bytes = Files.readAllBytes(localTimePath);
            Path zoneInfo = Path.of("/usr/share/zoneinfo", new String[0]);
            return TimeZone$_native.searchZoneInfo(bytes, zoneInfo);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String searchZoneInfo(byte[] bytes, Path zoneInfo) {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(zoneInfo);){
            Iterator<Path> iterator = stream.iterator();
            while (iterator.hasNext()) {
                Path path = iterator.next();
                if (Files.isDirectory(path, new LinkOption[0])) {
                    String result;
                    if (path.endsWith(".") || path.endsWith("..") || (result = TimeZone$_native.searchZoneInfo(bytes, path)) == null) continue;
                    String string = result;
                    return string;
                }
                String fnStr = path.getFileName().toString();
                if (fnStr.equals("ROC") || fnStr.equals("posixrules") || fnStr.equals("localtime")) continue;
                try {
                    String str;
                    int idx;
                    byte[] fileBytes = Files.readAllBytes(path);
                    if (!Arrays.equals(bytes, fileBytes) || (idx = (str = path.toString()).indexOf("zoneinfo/")) == -1) continue;
                    String string = str.substring(idx);
                    return string;
                }
                catch (IOException iOException) {}
            }
            return null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static String getSystemGMTOffsetID() {
        char sign;
        Time.time_t offset;
        if (Build.Target.isMacOs()) {
            Time.struct_tm local_tm = (Time.struct_tm)CNative.auto();
            Time.time_t clock = Time.time((Time.time_t_ptr)((Time.time_t_ptr)CNative.zero()));
            if (org.qbicc.runtime.posix.Time.localtime_r((Time.const_time_t_ptr)((Time.const_time_t_ptr)CNative.addr_of((CNative.object)clock)), (Time.struct_tm_ptr)((Time.struct_tm_ptr)CNative.addr_of((CNative.object)local_tm))).isNull()) {
                return "GMT";
            }
            offset = (Time.time_t)((CNative.c_int)CNative.addr_of((CNative.object)local_tm.tm_gmtoff).loadUnshared()).cast();
            if (offset.isZero()) {
                return "GMT";
            }
            if (offset.isGt((CNative.word)CNative.zero())) {
                sign = '+';
            } else {
                offset = (Time.time_t)CNative.word((long)(-offset.longValue()));
                sign = '-';
            }
        } else if (Build.Target.isPosix()) {
            offset = (Time.time_t)org.qbicc.runtime.posix.Time.timezone.cast();
            if (offset.isZero()) {
                return "GMT";
            }
            if (offset.isGt((CNative.word)CNative.zero())) {
                sign = '-';
            } else {
                offset = (Time.time_t)CNative.word((long)(-offset.longValue()));
                sign = '+';
            }
        } else {
            throw new UnsupportedOperationException();
        }
        int h = offset.intValue() / 3600;
        int m = offset.intValue() % 3600 / 60;
        StringBuilder sb = new StringBuilder(9);
        sb.append("GMT");
        sb.append(sign);
        if (h < 10) {
            sb.append('0');
        }
        sb.append(h);
        sb.append(':');
        if (m < 10) {
            sb.append('0');
        }
        sb.append(m);
        return sb.toString();
    }
}

