/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.lang.ref.Cleaner;
import java.util.Date;
import java.util.TaskQueue;
import java.util.TimerTask;
import java.util.TimerThread;
import java.util.concurrent.atomic.AtomicInteger;
import jdk.internal.ref.CleanerFactory;

public class Timer {
    private final TaskQueue queue = new TaskQueue();
    private final TimerThread thread = new TimerThread(this.queue);
    private final Cleaner.Cleanable cleanup;
    private static final AtomicInteger nextSerialNumber = new AtomicInteger();

    private static int serialNumber() {
        return nextSerialNumber.getAndIncrement();
    }

    public Timer() {
        this("Timer-" + Timer.serialNumber());
    }

    public Timer(boolean isDaemon) {
        this("Timer-" + Timer.serialNumber(), isDaemon);
    }

    public Timer(String name) {
        this(name, false);
    }

    public Timer(String name, boolean isDaemon) {
        ThreadReaper threadReaper = new ThreadReaper(this.queue, this.thread);
        this.cleanup = CleanerFactory.cleaner().register(this, threadReaper);
        this.thread.setName(name);
        this.thread.setDaemon(isDaemon);
        this.thread.start();
    }

    public void schedule(TimerTask task, long delay) {
        if (delay < 0L) {
            throw new IllegalArgumentException("Negative delay.");
        }
        this.sched(task, System.currentTimeMillis() + delay, 0L);
    }

    public void schedule(TimerTask task, Date time) {
        this.sched(task, time.getTime(), 0L);
    }

    public void schedule(TimerTask task, long delay, long period) {
        if (delay < 0L) {
            throw new IllegalArgumentException("Negative delay.");
        }
        if (period <= 0L) {
            throw new IllegalArgumentException("Non-positive period.");
        }
        this.sched(task, System.currentTimeMillis() + delay, -period);
    }

    public void schedule(TimerTask task, Date firstTime, long period) {
        if (period <= 0L) {
            throw new IllegalArgumentException("Non-positive period.");
        }
        this.sched(task, firstTime.getTime(), -period);
    }

    public void scheduleAtFixedRate(TimerTask task, long delay, long period) {
        if (delay < 0L) {
            throw new IllegalArgumentException("Negative delay.");
        }
        if (period <= 0L) {
            throw new IllegalArgumentException("Non-positive period.");
        }
        this.sched(task, System.currentTimeMillis() + delay, period);
    }

    public void scheduleAtFixedRate(TimerTask task, Date firstTime, long period) {
        if (period <= 0L) {
            throw new IllegalArgumentException("Non-positive period.");
        }
        this.sched(task, firstTime.getTime(), period);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sched(TimerTask task, long time, long period) {
        if (time < 0L) {
            throw new IllegalArgumentException("Illegal execution time.");
        }
        if (Math.abs(period) > 0x3FFFFFFFFFFFFFFFL) {
            period >>= 1;
        }
        TaskQueue taskQueue = this.queue;
        synchronized (taskQueue) {
            if (!this.thread.newTasksMayBeScheduled) {
                throw new IllegalStateException("Timer already cancelled.");
            }
            Object object2 = task.lock;
            synchronized (object2) {
                if (task.state != 0) {
                    throw new IllegalStateException("Task already scheduled or cancelled");
                }
                task.nextExecutionTime = time;
                task.period = period;
                task.state = 1;
            }
            this.queue.add(task);
            if (this.queue.getMin() == task) {
                this.queue.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        TaskQueue taskQueue = this.queue;
        synchronized (taskQueue) {
            this.queue.clear();
            this.cleanup.clean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int purge() {
        int result = 0;
        TaskQueue taskQueue = this.queue;
        synchronized (taskQueue) {
            for (int i = this.queue.size(); i > 0; --i) {
                if (this.queue.get((int)i).state != 3) continue;
                this.queue.quickRemove(i);
                ++result;
            }
            if (result != 0) {
                this.queue.heapify();
            }
        }
        return result;
    }

    private static class ThreadReaper
    implements Runnable {
        private final TaskQueue queue;
        private final TimerThread thread;

        ThreadReaper(TaskQueue queue, TimerThread thread) {
            this.queue = queue;
            this.thread = thread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TaskQueue taskQueue = this.queue;
            synchronized (taskQueue) {
                this.thread.newTasksMayBeScheduled = false;
                this.queue.notify();
            }
        }
    }
}

