/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import jdk.internal.access.SharedSecrets;

public class CopyOnWriteArrayList<E>
implements List<E>,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = 8673264195747942595L;
    final transient Object lock = new Object();
    private volatile transient Object[] array;

    final Object[] getArray() {
        return this.array;
    }

    final void setArray(Object[] a) {
        this.array = a;
    }

    public CopyOnWriteArrayList() {
        this.setArray(new Object[0]);
    }

    public CopyOnWriteArrayList(Collection<? extends E> c) {
        Object[] es;
        if (c.getClass() == CopyOnWriteArrayList.class) {
            es = ((CopyOnWriteArrayList)c).getArray();
        } else {
            es = c.toArray();
            if (c.getClass() != ArrayList.class) {
                es = Arrays.copyOf(es, es.length, Object[].class);
            }
        }
        this.setArray(es);
    }

    public CopyOnWriteArrayList(E[] toCopyIn) {
        this.setArray(Arrays.copyOf(toCopyIn, toCopyIn.length, Object[].class));
    }

    @Override
    public int size() {
        return this.getArray().length;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    private static int indexOfRange(Object o, Object[] es, int from, int to) {
        if (o == null) {
            for (int i = from; i < to; ++i) {
                if (es[i] != null) continue;
                return i;
            }
        } else {
            for (int i = from; i < to; ++i) {
                if (!o.equals(es[i])) continue;
                return i;
            }
        }
        return -1;
    }

    private static int lastIndexOfRange(Object o, Object[] es, int from, int to) {
        if (o == null) {
            for (int i = to - 1; i >= from; --i) {
                if (es[i] != null) continue;
                return i;
            }
        } else {
            for (int i = to - 1; i >= from; --i) {
                if (!o.equals(es[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public int indexOf(Object o) {
        Object[] es = this.getArray();
        return CopyOnWriteArrayList.indexOfRange(o, es, 0, es.length);
    }

    public int indexOf(E e, int index) {
        Object[] es = this.getArray();
        return CopyOnWriteArrayList.indexOfRange(e, es, index, es.length);
    }

    @Override
    public int lastIndexOf(Object o) {
        Object[] es = this.getArray();
        return CopyOnWriteArrayList.lastIndexOfRange(o, es, 0, es.length);
    }

    public int lastIndexOf(E e, int index) {
        Object[] es = this.getArray();
        return CopyOnWriteArrayList.lastIndexOfRange(e, es, 0, index + 1);
    }

    public Object clone() {
        try {
            CopyOnWriteArrayList clone = (CopyOnWriteArrayList)super.clone();
            clone.resetLock();
            VarHandle.releaseFence();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public Object[] toArray() {
        return (Object[])this.getArray().clone();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Object[] es = this.getArray();
        int len = es.length;
        if (a.length < len) {
            return Arrays.copyOf(es, len, a.getClass());
        }
        System.arraycopy(es, 0, a, 0, len);
        if (a.length > len) {
            a[len] = null;
        }
        return a;
    }

    static <E> E elementAt(Object[] a, int index) {
        return (E)a[index];
    }

    static String outOfBounds(int index, int size) {
        return "Index: " + index + ", Size: " + size;
    }

    @Override
    public E get(int index) {
        return CopyOnWriteArrayList.elementAt(this.getArray(), index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E set(int index, E element) {
        Object object2 = this.lock;
        synchronized (object2) {
            Object[] es = this.getArray();
            E oldValue = CopyOnWriteArrayList.elementAt(es, index);
            if (oldValue != element) {
                es = (Object[])es.clone();
                es[index] = element;
            }
            this.setArray(es);
            return oldValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E e) {
        Object object2 = this.lock;
        synchronized (object2) {
            Object[] es = this.getArray();
            int len = es.length;
            es = Arrays.copyOf(es, len + 1);
            es[len] = e;
            this.setArray(es);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int index, E element) {
        Object object2 = this.lock;
        synchronized (object2) {
            Object[] newElements;
            Object[] es = this.getArray();
            int len = es.length;
            if (index > len || index < 0) {
                throw new IndexOutOfBoundsException(CopyOnWriteArrayList.outOfBounds(index, len));
            }
            int numMoved = len - index;
            if (numMoved == 0) {
                newElements = Arrays.copyOf(es, len + 1);
            } else {
                newElements = new Object[len + 1];
                System.arraycopy(es, 0, newElements, 0, index);
                System.arraycopy(es, index, newElements, index + 1, numMoved);
            }
            newElements[index] = element;
            this.setArray(newElements);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E remove(int index) {
        Object object2 = this.lock;
        synchronized (object2) {
            Object[] newElements;
            Object[] es = this.getArray();
            int len = es.length;
            E oldValue = CopyOnWriteArrayList.elementAt(es, index);
            int numMoved = len - index - 1;
            if (numMoved == 0) {
                newElements = Arrays.copyOf(es, len - 1);
            } else {
                newElements = new Object[len - 1];
                System.arraycopy(es, 0, newElements, 0, index);
                System.arraycopy(es, index + 1, newElements, index, numMoved);
            }
            this.setArray(newElements);
            return oldValue;
        }
    }

    @Override
    public boolean remove(Object o) {
        Object[] snapshot = this.getArray();
        int index = CopyOnWriteArrayList.indexOfRange(o, snapshot, 0, snapshot.length);
        return index >= 0 && this.remove(o, snapshot, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean remove(Object o, Object[] snapshot, int index) {
        Object object2 = this.lock;
        synchronized (object2) {
            int len;
            Object[] current;
            block7: {
                current = this.getArray();
                len = current.length;
                if (snapshot != current) {
                    int prefix = Math.min(index, len);
                    for (int i = 0; i < prefix; ++i) {
                        if (current[i] == snapshot[i] || !Objects.equals(o, current[i])) continue;
                        index = i;
                        break block7;
                    }
                    if (index >= len) {
                        return false;
                    }
                    if (current[index] != o && (index = CopyOnWriteArrayList.indexOfRange(o, current, index, len)) < 0) {
                        return false;
                    }
                }
            }
            Object[] newElements = new Object[len - 1];
            System.arraycopy(current, 0, newElements, 0, index);
            System.arraycopy(current, index + 1, newElements, index, len - index - 1);
            this.setArray(newElements);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeRange(int fromIndex, int toIndex) {
        Object object2 = this.lock;
        synchronized (object2) {
            Object[] es = this.getArray();
            int len = es.length;
            if (fromIndex < 0 || toIndex > len || toIndex < fromIndex) {
                throw new IndexOutOfBoundsException();
            }
            int newlen = len - (toIndex - fromIndex);
            int numMoved = len - toIndex;
            if (numMoved == 0) {
                this.setArray(Arrays.copyOf(es, newlen));
            } else {
                Object[] newElements = new Object[newlen];
                System.arraycopy(es, 0, newElements, 0, fromIndex);
                System.arraycopy(es, toIndex, newElements, fromIndex, numMoved);
                this.setArray(newElements);
            }
        }
    }

    public boolean addIfAbsent(E e) {
        Object[] snapshot = this.getArray();
        return CopyOnWriteArrayList.indexOfRange(e, snapshot, 0, snapshot.length) < 0 && this.addIfAbsent(e, snapshot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addIfAbsent(E e, Object[] snapshot) {
        Object object2 = this.lock;
        synchronized (object2) {
            Object[] current = this.getArray();
            int len = current.length;
            if (snapshot != current) {
                int common = Math.min(snapshot.length, len);
                for (int i = 0; i < common; ++i) {
                    if (current[i] == snapshot[i] || !Objects.equals(e, current[i])) continue;
                    return false;
                }
                if (CopyOnWriteArrayList.indexOfRange(e, current, common, len) >= 0) {
                    return false;
                }
            }
            Object[] newElements = Arrays.copyOf(current, len + 1);
            newElements[len] = e;
            this.setArray(newElements);
            return true;
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Object[] es = this.getArray();
        int len = es.length;
        for (Object e : c) {
            if (CopyOnWriteArrayList.indexOfRange(e, es, 0, len) >= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        Objects.requireNonNull(c);
        return this.bulkRemove(e -> c.contains(e));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Objects.requireNonNull(c);
        return this.bulkRemove(e -> !c.contains(e));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addAllAbsent(Collection<? extends E> c) {
        Object[] cs = c.toArray();
        if (c.getClass() != ArrayList.class) {
            cs = (Object[])cs.clone();
        }
        if (cs.length == 0) {
            return 0;
        }
        Object object2 = this.lock;
        synchronized (object2) {
            Object[] es = this.getArray();
            int len = es.length;
            int added = 0;
            for (int i = 0; i < cs.length; ++i) {
                Object e = cs[i];
                if (CopyOnWriteArrayList.indexOfRange(e, es, 0, len) >= 0 || CopyOnWriteArrayList.indexOfRange(e, cs, 0, added) >= 0) continue;
                cs[added++] = e;
            }
            if (added > 0) {
                Object[] newElements = Arrays.copyOf(es, len + added);
                System.arraycopy(cs, 0, newElements, len, added);
                this.setArray(newElements);
            }
            return added;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object2 = this.lock;
        synchronized (object2) {
            this.setArray(new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends E> c) {
        Object[] cs;
        Object[] objectArray = cs = c.getClass() == CopyOnWriteArrayList.class ? ((CopyOnWriteArrayList)c).getArray() : c.toArray();
        if (cs.length == 0) {
            return false;
        }
        Object object2 = this.lock;
        synchronized (object2) {
            Object[] newElements;
            Object[] es = this.getArray();
            int len = es.length;
            if (len == 0 && (c.getClass() == CopyOnWriteArrayList.class || c.getClass() == ArrayList.class)) {
                newElements = cs;
            } else {
                newElements = Arrays.copyOf(es, len + cs.length);
                System.arraycopy(cs, 0, newElements, len, cs.length);
            }
            this.setArray(newElements);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        Object[] cs = c.toArray();
        Object object2 = this.lock;
        synchronized (object2) {
            Object[] newElements;
            Object[] es = this.getArray();
            int len = es.length;
            if (index > len || index < 0) {
                throw new IndexOutOfBoundsException(CopyOnWriteArrayList.outOfBounds(index, len));
            }
            if (cs.length == 0) {
                return false;
            }
            int numMoved = len - index;
            if (numMoved == 0) {
                newElements = Arrays.copyOf(es, len + cs.length);
            } else {
                newElements = new Object[len + cs.length];
                System.arraycopy(es, 0, newElements, 0, index);
                System.arraycopy(es, index, newElements, index + cs.length, numMoved);
            }
            System.arraycopy(cs, 0, newElements, index, cs.length);
            this.setArray(newElements);
            return true;
        }
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        Objects.requireNonNull(action);
        Object[] objectArray = this.getArray();
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Object x;
            Object e = x = objectArray[i];
            action.accept(e);
        }
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        Objects.requireNonNull(filter);
        return this.bulkRemove(filter);
    }

    private static long[] nBits(int n) {
        return new long[(n - 1 >> 6) + 1];
    }

    private static void setBit(long[] bits, int i) {
        int n = i >> 6;
        bits[n] = bits[n] | 1L << i;
    }

    private static boolean isClear(long[] bits, int i) {
        return (bits[i >> 6] & 1L << i) == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean bulkRemove(Predicate<? super E> filter) {
        Object object2 = this.lock;
        synchronized (object2) {
            return this.bulkRemove(filter, 0, this.getArray().length);
        }
    }

    boolean bulkRemove(Predicate<? super E> filter, int i, int end) {
        Object[] es = this.getArray();
        while (i < end && !filter.test(CopyOnWriteArrayList.elementAt(es, i))) {
            ++i;
        }
        if (i < end) {
            int beg = i;
            long[] deathRow = CopyOnWriteArrayList.nBits(end - beg);
            int deleted = 1;
            deathRow[0] = 1L;
            for (i = beg + 1; i < end; ++i) {
                if (!filter.test(CopyOnWriteArrayList.elementAt(es, i))) continue;
                CopyOnWriteArrayList.setBit(deathRow, i - beg);
                ++deleted;
            }
            if (es != this.getArray()) {
                throw new ConcurrentModificationException();
            }
            Object[] newElts = Arrays.copyOf(es, es.length - deleted);
            int w = beg;
            for (i = beg; i < end; ++i) {
                if (!CopyOnWriteArrayList.isClear(deathRow, i - beg)) continue;
                newElts[w++] = es[i];
            }
            System.arraycopy(es, i, newElts, w, es.length - i);
            this.setArray(newElts);
            return true;
        }
        if (es != this.getArray()) {
            throw new ConcurrentModificationException();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceAll(UnaryOperator<E> operator) {
        Object object2 = this.lock;
        synchronized (object2) {
            this.replaceAllRange(operator, 0, this.getArray().length);
        }
    }

    void replaceAllRange(UnaryOperator<E> operator, int i, int end) {
        Objects.requireNonNull(operator);
        Object[] es = (Object[])this.getArray().clone();
        while (i < end) {
            es[i] = operator.apply(CopyOnWriteArrayList.elementAt(es, i));
            ++i;
        }
        this.setArray(es);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sort(Comparator<? super E> c) {
        Object object2 = this.lock;
        synchronized (object2) {
            this.sortRange(c, 0, this.getArray().length);
        }
    }

    void sortRange(Comparator<? super E> c, int i, int end) {
        Object[] es = (Object[])this.getArray().clone();
        Arrays.sort(es, i, end, c);
        this.setArray(es);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Object[] es = this.getArray();
        s.writeInt(es.length);
        for (Object element : es) {
            s.writeObject(element);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.resetLock();
        int len = s.readInt();
        SharedSecrets.getJavaObjectInputStreamAccess().checkArray(s, Object[].class, len);
        Object[] es = new Object[len];
        for (int i = 0; i < len; ++i) {
            es[i] = s.readObject();
        }
        this.setArray(es);
    }

    public String toString() {
        return Arrays.toString(this.getArray());
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        List list = (List)o;
        Iterator it = list.iterator();
        for (Object element : this.getArray()) {
            if (it.hasNext() && Objects.equals(element, it.next())) continue;
            return false;
        }
        return !it.hasNext();
    }

    private static int hashCodeOfRange(Object[] es, int from, int to) {
        int hashCode = 1;
        for (int i = from; i < to; ++i) {
            Object x = es[i];
            hashCode = 31 * hashCode + (x == null ? 0 : x.hashCode());
        }
        return hashCode;
    }

    @Override
    public int hashCode() {
        Object[] es = this.getArray();
        return CopyOnWriteArrayList.hashCodeOfRange(es, 0, es.length);
    }

    @Override
    public Iterator<E> iterator() {
        return new COWIterator(this.getArray(), 0);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new COWIterator(this.getArray(), 0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        Object[] es = this.getArray();
        int len = es.length;
        if (index < 0 || index > len) {
            throw new IndexOutOfBoundsException(CopyOnWriteArrayList.outOfBounds(index, len));
        }
        return new COWIterator(es, index);
    }

    @Override
    public Spliterator<E> spliterator() {
        return Spliterators.spliterator(this.getArray(), 1040);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        Object object2 = this.lock;
        synchronized (object2) {
            Object[] es = this.getArray();
            int len = es.length;
            int size = toIndex - fromIndex;
            if (fromIndex < 0 || toIndex > len || size < 0) {
                throw new IndexOutOfBoundsException();
            }
            return new COWSubList(es, fromIndex, size);
        }
    }

    private void resetLock() {
        Field lockField = AccessController.doPrivileged(() -> {
            try {
                Field f = CopyOnWriteArrayList.class.getDeclaredField("lock");
                f.setAccessible(true);
                return f;
            }
            catch (ReflectiveOperationException e) {
                throw new Error(e);
            }
        });
        try {
            lockField.set(this, new Object());
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
    }

    static final class COWIterator<E>
    implements ListIterator<E> {
        private final Object[] snapshot;
        private int cursor;

        COWIterator(Object[] es, int initialCursor) {
            this.cursor = initialCursor;
            this.snapshot = es;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.snapshot.length;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return (E)this.snapshot[this.cursor++];
        }

        @Override
        public E previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return (E)this.snapshot[--this.cursor];
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            Objects.requireNonNull(action);
            int size = this.snapshot.length;
            this.cursor = size;
            for (int i = this.cursor; i < size; ++i) {
                action.accept(CopyOnWriteArrayList.elementAt(this.snapshot, i));
            }
        }
    }

    private class COWSubList
    implements List<E>,
    RandomAccess {
        private final int offset;
        private int size;
        private Object[] expectedArray;

        COWSubList(Object[] es, int offset, int size) {
            this.expectedArray = es;
            this.offset = offset;
            this.size = size;
        }

        private void checkForComodification() {
            if (CopyOnWriteArrayList.this.getArray() != this.expectedArray) {
                throw new ConcurrentModificationException();
            }
        }

        private Object[] getArrayChecked() {
            Object[] a = CopyOnWriteArrayList.this.getArray();
            if (a != this.expectedArray) {
                throw new ConcurrentModificationException();
            }
            return a;
        }

        private void rangeCheck(int index) {
            if (index < 0 || index >= this.size) {
                throw new IndexOutOfBoundsException(CopyOnWriteArrayList.outOfBounds(index, this.size));
            }
        }

        private void rangeCheckForAdd(int index) {
            if (index < 0 || index > this.size) {
                throw new IndexOutOfBoundsException(CopyOnWriteArrayList.outOfBounds(index, this.size));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            int size;
            int offset;
            Object[] es;
            Object object2 = CopyOnWriteArrayList.this.lock;
            synchronized (object2) {
                es = this.getArrayChecked();
                offset = this.offset;
                size = this.size;
            }
            return Arrays.copyOfRange(es, offset, offset + size);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] a) {
            int size;
            int offset;
            Object[] es;
            Object object2 = CopyOnWriteArrayList.this.lock;
            synchronized (object2) {
                es = this.getArrayChecked();
                offset = this.offset;
                size = this.size;
            }
            if (a.length < size) {
                return Arrays.copyOfRange(es, offset, offset + size, a.getClass());
            }
            System.arraycopy(es, offset, a, 0, size);
            if (a.length > size) {
                a[size] = null;
            }
            return a;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object o) {
            int size;
            int offset;
            Object[] es;
            Object object2 = CopyOnWriteArrayList.this.lock;
            synchronized (object2) {
                es = this.getArrayChecked();
                offset = this.offset;
                size = this.size;
            }
            int i = CopyOnWriteArrayList.indexOfRange(o, es, offset, offset + size);
            return i == -1 ? -1 : i - offset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object o) {
            int size;
            int offset;
            Object[] es;
            Object object2 = CopyOnWriteArrayList.this.lock;
            synchronized (object2) {
                es = this.getArrayChecked();
                offset = this.offset;
                size = this.size;
            }
            int i = CopyOnWriteArrayList.lastIndexOfRange(o, es, offset, offset + size);
            return i == -1 ? -1 : i - offset;
        }

        @Override
        public boolean contains(Object o) {
            return this.indexOf(o) >= 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsAll(Collection<?> c) {
            int size;
            int offset;
            Object[] es;
            Iterator<?> iterator = CopyOnWriteArrayList.this.lock;
            synchronized (iterator) {
                es = this.getArrayChecked();
                offset = this.offset;
                size = this.size;
            }
            for (Object o : c) {
                if (CopyOnWriteArrayList.indexOfRange(o, es, offset, offset + size) >= 0) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        public String toString() {
            return Arrays.toString(this.toArray());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            int size;
            int offset;
            Object[] es;
            Object object2 = CopyOnWriteArrayList.this.lock;
            synchronized (object2) {
                es = this.getArrayChecked();
                offset = this.offset;
                size = this.size;
            }
            return CopyOnWriteArrayList.hashCodeOfRange(es, offset, offset + size);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object o) {
            int size;
            int offset;
            Object[] es;
            if (o == this) {
                return true;
            }
            if (!(o instanceof List)) {
                return false;
            }
            Iterator it = ((List)o).iterator();
            Object object2 = CopyOnWriteArrayList.this.lock;
            synchronized (object2) {
                es = this.getArrayChecked();
                offset = this.offset;
                size = this.size;
            }
            int end = offset + size;
            for (int i = offset; i < end; ++i) {
                if (it.hasNext() && Objects.equals(es[i], it.next())) continue;
                return false;
            }
            return !it.hasNext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E set(int index, E element) {
            Object object2 = CopyOnWriteArrayList.this.lock;
            synchronized (object2) {
                this.rangeCheck(index);
                this.checkForComodification();
                Object x = CopyOnWriteArrayList.this.set(this.offset + index, element);
                this.expectedArray = CopyOnWriteArrayList.this.getArray();
                return x;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E get(int index) {
            Object object2 = CopyOnWriteArrayList.this.lock;
            synchronized (object2) {
                this.rangeCheck(index);
                this.checkForComodification();
                return CopyOnWriteArrayList.this.get(this.offset + index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object2 = CopyOnWriteArrayList.this.lock;
            synchronized (object2) {
                this.checkForComodification();
                return this.size;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(E element) {
            Object object2 = CopyOnWriteArrayList.this.lock;
            synchronized (object2) {
                this.checkForComodification();
                CopyOnWriteArrayList.this.add(this.offset + this.size, element);
                this.expectedArray = CopyOnWriteArrayList.this.getArray();
                ++this.size;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(int index, E element) {
            Object object2 = CopyOnWriteArrayList.this.lock;
            synchronized (object2) {
                this.checkForComodification();
                this.rangeCheckForAdd(index);
                CopyOnWriteArrayList.this.add(this.offset + index, element);
                this.expectedArray = CopyOnWriteArrayList.this.getArray();
                ++this.size;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(Collection<? extends E> c) {
            Object object2 = CopyOnWriteArrayList.this.lock;
            synchronized (object2) {
                Object[] oldArray = this.getArrayChecked();
                boolean modified = CopyOnWriteArrayList.this.addAll(this.offset + this.size, c);
                this.expectedArray = CopyOnWriteArrayList.this.getArray();
                this.size += this.expectedArray.length - oldArray.length;
                return modified;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            Object object2 = CopyOnWriteArrayList.this.lock;
            synchronized (object2) {
                this.rangeCheckForAdd(index);
                Object[] oldArray = this.getArrayChecked();
                boolean modified = CopyOnWriteArrayList.this.addAll(this.offset + index, c);
                this.expectedArray = CopyOnWriteArrayList.this.getArray();
                this.size += this.expectedArray.length - oldArray.length;
                return modified;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object2 = CopyOnWriteArrayList.this.lock;
            synchronized (object2) {
                this.checkForComodification();
                CopyOnWriteArrayList.this.removeRange(this.offset, this.offset + this.size);
                this.expectedArray = CopyOnWriteArrayList.this.getArray();
                this.size = 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E remove(int index) {
            Object object2 = CopyOnWriteArrayList.this.lock;
            synchronized (object2) {
                this.rangeCheck(index);
                this.checkForComodification();
                Object result = CopyOnWriteArrayList.this.remove(this.offset + index);
                this.expectedArray = CopyOnWriteArrayList.this.getArray();
                --this.size;
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object o) {
            Object object2 = CopyOnWriteArrayList.this.lock;
            synchronized (object2) {
                this.checkForComodification();
                int index = this.indexOf(o);
                if (index == -1) {
                    return false;
                }
                this.remove(index);
                return true;
            }
        }

        @Override
        public Iterator<E> iterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<E> listIterator() {
            return this.listIterator(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ListIterator<E> listIterator(int index) {
            Object object2 = CopyOnWriteArrayList.this.lock;
            synchronized (object2) {
                this.checkForComodification();
                this.rangeCheckForAdd(index);
                return new COWSubListIterator(CopyOnWriteArrayList.this, index, this.offset, this.size);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            Object object2 = CopyOnWriteArrayList.this.lock;
            synchronized (object2) {
                this.checkForComodification();
                if (fromIndex < 0 || toIndex > this.size || fromIndex > toIndex) {
                    throw new IndexOutOfBoundsException();
                }
                return new COWSubList(this.expectedArray, fromIndex + this.offset, toIndex - fromIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void forEach(Consumer<? super E> action) {
            int end;
            int i;
            Object[] es;
            Objects.requireNonNull(action);
            Object object2 = CopyOnWriteArrayList.this.lock;
            synchronized (object2) {
                es = this.getArrayChecked();
                end = i + this.size;
            }
            for (i = this.offset; i < end; ++i) {
                action.accept(CopyOnWriteArrayList.elementAt(es, i));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void replaceAll(UnaryOperator<E> operator) {
            Object object2 = CopyOnWriteArrayList.this.lock;
            synchronized (object2) {
                this.checkForComodification();
                CopyOnWriteArrayList.this.replaceAllRange(operator, this.offset, this.offset + this.size);
                this.expectedArray = CopyOnWriteArrayList.this.getArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sort(Comparator<? super E> c) {
            Object object2 = CopyOnWriteArrayList.this.lock;
            synchronized (object2) {
                this.checkForComodification();
                CopyOnWriteArrayList.this.sortRange(c, this.offset, this.offset + this.size);
                this.expectedArray = CopyOnWriteArrayList.this.getArray();
            }
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            Objects.requireNonNull(c);
            return this.bulkRemove(e -> c.contains(e));
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            Objects.requireNonNull(c);
            return this.bulkRemove(e -> !c.contains(e));
        }

        @Override
        public boolean removeIf(Predicate<? super E> filter) {
            Objects.requireNonNull(filter);
            return this.bulkRemove(filter);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean bulkRemove(Predicate<? super E> filter) {
            Object object2 = CopyOnWriteArrayList.this.lock;
            synchronized (object2) {
                Object[] oldArray = this.getArrayChecked();
                boolean modified = CopyOnWriteArrayList.this.bulkRemove(filter, this.offset, this.offset + this.size);
                this.expectedArray = CopyOnWriteArrayList.this.getArray();
                this.size += this.expectedArray.length - oldArray.length;
                return modified;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Spliterator<E> spliterator() {
            Object object2 = CopyOnWriteArrayList.this.lock;
            synchronized (object2) {
                return Spliterators.spliterator(this.getArrayChecked(), this.offset, this.offset + this.size, 1040);
            }
        }
    }

    private static class COWSubListIterator<E>
    implements ListIterator<E> {
        private final ListIterator<E> it;
        private final int offset;
        private final int size;

        COWSubListIterator(List<E> l, int index, int offset, int size) {
            this.offset = offset;
            this.size = size;
            this.it = l.listIterator(index + offset);
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex() < this.size;
        }

        @Override
        public E next() {
            if (this.hasNext()) {
                return this.it.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasPrevious() {
            return this.previousIndex() >= 0;
        }

        @Override
        public E previous() {
            if (this.hasPrevious()) {
                return this.it.previous();
            }
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return this.it.nextIndex() - this.offset;
        }

        @Override
        public int previousIndex() {
            return this.it.previousIndex() - this.offset;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            Objects.requireNonNull(action);
            while (this.hasNext()) {
                action.accept(this.it.next());
            }
        }
    }
}

