/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.ForkJoinWorkerThread;

public abstract class CountedCompleter<T>
extends ForkJoinTask<T> {
    private static final long serialVersionUID = 5232453752276485070L;
    final CountedCompleter<?> completer;
    volatile int pending;
    private static final VarHandle PENDING;

    protected CountedCompleter(CountedCompleter<?> completer, int initialPendingCount) {
        this.completer = completer;
        this.pending = initialPendingCount;
    }

    protected CountedCompleter(CountedCompleter<?> completer) {
        this.completer = completer;
    }

    protected CountedCompleter() {
        this.completer = null;
    }

    public abstract void compute();

    public void onCompletion(CountedCompleter<?> caller) {
    }

    public boolean onExceptionalCompletion(Throwable ex, CountedCompleter<?> caller) {
        return true;
    }

    public final CountedCompleter<?> getCompleter() {
        return this.completer;
    }

    public final int getPendingCount() {
        return this.pending;
    }

    public final void setPendingCount(int count) {
        this.pending = count;
    }

    public final void addToPendingCount(int delta) {
        PENDING.getAndAdd(this, delta);
    }

    public final boolean compareAndSetPendingCount(int expected, int count) {
        return PENDING.compareAndSet(this, expected, count);
    }

    final boolean weakCompareAndSetPendingCount(int expected, int count) {
        return PENDING.weakCompareAndSet(this, expected, count);
    }

    public final int decrementPendingCountUnlessZero() {
        int c;
        while ((c = this.pending) != 0 && !this.weakCompareAndSetPendingCount(c, c - 1)) {
        }
        return c;
    }

    public final CountedCompleter<?> getRoot() {
        CountedCompleter<?> p;
        CountedCompleter<?> a = this;
        while ((p = a.completer) != null) {
            a = p;
        }
        return a;
    }

    public final void tryComplete() {
        CountedCompleter<?> a;
        CountedCompleter<?> s = a = this;
        while (true) {
            int c;
            if ((c = a.pending) == 0) {
                a.onCompletion(s);
                s = a;
                a = s.completer;
                if (a != null) continue;
                s.quietlyComplete();
                return;
            }
            if (a.weakCompareAndSetPendingCount(c, c - 1)) break;
        }
    }

    public final void propagateCompletion() {
        CountedCompleter<?> a = this;
        while (true) {
            int c;
            if ((c = a.pending) == 0) {
                CountedCompleter<?> s = a;
                a = s.completer;
                if (a != null) continue;
                s.quietlyComplete();
                return;
            }
            if (a.weakCompareAndSetPendingCount(c, c - 1)) break;
        }
    }

    @Override
    public void complete(T rawResult) {
        this.setRawResult(rawResult);
        this.onCompletion(this);
        this.quietlyComplete();
        CountedCompleter<?> p = this.completer;
        if (p != null) {
            p.tryComplete();
        }
    }

    public final CountedCompleter<?> firstComplete() {
        int c;
        do {
            if ((c = this.pending) != 0) continue;
            return this;
        } while (!this.weakCompareAndSetPendingCount(c, c - 1));
        return null;
    }

    public final CountedCompleter<?> nextComplete() {
        CountedCompleter<?> p = this.completer;
        if (p != null) {
            return p.firstComplete();
        }
        this.quietlyComplete();
        return null;
    }

    public final void quietlyCompleteRoot() {
        CountedCompleter<?> a = this;
        while (true) {
            CountedCompleter<?> p;
            if ((p = a.completer) == null) {
                a.quietlyComplete();
                return;
            }
            a = p;
        }
    }

    public final void helpComplete(int maxTasks) {
        Thread t = Thread.currentThread();
        boolean owned = t instanceof ForkJoinWorkerThread;
        ForkJoinPool.WorkQueue q = owned ? ((ForkJoinWorkerThread)t).workQueue : ForkJoinPool.commonQueue();
        if (q != null && maxTasks > 0) {
            q.helpComplete(this, owned, maxTasks);
        }
    }

    @Override
    final int trySetException(Throwable ex) {
        CountedCompleter<?> a;
        CountedCompleter<?> p = a = this;
        while (CountedCompleter.isExceptionalStatus(a.trySetThrown(ex)) && a.onExceptionalCompletion(ex, p)) {
            p = a;
            a = p.completer;
            if (a != null && a.status >= 0) continue;
        }
        return this.status;
    }

    @Override
    protected final boolean exec() {
        this.compute();
        return false;
    }

    @Override
    public T getRawResult() {
        return null;
    }

    @Override
    protected void setRawResult(T t) {
    }

    static {
        try {
            MethodHandles.Lookup l = MethodHandles.lookup();
            PENDING = l.findVarHandle(CountedCompleter.class, "pending", Integer.TYPE);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

