/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class CyclicBarrier {
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition trip = this.lock.newCondition();
    private final int parties;
    private final Runnable barrierCommand;
    private Generation generation = new Generation();
    private int count;

    private void nextGeneration() {
        this.trip.signalAll();
        this.count = this.parties;
        this.generation = new Generation();
    }

    private void breakBarrier() {
        this.generation.broken = true;
        this.count = this.parties;
        this.trip.signalAll();
    }

    private int dowait(boolean timed, long nanos) throws InterruptedException, BrokenBarrierException, TimeoutException {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int index;
            Generation g = this.generation;
            if (g.broken) {
                throw new BrokenBarrierException();
            }
            if (Thread.interrupted()) {
                this.breakBarrier();
                throw new InterruptedException();
            }
            if ((index = --this.count) == 0) {
                Runnable command = this.barrierCommand;
                if (command != null) {
                    try {
                        command.run();
                    }
                    catch (Throwable ex) {
                        this.breakBarrier();
                        throw ex;
                    }
                }
                this.nextGeneration();
                int n = 0;
                return n;
            }
            do {
                try {
                    if (!timed) {
                        this.trip.await();
                    } else if (nanos > 0L) {
                        nanos = this.trip.awaitNanos(nanos);
                    }
                }
                catch (InterruptedException ie) {
                    if (g == this.generation && !g.broken) {
                        this.breakBarrier();
                        throw ie;
                    }
                    Thread.currentThread().interrupt();
                }
                if (g.broken) {
                    throw new BrokenBarrierException();
                }
                if (g == this.generation) continue;
                int n = index;
                return n;
            } while (!timed || nanos > 0L);
            this.breakBarrier();
            throw new TimeoutException();
        }
        finally {
            lock.unlock();
        }
    }

    public CyclicBarrier(int parties, Runnable barrierAction) {
        if (parties <= 0) {
            throw new IllegalArgumentException();
        }
        this.parties = parties;
        this.count = parties;
        this.barrierCommand = barrierAction;
    }

    public CyclicBarrier(int parties) {
        this(parties, null);
    }

    public int getParties() {
        return this.parties;
    }

    public int await() throws InterruptedException, BrokenBarrierException {
        try {
            return this.dowait(false, 0L);
        }
        catch (TimeoutException toe) {
            throw new Error(toe);
        }
    }

    public int await(long timeout, TimeUnit unit) throws InterruptedException, BrokenBarrierException, TimeoutException {
        return this.dowait(true, unit.toNanos(timeout));
    }

    public boolean isBroken() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            boolean bl = this.generation.broken;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public void reset() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.breakBarrier();
            this.nextGeneration();
        }
        finally {
            lock.unlock();
        }
    }

    public int getNumberWaiting() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.parties - this.count;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    private static class Generation {
        boolean broken;

        Generation() {
        }
    }
}

