/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.LockSupport;
import jdk.internal.vm.annotation.Contended;

public class Exchanger<V> {
    private static final int ASHIFT = 5;
    private static final int MMASK = 255;
    private static final int SEQ = 256;
    private static final int NCPU = Runtime.getRuntime().availableProcessors();
    static final int FULL = NCPU >= 510 ? 255 : NCPU >>> 1;
    private static final int SPINS = 1024;
    private static final Object NULL_ITEM = new Object();
    private static final Object TIMED_OUT = new Object();
    private final Participant participant = new Participant();
    private volatile Node[] arena;
    private volatile Node slot;
    private volatile int bound;
    private static final VarHandle BOUND;
    private static final VarHandle SLOT;
    private static final VarHandle MATCH;
    private static final VarHandle AA;

    private final Object arenaExchange(Object item, boolean timed, long ns) {
        Node[] a = this.arena;
        int alen = a.length;
        Node p = (Node)this.participant.get();
        int i = p.index;
        while (true) {
            Node q;
            int j;
            if ((j = (i << 5) + 31) < 0 || j >= alen) {
                j = alen - 1;
            }
            if ((q = AA.getAcquire(a, j)) != null && AA.compareAndSet(a, j, q, null)) {
                Object v = q.item;
                q.match = item;
                Thread w = q.parked;
                if (w != null) {
                    LockSupport.unpark(w);
                }
                return v;
            }
            int b = this.bound;
            int m = b & 0xFF;
            if (i <= m && q == null) {
                p.item = item;
                if (AA.compareAndSet(a, j, null, p)) {
                    long end = timed && m == 0 ? System.nanoTime() + ns : 0L;
                    Thread t = Thread.currentThread();
                    int h = p.hash;
                    int spins = 1024;
                    while (true) {
                        Object v;
                        if ((v = p.match) != null) {
                            MATCH.setRelease(p, null);
                            p.item = null;
                            p.hash = h;
                            return v;
                        }
                        if (spins > 0) {
                            h ^= h << 1;
                            h ^= h >>> 3;
                            if ((h ^= h << 10) == 0) {
                                h = 0x400 | (int)t.getId();
                                continue;
                            }
                            if (h >= 0 || (--spins & 0x1FF) != 0) continue;
                            Thread.yield();
                            continue;
                        }
                        if (AA.getAcquire(a, j) != p) {
                            spins = 1024;
                            continue;
                        }
                        if (!(t.isInterrupted() || m != 0 || timed && (ns = end - System.nanoTime()) <= 0L)) {
                            p.parked = t;
                            if (AA.getAcquire(a, j) == p) {
                                if (ns == 0L) {
                                    LockSupport.park(this);
                                } else {
                                    LockSupport.parkNanos(this, ns);
                                }
                            }
                            p.parked = null;
                            continue;
                        }
                        if (AA.getAcquire(a, j) == p && AA.compareAndSet(a, j, p, null)) break;
                    }
                    if (m != 0) {
                        BOUND.compareAndSet(this, b, b + 256 - 1);
                    }
                    p.item = null;
                    p.hash = h;
                    i = p.index >>>= 1;
                    if (Thread.interrupted()) {
                        return null;
                    }
                    if (!timed || m != 0 || ns > 0L) continue;
                    return TIMED_OUT;
                }
                p.item = null;
                continue;
            }
            if (p.bound != b) {
                p.bound = b;
                p.collides = 0;
                i = i != m || m == 0 ? m : m - 1;
            } else {
                int c = p.collides;
                if (c < m || m == FULL || !BOUND.compareAndSet(this, b, b + 256 + 1)) {
                    p.collides = c + 1;
                    i = i == 0 ? m : i - 1;
                } else {
                    i = m + 1;
                }
            }
            p.index = i;
        }
    }

    private final Object slotExchange(Object item, boolean timed, long ns) {
        Object v;
        int spins;
        Node p = (Node)this.participant.get();
        Thread t = Thread.currentThread();
        if (t.isInterrupted()) {
            return null;
        }
        while (true) {
            Node q;
            if ((q = this.slot) != null) {
                if (SLOT.compareAndSet(this, q, null)) {
                    Object v2 = q.item;
                    q.match = item;
                    Thread w = q.parked;
                    if (w != null) {
                        LockSupport.unpark(w);
                    }
                    return v2;
                }
                if (NCPU <= 1 || this.bound != 0 || !BOUND.compareAndSet(this, 0, 256)) continue;
                this.arena = new Node[FULL + 2 << 5];
                continue;
            }
            if (this.arena != null) {
                return null;
            }
            p.item = item;
            if (SLOT.compareAndSet(this, null, p)) break;
            p.item = null;
        }
        int h = p.hash;
        long end = timed ? System.nanoTime() + ns : 0L;
        int n = spins = NCPU > 1 ? 1024 : 1;
        while ((v = p.match) == null) {
            if (spins > 0) {
                h ^= h << 1;
                h ^= h >>> 3;
                if ((h ^= h << 10) == 0) {
                    h = 0x400 | (int)t.getId();
                    continue;
                }
                if (h >= 0 || (--spins & 0x1FF) != 0) continue;
                Thread.yield();
                continue;
            }
            if (this.slot != p) {
                spins = 1024;
                continue;
            }
            if (!(t.isInterrupted() || this.arena != null || timed && (ns = end - System.nanoTime()) <= 0L)) {
                p.parked = t;
                if (this.slot == p) {
                    if (ns == 0L) {
                        LockSupport.park(this);
                    } else {
                        LockSupport.parkNanos(this, ns);
                    }
                }
                p.parked = null;
                continue;
            }
            if (!SLOT.compareAndSet(this, p, null)) continue;
            v = timed && ns <= 0L && !t.isInterrupted() ? TIMED_OUT : null;
            break;
        }
        MATCH.setRelease(p, null);
        p.item = null;
        p.hash = h;
        return v;
    }

    public V exchange(V x) throws InterruptedException {
        Object v;
        Object item = x == null ? NULL_ITEM : x;
        Node[] a = this.arena;
        if (!(this.arena == null && (v = this.slotExchange(item, false, 0L)) != null || !Thread.interrupted() && (v = this.arenaExchange(item, false, 0L)) != null)) {
            throw new InterruptedException();
        }
        return (V)(v == NULL_ITEM ? null : v);
    }

    public V exchange(V x, long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        Object v;
        Object item = x == null ? NULL_ITEM : x;
        long ns = unit.toNanos(timeout);
        if (!(this.arena == null && (v = this.slotExchange(item, true, ns)) != null || !Thread.interrupted() && (v = this.arenaExchange(item, true, ns)) != null)) {
            throw new InterruptedException();
        }
        if (v == TIMED_OUT) {
            throw new TimeoutException();
        }
        return (V)(v == NULL_ITEM ? null : v);
    }

    static {
        try {
            MethodHandles.Lookup l = MethodHandles.lookup();
            BOUND = l.findVarHandle(Exchanger.class, "bound", Integer.TYPE);
            SLOT = l.findVarHandle(Exchanger.class, "slot", Node.class);
            MATCH = l.findVarHandle(Node.class, "match", Object.class);
            AA = MethodHandles.arrayElementVarHandle(Node[].class);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    @Contended
    static final class Node {
        int index;
        int bound;
        int collides;
        int hash;
        Object item;
        volatile Object match;
        volatile Thread parked;

        Node() {
        }
    }

    static final class Participant
    extends ThreadLocal<Node> {
        Participant() {
        }

        @Override
        public Node initialValue() {
            return new Node();
        }
    }
}

