/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountedCompleter;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import jdk.internal.vm.annotation.Contended;

public class ForkJoinPool
extends AbstractExecutorService {
    static final int SWIDTH = 16;
    static final int SMASK = 65535;
    static final int MAX_CAP = Short.MAX_VALUE;
    static final int UNSIGNALLED = Integer.MIN_VALUE;
    static final int SS_SEQ = 65536;
    static final int FIFO = 65536;
    static final int SRC = 131072;
    static final int INNOCUOUS = 262144;
    static final int QUIET = 524288;
    static final int SHUTDOWN = 0x1000000;
    static final int TERMINATED = 0x2000000;
    static final int STOP = Integer.MIN_VALUE;
    static final int UNCOMPENSATE = 65536;
    static final int INITIAL_QUEUE_CAPACITY = 256;
    public static final ForkJoinWorkerThreadFactory defaultForkJoinWorkerThreadFactory;
    static final RuntimePermission modifyThreadPermission;
    static final ForkJoinPool common;
    static final int COMMON_PARALLELISM;
    private static final int COMMON_MAX_SPARES;
    private static volatile int poolIds;
    private static final long DEFAULT_KEEPALIVE = 60000L;
    private static final long TIMEOUT_SLOP = 20L;
    private static final int DEFAULT_COMMON_MAX_SPARES = 256;
    private static final long SP_MASK = 0xFFFFFFFFL;
    private static final long UC_MASK = -4294967296L;
    private static final int RC_SHIFT = 48;
    private static final long RC_UNIT = 0x1000000000000L;
    private static final long RC_MASK = -281474976710656L;
    private static final int TC_SHIFT = 32;
    private static final long TC_UNIT = 0x100000000L;
    private static final long TC_MASK = 0xFFFF00000000L;
    private static final long ADD_WORKER = 0x800000000000L;
    final long keepAlive;
    volatile long stealCount;
    int scanRover;
    volatile int threadIds;
    final int bounds;
    volatile int mode;
    WorkQueue[] queues;
    final ReentrantLock registrationLock;
    Condition termination;
    final String workerNamePrefix;
    final ForkJoinWorkerThreadFactory factory;
    final Thread.UncaughtExceptionHandler ueh;
    final Predicate<? super ForkJoinPool> saturate;
    @Contended(value="fjpctl")
    volatile long ctl;
    private static final VarHandle CTL;
    private static final VarHandle MODE;
    private static final VarHandle THREADIDS;
    private static final VarHandle POOLIDS;

    private static void checkPermission() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(modifyThreadPermission);
        }
    }

    static AccessControlContext contextWithPermissions(Permission ... perms) {
        Permissions permissions = new Permissions();
        for (Permission perm : perms) {
            permissions.add(perm);
        }
        return new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, permissions)});
    }

    private boolean compareAndSetCtl(long c, long v) {
        return CTL.compareAndSet(this, c, v);
    }

    private long compareAndExchangeCtl(long c, long v) {
        return CTL.compareAndExchange(this, c, v);
    }

    private long getAndAddCtl(long v) {
        return CTL.getAndAdd(this, v);
    }

    private int getAndBitwiseOrMode(int v) {
        return MODE.getAndBitwiseOr(this, v);
    }

    private int getAndAddThreadIds(int x) {
        return THREADIDS.getAndAdd(this, x);
    }

    private static int getAndAddPoolIds(int x) {
        return POOLIDS.getAndAdd(x);
    }

    private boolean createWorker() {
        ForkJoinWorkerThreadFactory fac = this.factory;
        Throwable ex = null;
        ForkJoinWorkerThread wt = null;
        try {
            if (fac != null && (wt = fac.newThread(this)) != null) {
                wt.start();
                return true;
            }
        }
        catch (Throwable rex) {
            ex = rex;
        }
        this.deregisterWorker(wt, ex);
        return false;
    }

    final String nextWorkerThreadName() {
        String prefix = this.workerNamePrefix;
        int tid = this.getAndAddThreadIds(1) + 1;
        if (prefix == null) {
            prefix = "ForkJoinPool.commonPool-worker-";
        }
        return prefix.concat(Integer.toString(tid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void registerWorker(WorkQueue w) {
        ReentrantLock lock = this.registrationLock;
        ThreadLocalRandom.localInit();
        int seed = ThreadLocalRandom.getProbe();
        if (w != null && lock != null) {
            int modebits = this.mode & 0x10000 | w.config;
            w.array = new ForkJoinTask[256];
            w.stackPred = seed;
            if ((modebits & 0x40000) != 0) {
                w.initializeInnocuousWorker();
            }
            int id = seed << 1 | 1;
            lock.lock();
            try {
                int n;
                WorkQueue[] qs = this.queues;
                if (this.queues != null && (n = qs.length) > 0) {
                    int k;
                    int m = n - 1;
                    for (k = n; qs[id &= m] != null && k > 0; k -= 2) {
                        id -= 2;
                    }
                    if (k == 0) {
                        id = n | 1;
                    }
                    w.phase = w.config = id | modebits;
                    if (id < n) {
                        qs[id] = w;
                    } else {
                        int j;
                        int an = n << 1;
                        int am = an - 1;
                        WorkQueue[] as = new WorkQueue[an];
                        as[id & am] = w;
                        for (j = 1; j < n; j += 2) {
                            as[j] = qs[j];
                        }
                        for (j = 0; j < n; j += 2) {
                            WorkQueue q = qs[j];
                            if (q == null) continue;
                            as[q.config & am] = q;
                        }
                        VarHandle.releaseFence();
                        this.queues = as;
                    }
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    final void deregisterWorker(ForkJoinWorkerThread wt, Throwable ex) {
        ReentrantLock lock = this.registrationLock;
        WorkQueue w = null;
        int cfg = 0;
        if (wt != null && (w = wt.workQueue) != null && lock != null) {
            ForkJoinTask<?> t;
            int i;
            int n;
            cfg = w.config;
            long ns = (long)w.nsteals & 0xFFFFFFFFL;
            lock.lock();
            WorkQueue[] qs = this.queues;
            if (this.queues != null && (n = qs.length) > 0 && qs[i = cfg & n - 1] == w) {
                qs[i] = null;
            }
            this.stealCount += ns;
            lock.unlock();
            long c = this.ctl;
            if ((cfg & 0x80000) == 0) {
                while (c != (c = this.compareAndExchangeCtl(c, 0xFFFF000000000000L & c - 0x1000000000000L | 0xFFFF00000000L & c - 0x100000000L | 0xFFFFFFFFL & c))) {
                }
            } else if ((int)c == 0) {
                cfg = 0;
            }
            while ((t = w.pop()) != null) {
                ForkJoinTask.cancelIgnoringExceptions(t);
            }
        }
        if (!this.tryTerminate(false, false) && w != null && (cfg & 0x20000) != 0) {
            this.signalWork();
        }
        if (ex != null) {
            ForkJoinTask.rethrow(ex);
        }
    }

    final void signalWork() {
        long c = this.ctl;
        while (c < 0L) {
            WorkQueue v;
            int i;
            int sp = (int)c & Integer.MAX_VALUE;
            if (sp == 0) {
                if ((c & 0x800000000000L) == 0L) break;
                if (c != (c = this.compareAndExchangeCtl(c, 0xFFFF000000000000L & c + 0x1000000000000L | 0xFFFF00000000L & c + 0x100000000L))) continue;
                this.createWorker();
                break;
            }
            WorkQueue[] qs = this.queues;
            if (this.queues == null || qs.length <= (i = sp & 0xFFFF) || (v = qs[i]) == null) break;
            long nc = (long)v.stackPred & 0xFFFFFFFFL | 0xFFFFFFFF00000000L & c + 0x1000000000000L;
            ForkJoinWorkerThread vt = v.owner;
            if (c != (c = this.compareAndExchangeCtl(c, nc))) continue;
            v.phase = sp;
            LockSupport.unpark(vt);
            break;
        }
    }

    final void runWorker(WorkQueue w) {
        if (this.mode >= 0 && w != null) {
            w.config |= 0x20000;
            int r = w.stackPred;
            int src = 0;
            do {
                r ^= r << 13;
                r ^= r >>> 17;
            } while ((src = this.scan(w, src, r ^= r << 5)) >= 0 || (src = this.awaitWork(w)) == 0);
        }
    }

    private int scan(WorkQueue w, int prevSrc, int r) {
        WorkQueue[] qs = this.queues;
        int n = w == null || qs == null ? 0 : qs.length;
        int step = r >>> 16 | 1;
        int i = n;
        while (i > 0) {
            int j = r & n - 1;
            WorkQueue q = qs[j];
            if (q != null) {
                int cap;
                ForkJoinTask<?>[] a = q.array;
                if (q.array != null && (cap = a.length) > 0) {
                    int b = q.base;
                    int k = cap - 1 & b;
                    int nextBase = b + 1;
                    int nextIndex = cap - 1 & nextBase;
                    int src = j | 0x20000;
                    ForkJoinTask<?> t = WorkQueue.getSlot(a, k);
                    if (q.base != b) {
                        return prevSrc;
                    }
                    if (t != null && WorkQueue.casSlotToNull(a, k, t)) {
                        q.base = nextBase;
                        ForkJoinTask<?> next = a[nextIndex];
                        w.source = src;
                        if (w.source != prevSrc && next != null) {
                            this.signalWork();
                        }
                        w.topLevelExec(t, q);
                        return src;
                    }
                    if (a[nextIndex] != null) {
                        return prevSrc;
                    }
                }
            }
            --i;
            r += step;
        }
        return this.queues != qs ? prevSrc : -1;
    }

    private int awaitWork(WorkQueue w) {
        long c;
        if (w == null) {
            return -1;
        }
        int phase = w.phase + 65536 & Integer.MAX_VALUE;
        w.phase = phase | Integer.MIN_VALUE;
        long prevCtl = this.ctl;
        do {
            w.stackPred = (int)prevCtl;
        } while (prevCtl != (prevCtl = this.compareAndExchangeCtl(prevCtl, c = prevCtl - 0x1000000000000L & 0xFFFFFFFF00000000L | (long)phase & 0xFFFFFFFFL)));
        Thread.interrupted();
        LockSupport.setCurrentBlocker(this);
        long deadline = 0L;
        int ac = (int)(c >> 48);
        int md = this.mode;
        if (md < 0) {
            return -1;
        }
        if ((md & 0xFFFF) + ac <= 0) {
            WorkQueue[] qs;
            boolean checkTermination = (md & 0x1000000) != 0;
            deadline = System.currentTimeMillis() + this.keepAlive;
            if (deadline == 0L) {
                deadline = 1L;
            }
            int n = (qs = this.queues) == null ? 0 : qs.length;
            for (int i = 0; i < n; i += 2) {
                int b;
                int cap;
                if (this.ctl != c) {
                    checkTermination = false;
                    break;
                }
                WorkQueue q = qs[i];
                if (q == null) continue;
                ForkJoinTask<?>[] a = q.array;
                if (q.array == null || (cap = a.length) <= 0 || (b = q.base) == q.top && a[cap - 1 & b] == null && q.source == 0) continue;
                if (this.compareAndSetCtl(c, prevCtl)) {
                    w.phase = phase;
                }
                checkTermination = false;
                break;
            }
            if (checkTermination && this.tryTerminate(false, false)) {
                return -1;
            }
        }
        boolean alt = false;
        while (w.phase < 0) {
            if (this.mode < 0) {
                return -1;
            }
            c = this.ctl;
            if (c == prevCtl) {
                Thread.onSpinWait();
                continue;
            }
            if (!(alt = !alt)) {
                Thread.interrupted();
                continue;
            }
            if (deadline == 0L) {
                LockSupport.park();
                continue;
            }
            if (deadline - System.currentTimeMillis() > 20L) {
                LockSupport.parkUntil(deadline);
                continue;
            }
            if (((int)c & 0xFFFF) == (w.config & 0xFFFF) && this.compareAndSetCtl(c, 0xFFFFFFFF00000000L & c - 0x100000000L | prevCtl & 0xFFFFFFFFL)) {
                w.config |= 0x80000;
                return -1;
            }
            if ((deadline += this.keepAlive) != 0L) continue;
            deadline = 1L;
        }
        return 0;
    }

    final boolean canStop() {
        block5: {
            WorkQueue[] qs;
            long checkSum;
            long oldSum = 0L;
            do {
                int md;
                qs = this.queues;
                if (this.queues == null || ((md = this.mode) & Integer.MIN_VALUE) != 0) {
                    return true;
                }
                long c = this.ctl;
                if ((md & 0xFFFF) + (int)(c >> 48) > 0) break block5;
                checkSum = c;
                for (int i = 1; i < qs.length; i += 2) {
                    int s = 0;
                    WorkQueue q = qs[i];
                    if (q != null) {
                        int cap;
                        ForkJoinTask<?>[] a = q.array;
                        if (q.array != null && (cap = a.length) > 0 && ((s = q.top) != q.base || a[cap - 1 & s] != null || q.source != 0)) break block5;
                    }
                    checkSum += (long)i << 32 ^ (long)s;
                }
            } while (oldSum != (oldSum = checkSum) || this.queues != qs);
            return true;
        }
        return (this.mode & Integer.MIN_VALUE) != 0;
    }

    private int tryCompensate(long c) {
        int md = this.mode;
        int b = this.bounds;
        short minActive = (short)(b & 0xFFFF);
        int maxTotal = b >>> 16;
        int active = (int)(c >> 48);
        short total = (short)(c >>> 32);
        int sp = (int)c & Integer.MAX_VALUE;
        if ((md & 0xFFFF) == 0) {
            return 0;
        }
        if (total >= 0) {
            if (sp != 0) {
                WorkQueue v;
                int n;
                WorkQueue[] qs = this.queues;
                if (this.queues != null && (n = qs.length) > 0 && (v = qs[sp & n - 1]) != null) {
                    ForkJoinWorkerThread vt = v.owner;
                    long nc = (long)v.stackPred & 0xFFFFFFFFL | 0xFFFFFFFF00000000L & c;
                    if (this.compareAndSetCtl(c, nc)) {
                        v.phase = sp;
                        LockSupport.unpark(vt);
                        return 65536;
                    }
                }
                return -1;
            }
            if (active > minActive) {
                long nc = 0xFFFF000000000000L & c - 0x1000000000000L | 0xFFFFFFFFFFFFL & c;
                return this.compareAndSetCtl(c, nc) ? 65536 : -1;
            }
        }
        if (total < maxTotal) {
            long nc = c + 0x100000000L & 0xFFFF00000000L | c & 0xFFFF0000FFFFFFFFL;
            return !this.compareAndSetCtl(c, nc) ? -1 : (!this.createWorker() ? 0 : 65536);
        }
        if (!this.compareAndSetCtl(c, c)) {
            return -1;
        }
        Predicate<? super ForkJoinPool> sat = this.saturate;
        if (sat != null && sat.test(this)) {
            return 0;
        }
        throw new RejectedExecutionException("Thread limit exceeded replacing blocked worker");
    }

    final void uncompensate() {
        this.getAndAddCtl(0x1000000000000L);
    }

    final int helpJoin(ForkJoinTask<?> task, WorkQueue w, boolean canHelp) {
        int s = 0;
        if (task != null && w != null) {
            int wsrc = w.source;
            int wid = w.config & 0xFFFF;
            int r = wid + 2;
            boolean scan = true;
            long c = 0L;
            block0: while ((s = task.status) >= 0) {
                if (scan = !scan) {
                    if (this.mode < 0) {
                        ForkJoinTask.cancelIgnoringExceptions(task);
                        continue;
                    }
                    if (c != (c = this.ctl) || (s = this.tryCompensate(c)) < 0) continue;
                    break;
                }
                if (!canHelp) continue;
                WorkQueue[] qs = this.queues;
                int n = qs == null ? 0 : qs.length;
                int m = n - 1;
                int i = n;
                while (i > 0) {
                    int j = r & m;
                    WorkQueue q = qs[j];
                    if (q != null) {
                        int cap;
                        int sq = q.source & 0xFFFF;
                        ForkJoinTask<?>[] a = q.array;
                        if (q.array != null && (cap = a.length) > 0) {
                            WorkQueue y;
                            int sx;
                            WorkQueue x;
                            int b = q.base;
                            int k = cap - 1 & b;
                            int nextBase = b + 1;
                            int src = j | 0x20000;
                            ForkJoinTask<?> t = WorkQueue.getSlot(a, k);
                            boolean eligible = sq == wid || (x = qs[sq & m]) != null && ((sx = x.source & 0xFFFF) == wid || (y = qs[sx & m]) != null && (y.source & 0xFFFF) == wid);
                            s = task.status;
                            if (s < 0) break block0;
                            if ((q.source & 0xFFFF) != sq || q.base != b) {
                                scan = true;
                            } else if (t == null) {
                                scan |= a[nextBase & cap - 1] != null || q.top != b;
                            } else if (eligible) {
                                if (WorkQueue.casSlotToNull(a, k, t)) {
                                    q.base = nextBase;
                                    w.source = src;
                                    t.doExec();
                                    w.source = wsrc;
                                }
                                scan = true;
                                continue block0;
                            }
                        }
                    }
                    i -= 2;
                    r += 2;
                }
            }
        }
        return s;
    }

    final int helpComplete(ForkJoinTask<?> task, WorkQueue w, boolean owned) {
        int s = 0;
        if (task != null && w != null) {
            int r = w.config;
            boolean scan = true;
            boolean locals = true;
            long c = 0L;
            block0: while (true) {
                int n;
                if (locals) {
                    s = w.helpComplete(task, owned, 0);
                    if (s < 0) break;
                    locals = false;
                    continue;
                }
                s = task.status;
                if (s < 0) break;
                if (scan = !scan) {
                    if (c != (c = this.ctl)) continue;
                    break;
                }
                WorkQueue[] qs = this.queues;
                int i = n = qs == null ? 0 : qs.length;
                while (true) {
                    if (i <= 0) continue block0;
                    boolean eligible = false;
                    int j = r & n - 1;
                    WorkQueue q = qs[j];
                    if (q != null) {
                        int cap;
                        ForkJoinTask<?>[] a = q.array;
                        if (q.array != null && (cap = a.length) > 0) {
                            int b = q.base;
                            int k = cap - 1 & b;
                            int nextBase = b + 1;
                            ForkJoinTask<?> t = WorkQueue.getSlot(a, k);
                            if (t instanceof CountedCompleter) {
                                CountedCompleter<?> f = (CountedCompleter<?>)t;
                                while (!(eligible = f == task) && (f = f.completer) != null) {
                                }
                            }
                            if ((s = task.status) < 0) break block0;
                            if (q.base != b) {
                                scan = true;
                            } else if (t == null) {
                                scan |= a[nextBase & cap - 1] != null || q.top != b;
                            } else if (eligible) {
                                if (WorkQueue.casSlotToNull(a, k, t)) {
                                    q.setBaseOpaque(nextBase);
                                    t.doExec();
                                    locals = true;
                                }
                                scan = true;
                                continue block0;
                            }
                        }
                    }
                    --i;
                    ++r;
                }
                break;
            }
        }
        return s;
    }

    private ForkJoinTask<?> pollScan(boolean submissionsOnly) {
        WorkQueue[] qs;
        boolean scan;
        VarHandle.acquireFence();
        int r = this.scanRover += 1640531527;
        if (submissionsOnly) {
            r &= 0xFFFFFFFE;
        }
        int step = submissionsOnly ? 2 : 1;
        do {
            int n;
            qs = this.queues;
            if (this.queues == null || (n = qs.length) <= 0) break;
            scan = false;
            for (int i = 0; i < n; i += step) {
                int cap;
                int j = n - 1 & r + i;
                WorkQueue q = qs[j];
                if (q == null) continue;
                ForkJoinTask<?>[] a = q.array;
                if (q.array == null || (cap = a.length) <= 0) continue;
                int b = q.base;
                int k = cap - 1 & b;
                int nextBase = b + 1;
                ForkJoinTask<?> t = WorkQueue.getSlot(a, k);
                if (q.base != b) {
                    scan = true;
                    continue;
                }
                if (t == null) {
                    scan |= q.top != b || a[nextBase & cap - 1] != null;
                    continue;
                }
                if (!WorkQueue.casSlotToNull(a, k, t)) {
                    scan = true;
                    continue;
                }
                q.setBaseOpaque(nextBase);
                return t;
            }
        } while (scan || this.queues != qs);
        return null;
    }

    final int helpQuiescePool(WorkQueue w, long nanos, boolean interruptible) {
        int prevSrc;
        if (w == null) {
            return 0;
        }
        long startTime = System.nanoTime();
        long parkTime = 0L;
        int wsrc = prevSrc = w.source;
        int cfg = w.config;
        int r = cfg + 1;
        boolean active = true;
        boolean locals = true;
        while (true) {
            WorkQueue[] qs;
            int n;
            boolean busy = false;
            boolean scan = false;
            if (locals) {
                ForkJoinTask<?> u;
                locals = false;
                while ((u = w.nextLocalTask(cfg)) != null) {
                    u.doExec();
                }
            }
            int i = n = (qs = this.queues) == null ? 0 : qs.length;
            while (i > 0) {
                int j = n - 1 & r;
                WorkQueue q = qs[j];
                if (q != null && q != w) {
                    int cap;
                    ForkJoinTask<?>[] a = q.array;
                    if (q.array != null && (cap = a.length) > 0) {
                        int b = q.base;
                        int k = cap - 1 & b;
                        int nextBase = b + 1;
                        int src = j | 0x20000;
                        ForkJoinTask<?> t = WorkQueue.getSlot(a, k);
                        if (q.base != b) {
                            scan = true;
                            busy = true;
                        } else {
                            if (t != null) {
                                scan = true;
                                busy = true;
                                if (!active) {
                                    active = true;
                                    this.getAndAddCtl(0x1000000000000L);
                                }
                                if (!WorkQueue.casSlotToNull(a, k, t)) break;
                                q.base = nextBase;
                                w.source = src;
                                t.doExec();
                                w.source = wsrc = prevSrc;
                                locals = true;
                                break;
                            }
                            if (!busy) {
                                if (q.top != b || a[nextBase & cap - 1] != null) {
                                    scan = true;
                                    busy = true;
                                } else if (q.source != 524288 && q.phase >= 0) {
                                    busy = true;
                                }
                            }
                        }
                    }
                }
                --i;
                ++r;
            }
            VarHandle.acquireFence();
            if (scan || this.queues != qs) continue;
            if (!busy) {
                w.source = prevSrc;
                if (!active) {
                    this.getAndAddCtl(0x1000000000000L);
                }
                return 1;
            }
            if (wsrc != 524288) {
                wsrc = 524288;
                w.source = 524288;
            }
            if (active) {
                active = false;
                parkTime = 0L;
                this.getAndAddCtl(-281474976710656L);
                continue;
            }
            if (parkTime == 0L) {
                parkTime = 1024L;
                Thread.yield();
                continue;
            }
            boolean interrupted = interruptible && Thread.interrupted();
            if (interrupted || System.nanoTime() - startTime > nanos) {
                this.getAndAddCtl(0x1000000000000L);
                return interrupted ? -1 : 0;
            }
            LockSupport.parkNanos(this, parkTime);
            if (parkTime >= nanos >>> 8 || parkTime >= 0x100000L) continue;
            parkTime <<= 1;
        }
    }

    final int externalHelpQuiescePool(long nanos, boolean interruptible) {
        long startTime = System.nanoTime();
        long parkTime = 0L;
        while (true) {
            ForkJoinTask<?> t;
            if ((t = this.pollScan(false)) != null) {
                t.doExec();
                parkTime = 0L;
                continue;
            }
            if (this.canStop()) {
                return 1;
            }
            if (parkTime == 0L) {
                parkTime = 1024L;
                Thread.yield();
                continue;
            }
            if (System.nanoTime() - startTime > nanos) {
                return 0;
            }
            if (interruptible && Thread.interrupted()) {
                return -1;
            }
            LockSupport.parkNanos(this, parkTime);
            if (parkTime >= nanos >>> 8 || parkTime >= 0x100000L) continue;
            parkTime <<= 1;
        }
    }

    final ForkJoinTask<?> nextTaskFor(WorkQueue w) {
        ForkJoinTask<?> t;
        if (w == null || (t = w.nextLocalTask(w.config)) == null) {
            t = this.pollScan(false);
        }
        return t;
    }

    final WorkQueue submissionQueue() {
        WorkQueue q;
        int r = ThreadLocalRandom.getProbe();
        if (r == 0) {
            ThreadLocalRandom.localInit();
            r = ThreadLocalRandom.getProbe();
        }
        int id = r << 1;
        while (true) {
            int n;
            int md = this.mode;
            WorkQueue[] qs = this.queues;
            if ((md & 0x1000000) != 0 || qs == null || (n = qs.length) <= 0) {
                return null;
            }
            int i = n - 1 & id;
            q = qs[i];
            if (q == null) {
                ReentrantLock lock = this.registrationLock;
                if (lock == null) continue;
                WorkQueue w = new WorkQueue(id | 0x20000);
                lock.lock();
                if (qs[i] == null) {
                    qs[i] = w;
                }
                lock.unlock();
                continue;
            }
            if (q.tryLock()) break;
            r = ThreadLocalRandom.advanceProbe(r);
            id = r << 1;
        }
        return q;
    }

    final void externalPush(ForkJoinTask<?> task) {
        WorkQueue q = this.submissionQueue();
        if (q == null) {
            throw new RejectedExecutionException();
        }
        if (q.lockedPush(task)) {
            this.signalWork();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private <T> ForkJoinTask<T> externalSubmit(ForkJoinTask<T> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        Thread t = Thread.currentThread();
        if (t instanceof ForkJoinWorkerThread) {
            ForkJoinWorkerThread wt = (ForkJoinWorkerThread)t;
            WorkQueue q = wt.workQueue;
            if (q != null && wt.pool == this) {
                q.push(task, this);
                return task;
            }
        }
        this.externalPush(task);
        return task;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static WorkQueue commonQueue() {
        int r = ThreadLocalRandom.getProbe();
        ForkJoinPool p = common;
        if (p == null) return null;
        WorkQueue[] qs = p.queues;
        if (p.queues == null) return null;
        int n = qs.length;
        if (n <= 0) return null;
        if (r == 0) return null;
        WorkQueue workQueue = qs[n - 1 & r << 1];
        return workQueue;
    }

    final WorkQueue externalQueue() {
        int n;
        int r = ThreadLocalRandom.getProbe();
        WorkQueue[] qs = this.queues;
        return this.queues != null && (n = qs.length) > 0 && r != 0 ? qs[n - 1 & r << 1] : null;
    }

    static void helpAsyncBlocker(Executor e, ManagedBlocker blocker) {
        WorkQueue w = null;
        Thread t = Thread.currentThread();
        if (t instanceof ForkJoinWorkerThread) {
            ForkJoinWorkerThread wt = (ForkJoinWorkerThread)t;
            if (wt.pool == e) {
                w = wt.workQueue;
            }
        } else if (e instanceof ForkJoinPool) {
            w = ((ForkJoinPool)e).externalQueue();
        }
        if (w != null) {
            w.helpAsyncBlocker(blocker);
        }
    }

    static int getSurplusQueuedTaskCount() {
        Thread t = Thread.currentThread();
        if (t instanceof ForkJoinWorkerThread) {
            WorkQueue q;
            ForkJoinWorkerThread wt = (ForkJoinWorkerThread)t;
            ForkJoinPool pool = wt.pool;
            if (pool != null && (q = wt.workQueue) != null) {
                int p = pool.mode & 0xFFFF;
                int a = p + (int)(pool.ctl >> 48);
                int n = q.top - q.base;
                return n - (a > (p >>>= 1) ? 0 : (a > (p >>>= 1) ? 1 : (a > (p >>>= 1) ? 2 : (a > (p >>>= 1) ? 4 : 8))));
            }
        }
        return 0;
    }

    private boolean tryTerminate(boolean now, boolean enable) {
        int md = this.mode;
        if ((md & 0x1000000) == 0) {
            if (!enable) {
                return false;
            }
            md = this.getAndBitwiseOrMode(0x1000000);
        }
        if ((md & Integer.MIN_VALUE) == 0) {
            if (!now && !this.canStop()) {
                return false;
            }
            md = this.getAndBitwiseOrMode(Integer.MIN_VALUE);
        }
        boolean rescan = true;
        while (true) {
            ReentrantLock lock;
            int n;
            ForkJoinTask<?> t;
            boolean changed = false;
            while ((t = this.pollScan(false)) != null) {
                changed = true;
                ForkJoinTask.cancelIgnoringExceptions(t);
            }
            WorkQueue[] qs = this.queues;
            if (this.queues != null && (n = qs.length) > 0) {
                for (int j = 1; j < n; j += 2) {
                    ForkJoinWorkerThread thread;
                    WorkQueue q = qs[j];
                    if (q == null || (thread = q.owner) == null || thread.isInterrupted()) continue;
                    changed = true;
                    try {
                        thread.interrupt();
                        continue;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            if (((md = this.mode) & 0x2000000) == 0 && (md & 0xFFFF) + (short)(this.ctl >>> 32) <= 0 && (this.getAndBitwiseOrMode(0x2000000) & 0x2000000) == 0 && (lock = this.registrationLock) != null) {
                lock.lock();
                Condition cond = this.termination;
                if (cond != null) {
                    cond.signalAll();
                }
                lock.unlock();
            }
            if (changed) {
                rescan = true;
                continue;
            }
            if (!rescan) break;
            rescan = false;
        }
        return true;
    }

    public ForkJoinPool() {
        this(Math.min(Short.MAX_VALUE, Runtime.getRuntime().availableProcessors()), defaultForkJoinWorkerThreadFactory, null, false, 0, Short.MAX_VALUE, 1, null, 60000L, TimeUnit.MILLISECONDS);
    }

    public ForkJoinPool(int parallelism) {
        this(parallelism, defaultForkJoinWorkerThreadFactory, null, false, 0, Short.MAX_VALUE, 1, null, 60000L, TimeUnit.MILLISECONDS);
    }

    public ForkJoinPool(int parallelism, ForkJoinWorkerThreadFactory factory, Thread.UncaughtExceptionHandler handler, boolean asyncMode) {
        this(parallelism, factory, handler, asyncMode, 0, Short.MAX_VALUE, 1, null, 60000L, TimeUnit.MILLISECONDS);
    }

    public ForkJoinPool(int parallelism, ForkJoinWorkerThreadFactory factory, Thread.UncaughtExceptionHandler handler, boolean asyncMode, int corePoolSize, int maximumPoolSize, int minimumRunnable, Predicate<? super ForkJoinPool> saturate, long keepAliveTime, TimeUnit unit) {
        ForkJoinPool.checkPermission();
        int p = parallelism;
        if (p <= 0 || p > Short.MAX_VALUE || p > maximumPoolSize || keepAliveTime <= 0L) {
            throw new IllegalArgumentException();
        }
        if (factory == null || unit == null) {
            throw new NullPointerException();
        }
        this.factory = factory;
        this.ueh = handler;
        this.saturate = saturate;
        this.keepAlive = Math.max(unit.toMillis(keepAliveTime), 20L);
        int size = 1 << 33 - Integer.numberOfLeadingZeros(p - 1);
        int corep = Math.min(Math.max(corePoolSize, p), Short.MAX_VALUE);
        int maxSpares = Math.min(maximumPoolSize, Short.MAX_VALUE) - p;
        int minAvail = Math.min(Math.max(minimumRunnable, 0), Short.MAX_VALUE);
        this.bounds = minAvail - p & 0xFFFF | maxSpares << 16;
        this.mode = p | (asyncMode ? 65536 : 0);
        this.ctl = (long)(-corep) << 32 & 0xFFFF00000000L | (long)(-p) << 48 & 0xFFFF000000000000L;
        this.registrationLock = new ReentrantLock();
        this.queues = new WorkQueue[size];
        String pid = Integer.toString(ForkJoinPool.getAndAddPoolIds(1) + 1);
        this.workerNamePrefix = "ForkJoinPool-" + pid + "-worker-";
    }

    private static Object newInstanceFromSystemProperty(String property) throws ReflectiveOperationException {
        String className = System.getProperty(property);
        return className == null ? null : ClassLoader.getSystemClassLoader().loadClass(className).getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private ForkJoinPool(byte forCommonPoolOnly) {
        int size;
        int p;
        int parallelism = Math.max(1, Runtime.getRuntime().availableProcessors() - 1);
        ForkJoinWorkerThreadFactory fac = null;
        Thread.UncaughtExceptionHandler handler = null;
        try {
            fac = (ForkJoinWorkerThreadFactory)ForkJoinPool.newInstanceFromSystemProperty("java.util.concurrent.ForkJoinPool.common.threadFactory");
            handler = (Thread.UncaughtExceptionHandler)ForkJoinPool.newInstanceFromSystemProperty("java.util.concurrent.ForkJoinPool.common.exceptionHandler");
            String pp = System.getProperty("java.util.concurrent.ForkJoinPool.common.parallelism");
            if (pp != null) {
                parallelism = Integer.parseInt(pp);
            }
        }
        catch (Exception pp) {
            // empty catch block
        }
        this.ueh = handler;
        this.keepAlive = 60000L;
        this.saturate = null;
        this.workerNamePrefix = null;
        this.mode = p = Math.min(Math.max(parallelism, 0), Short.MAX_VALUE);
        if (p > 0) {
            size = 1 << 33 - Integer.numberOfLeadingZeros(p - 1);
            this.bounds = 1 - p & 0xFFFF | COMMON_MAX_SPARES << 16;
            this.ctl = (long)(-p) << 32 & 0xFFFF00000000L | (long)(-p) << 48 & 0xFFFF000000000000L;
        } else {
            size = 1;
            this.bounds = 0;
            this.ctl = 0L;
        }
        this.factory = fac != null ? fac : new DefaultCommonPoolForkJoinWorkerThreadFactory();
        this.queues = new WorkQueue[size];
        this.registrationLock = new ReentrantLock();
    }

    public static ForkJoinPool commonPool() {
        return common;
    }

    public <T> T invoke(ForkJoinTask<T> task) {
        this.externalSubmit(task);
        return task.joinForPoolInvoke(this);
    }

    public void execute(ForkJoinTask<?> task) {
        this.externalSubmit(task);
    }

    @Override
    public void execute(Runnable task) {
        this.externalSubmit(task instanceof ForkJoinTask ? (ForkJoinTask)((Object)task) : new ForkJoinTask.RunnableExecuteAction(task));
    }

    public <T> ForkJoinTask<T> submit(ForkJoinTask<T> task) {
        return this.externalSubmit(task);
    }

    public <T> ForkJoinTask<T> submit(Callable<T> task) {
        return this.externalSubmit(new ForkJoinTask.AdaptedCallable<T>(task));
    }

    public <T> ForkJoinTask<T> submit(Runnable task, T result) {
        return this.externalSubmit(new ForkJoinTask.AdaptedRunnable<T>(task, result));
    }

    public ForkJoinTask<?> submit(Runnable task) {
        return this.externalSubmit(task instanceof ForkJoinTask ? (ForkJoinTask)((Object)task) : new ForkJoinTask.AdaptedRunnableAction(task));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) {
        ArrayList<Future<T>> futures = new ArrayList<Future<T>>(tasks.size());
        try {
            for (Callable<T> t : tasks) {
                ForkJoinTask.AdaptedInterruptibleCallable<T> adaptedInterruptibleCallable = new ForkJoinTask.AdaptedInterruptibleCallable<T>(t);
                futures.add(adaptedInterruptibleCallable);
                this.externalSubmit(adaptedInterruptibleCallable);
            }
            for (int i = futures.size() - 1; i >= 0; --i) {
                ((ForkJoinTask)futures.get(i)).awaitPoolInvoke(this);
            }
            return futures;
        }
        catch (Throwable t) {
            for (Future future : futures) {
                ForkJoinTask.cancelIgnoringExceptions(future);
            }
            throw t;
        }
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        ArrayList<Future<T>> futures = new ArrayList<Future<T>>(tasks.size());
        try {
            for (Callable<T> t : tasks) {
                ForkJoinTask.AdaptedInterruptibleCallable<T> adaptedInterruptibleCallable = new ForkJoinTask.AdaptedInterruptibleCallable<T>(t);
                futures.add(adaptedInterruptibleCallable);
                this.externalSubmit(adaptedInterruptibleCallable);
            }
            long startTime = System.nanoTime();
            long l = nanos;
            boolean timedOut = l < 0L;
            for (int i = futures.size() - 1; i >= 0; --i) {
                Future<T> f = futures.get(i);
                if (f.isDone()) continue;
                if (timedOut) {
                    ForkJoinTask.cancelIgnoringExceptions(f);
                    continue;
                }
                ((ForkJoinTask)f).awaitPoolInvoke(this, l);
                l = nanos - (System.nanoTime() - startTime);
                if (l >= 0L) continue;
                timedOut = true;
            }
            return futures;
        }
        catch (Throwable t) {
            for (Future future : futures) {
                ForkJoinTask.cancelIgnoringExceptions(future);
            }
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        int n = tasks.size();
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        InvokeAnyRoot root = new InvokeAnyRoot(n, this);
        ArrayList<InvokeAnyTask> fs = new ArrayList<InvokeAnyTask>(n);
        try {
            for (Callable<T> c : tasks) {
                if (c == null) {
                    throw new NullPointerException();
                }
                InvokeAnyTask f = new InvokeAnyTask(root, c);
                fs.add(f);
                this.externalSubmit(f);
                if (!root.isDone()) continue;
                break;
            }
            Iterator<Callable<Object>> iterator = root.getForPoolInvoke(this);
            return (T)iterator;
        }
        finally {
            for (InvokeAnyTask f : fs) {
                ForkJoinTask.cancelIgnoringExceptions(f);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long nanos = unit.toNanos(timeout);
        int n = tasks.size();
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        InvokeAnyRoot root = new InvokeAnyRoot(n, this);
        ArrayList<InvokeAnyTask> fs = new ArrayList<InvokeAnyTask>(n);
        try {
            for (Callable<T> c : tasks) {
                if (c == null) {
                    throw new NullPointerException();
                }
                InvokeAnyTask f = new InvokeAnyTask(root, c);
                fs.add(f);
                this.externalSubmit(f);
                if (!root.isDone()) continue;
                break;
            }
            Iterator<Callable<Object>> iterator = root.getForPoolInvoke(this, nanos);
            return (T)iterator;
        }
        finally {
            for (InvokeAnyTask f : fs) {
                ForkJoinTask.cancelIgnoringExceptions(f);
            }
        }
    }

    public ForkJoinWorkerThreadFactory getFactory() {
        return this.factory;
    }

    public Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.ueh;
    }

    public int getParallelism() {
        int par = this.mode & 0xFFFF;
        return par > 0 ? par : 1;
    }

    public static int getCommonPoolParallelism() {
        return COMMON_PARALLELISM;
    }

    public int getPoolSize() {
        return (this.mode & 0xFFFF) + (short)(this.ctl >>> 32);
    }

    public boolean getAsyncMode() {
        return (this.mode & 0x10000) != 0;
    }

    public int getRunningThreadCount() {
        VarHandle.acquireFence();
        int rc = 0;
        WorkQueue[] qs = this.queues;
        if (this.queues != null) {
            for (int i = 1; i < qs.length; i += 2) {
                WorkQueue q = qs[i];
                if (q == null || !q.isApparentlyUnblocked()) continue;
                ++rc;
            }
        }
        return rc;
    }

    public int getActiveThreadCount() {
        int r = (this.mode & 0xFFFF) + (int)(this.ctl >> 48);
        return r <= 0 ? 0 : r;
    }

    public boolean isQuiescent() {
        return this.canStop();
    }

    public long getStealCount() {
        long count = this.stealCount;
        WorkQueue[] qs = this.queues;
        if (this.queues != null) {
            for (int i = 1; i < qs.length; i += 2) {
                WorkQueue q = qs[i];
                if (q == null) continue;
                count += (long)q.nsteals & 0xFFFFFFFFL;
            }
        }
        return count;
    }

    public long getQueuedTaskCount() {
        VarHandle.acquireFence();
        int count = 0;
        WorkQueue[] qs = this.queues;
        if (this.queues != null) {
            for (int i = 1; i < qs.length; i += 2) {
                WorkQueue q = qs[i];
                if (q == null) continue;
                count += q.queueSize();
            }
        }
        return count;
    }

    public int getQueuedSubmissionCount() {
        VarHandle.acquireFence();
        int count = 0;
        WorkQueue[] qs = this.queues;
        if (this.queues != null) {
            for (int i = 0; i < qs.length; i += 2) {
                WorkQueue q = qs[i];
                if (q == null) continue;
                count += q.queueSize();
            }
        }
        return count;
    }

    public boolean hasQueuedSubmissions() {
        VarHandle.acquireFence();
        WorkQueue[] qs = this.queues;
        if (this.queues != null) {
            for (int i = 0; i < qs.length; i += 2) {
                WorkQueue q = qs[i];
                if (q == null || q.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    protected ForkJoinTask<?> pollSubmission() {
        return this.pollScan(true);
    }

    protected int drainTasksTo(Collection<? super ForkJoinTask<?>> c) {
        ForkJoinTask<?> t;
        int count = 0;
        while ((t = this.pollScan(false)) != null) {
            c.add(t);
            ++count;
        }
        return count;
    }

    public String toString() {
        int md = this.mode;
        long c = this.ctl;
        long st = this.stealCount;
        long qt = 0L;
        long ss = 0L;
        int rc = 0;
        WorkQueue[] qs = this.queues;
        if (this.queues != null) {
            for (int i = 0; i < qs.length; ++i) {
                WorkQueue q = qs[i];
                if (q == null) continue;
                int size = q.queueSize();
                if ((i & 1) == 0) {
                    ss += (long)size;
                    continue;
                }
                qt += (long)size;
                st += (long)q.nsteals & 0xFFFFFFFFL;
                if (!q.isApparentlyUnblocked()) continue;
                ++rc;
            }
        }
        int pc = md & 0xFFFF;
        int tc = pc + (short)(c >>> 32);
        int ac = pc + (int)(c >> 48);
        if (ac < 0) {
            ac = 0;
        }
        String level = (md & 0x2000000) != 0 ? "Terminated" : ((md & Integer.MIN_VALUE) != 0 ? "Terminating" : ((md & 0x1000000) != 0 ? "Shutting down" : "Running"));
        return super.toString() + "[" + level + ", parallelism = " + pc + ", size = " + tc + ", active = " + ac + ", running = " + rc + ", steals = " + st + ", tasks = " + qt + ", submissions = " + ss + "]";
    }

    @Override
    public void shutdown() {
        ForkJoinPool.checkPermission();
        if (this != common) {
            this.tryTerminate(false, true);
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        ForkJoinPool.checkPermission();
        if (this != common) {
            this.tryTerminate(true, true);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isTerminated() {
        return (this.mode & 0x2000000) != 0;
    }

    public boolean isTerminating() {
        return (this.mode & 0x82000000) == Integer.MIN_VALUE;
    }

    @Override
    public boolean isShutdown() {
        return (this.mode & 0x1000000) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        block9: {
            block10: {
                nanos = unit.toNanos(timeout);
                terminated = false;
                if (this != ForkJoinPool.common) break block10;
                t = Thread.currentThread();
                if (!(t instanceof ForkJoinWorkerThread)) ** GOTO lbl-1000
                wt = (ForkJoinWorkerThread)t;
                if (wt.pool == this) {
                    q = this.helpQuiescePool(wt.workQueue, nanos, true);
                } else lbl-1000:
                // 2 sources

                {
                    q = this.externalHelpQuiescePool(nanos, true);
                }
                if (q < 0) {
                    throw new InterruptedException();
                }
                break block9;
            }
            terminated = (this.mode & 0x2000000) != 0;
            if (!terminated && (lock = this.registrationLock) != null) {
                lock.lock();
                try {
                    cond = this.termination;
                    if (cond == null) {
                        this.termination = cond = lock.newCondition();
                    }
                    while (!(terminated = (this.mode & 0x2000000) != 0) && nanos > 0L) {
                        nanos = cond.awaitNanos(nanos);
                    }
                }
                finally {
                    lock.unlock();
                }
            }
        }
        return terminated;
    }

    /*
     * Unable to fully structure code
     */
    public boolean awaitQuiescence(long timeout, TimeUnit unit) {
        nanos = unit.toNanos(timeout);
        t = Thread.currentThread();
        if (!(t instanceof ForkJoinWorkerThread)) ** GOTO lbl-1000
        wt = (ForkJoinWorkerThread)t;
        if (wt.pool == this) {
            q = this.helpQuiescePool(wt.workQueue, nanos, false);
        } else lbl-1000:
        // 2 sources

        {
            q = this.externalHelpQuiescePool(nanos, false);
        }
        return q > 0;
    }

    public static void managedBlock(ManagedBlocker blocker) throws InterruptedException {
        ForkJoinPool p;
        Thread t = Thread.currentThread();
        if (t instanceof ForkJoinWorkerThread && (p = ((ForkJoinWorkerThread)t).pool) != null) {
            p.compensatedBlock(blocker);
        } else {
            ForkJoinPool.unmanagedBlock(blocker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void compensatedBlock(ManagedBlocker blocker) throws InterruptedException {
        if (blocker == null) {
            throw new NullPointerException();
        }
        while (true) {
            boolean done;
            long c = this.ctl;
            if (blocker.isReleasable()) return;
            int comp = this.tryCompensate(c);
            if (comp < 0) continue;
            long post = comp == 0 ? 0L : 0x1000000000000L;
            try {
                done = blocker.block();
            }
            finally {
                this.getAndAddCtl(post);
            }
            if (done) return;
        }
    }

    private static void unmanagedBlock(ManagedBlocker blocker) throws InterruptedException {
        if (blocker == null) {
            throw new NullPointerException();
        }
        while (!blocker.isReleasable() && !blocker.block()) {
        }
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        return new ForkJoinTask.AdaptedRunnable<T>(runnable, value);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return new ForkJoinTask.AdaptedCallable<T>(callable);
    }

    static {
        ForkJoinPool tmp;
        try {
            MethodHandles.Lookup l = MethodHandles.lookup();
            CTL = l.findVarHandle(ForkJoinPool.class, "ctl", Long.TYPE);
            MODE = l.findVarHandle(ForkJoinPool.class, "mode", Integer.TYPE);
            THREADIDS = l.findVarHandle(ForkJoinPool.class, "threadIds", Integer.TYPE);
            POOLIDS = l.findStaticVarHandle(ForkJoinPool.class, "poolIds", Integer.TYPE);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
        Class<LockSupport> ensureLoaded = LockSupport.class;
        int commonMaxSpares = 256;
        try {
            String p = System.getProperty("java.util.concurrent.ForkJoinPool.common.maximumSpares");
            if (p != null) {
                commonMaxSpares = Integer.parseInt(p);
            }
        }
        catch (Exception p) {
            // empty catch block
        }
        COMMON_MAX_SPARES = commonMaxSpares;
        defaultForkJoinWorkerThreadFactory = new DefaultForkJoinWorkerThreadFactory();
        modifyThreadPermission = new RuntimePermission("modifyThread");
        common = tmp = AccessController.doPrivileged(new PrivilegedAction<ForkJoinPool>(){

            @Override
            public ForkJoinPool run() {
                return new ForkJoinPool(0);
            }
        });
        COMMON_PARALLELISM = Math.max(ForkJoinPool.common.mode & 0xFFFF, 1);
    }

    public static interface ForkJoinWorkerThreadFactory {
        public ForkJoinWorkerThread newThread(ForkJoinPool var1);
    }

    static final class WorkQueue {
        volatile int phase;
        int stackPred;
        int config;
        int base;
        ForkJoinTask<?>[] array;
        final ForkJoinWorkerThread owner;
        @Contended(value="w")
        int top;
        @Contended(value="w")
        volatile int source;
        @Contended(value="w")
        int nsteals;
        private static final VarHandle QA;
        private static final VarHandle SOURCE;
        private static final VarHandle BASE;
        private static AccessControlContext INNOCUOUS_ACC;

        static final ForkJoinTask<?> getSlot(ForkJoinTask<?>[] a, int i) {
            return QA.getAcquire(a, i);
        }

        static final ForkJoinTask<?> getAndClearSlot(ForkJoinTask<?>[] a, int i) {
            return QA.getAndSet(a, i, null);
        }

        static final void setSlotVolatile(ForkJoinTask<?>[] a, int i, ForkJoinTask<?> v) {
            QA.setVolatile(a, i, v);
        }

        static final boolean casSlotToNull(ForkJoinTask<?>[] a, int i, ForkJoinTask<?> c) {
            return QA.compareAndSet(a, i, c, null);
        }

        final boolean tryLock() {
            return SOURCE.compareAndSet(this, 0, 1);
        }

        final void setBaseOpaque(int b) {
            BASE.setOpaque(this, b);
        }

        WorkQueue(ForkJoinWorkerThread owner, boolean isInnocuous) {
            this.config = isInnocuous ? 262144 : 0;
            this.owner = owner;
        }

        WorkQueue(int config) {
            this.array = new ForkJoinTask[256];
            this.config = config;
            this.owner = null;
            this.phase = -1;
        }

        final int getPoolIndex() {
            return (this.config & 0xFFFF) >>> 1;
        }

        final int queueSize() {
            VarHandle.acquireFence();
            int n = this.top - this.base;
            return n < 0 ? 0 : n;
        }

        final boolean isEmpty() {
            return (this.source == 0 || this.owner != null) && this.top - this.base <= 0;
        }

        final void push(ForkJoinTask<?> task, ForkJoinPool pool) {
            int cap;
            ForkJoinTask<?>[] a = this.array;
            int s = this.top++;
            int d = s - this.base;
            if (a != null && pool != null && (cap = a.length) > 0) {
                int m = cap - 1;
                WorkQueue.setSlotVolatile(a, m & s, task);
                if (d == m) {
                    this.growArray();
                }
                if (d == m || a[m & s - 1] == null) {
                    pool.signalWork();
                }
            }
        }

        final boolean lockedPush(ForkJoinTask<?> task) {
            int cap;
            ForkJoinTask<?>[] a = this.array;
            int s = this.top++;
            int d = s - this.base;
            if (a != null && (cap = a.length) > 0) {
                int m = cap - 1;
                a[m & s] = task;
                if (d == m) {
                    this.growArray();
                }
                this.source = 0;
                if (d == m || a[m & s - 1] == null) {
                    return true;
                }
            }
            return false;
        }

        final void growArray() {
            int newCap;
            int oldCap;
            ForkJoinTask<?>[] oldArray = this.array;
            int s = this.top - 1;
            if (oldArray != null && (oldCap = oldArray.length) > 0 && (newCap = oldCap << 1) > 0) {
                ForkJoinTask<?> x;
                ForkJoinTask[] newArray;
                try {
                    newArray = new ForkJoinTask[newCap];
                }
                catch (Throwable ex) {
                    this.top = s;
                    if (this.owner == null) {
                        this.source = 0;
                    }
                    throw new RejectedExecutionException("Queue capacity exceeded");
                }
                int newMask = newCap - 1;
                int oldMask = oldCap - 1;
                int k = oldCap;
                while (k > 0 && (x = WorkQueue.getAndClearSlot(oldArray, s & oldMask)) != null) {
                    newArray[s & newMask] = x;
                    --k;
                    --s;
                }
                VarHandle.releaseFence();
                this.array = newArray;
            }
        }

        private ForkJoinTask<?> pop() {
            int cap;
            ForkJoinTask<?> t = null;
            int s = this.top;
            ForkJoinTask<?>[] a = this.array;
            if (this.array != null && (cap = a.length) > 0 && this.base != s-- && (t = WorkQueue.getAndClearSlot(a, cap - 1 & s)) != null) {
                this.top = s;
            }
            return t;
        }

        final boolean tryUnpush(ForkJoinTask<?> task) {
            int cap;
            int s = this.top;
            ForkJoinTask<?>[] a = this.array;
            if (this.array != null && (cap = a.length) > 0 && this.base != s-- && WorkQueue.casSlotToNull(a, cap - 1 & s, task)) {
                this.top = s;
                return true;
            }
            return false;
        }

        final boolean externalTryUnpush(ForkJoinTask<?> task) {
            boolean taken = false;
            while (true) {
                int k;
                int cap;
                int s = this.top;
                ForkJoinTask<?>[] a = this.array;
                if (this.array == null || (cap = a.length) <= 0 || a[k = cap - 1 & s - 1] != task) break;
                if (this.tryLock()) {
                    if (this.top == s && this.array == a && (taken = WorkQueue.casSlotToNull(a, k, task))) {
                        this.top = s - 1;
                        this.source = 0;
                        break;
                    }
                    this.source = 0;
                }
                Thread.yield();
            }
            return taken;
        }

        final boolean tryRemove(ForkJoinTask<?> task, boolean owned) {
            int cap;
            boolean taken = false;
            int p = this.top;
            ForkJoinTask<?>[] a = this.array;
            if (this.array != null && task != null && (cap = a.length) > 0) {
                int m = cap - 1;
                int s = p - 1;
                int i = s;
                for (int d = p - this.base; d > 0; --d) {
                    int k = i & m;
                    ForkJoinTask<?> t = a[k];
                    if (t == task) {
                        if (!owned && !this.tryLock()) break;
                        if ((owned || this.array == a && this.top == p) && (taken = WorkQueue.casSlotToNull(a, k, t))) {
                            int j = i;
                            while (j != s) {
                                a[j & m] = WorkQueue.getAndClearSlot(a, ++j & m);
                            }
                            this.top = s;
                        }
                        if (owned) break;
                        this.source = 0;
                        break;
                    }
                    --i;
                }
            }
            return taken;
        }

        final ForkJoinTask<?> tryPoll() {
            int cap;
            ForkJoinTask<?>[] a = this.array;
            if (this.array != null && (cap = a.length) > 0) {
                int b = this.base;
                int k = cap - 1 & b;
                ForkJoinTask<?> t = WorkQueue.getSlot(a, k);
                if (this.base == b++ && t != null && WorkQueue.casSlotToNull(a, k, t)) {
                    this.setBaseOpaque(b);
                    return t;
                }
            }
            return null;
        }

        final ForkJoinTask<?> nextLocalTask(int cfg) {
            int cap;
            ForkJoinTask<?> t = null;
            int s = this.top;
            ForkJoinTask<?>[] a = this.array;
            if (this.array != null && (cap = a.length) > 0) {
                int b;
                int d;
                while ((d = s - (b = this.base)) > 0) {
                    if (d == 1 || (cfg & 0x10000) == 0) {
                        if ((t = WorkQueue.getAndClearSlot(a, --s & cap - 1)) == null) break;
                        this.top = s;
                        break;
                    }
                    if ((t = WorkQueue.getAndClearSlot(a, b++ & cap - 1)) == null) continue;
                    this.setBaseOpaque(b);
                    break;
                }
            }
            return t;
        }

        final ForkJoinTask<?> nextLocalTask() {
            return this.nextLocalTask(this.config);
        }

        final ForkJoinTask<?> peek() {
            int cap;
            VarHandle.acquireFence();
            ForkJoinTask<?>[] a = this.array;
            return this.array != null && (cap = a.length) > 0 ? a[cap - 1 & ((this.config & 0x10000) != 0 ? this.base : this.top - 1)] : null;
        }

        final void topLevelExec(ForkJoinTask<?> task, WorkQueue q) {
            int cfg = this.config;
            int nstolen = 1;
            while (task != null) {
                task.doExec();
                task = this.nextLocalTask(cfg);
                if (task != null || q == null || (task = q.tryPoll()) == null) continue;
                ++nstolen;
            }
            this.nsteals += nstolen;
            this.source = 0;
            if ((cfg & 0x40000) != 0) {
                ThreadLocalRandom.eraseThreadLocals(Thread.currentThread());
            }
        }

        final int helpComplete(ForkJoinTask<?> task, boolean owned, int limit) {
            int status = 0;
            while (task != null && (status = task.status) >= 0) {
                int p;
                int s;
                int k;
                ForkJoinTask<?> t;
                int cap;
                ForkJoinTask<?>[] a = this.array;
                if (this.array == null || (cap = a.length) <= 0 || !((t = a[k = cap - 1 & (s = (p = this.top) - 1)]) instanceof CountedCompleter)) break;
                CountedCompleter<?> f = (CountedCompleter<?>)t;
                boolean taken = false;
                do {
                    if (f != task) continue;
                    if (owned) {
                        taken = WorkQueue.casSlotToNull(a, k, t);
                        if (taken) {
                            this.top = s;
                        }
                    } else if (this.tryLock()) {
                        if (this.top == p && this.array == a && (taken = WorkQueue.casSlotToNull(a, k, t))) {
                            this.top = s;
                        }
                        this.source = 0;
                    }
                    if (taken) {
                        t.doExec();
                        break;
                    }
                    if (owned) break;
                    Thread.yield();
                    break;
                } while ((f = f.completer) != null);
                if (!taken || limit == 0 || --limit != 0) continue;
                break;
            }
            return status;
        }

        final void helpAsyncBlocker(ManagedBlocker blocker) {
            int b;
            int d;
            while (blocker != null && (d = this.top - (b = this.base)) > 0) {
                int k;
                ForkJoinTask<?> t;
                int cap;
                ForkJoinTask<?>[] a = this.array;
                if (this.array == null || (cap = a.length) <= 0 || ((t = WorkQueue.getSlot(a, k = cap - 1 & b)) != null || d <= 1) && !(t instanceof CompletableFuture.AsynchronousCompletionTask) || blocker.isReleasable()) break;
                if (t == null || this.base != b++ || !WorkQueue.casSlotToNull(a, k, t)) continue;
                this.setBaseOpaque(b);
                t.doExec();
            }
        }

        final void initializeInnocuousWorker() {
            AccessControlContext acc = INNOCUOUS_ACC;
            if (acc == null) {
                INNOCUOUS_ACC = acc = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, null)});
            }
            Thread t = Thread.currentThread();
            ThreadLocalRandom.setInheritedAccessControlContext(t, acc);
            ThreadLocalRandom.eraseThreadLocals(t);
        }

        final boolean isApparentlyUnblocked() {
            Thread.State s;
            ForkJoinWorkerThread wt = this.owner;
            return wt != null && (s = wt.getState()) != Thread.State.BLOCKED && s != Thread.State.WAITING && s != Thread.State.TIMED_WAITING;
        }

        static {
            try {
                QA = MethodHandles.arrayElementVarHandle(ForkJoinTask[].class);
                MethodHandles.Lookup l = MethodHandles.lookup();
                SOURCE = l.findVarHandle(WorkQueue.class, "source", Integer.TYPE);
                BASE = l.findVarHandle(WorkQueue.class, "base", Integer.TYPE);
            }
            catch (ReflectiveOperationException e) {
                throw new ExceptionInInitializerError(e);
            }
        }
    }

    public static interface ManagedBlocker {
        public boolean block() throws InterruptedException;

        public boolean isReleasable();
    }

    static final class DefaultCommonPoolForkJoinWorkerThreadFactory
    implements ForkJoinWorkerThreadFactory {
        private static final AccessControlContext ACC = ForkJoinPool.contextWithPermissions(modifyThreadPermission, new RuntimePermission("enableContextClassLoaderOverride"), new RuntimePermission("modifyThreadGroup"), new RuntimePermission("getClassLoader"), new RuntimePermission("setContextClassLoader"));

        DefaultCommonPoolForkJoinWorkerThreadFactory() {
        }

        @Override
        public final ForkJoinWorkerThread newThread(final ForkJoinPool pool) {
            return AccessController.doPrivileged(new PrivilegedAction<ForkJoinWorkerThread>(){

                @Override
                public ForkJoinWorkerThread run() {
                    return System.getSecurityManager() == null ? new ForkJoinWorkerThread(null, pool, true, true) : new ForkJoinWorkerThread.InnocuousForkJoinWorkerThread(pool);
                }
            }, ACC);
        }
    }

    static final class InvokeAnyRoot<E>
    extends ForkJoinTask<E> {
        private static final long serialVersionUID = 2838392045355241008L;
        volatile E result;
        final AtomicInteger count;
        final ForkJoinPool pool;

        InvokeAnyRoot(int n, ForkJoinPool p) {
            this.pool = p;
            this.count = new AtomicInteger(n);
        }

        final void tryComplete(Callable<E> c) {
            boolean failed;
            Throwable ex = null;
            if (c == null || Thread.interrupted() || this.pool != null && this.pool.mode < 0) {
                failed = true;
            } else if (this.isDone()) {
                failed = false;
            } else {
                try {
                    this.complete(c.call());
                    failed = false;
                }
                catch (Throwable tx) {
                    ex = tx;
                    failed = true;
                }
            }
            if (this.pool != null && this.pool.mode < 0 || failed && this.count.getAndDecrement() <= 1) {
                this.trySetThrown(ex != null ? ex : new CancellationException());
            }
        }

        @Override
        public final boolean exec() {
            return false;
        }

        @Override
        public final E getRawResult() {
            return this.result;
        }

        @Override
        public final void setRawResult(E v) {
            this.result = v;
        }
    }

    static final class InvokeAnyTask<E>
    extends ForkJoinTask<E> {
        private static final long serialVersionUID = 2838392045355241008L;
        final InvokeAnyRoot<E> root;
        final Callable<E> callable;
        volatile transient Thread runner;

        InvokeAnyTask(InvokeAnyRoot<E> root, Callable<E> callable) {
            this.root = root;
            this.callable = callable;
        }

        @Override
        public final boolean exec() {
            Thread.interrupted();
            this.runner = Thread.currentThread();
            this.root.tryComplete(this.callable);
            this.runner = null;
            Thread.interrupted();
            return true;
        }

        @Override
        public final boolean cancel(boolean mayInterruptIfRunning) {
            Thread t;
            boolean stat = super.cancel(false);
            if (mayInterruptIfRunning && (t = this.runner) != null) {
                try {
                    t.interrupt();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return stat;
        }

        @Override
        public final void setRawResult(E v) {
        }

        @Override
        public final E getRawResult() {
            return null;
        }
    }

    static final class DefaultForkJoinWorkerThreadFactory
    implements ForkJoinWorkerThreadFactory {
        private static final AccessControlContext ACC = ForkJoinPool.contextWithPermissions(new RuntimePermission("getClassLoader"), new RuntimePermission("setContextClassLoader"));

        DefaultForkJoinWorkerThreadFactory() {
        }

        @Override
        public final ForkJoinWorkerThread newThread(final ForkJoinPool pool) {
            return AccessController.doPrivileged(new PrivilegedAction<ForkJoinWorkerThread>(){

                @Override
                public ForkJoinWorkerThread run() {
                    return new ForkJoinWorkerThread(null, pool, true, false);
                }
            }, ACC);
        }
    }
}

