/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountedCompleter;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.Future;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.LockSupport;

public abstract class ForkJoinTask<V>
implements Future<V>,
Serializable {
    private static final int DONE = Integer.MIN_VALUE;
    private static final int ABNORMAL = 65536;
    private static final int THROWN = 131072;
    private static final int SMASK = 65535;
    private static final int UNCOMPENSATE = 65536;
    volatile int status;
    private volatile transient Aux aux;
    private static final VarHandle STATUS;
    private static final VarHandle AUX;
    private static final long serialVersionUID = -7721805057305804111L;

    private int getAndBitwiseOrStatus(int v) {
        return STATUS.getAndBitwiseOr(this, v);
    }

    private boolean casStatus(int c, int v) {
        return STATUS.compareAndSet(this, c, v);
    }

    private boolean casAux(Aux c, Aux v) {
        return AUX.compareAndSet(this, c, v);
    }

    private void signalWaiters() {
        Aux a;
        while ((a = this.aux) != null && a.ex == null) {
            if (!this.casAux(a, null)) continue;
            while (a != null) {
                Thread t = a.thread;
                if (t != Thread.currentThread() && t != null) {
                    LockSupport.unpark(t);
                }
                a = a.next;
            }
            break block0;
        }
    }

    private int setDone() {
        int s = this.getAndBitwiseOrStatus(Integer.MIN_VALUE) | Integer.MIN_VALUE;
        this.signalWaiters();
        return s;
    }

    private int trySetCancelled() {
        int s;
        while ((s = this.status) >= 0 && !this.casStatus(s, s |= 0x80010000)) {
        }
        this.signalWaiters();
        return s;
    }

    final int trySetThrown(Throwable ex) {
        int s;
        Aux h = new Aux(Thread.currentThread(), ex);
        Aux p = null;
        boolean installed = false;
        while ((s = this.status) >= 0) {
            Aux a;
            if (!installed && ((a = this.aux) == null || a.ex == null) && (installed = this.casAux(a, h))) {
                p = a;
            }
            if (!installed || !this.casStatus(s, s |= 0x80030000)) continue;
        }
        while (p != null) {
            LockSupport.unpark(p.thread);
            p = p.next;
        }
        return s;
    }

    int trySetException(Throwable ex) {
        return this.trySetThrown(ex);
    }

    static boolean isExceptionalStatus(int s) {
        return (s & 0x20000) != 0;
    }

    final int doExec() {
        int s = this.status;
        if (s >= 0) {
            boolean completed;
            try {
                completed = this.exec();
            }
            catch (Throwable rex) {
                s = this.trySetException(rex);
                completed = false;
            }
            if (completed) {
                s = this.setDone();
            }
        }
        return s;
    }

    private int awaitDone(ForkJoinPool pool, boolean ran, boolean interruptible, boolean timed, long nanos) {
        int s;
        block38: {
            Aux a;
            boolean internal;
            ForkJoinPool p;
            ForkJoinPool.WorkQueue q = null;
            Thread t = Thread.currentThread();
            if (t instanceof ForkJoinWorkerThread) {
                ForkJoinWorkerThread wt = (ForkJoinWorkerThread)t;
                p = wt.pool;
                if (pool == null) {
                    pool = p;
                }
                if (internal = pool == p) {
                    q = wt.workQueue;
                }
            } else {
                internal = false;
                p = ForkJoinPool.common;
                if (pool == null) {
                    pool = p;
                }
                if (pool == p && p != null) {
                    q = p.externalQueue();
                }
            }
            if (interruptible && Thread.interrupted()) {
                return 65536;
            }
            s = this.status;
            if (s < 0) {
                return s;
            }
            long deadline = 0L;
            if (timed) {
                if (nanos <= 0L) {
                    return 0;
                }
                deadline = nanos + System.nanoTime();
                if (deadline == 0L) {
                    deadline = 1L;
                }
            }
            boolean uncompensate = false;
            if (q != null && p != null) {
                boolean canHelp;
                boolean bl = canHelp = !timed || (p.mode & 0xFFFF) == 0;
                if (canHelp) {
                    if (this instanceof CountedCompleter && (s = p.helpComplete(this, q, internal)) < 0) {
                        return s;
                    }
                    if (!ran && (!internal && q.externalTryUnpush(this) || q.tryRemove(this, internal)) && (s = this.doExec()) < 0) {
                        return s;
                    }
                }
                if (internal) {
                    s = p.helpJoin(this, q, canHelp);
                    if (s < 0) {
                        return s;
                    }
                    if (s == 65536) {
                        uncompensate = true;
                    }
                }
            }
            boolean interrupted = false;
            boolean queued = false;
            boolean parked = false;
            boolean fail = false;
            Aux node = null;
            while ((s = this.status) >= 0) {
                if (fail || (fail = pool != null && pool.mode < 0)) {
                    this.casStatus(s, s | 0x80010000);
                    continue;
                }
                if (parked && Thread.interrupted()) {
                    if (interruptible) {
                        s = 65536;
                        break;
                    }
                    interrupted = true;
                    continue;
                }
                if (queued) {
                    if (deadline != 0L) {
                        long ns = deadline - System.nanoTime();
                        if (ns <= 0L) break;
                        LockSupport.parkNanos(ns);
                    } else {
                        LockSupport.park();
                    }
                    parked = true;
                    continue;
                }
                if (node != null) {
                    a = this.aux;
                    if (a != null && a.ex != null) {
                        Thread.onSpinWait();
                        continue;
                    }
                    node.next = a;
                    queued = this.casAux(node.next, node);
                    if (!queued) continue;
                    LockSupport.setCurrentBlocker(this);
                    continue;
                }
                try {
                    node = new Aux(Thread.currentThread(), null);
                }
                catch (Throwable ex) {
                    fail = true;
                }
            }
            if (pool != null && uncompensate) {
                pool.uncompensate();
            }
            if (queued) {
                LockSupport.setCurrentBlocker(null);
                if (s >= 0) {
                    block3: while ((a = this.aux) != null && a.ex == null) {
                        Aux next;
                        Aux trail = null;
                        do {
                            next = a.next;
                            if (a == node) {
                                if (trail != null) {
                                    trail.casNext(trail, next);
                                    continue block3;
                                }
                                if (!this.casAux(a, next)) continue block3;
                                break block38;
                            }
                            trail = a;
                        } while ((a = next) != null);
                        break;
                    }
                } else {
                    this.signalWaiters();
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
        return s;
    }

    static final void cancelIgnoringExceptions(Future<?> t) {
        if (t != null) {
            try {
                t.cancel(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private Throwable getThrowableException() {
        Throwable ex;
        Aux a = this.aux;
        if (a == null) {
            ex = null;
        } else {
            ex = a.ex;
            if (ex != null && a.thread != Thread.currentThread()) {
                try {
                    Constructor<?> noArgCtor = null;
                    Constructor<?> oneArgCtor = null;
                    for (Constructor<?> c : ex.getClass().getConstructors()) {
                        Class<?>[] ps = c.getParameterTypes();
                        if (ps.length == 0) {
                            noArgCtor = c;
                            continue;
                        }
                        if (ps.length != 1 || ps[0] != Throwable.class) continue;
                        oneArgCtor = c;
                        break;
                    }
                    if (oneArgCtor != null) {
                        ex = (Throwable)oneArgCtor.newInstance(ex);
                    } else if (noArgCtor != null) {
                        Throwable rx = (Throwable)noArgCtor.newInstance(new Object[0]);
                        rx.initCause(ex);
                        ex = rx;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return ex;
    }

    private Throwable getException(int s) {
        Throwable ex = null;
        if ((s & 0x10000) != 0 && ((s & 0x20000) == 0 || (ex = this.getThrowableException()) == null)) {
            ex = new CancellationException();
        }
        return ex;
    }

    private void reportException(int s) {
        ForkJoinTask.uncheckedThrow((s & 0x20000) != 0 ? this.getThrowableException() : null);
    }

    private void reportExecutionException(int s) {
        Throwable ex = null;
        if (s == 65536) {
            ex = new InterruptedException();
        } else if (s >= 0) {
            ex = new TimeoutException();
        } else if ((s & 0x20000) != 0 && (ex = this.getThrowableException()) != null) {
            ex = new ExecutionException(ex);
        }
        ForkJoinTask.uncheckedThrow(ex);
    }

    static void rethrow(Throwable ex) {
        ForkJoinTask.uncheckedThrow(ex);
    }

    static <T extends Throwable> void uncheckedThrow(Throwable t) throws T {
        if (t == null) {
            t = new CancellationException();
        }
        throw t;
    }

    public final ForkJoinTask<V> fork() {
        Thread t = Thread.currentThread();
        if (t instanceof ForkJoinWorkerThread) {
            ForkJoinWorkerThread w = (ForkJoinWorkerThread)t;
            w.workQueue.push(this, w.pool);
        } else {
            ForkJoinPool.common.externalPush(this);
        }
        return this;
    }

    public final V join() {
        int s = this.status;
        if (s >= 0) {
            s = this.awaitDone(null, false, false, false, 0L);
        }
        if ((s & 0x10000) != 0) {
            this.reportException(s);
        }
        return this.getRawResult();
    }

    public final V invoke() {
        int s = this.doExec();
        if (s >= 0) {
            s = this.awaitDone(null, true, false, false, 0L);
        }
        if ((s & 0x10000) != 0) {
            this.reportException(s);
        }
        return this.getRawResult();
    }

    public static void invokeAll(ForkJoinTask<?> t1, ForkJoinTask<?> t2) {
        if (t1 == null || t2 == null) {
            throw new NullPointerException();
        }
        t2.fork();
        int s1 = t1.doExec();
        if (s1 >= 0) {
            s1 = t1.awaitDone(null, true, false, false, 0L);
        }
        if ((s1 & 0x10000) != 0) {
            ForkJoinTask.cancelIgnoringExceptions(t2);
            t1.reportException(s1);
        } else {
            int s2 = t2.awaitDone(null, false, false, false, 0L);
            if ((s2 & 0x10000) != 0) {
                t2.reportException(s2);
            }
        }
    }

    public static void invokeAll(ForkJoinTask<?> ... tasks) {
        int s;
        ForkJoinTask<?> t;
        int last;
        int i;
        Throwable ex = null;
        for (i = last = tasks.length - 1; i >= 0; --i) {
            t = tasks[i];
            if (t == null) {
                ex = new NullPointerException();
                break;
            }
            if (i == 0) {
                s = t.doExec();
                if (s >= 0) {
                    s = t.awaitDone(null, true, false, false, 0L);
                }
                if ((s & 0x10000) == 0) break;
                ex = t.getException(s);
                break;
            }
            t.fork();
        }
        if (ex == null) {
            for (i = 1; i <= last; ++i) {
                t = tasks[i];
                if (t == null) continue;
                s = t.status;
                if (s >= 0) {
                    s = t.awaitDone(null, false, false, false, 0L);
                }
                if ((s & 0x10000) != 0 && (ex = t.getException(s)) != null) break;
            }
        }
        if (ex != null) {
            for (i = 1; i <= last; ++i) {
                ForkJoinTask.cancelIgnoringExceptions(tasks[i]);
            }
            ForkJoinTask.rethrow(ex);
        }
    }

    public static <T extends ForkJoinTask<?>> Collection<T> invokeAll(Collection<T> tasks) {
        int s;
        ForkJoinTask t;
        int last;
        int i;
        if (!(tasks instanceof RandomAccess) || !(tasks instanceof List)) {
            ForkJoinTask.invokeAll(tasks.toArray(new ForkJoinTask[0]));
            return tasks;
        }
        List ts = (List)tasks;
        Throwable ex = null;
        for (i = last = ts.size() - 1; i >= 0; --i) {
            t = (ForkJoinTask)ts.get(i);
            if (t == null) {
                ex = new NullPointerException();
                break;
            }
            if (i == 0) {
                s = t.doExec();
                if (s >= 0) {
                    s = t.awaitDone(null, true, false, false, 0L);
                }
                if ((s & 0x10000) == 0) break;
                ex = t.getException(s);
                break;
            }
            t.fork();
        }
        if (ex == null) {
            for (i = 1; i <= last; ++i) {
                t = (ForkJoinTask)ts.get(i);
                if (t == null) continue;
                s = t.status;
                if (s >= 0) {
                    s = t.awaitDone(null, false, false, false, 0L);
                }
                if ((s & 0x10000) != 0 && (ex = t.getException(s)) != null) break;
            }
        }
        if (ex != null) {
            for (i = 1; i <= last; ++i) {
                ForkJoinTask.cancelIgnoringExceptions((Future)ts.get(i));
            }
            ForkJoinTask.rethrow(ex);
        }
        return tasks;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return (this.trySetCancelled() & 0x30000) == 65536;
    }

    @Override
    public final boolean isDone() {
        return this.status < 0;
    }

    @Override
    public final boolean isCancelled() {
        return (this.status & 0x30000) == 65536;
    }

    public final boolean isCompletedAbnormally() {
        return (this.status & 0x10000) != 0;
    }

    public final boolean isCompletedNormally() {
        return (this.status & 0x80010000) == Integer.MIN_VALUE;
    }

    public final Throwable getException() {
        return this.getException(this.status);
    }

    public void completeExceptionally(Throwable ex) {
        this.trySetException(ex instanceof RuntimeException || ex instanceof Error ? ex : new RuntimeException(ex));
    }

    public void complete(V value) {
        try {
            this.setRawResult(value);
        }
        catch (Throwable rex) {
            this.trySetException(rex);
            return;
        }
        this.setDone();
    }

    public final void quietlyComplete() {
        this.setDone();
    }

    @Override
    public final V get() throws InterruptedException, ExecutionException {
        int s = this.awaitDone(null, false, true, false, 0L);
        if ((s & 0x10000) != 0) {
            this.reportExecutionException(s);
        }
        return this.getRawResult();
    }

    @Override
    public final V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long nanos = unit.toNanos(timeout);
        int s = this.awaitDone(null, false, true, true, nanos);
        if (s >= 0 || (s & 0x10000) != 0) {
            this.reportExecutionException(s);
        }
        return this.getRawResult();
    }

    public final void quietlyJoin() {
        if (this.status >= 0) {
            this.awaitDone(null, false, false, false, 0L);
        }
    }

    public final void quietlyInvoke() {
        if (this.doExec() >= 0) {
            this.awaitDone(null, true, false, false, 0L);
        }
    }

    final void awaitPoolInvoke(ForkJoinPool pool) {
        this.awaitDone(pool, false, false, false, 0L);
    }

    final void awaitPoolInvoke(ForkJoinPool pool, long nanos) {
        this.awaitDone(pool, false, true, true, nanos);
    }

    final V joinForPoolInvoke(ForkJoinPool pool) {
        int s = this.awaitDone(pool, false, false, false, 0L);
        if ((s & 0x10000) != 0) {
            this.reportException(s);
        }
        return this.getRawResult();
    }

    final V getForPoolInvoke(ForkJoinPool pool) throws InterruptedException, ExecutionException {
        int s = this.awaitDone(pool, false, true, false, 0L);
        if ((s & 0x10000) != 0) {
            this.reportExecutionException(s);
        }
        return this.getRawResult();
    }

    final V getForPoolInvoke(ForkJoinPool pool, long nanos) throws InterruptedException, ExecutionException, TimeoutException {
        int s = this.awaitDone(pool, false, true, true, nanos);
        if (s >= 0 || (s & 0x10000) != 0) {
            this.reportExecutionException(s);
        }
        return this.getRawResult();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void helpQuiesce() {
        Thread t = Thread.currentThread();
        if (t instanceof ForkJoinWorkerThread) {
            ForkJoinWorkerThread w = (ForkJoinWorkerThread)t;
            ForkJoinPool p = w.pool;
            if (p != null) {
                p.helpQuiescePool(w.workQueue, Long.MAX_VALUE, false);
                return;
            }
        }
        ForkJoinPool.common.externalHelpQuiescePool(Long.MAX_VALUE, false);
    }

    public void reinitialize() {
        this.aux = null;
        this.status = 0;
    }

    public static ForkJoinPool getPool() {
        Thread t = Thread.currentThread();
        return t instanceof ForkJoinWorkerThread ? ((ForkJoinWorkerThread)t).pool : null;
    }

    public static boolean inForkJoinPool() {
        return Thread.currentThread() instanceof ForkJoinWorkerThread;
    }

    public boolean tryUnfork() {
        ForkJoinPool.WorkQueue q;
        Thread t = Thread.currentThread();
        boolean bl = t instanceof ForkJoinWorkerThread ? (q = ((ForkJoinWorkerThread)t).workQueue) != null && q.tryUnpush(this) : (q = ForkJoinPool.commonQueue()) != null && q.externalTryUnpush(this);
        return bl;
    }

    public static int getQueuedTaskCount() {
        Thread t = Thread.currentThread();
        ForkJoinPool.WorkQueue q = t instanceof ForkJoinWorkerThread ? ((ForkJoinWorkerThread)t).workQueue : ForkJoinPool.commonQueue();
        return q == null ? 0 : q.queueSize();
    }

    public static int getSurplusQueuedTaskCount() {
        return ForkJoinPool.getSurplusQueuedTaskCount();
    }

    public abstract V getRawResult();

    protected abstract void setRawResult(V var1);

    protected abstract boolean exec();

    protected static ForkJoinTask<?> peekNextLocalTask() {
        Thread t = Thread.currentThread();
        ForkJoinPool.WorkQueue q = t instanceof ForkJoinWorkerThread ? ((ForkJoinWorkerThread)t).workQueue : ForkJoinPool.commonQueue();
        return q == null ? null : q.peek();
    }

    protected static ForkJoinTask<?> pollNextLocalTask() {
        Thread t = Thread.currentThread();
        return t instanceof ForkJoinWorkerThread ? ((ForkJoinWorkerThread)t).workQueue.nextLocalTask() : null;
    }

    protected static ForkJoinTask<?> pollTask() {
        ForkJoinTask<?> forkJoinTask;
        Thread t = Thread.currentThread();
        if (t instanceof ForkJoinWorkerThread) {
            ForkJoinWorkerThread w = (ForkJoinWorkerThread)t;
            forkJoinTask = w.pool.nextTaskFor(w.workQueue);
        } else {
            forkJoinTask = null;
        }
        return forkJoinTask;
    }

    protected static ForkJoinTask<?> pollSubmission() {
        Thread t = Thread.currentThread();
        return t instanceof ForkJoinWorkerThread ? ((ForkJoinWorkerThread)t).pool.pollSubmission() : null;
    }

    public final short getForkJoinTaskTag() {
        return (short)this.status;
    }

    public final short setForkJoinTaskTag(short newValue) {
        int s;
        while (!this.casStatus(s = this.status, s & 0xFFFF0000 | newValue & 0xFFFF)) {
        }
        return (short)s;
    }

    public final boolean compareAndSetForkJoinTaskTag(short expect, short update) {
        int s;
        do {
            if ((short)(s = this.status) == expect) continue;
            return false;
        } while (!this.casStatus(s, s & 0xFFFF0000 | update & 0xFFFF));
        return true;
    }

    public static ForkJoinTask<?> adapt(Runnable runnable) {
        return new AdaptedRunnableAction(runnable);
    }

    public static <T> ForkJoinTask<T> adapt(Runnable runnable, T result) {
        return new AdaptedRunnable<T>(runnable, result);
    }

    public static <T> ForkJoinTask<T> adapt(Callable<? extends T> callable) {
        return new AdaptedCallable<T>(callable);
    }

    private static <T> ForkJoinTask<T> adaptInterruptible(Callable<? extends T> callable) {
        return new AdaptedInterruptibleCallable<T>(callable);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Aux a = this.aux;
        s.writeObject(a == null ? null : a.ex);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        Object ex = s.readObject();
        if (ex != null) {
            this.trySetThrown((Throwable)ex);
        }
    }

    static {
        try {
            MethodHandles.Lookup l = MethodHandles.lookup();
            STATUS = l.findVarHandle(ForkJoinTask.class, "status", Integer.TYPE);
            AUX = l.findVarHandle(ForkJoinTask.class, "aux", Aux.class);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    static final class Aux {
        final Thread thread;
        final Throwable ex;
        Aux next;
        private static final VarHandle NEXT;

        Aux(Thread thread, Throwable ex) {
            this.thread = thread;
            this.ex = ex;
        }

        final boolean casNext(Aux c, Aux v) {
            return NEXT.compareAndSet(this, c, v);
        }

        static {
            try {
                NEXT = MethodHandles.lookup().findVarHandle(Aux.class, "next", Aux.class);
            }
            catch (ReflectiveOperationException e) {
                throw new ExceptionInInitializerError(e);
            }
        }
    }

    static final class AdaptedRunnableAction
    extends ForkJoinTask<Void>
    implements RunnableFuture<Void> {
        final Runnable runnable;
        private static final long serialVersionUID = 5232453952276885070L;

        AdaptedRunnableAction(Runnable runnable) {
            if (runnable == null) {
                throw new NullPointerException();
            }
            this.runnable = runnable;
        }

        @Override
        public final Void getRawResult() {
            return null;
        }

        @Override
        public final void setRawResult(Void v) {
        }

        @Override
        public final boolean exec() {
            this.runnable.run();
            return true;
        }

        @Override
        public final void run() {
            this.invoke();
        }

        public String toString() {
            return super.toString() + "[Wrapped task = " + this.runnable + "]";
        }
    }

    static final class AdaptedRunnable<T>
    extends ForkJoinTask<T>
    implements RunnableFuture<T> {
        final Runnable runnable;
        T result;
        private static final long serialVersionUID = 5232453952276885070L;

        AdaptedRunnable(Runnable runnable, T result) {
            if (runnable == null) {
                throw new NullPointerException();
            }
            this.runnable = runnable;
            this.result = result;
        }

        @Override
        public final T getRawResult() {
            return this.result;
        }

        @Override
        public final void setRawResult(T v) {
            this.result = v;
        }

        @Override
        public final boolean exec() {
            this.runnable.run();
            return true;
        }

        @Override
        public final void run() {
            this.invoke();
        }

        public String toString() {
            return super.toString() + "[Wrapped task = " + this.runnable + "]";
        }
    }

    static final class AdaptedCallable<T>
    extends ForkJoinTask<T>
    implements RunnableFuture<T> {
        final Callable<? extends T> callable;
        T result;
        private static final long serialVersionUID = 2838392045355241008L;

        AdaptedCallable(Callable<? extends T> callable) {
            if (callable == null) {
                throw new NullPointerException();
            }
            this.callable = callable;
        }

        @Override
        public final T getRawResult() {
            return this.result;
        }

        @Override
        public final void setRawResult(T v) {
            this.result = v;
        }

        @Override
        public final boolean exec() {
            try {
                this.result = this.callable.call();
                return true;
            }
            catch (RuntimeException rex) {
                throw rex;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public final void run() {
            this.invoke();
        }

        public String toString() {
            return super.toString() + "[Wrapped task = " + this.callable + "]";
        }
    }

    static final class AdaptedInterruptibleCallable<T>
    extends ForkJoinTask<T>
    implements RunnableFuture<T> {
        final Callable<? extends T> callable;
        volatile transient Thread runner;
        T result;
        private static final long serialVersionUID = 2838392045355241008L;

        AdaptedInterruptibleCallable(Callable<? extends T> callable) {
            if (callable == null) {
                throw new NullPointerException();
            }
            this.callable = callable;
        }

        @Override
        public final T getRawResult() {
            return this.result;
        }

        @Override
        public final void setRawResult(T v) {
            this.result = v;
        }

        @Override
        public final boolean exec() {
            Thread.interrupted();
            this.runner = Thread.currentThread();
            try {
                if (!this.isDone()) {
                    this.result = this.callable.call();
                }
                boolean bl = true;
                return bl;
            }
            catch (RuntimeException rex) {
                throw rex;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            finally {
                this.runner = null;
                Thread.interrupted();
            }
        }

        @Override
        public final void run() {
            this.invoke();
        }

        @Override
        public final boolean cancel(boolean mayInterruptIfRunning) {
            Thread t;
            boolean stat = super.cancel(false);
            if (mayInterruptIfRunning && (t = this.runner) != null) {
                try {
                    t.interrupt();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return stat;
        }

        public String toString() {
            return super.toString() + "[Wrapped task = " + this.callable + "]";
        }
    }

    static final class RunnableExecuteAction
    extends ForkJoinTask<Void> {
        final Runnable runnable;
        private static final long serialVersionUID = 5232453952276885070L;

        RunnableExecuteAction(Runnable runnable) {
            if (runnable == null) {
                throw new NullPointerException();
            }
            this.runnable = runnable;
        }

        @Override
        public final Void getRawResult() {
            return null;
        }

        @Override
        public final void setRawResult(Void v) {
        }

        @Override
        public final boolean exec() {
            this.runnable.run();
            return true;
        }

        @Override
        int trySetException(Throwable ex) {
            Thread t;
            Thread.UncaughtExceptionHandler h;
            int s = this.trySetThrown(ex);
            if (RunnableExecuteAction.isExceptionalStatus(s) && (h = (t = Thread.currentThread()).getUncaughtExceptionHandler()) != null) {
                try {
                    h.uncaughtException(t, ex);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return s;
        }
    }
}

