/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ForkJoinPool;

public class ForkJoinWorkerThread
extends Thread {
    final ForkJoinPool pool;
    final ForkJoinPool.WorkQueue workQueue;

    ForkJoinWorkerThread(ThreadGroup group, ForkJoinPool pool, boolean useSystemClassLoader, boolean isInnocuous) {
        super(group, null, pool.nextWorkerThreadName(), 0L);
        this.pool = pool;
        Thread.UncaughtExceptionHandler handler = this.pool.ueh;
        this.workQueue = new ForkJoinPool.WorkQueue(this, isInnocuous);
        super.setDaemon(true);
        if (handler != null) {
            super.setUncaughtExceptionHandler(handler);
        }
        if (useSystemClassLoader) {
            super.setContextClassLoader(ClassLoader.getSystemClassLoader());
        }
    }

    ForkJoinWorkerThread(ThreadGroup group, ForkJoinPool pool) {
        this(group, pool, false, false);
    }

    protected ForkJoinWorkerThread(ForkJoinPool pool) {
        this(null, pool, false, false);
    }

    public ForkJoinPool getPool() {
        return this.pool;
    }

    public int getPoolIndex() {
        return this.workQueue.getPoolIndex();
    }

    protected void onStart() {
    }

    protected void onTermination(Throwable exception) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Throwable exception = null;
        ForkJoinPool p = this.pool;
        ForkJoinPool.WorkQueue w = this.workQueue;
        if (p != null && w != null) {
            try {
                p.registerWorker(w);
                this.onStart();
                p.runWorker(w);
            }
            catch (Throwable ex) {
                exception = ex;
            }
            finally {
                try {
                    this.onTermination(exception);
                }
                catch (Throwable ex) {
                    if (exception == null) {
                        exception = ex;
                    }
                }
                finally {
                    p.deregisterWorker(this, exception);
                }
            }
        }
    }

    static final class InnocuousForkJoinWorkerThread
    extends ForkJoinWorkerThread {
        private static final ThreadGroup innocuousThreadGroup = AccessController.doPrivileged(new PrivilegedAction<ThreadGroup>(){

            @Override
            public ThreadGroup run() {
                ThreadGroup p;
                ThreadGroup group = Thread.currentThread().getThreadGroup();
                while ((p = group.getParent()) != null) {
                    group = p;
                }
                return new ThreadGroup(group, "InnocuousForkJoinWorkerThreadGroup");
            }
        });

        InnocuousForkJoinWorkerThread(ForkJoinPool pool) {
            super(innocuousThreadGroup, pool, true, true);
        }

        @Override
        public void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler x) {
        }

        @Override
        public void setContextClassLoader(ClassLoader cl) {
            if (cl != null && ClassLoader.getSystemClassLoader() != cl) {
                throw new SecurityException("setContextClassLoader");
            }
        }
    }
}

