/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.Helpers;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class LinkedBlockingDeque<E>
extends AbstractQueue<E>
implements BlockingDeque<E>,
Serializable {
    private static final long serialVersionUID = -387911632671998426L;
    transient Node<E> first;
    transient Node<E> last;
    private transient int count;
    private final int capacity;
    final ReentrantLock lock = new ReentrantLock();
    private final Condition notEmpty = this.lock.newCondition();
    private final Condition notFull = this.lock.newCondition();

    public LinkedBlockingDeque() {
        this(Integer.MAX_VALUE);
    }

    public LinkedBlockingDeque(int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.capacity = capacity;
    }

    public LinkedBlockingDeque(Collection<? extends E> c) {
        this(Integer.MAX_VALUE);
        this.addAll(c);
    }

    private boolean linkFirst(Node<E> node) {
        if (this.count >= this.capacity) {
            return false;
        }
        Node<E> f = this.first;
        node.next = f;
        this.first = node;
        if (this.last == null) {
            this.last = node;
        } else {
            f.prev = node;
        }
        ++this.count;
        this.notEmpty.signal();
        return true;
    }

    private boolean linkLast(Node<E> node) {
        if (this.count >= this.capacity) {
            return false;
        }
        Node<E> l = this.last;
        node.prev = l;
        this.last = node;
        if (this.first == null) {
            this.first = node;
        } else {
            l.next = node;
        }
        ++this.count;
        this.notEmpty.signal();
        return true;
    }

    private E unlinkFirst() {
        Node<E> f = this.first;
        if (f == null) {
            return null;
        }
        Node n = f.next;
        Object item = f.item;
        f.item = null;
        f.next = f;
        this.first = n;
        if (n == null) {
            this.last = null;
        } else {
            n.prev = null;
        }
        --this.count;
        this.notFull.signal();
        return item;
    }

    private E unlinkLast() {
        Node<E> l = this.last;
        if (l == null) {
            return null;
        }
        Node p = l.prev;
        Object item = l.item;
        l.item = null;
        l.prev = l;
        this.last = p;
        if (p == null) {
            this.first = null;
        } else {
            p.next = null;
        }
        --this.count;
        this.notFull.signal();
        return item;
    }

    void unlink(Node<E> x) {
        Node p = x.prev;
        Node n = x.next;
        if (p == null) {
            this.unlinkFirst();
        } else if (n == null) {
            this.unlinkLast();
        } else {
            p.next = n;
            n.prev = p;
            x.item = null;
            --this.count;
            this.notFull.signal();
        }
    }

    @Override
    public void addFirst(E e) {
        if (!this.offerFirst(e)) {
            throw new IllegalStateException("Deque full");
        }
    }

    @Override
    public void addLast(E e) {
        if (!this.offerLast(e)) {
            throw new IllegalStateException("Deque full");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offerFirst(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        Node<E> node = new Node<E>(e);
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            boolean bl = this.linkFirst(node);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offerLast(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        Node<E> node = new Node<E>(e);
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            boolean bl = this.linkLast(node);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putFirst(E e) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        Node<E> node = new Node<E>(e);
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            while (!this.linkFirst(node)) {
                this.notFull.await();
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putLast(E e) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        Node<E> node = new Node<E>(e);
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            while (!this.linkLast(node)) {
                this.notFull.await();
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offerFirst(E e, long timeout, TimeUnit unit) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        Node<E> node = new Node<E>(e);
        long nanos = unit.toNanos(timeout);
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while (!this.linkFirst(node)) {
                if (nanos <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                nanos = this.notFull.awaitNanos(nanos);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offerLast(E e, long timeout, TimeUnit unit) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        Node<E> node = new Node<E>(e);
        long nanos = unit.toNanos(timeout);
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while (!this.linkLast(node)) {
                if (nanos <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                nanos = this.notFull.awaitNanos(nanos);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public E removeFirst() {
        E x = this.pollFirst();
        if (x == null) {
            throw new NoSuchElementException();
        }
        return x;
    }

    @Override
    public E removeLast() {
        E x = this.pollLast();
        if (x == null) {
            throw new NoSuchElementException();
        }
        return x;
    }

    @Override
    public E pollFirst() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            E e = this.unlinkFirst();
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public E pollLast() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            E e = this.unlinkLast();
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E takeFirst() throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            E x;
            while ((x = this.unlinkFirst()) == null) {
                this.notEmpty.await();
            }
            E e = x;
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E takeLast() throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            E x;
            while ((x = this.unlinkLast()) == null) {
                this.notEmpty.await();
            }
            E e = x;
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E pollFirst(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            E x;
            while ((x = this.unlinkFirst()) == null) {
                if (nanos <= 0L) {
                    E e = null;
                    return e;
                }
                nanos = this.notEmpty.awaitNanos(nanos);
            }
            E e = x;
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E pollLast(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            E x;
            while ((x = this.unlinkLast()) == null) {
                if (nanos <= 0L) {
                    E e = null;
                    return e;
                }
                nanos = this.notEmpty.awaitNanos(nanos);
            }
            E e = x;
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public E getFirst() {
        E x = this.peekFirst();
        if (x == null) {
            throw new NoSuchElementException();
        }
        return x;
    }

    @Override
    public E getLast() {
        E x = this.peekLast();
        if (x == null) {
            throw new NoSuchElementException();
        }
        return x;
    }

    @Override
    public E peekFirst() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            E e = this.first == null ? null : (E)this.first.item;
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public E peekLast() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            E e = this.last == null ? null : (E)this.last.item;
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeFirstOccurrence(Object o) {
        if (o == null) {
            return false;
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Node<E> p = this.first;
            while (p != null) {
                if (o.equals(p.item)) {
                    this.unlink(p);
                    boolean bl = true;
                    return bl;
                }
                p = p.next;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeLastOccurrence(Object o) {
        if (o == null) {
            return false;
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Node<E> p = this.last;
            while (p != null) {
                if (o.equals(p.item)) {
                    this.unlink(p);
                    boolean bl = true;
                    return bl;
                }
                p = p.prev;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean add(E e) {
        this.addLast(e);
        return true;
    }

    @Override
    public boolean offer(E e) {
        return this.offerLast(e);
    }

    @Override
    public void put(E e) throws InterruptedException {
        this.putLast(e);
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        return this.offerLast(e, timeout, unit);
    }

    @Override
    public E remove() {
        return this.removeFirst();
    }

    @Override
    public E poll() {
        return this.pollFirst();
    }

    @Override
    public E take() throws InterruptedException {
        return this.takeFirst();
    }

    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.pollFirst(timeout, unit);
    }

    @Override
    public E element() {
        return this.getFirst();
    }

    @Override
    public E peek() {
        return this.peekFirst();
    }

    @Override
    public int remainingCapacity() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.capacity - this.count;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        return this.drainTo(c, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        Objects.requireNonNull(c);
        if (c == this) {
            throw new IllegalArgumentException();
        }
        if (maxElements <= 0) {
            return 0;
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = Math.min(maxElements, this.count);
            for (int i = 0; i < n; ++i) {
                c.add(this.first.item);
                this.unlinkFirst();
            }
            int n2 = n;
            return n2;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void push(E e) {
        this.addFirst(e);
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    @Override
    public boolean remove(Object o) {
        return this.removeFirstOccurrence(o);
    }

    @Override
    public int size() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.count;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Node<E> p = this.first;
            while (p != null) {
                if (o.equals(p.item)) {
                    boolean bl = true;
                    return bl;
                }
                p = p.next;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (c == this) {
            throw new IllegalArgumentException();
        }
        Node<E> beg = null;
        Node<E> end = null;
        int n = 0;
        for (E e : c) {
            Objects.requireNonNull(e);
            ++n;
            Node<E> newNode = new Node<E>(e);
            if (beg == null) {
                beg = end = newNode;
                continue;
            }
            end.next = newNode;
            newNode.prev = end;
            end = newNode;
        }
        if (beg == null) {
            return false;
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (this.count + n <= this.capacity) {
                beg.prev = this.last;
                if (this.first == null) {
                    this.first = beg;
                } else {
                    this.last.next = beg;
                }
                this.last = end;
                this.count += n;
                this.notEmpty.signalAll();
                boolean bl = true;
                return bl;
            }
        }
        finally {
            lock.unlock();
        }
        return super.addAll(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] a = new Object[this.count];
            int k = 0;
            Node<E> p = this.first;
            while (p != null) {
                a[k++] = p.item;
                p = p.next;
            }
            Object[] objectArray = a;
            return objectArray;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (a.length < this.count) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.count);
            }
            int k = 0;
            Node<E> p = this.first;
            while (p != null) {
                a[k++] = p.item;
                p = p.next;
            }
            if (a.length > k) {
                a[k] = null;
            }
            Object[] objectArray = a;
            return objectArray;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public String toString() {
        return Helpers.collectionToString(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Node<E> f = this.first;
            while (f != null) {
                f.item = null;
                Node n = f.next;
                f.prev = null;
                f.next = null;
                f = n;
            }
            this.last = null;
            this.first = null;
            this.count = 0;
            this.notFull.signalAll();
        }
        finally {
            lock.unlock();
        }
    }

    Node<E> succ(Node<E> p) {
        if (p == (p = p.next)) {
            p = this.first;
        }
        return p;
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public Iterator<E> descendingIterator() {
        return new DescendingItr();
    }

    @Override
    public Spliterator<E> spliterator() {
        return new LBDSpliterator();
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        Objects.requireNonNull(action);
        this.forEachFrom(action, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forEachFrom(Consumer<? super E> action, Node<E> p) {
        int n;
        ReentrantLock lock = this.lock;
        int batchSize = 64;
        Object[] es = null;
        int len = 0;
        do {
            lock.lock();
            try {
                if (es == null) {
                    if (p == null) {
                        p = this.first;
                    }
                    Node<E> q = p;
                    while (q != null && (q.item == null || ++len != 64)) {
                        q = this.succ(q);
                    }
                    es = new Object[len];
                }
                n = 0;
                while (p != null && n < len) {
                    es[n] = p.item;
                    if (es[n] != null) {
                        ++n;
                    }
                    p = this.succ(p);
                }
            }
            finally {
                lock.unlock();
            }
            for (int i = 0; i < n; ++i) {
                Object e = es[i];
                action.accept(e);
            }
        } while (n > 0 && p != null);
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        Objects.requireNonNull(filter);
        return this.bulkRemove(filter);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        Objects.requireNonNull(c);
        return this.bulkRemove(e -> c.contains(e));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Objects.requireNonNull(c);
        return this.bulkRemove(e -> !c.contains(e));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean bulkRemove(Predicate<? super E> filter) {
        int n;
        boolean removed = false;
        ReentrantLock lock = this.lock;
        Node<E> p = null;
        Node[] nodes = null;
        int len = 0;
        do {
            int i;
            lock.lock();
            try {
                if (nodes == null) {
                    Node<E> q = p = this.first;
                    while (q != null && (q.item == null || ++len != 64)) {
                        q = this.succ(q);
                    }
                    nodes = new Node[len];
                }
                n = 0;
                while (p != null && n < len) {
                    nodes[n++] = p;
                    p = this.succ(p);
                }
            }
            finally {
                lock.unlock();
            }
            long deathRow = 0L;
            for (i = 0; i < n; ++i) {
                Object e = nodes[i].item;
                if (e == null || !filter.test(e)) continue;
                deathRow |= 1L << i;
            }
            if (deathRow == 0L) continue;
            lock.lock();
            try {
                for (i = 0; i < n; ++i) {
                    if ((deathRow & 1L << i) != 0L) {
                        Node q = nodes[i];
                        if (q.item != null) {
                            this.unlink(q);
                            removed = true;
                        }
                    }
                    nodes[i] = null;
                }
            }
            finally {
                lock.unlock();
            }
        } while (n > 0 && p != null);
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream s) throws IOException {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            s.defaultWriteObject();
            Node<E> p = this.first;
            while (p != null) {
                s.writeObject(p.item);
                p = p.next;
            }
            s.writeObject(null);
        }
        finally {
            lock.unlock();
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        Object item;
        s.defaultReadObject();
        this.count = 0;
        this.first = null;
        this.last = null;
        while ((item = s.readObject()) != null) {
            this.add(item);
        }
    }

    void checkInvariants() {
        Node<E> p = this.first;
        while (p != null) {
            p = p.next;
        }
    }

    static final class Node<E> {
        E item;
        Node<E> prev;
        Node<E> next;

        Node(E x) {
            this.item = x;
        }
    }

    private class Itr
    extends AbstractItr {
        Itr() {
        }

        @Override
        Node<E> firstNode() {
            return LinkedBlockingDeque.this.first;
        }

        @Override
        Node<E> nextNode(Node<E> n) {
            return n.next;
        }
    }

    private class DescendingItr
    extends AbstractItr {
        DescendingItr() {
        }

        @Override
        Node<E> firstNode() {
            return LinkedBlockingDeque.this.last;
        }

        @Override
        Node<E> nextNode(Node<E> n) {
            return n.prev;
        }
    }

    private final class LBDSpliterator
    implements Spliterator<E> {
        static final int MAX_BATCH = 0x2000000;
        Node<E> current;
        int batch;
        boolean exhausted;
        long est;

        LBDSpliterator() {
            this.est = LinkedBlockingDeque.this.size();
        }

        @Override
        public long estimateSize() {
            return this.est;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Spliterator<E> trySplit() {
            Node h;
            if (!(this.exhausted || (h = this.current) == null && (h = LinkedBlockingDeque.this.first) == null || h.next == null)) {
                int n = this.batch = Math.min(this.batch + 1, 0x2000000);
                Object[] a = new Object[n];
                ReentrantLock lock = LinkedBlockingDeque.this.lock;
                int i = 0;
                Node p = this.current;
                lock.lock();
                try {
                    if (p != null || (p = LinkedBlockingDeque.this.first) != null) {
                        while (p != null && i < n) {
                            a[i] = p.item;
                            if (a[i] != null) {
                                ++i;
                            }
                            p = LinkedBlockingDeque.this.succ(p);
                        }
                    }
                }
                finally {
                    lock.unlock();
                }
                this.current = p;
                if (this.current == null) {
                    this.est = 0L;
                    this.exhausted = true;
                } else if ((this.est -= (long)i) < 0L) {
                    this.est = 0L;
                }
                if (i > 0) {
                    return Spliterators.spliterator(a, 0, i, 4368);
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean tryAdvance(Consumer<? super E> action) {
            Objects.requireNonNull(action);
            if (!this.exhausted) {
                Object e = null;
                ReentrantLock lock = LinkedBlockingDeque.this.lock;
                lock.lock();
                try {
                    Node p = this.current;
                    if (p != null || (p = LinkedBlockingDeque.this.first) != null) {
                        do {
                            e = p.item;
                            p = LinkedBlockingDeque.this.succ(p);
                        } while (e == null && p != null);
                    }
                    if ((this.current = p) == null) {
                        this.exhausted = true;
                    }
                }
                finally {
                    lock.unlock();
                }
                if (e != null) {
                    action.accept(e);
                    return true;
                }
            }
            return false;
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            Objects.requireNonNull(action);
            if (!this.exhausted) {
                this.exhausted = true;
                Node p = this.current;
                this.current = null;
                LinkedBlockingDeque.this.forEachFrom(action, p);
            }
        }

        @Override
        public int characteristics() {
            return 4368;
        }
    }

    private abstract class AbstractItr
    implements Iterator<E> {
        Node<E> next;
        E nextItem;
        private Node<E> lastRet;

        abstract Node<E> firstNode();

        abstract Node<E> nextNode(Node<E> var1);

        private Node<E> succ(Node<E> p) {
            if (p == (p = this.nextNode(p))) {
                p = this.firstNode();
            }
            return p;
        }

        AbstractItr() {
            ReentrantLock lock = LinkedBlockingDeque.this.lock;
            lock.lock();
            try {
                this.next = this.firstNode();
                if (this.next != null) {
                    this.nextItem = this.next.item;
                }
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E next() {
            Node p = this.next;
            if (p == null) {
                throw new NoSuchElementException();
            }
            this.lastRet = p;
            Object x = this.nextItem;
            ReentrantLock lock = LinkedBlockingDeque.this.lock;
            lock.lock();
            try {
                Object e = null;
                p = this.nextNode(p);
                while (p != null) {
                    Object e2 = p.item;
                    e = e2;
                    if (e2 != null) break;
                    p = this.succ(p);
                }
                this.next = p;
                this.nextItem = e;
            }
            finally {
                lock.unlock();
            }
            return x;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            int n;
            Objects.requireNonNull(action);
            Node p = this.next;
            if (p == null) {
                return;
            }
            this.lastRet = p;
            this.next = null;
            ReentrantLock lock = LinkedBlockingDeque.this.lock;
            int batchSize = 64;
            Object[] es = null;
            int len = 1;
            do {
                lock.lock();
                try {
                    if (es == null) {
                        Node q = p = this.nextNode(p);
                        while (q != null && (q.item == null || ++len != 64)) {
                            q = this.succ(q);
                        }
                        es = new Object[len];
                        es[0] = this.nextItem;
                        this.nextItem = null;
                        n = 1;
                    } else {
                        n = 0;
                    }
                    while (p != null && n < len) {
                        es[n] = p.item;
                        if (es[n] != null) {
                            this.lastRet = p;
                            ++n;
                        }
                        p = this.succ(p);
                    }
                }
                finally {
                    lock.unlock();
                }
                for (int i = 0; i < n; ++i) {
                    Object e = es[i];
                    action.accept(e);
                }
            } while (n > 0 && p != null);
        }

        @Override
        public void remove() {
            Node n = this.lastRet;
            if (n == null) {
                throw new IllegalStateException();
            }
            this.lastRet = null;
            ReentrantLock lock = LinkedBlockingDeque.this.lock;
            lock.lock();
            try {
                if (n.item != null) {
                    LinkedBlockingDeque.this.unlink(n);
                }
            }
            finally {
                lock.unlock();
            }
        }
    }
}

