/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.AbstractQueue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Helpers;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TransferQueue;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class LinkedTransferQueue<E>
extends AbstractQueue<E>
implements TransferQueue<E>,
Serializable {
    private static final long serialVersionUID = -3223113410248163686L;
    static final long SPIN_FOR_TIMEOUT_THRESHOLD = 1023L;
    static final int SWEEP_THRESHOLD = 32;
    volatile transient Node head;
    private volatile transient Node tail;
    private volatile transient boolean needSweep;
    private static final int NOW = 0;
    private static final int ASYNC = 1;
    private static final int SYNC = 2;
    private static final int TIMED = 3;
    private static final int MAX_HOPS = 8;
    private static final VarHandle HEAD;
    private static final VarHandle TAIL;
    static final VarHandle ITEM;
    static final VarHandle NEXT;
    static final VarHandle WAITER;

    private boolean casTail(Node cmp, Node val) {
        return TAIL.compareAndSet(this, cmp, val);
    }

    private boolean casHead(Node cmp, Node val) {
        return HEAD.compareAndSet(this, cmp, val);
    }

    private boolean tryCasSuccessor(Node pred, Node c, Node p) {
        if (pred != null) {
            return pred.casNext(c, p);
        }
        if (this.casHead(c, p)) {
            c.selfLink();
            return true;
        }
        return false;
    }

    private Node skipDeadNodes(Node pred, Node c, Node p, Node q) {
        if (q == null) {
            if (c == p) {
                return pred;
            }
            q = p;
        }
        return this.tryCasSuccessor(pred, c, q) && (pred == null || !pred.isMatched()) ? pred : p;
    }

    private void skipDeadNodesNearHead(Node h, Node p) {
        Node q;
        while ((q = p.next) != null) {
            if (!q.isMatched()) {
                p = q;
                break;
            }
            if (p != (p = q)) continue;
            return;
        }
        if (this.casHead(h, p)) {
            h.selfLink();
        }
    }

    private E xfer(E e, boolean haveData, int how, long nanos) {
        if (haveData && e == null) {
            throw new NullPointerException();
        }
        Node s = null;
        Node t = null;
        Node h = null;
        while (true) {
            Node p;
            Node node = p = t != (t = this.tail) && t.isData == haveData ? t : this.head;
            while (true) {
                Node q;
                Object item;
                if (p.isData != haveData && haveData == ((item = p.item) == null)) {
                    if (h == null) {
                        h = this.head;
                    }
                    if (p.tryMatch(item, e)) {
                        if (h != p) {
                            this.skipDeadNodesNearHead(h, p);
                        }
                        return (E)item;
                    }
                }
                if ((q = p.next) == null) {
                    if (how == 0) {
                        return e;
                    }
                    if (s == null) {
                        s = new Node(e);
                    }
                    if (!p.casNext(null, s)) continue;
                    if (p != t) {
                        this.casTail(t, s);
                    }
                    if (how == 1) {
                        return e;
                    }
                    return this.awaitMatch(s, p, e, how == 3, nanos);
                }
                if (p == (p = q)) break;
            }
        }
    }

    private E awaitMatch(Node s, Node pred, E e, boolean timed, long nanos) {
        Object item;
        boolean isData = s.isData;
        long deadline = timed ? System.nanoTime() + nanos : 0L;
        Thread w = Thread.currentThread();
        int stat = -1;
        while ((item = s.item) == e) {
            if (this.needSweep) {
                this.sweep();
                continue;
            }
            if (timed && nanos <= 0L || w.isInterrupted()) {
                if (!s.casItem(e, e == null ? s : null)) continue;
                this.unsplice(pred, s);
                return e;
            }
            if (stat <= 0) {
                if (pred == null || pred.next != s) continue;
                if (stat < 0 && (pred.isData != isData || pred.isMatched())) {
                    stat = 0;
                    Thread.yield();
                    continue;
                }
                stat = 1;
                s.waiter = w;
                continue;
            }
            item = s.item;
            if (item != e) break;
            if (!timed) {
                LockSupport.setCurrentBlocker(this);
                try {
                    ForkJoinPool.managedBlock(s);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                LockSupport.setCurrentBlocker(null);
                continue;
            }
            nanos = deadline - System.nanoTime();
            if (nanos <= 1023L) continue;
            LockSupport.parkNanos(this, nanos);
        }
        if (stat == 1) {
            WAITER.set(s, null);
        }
        if (!isData) {
            ITEM.set(s, s);
        }
        return (E)item;
    }

    final Node firstDataNode() {
        Node p;
        Node h;
        Node first = null;
        block0: while (true) {
            p = h = this.head;
            while (p != null) {
                Node q;
                if (p.item != null) {
                    if (p.isData) {
                        first = p;
                        break block0;
                    }
                } else if (!p.isData) break block0;
                if ((q = p.next) == null) break block0;
                if (p != (p = q)) continue;
                continue block0;
            }
            break;
        }
        if (p != h && this.casHead(h, p)) {
            h.selfLink();
        }
        return first;
    }

    private int countOfMode(boolean data) {
        int count;
        block0: while (true) {
            count = 0;
            Node p = this.head;
            while (p != null) {
                if (!p.isMatched()) {
                    if (p.isData != data) {
                        return 0;
                    }
                    if (++count == Integer.MAX_VALUE) break block0;
                }
                if (p != (p = p.next)) continue;
                continue block0;
            }
            break;
        }
        return count;
    }

    @Override
    public String toString() {
        int size;
        int charLength;
        String[] a = null;
        block0: while (true) {
            charLength = 0;
            size = 0;
            Node p = this.head;
            while (p != null) {
                Object item = p.item;
                if (p.isData) {
                    if (item != null) {
                        if (a == null) {
                            a = new String[4];
                        } else if (size == a.length) {
                            a = Arrays.copyOf(a, 2 * size);
                        }
                        String s = item.toString();
                        a[size++] = s;
                        charLength += s.length();
                    }
                } else if (item == null) break block0;
                if (p != (p = p.next)) continue;
                continue block0;
            }
            break;
        }
        if (size == 0) {
            return "[]";
        }
        return Helpers.toString(a, size, charLength);
    }

    private Object[] toArrayInternal(Object[] a) {
        int size;
        Object[] x = a;
        block0: while (true) {
            size = 0;
            Node p = this.head;
            while (p != null) {
                Object item = p.item;
                if (p.isData) {
                    if (item != null) {
                        if (x == null) {
                            x = new Object[4];
                        } else if (size == x.length) {
                            x = Arrays.copyOf(x, 2 * (size + 4));
                        }
                        x[size++] = item;
                    }
                } else if (item == null) break block0;
                if (p != (p = p.next)) continue;
                continue block0;
            }
            break;
        }
        if (x == null) {
            return new Object[0];
        }
        if (a != null && size <= a.length) {
            if (a != x) {
                System.arraycopy(x, 0, a, 0, size);
            }
            if (size < a.length) {
                a[size] = null;
            }
            return a;
        }
        return size == x.length ? x : Arrays.copyOf(x, size);
    }

    @Override
    public Object[] toArray() {
        return this.toArrayInternal(null);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Objects.requireNonNull(a);
        return this.toArrayInternal(a);
    }

    @Override
    public Spliterator<E> spliterator() {
        return new LTQSpliterator();
    }

    final void unsplice(Node pred, Node s) {
        Node n;
        s.waiter = null;
        if (pred != null && pred.next == s && ((n = s.next) == null || n != s && pred.casNext(s, n) && pred.isMatched())) {
            while (true) {
                Node h;
                if ((h = this.head) == pred || h == s) {
                    return;
                }
                if (!h.isMatched()) break;
                Node hn = h.next;
                if (hn == null) {
                    return;
                }
                if (hn == h || !this.casHead(h, hn)) continue;
                h.selfLink();
            }
            if (pred.next != pred && s.next != s) {
                this.needSweep = true;
            }
        }
    }

    private void sweep() {
        Node s;
        this.needSweep = false;
        Node p = this.head;
        while (p != null && (s = p.next) != null) {
            if (!s.isMatched()) {
                p = s;
                continue;
            }
            Node n = s.next;
            if (n == null) break;
            if (s == n) {
                p = this.head;
                continue;
            }
            p.casNext(s, n);
        }
    }

    public LinkedTransferQueue() {
        this.head = this.tail = new Node();
    }

    public LinkedTransferQueue(Collection<? extends E> c) {
        Node h = null;
        Node t = null;
        for (E e : c) {
            Node newNode = new Node(Objects.requireNonNull(e));
            if (h == null) {
                h = t = newNode;
                continue;
            }
            Node node = t;
            t = newNode;
            node.appendRelaxed(t);
        }
        if (h == null) {
            h = t = new Node();
        }
        this.head = h;
        this.tail = t;
    }

    @Override
    public void put(E e) {
        this.xfer(e, true, 1, 0L);
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) {
        this.xfer(e, true, 1, 0L);
        return true;
    }

    @Override
    public boolean offer(E e) {
        this.xfer(e, true, 1, 0L);
        return true;
    }

    @Override
    public boolean add(E e) {
        this.xfer(e, true, 1, 0L);
        return true;
    }

    @Override
    public boolean tryTransfer(E e) {
        return this.xfer(e, true, 0, 0L) == null;
    }

    @Override
    public void transfer(E e) throws InterruptedException {
        if (this.xfer(e, true, 2, 0L) != null) {
            Thread.interrupted();
            throw new InterruptedException();
        }
    }

    @Override
    public boolean tryTransfer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        if (this.xfer(e, true, 3, unit.toNanos(timeout)) == null) {
            return true;
        }
        if (!Thread.interrupted()) {
            return false;
        }
        throw new InterruptedException();
    }

    @Override
    public E take() throws InterruptedException {
        E e = this.xfer(null, false, 2, 0L);
        if (e != null) {
            return e;
        }
        Thread.interrupted();
        throw new InterruptedException();
    }

    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        E e = this.xfer(null, false, 3, unit.toNanos(timeout));
        if (e != null || !Thread.interrupted()) {
            return e;
        }
        throw new InterruptedException();
    }

    @Override
    public E poll() {
        return this.xfer(null, false, 0, 0L);
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        E e;
        Objects.requireNonNull(c);
        if (c == this) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        while ((e = this.poll()) != null) {
            c.add(e);
            ++n;
        }
        return n;
    }

    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        E e;
        int n;
        Objects.requireNonNull(c);
        if (c == this) {
            throw new IllegalArgumentException();
        }
        for (n = 0; n < maxElements && (e = this.poll()) != null; ++n) {
            c.add(e);
        }
        return n;
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public E peek() {
        block0: while (true) {
            Node p = this.head;
            while (p != null) {
                Object item = p.item;
                if (p.isData) {
                    if (item != null) {
                        Object e = item;
                        return (E)e;
                    }
                } else if (item == null) break block0;
                if (p != (p = p.next)) continue;
                continue block0;
            }
            break;
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.firstDataNode() == null;
    }

    @Override
    public boolean hasWaitingConsumer() {
        block0: while (true) {
            Node p = this.head;
            while (p != null) {
                Object item = p.item;
                if (p.isData) {
                    if (item != null) {
                        break block0;
                    }
                } else if (item == null) {
                    return true;
                }
                if (p != (p = p.next)) continue;
                continue block0;
            }
            break;
        }
        return false;
    }

    @Override
    public int size() {
        return this.countOfMode(true);
    }

    @Override
    public int getWaitingConsumerCount() {
        return this.countOfMode(false);
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            return false;
        }
        block0: while (true) {
            Node p = this.head;
            Node pred = null;
            block1: while (p != null) {
                Node q = p.next;
                Object item = p.item;
                if (item != null) {
                    if (p.isData) {
                        if (o.equals(item) && p.tryMatch(item, null)) {
                            this.skipDeadNodes(pred, p, p, q);
                            return true;
                        }
                        pred = p;
                        p = q;
                        continue;
                    }
                } else if (!p.isData) break block0;
                Node c = p;
                while (true) {
                    if (q == null || !q.isMatched()) {
                        pred = this.skipDeadNodes(pred, c, p, q);
                        p = q;
                        continue block1;
                    }
                    if (p == (p = q)) continue block0;
                    q = p.next;
                }
            }
            break;
        }
        return false;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        block0: while (true) {
            Node p = this.head;
            Node pred = null;
            block1: while (p != null) {
                Node q = p.next;
                Object item = p.item;
                if (item != null) {
                    if (p.isData) {
                        if (o.equals(item)) {
                            return true;
                        }
                        pred = p;
                        p = q;
                        continue;
                    }
                } else if (!p.isData) break block0;
                Node c = p;
                while (true) {
                    if (q == null || !q.isMatched()) {
                        pred = this.skipDeadNodes(pred, c, p, q);
                        p = q;
                        continue block1;
                    }
                    if (p == (p = q)) continue block0;
                    q = p.next;
                }
            }
            break;
        }
        return false;
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        for (E e : this) {
            s.writeObject(e);
        }
        s.writeObject(null);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        Object item;
        Node h = null;
        Node t = null;
        while ((item = s.readObject()) != null) {
            Node newNode = new Node(item);
            if (h == null) {
                h = t = newNode;
                continue;
            }
            Node node = t;
            t = newNode;
            node.appendRelaxed(t);
        }
        if (h == null) {
            h = t = new Node();
        }
        this.head = h;
        this.tail = t;
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        Objects.requireNonNull(filter);
        return this.bulkRemove(filter);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        Objects.requireNonNull(c);
        return this.bulkRemove(e -> c.contains(e));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Objects.requireNonNull(c);
        return this.bulkRemove(e -> !c.contains(e));
    }

    @Override
    public void clear() {
        this.bulkRemove(e -> true);
    }

    private boolean bulkRemove(Predicate<? super E> filter) {
        boolean removed = false;
        block0: while (true) {
            Node p;
            int hops = 8;
            Node c = p = this.head;
            Node pred = null;
            while (p != null) {
                Node q = p.next;
                Object item = p.item;
                boolean pAlive = item != null && p.isData;
                if (pAlive) {
                    if (filter.test(item)) {
                        if (p.tryMatch(item, null)) {
                            removed = true;
                        }
                        pAlive = false;
                    }
                } else if (!p.isData && item == null) break block0;
                if (pAlive || q == null || --hops == 0) {
                    if (c != p && !this.tryCasSuccessor(pred, c, c = p) || pAlive) {
                        hops = 8;
                        pred = p;
                        c = q;
                    }
                } else if (p == q) continue block0;
                p = q;
            }
            break;
        }
        return removed;
    }

    void forEachFrom(Consumer<? super E> action, Node p) {
        Node pred = null;
        block0: while (p != null) {
            Node q = p.next;
            Object item = p.item;
            if (item != null) {
                if (p.isData) {
                    action.accept(item);
                    pred = p;
                    p = q;
                    continue;
                }
            } else if (!p.isData) break;
            Node c = p;
            while (true) {
                if (q == null || !q.isMatched()) {
                    pred = this.skipDeadNodes(pred, c, p, q);
                    p = q;
                    continue block0;
                }
                if (p == (p = q)) {
                    pred = null;
                    p = this.head;
                    continue block0;
                }
                q = p.next;
            }
        }
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        Objects.requireNonNull(action);
        this.forEachFrom(action, this.head);
    }

    static {
        try {
            MethodHandles.Lookup l = MethodHandles.lookup();
            HEAD = l.findVarHandle(LinkedTransferQueue.class, "head", Node.class);
            TAIL = l.findVarHandle(LinkedTransferQueue.class, "tail", Node.class);
            ITEM = l.findVarHandle(Node.class, "item", Object.class);
            NEXT = l.findVarHandle(Node.class, "next", Node.class);
            WAITER = l.findVarHandle(Node.class, "waiter", Thread.class);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
        Class<LockSupport> clazz = LockSupport.class;
    }

    static final class Node
    implements ForkJoinPool.ManagedBlocker {
        final boolean isData;
        volatile Object item;
        volatile Node next;
        volatile Thread waiter;
        private static final long serialVersionUID = -3375979862319811754L;

        Node(Object item) {
            ITEM.set(this, item);
            this.isData = item != null;
        }

        Node() {
            this.isData = true;
        }

        final boolean casNext(Node cmp, Node val) {
            return NEXT.compareAndSet(this, cmp, val);
        }

        final boolean casItem(Object cmp, Object val) {
            return ITEM.compareAndSet(this, cmp, val);
        }

        final void selfLink() {
            NEXT.setRelease(this, this);
        }

        final void appendRelaxed(Node next) {
            NEXT.setOpaque(this, next);
        }

        final boolean isMatched() {
            return this.isData == (this.item == null);
        }

        final boolean tryMatch(Object cmp, Object val) {
            if (this.casItem(cmp, val)) {
                LockSupport.unpark(this.waiter);
                return true;
            }
            return false;
        }

        final boolean cannotPrecede(boolean haveData) {
            boolean d = this.isData;
            return d != haveData && d != (this.item == null);
        }

        @Override
        public final boolean isReleasable() {
            return this.isData == (this.item == null) || Thread.currentThread().isInterrupted();
        }

        @Override
        public final boolean block() {
            while (!this.isReleasable()) {
                LockSupport.park();
            }
            return true;
        }
    }

    final class LTQSpliterator
    implements Spliterator<E> {
        static final int MAX_BATCH = 0x2000000;
        Node current;
        int batch;
        boolean exhausted;

        LTQSpliterator() {
        }

        @Override
        public Spliterator<E> trySplit() {
            Node q;
            Node p = this.current();
            if (p == null || (q = p.next) == null) {
                return null;
            }
            int i = 0;
            int n = this.batch = Math.min(this.batch + 1, 0x2000000);
            Object[] a = null;
            do {
                Object item = p.item;
                if (p.isData) {
                    if (item != null) {
                        if (a == null) {
                            a = new Object[n];
                        }
                        a[i++] = item;
                    }
                } else if (item == null) {
                    p = null;
                    break;
                }
                if (p != (p = q)) continue;
                p = LinkedTransferQueue.this.firstDataNode();
            } while (p != null && (q = p.next) != null && i < n);
            this.setCurrent(p);
            return i == 0 ? null : Spliterators.spliterator(a, 0, i, 4368);
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            Objects.requireNonNull(action);
            Node p = this.current();
            if (p != null) {
                this.current = null;
                this.exhausted = true;
                LinkedTransferQueue.this.forEachFrom(action, p);
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super E> action) {
            Objects.requireNonNull(action);
            Node p = this.current();
            if (p != null) {
                Object e = null;
                do {
                    Object item = p.item;
                    boolean isData = p.isData;
                    if (p == (p = p.next)) {
                        p = LinkedTransferQueue.this.head;
                    }
                    if (isData) {
                        if (item == null) continue;
                        e = item;
                        break;
                    }
                    if (item != null) continue;
                    p = null;
                } while (p != null);
                this.setCurrent(p);
                if (e != null) {
                    action.accept(e);
                    return true;
                }
            }
            return false;
        }

        private void setCurrent(Node p) {
            this.current = p;
            if (this.current == null) {
                this.exhausted = true;
            }
        }

        private Node current() {
            Node p = this.current;
            if (p == null && !this.exhausted) {
                p = LinkedTransferQueue.this.firstDataNode();
                this.setCurrent(p);
            }
            return p;
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return 4368;
        }
    }

    final class Itr
    implements Iterator<E> {
        private Node nextNode;
        private E nextItem;
        private Node lastRet;
        private Node ancestor;

        private void advance(Node pred) {
            Node p;
            Node c = p = pred == null ? LinkedTransferQueue.this.head : pred.next;
            while (p != null) {
                Object item = p.item;
                if (item != null && p.isData) {
                    this.nextNode = p;
                    this.nextItem = item;
                    if (c != p) {
                        LinkedTransferQueue.this.tryCasSuccessor(pred, c, p);
                    }
                    return;
                }
                if (!p.isData && item == null) break;
                if (c != p && !LinkedTransferQueue.this.tryCasSuccessor(pred, c, c = p)) {
                    pred = p;
                    c = p = p.next;
                    continue;
                }
                if (p != (p = p.next)) continue;
                pred = null;
                c = p = LinkedTransferQueue.this.head;
            }
            this.nextItem = null;
            this.nextNode = null;
        }

        Itr() {
            this.advance(null);
        }

        @Override
        public final boolean hasNext() {
            return this.nextNode != null;
        }

        @Override
        public final E next() {
            Node p = this.nextNode;
            if (p == null) {
                throw new NoSuchElementException();
            }
            Object e = this.nextItem;
            this.lastRet = p;
            this.advance(this.lastRet);
            return e;
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            Node p;
            Objects.requireNonNull(action);
            Node q = null;
            while ((p = this.nextNode) != null) {
                action.accept(this.nextItem);
                q = p;
                this.advance(q);
            }
            if (q != null) {
                this.lastRet = q;
            }
        }

        @Override
        public final void remove() {
            Node p;
            Node lastRet = this.lastRet;
            if (lastRet == null) {
                throw new IllegalStateException();
            }
            this.lastRet = null;
            if (lastRet.item == null) {
                return;
            }
            Node pred = this.ancestor;
            Node c = p = pred == null ? LinkedTransferQueue.this.head : pred.next;
            while (p != null) {
                Object item;
                if (p == lastRet) {
                    Node q;
                    item = p.item;
                    if (item != null) {
                        p.tryMatch(item, null);
                    }
                    if ((q = p.next) == null) {
                        q = p;
                    }
                    if (c != q) {
                        LinkedTransferQueue.this.tryCasSuccessor(pred, c, q);
                    }
                    this.ancestor = pred;
                    return;
                }
                item = p.item;
                boolean pAlive = item != null && p.isData;
                if (!pAlive && !p.isData && item == null) break;
                if (c != p && !LinkedTransferQueue.this.tryCasSuccessor(pred, c, c = p) || pAlive) {
                    pred = p;
                    c = p = p.next;
                    continue;
                }
                if (p != (p = p.next)) continue;
                pred = null;
                c = p = LinkedTransferQueue.this.head;
            }
        }
    }
}

