/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.SortedSet;
import java.util.Spliterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Helpers;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Predicate;
import jdk.internal.access.SharedSecrets;
import jdk.internal.util.ArraysSupport;

public class PriorityBlockingQueue<E>
extends AbstractQueue<E>
implements BlockingQueue<E>,
Serializable {
    private static final long serialVersionUID = 5595510919245408276L;
    private static final int DEFAULT_INITIAL_CAPACITY = 11;
    private transient Object[] queue;
    private transient int size;
    private transient Comparator<? super E> comparator;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition notEmpty = this.lock.newCondition();
    private volatile transient int allocationSpinLock;
    private PriorityQueue<E> q;
    private static final VarHandle ALLOCATIONSPINLOCK;

    public PriorityBlockingQueue() {
        this(11, null);
    }

    public PriorityBlockingQueue(int initialCapacity) {
        this(initialCapacity, null);
    }

    public PriorityBlockingQueue(int initialCapacity, Comparator<? super E> comparator) {
        if (initialCapacity < 1) {
            throw new IllegalArgumentException();
        }
        this.comparator = comparator;
        this.queue = new Object[Math.max(1, initialCapacity)];
    }

    public PriorityBlockingQueue(Collection<? extends E> c) {
        boolean heapify = true;
        boolean screen = true;
        if (c instanceof SortedSet) {
            SortedSet ss = (SortedSet)c;
            this.comparator = ss.comparator();
            heapify = false;
        } else if (c instanceof PriorityBlockingQueue) {
            PriorityBlockingQueue pq = (PriorityBlockingQueue)c;
            this.comparator = pq.comparator();
            screen = false;
            if (pq.getClass() == PriorityBlockingQueue.class) {
                heapify = false;
            }
        }
        Object[] es = c.toArray();
        int n = es.length;
        if (c.getClass() != ArrayList.class) {
            es = Arrays.copyOf(es, n, Object[].class);
        }
        if (screen && (n == 1 || this.comparator != null)) {
            for (Object e : es) {
                if (e != null) continue;
                throw new NullPointerException();
            }
        }
        this.queue = PriorityBlockingQueue.ensureNonEmpty(es);
        this.size = n;
        if (heapify) {
            this.heapify();
        }
    }

    private static Object[] ensureNonEmpty(Object[] es) {
        return es.length > 0 ? es : new Object[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryGrow(Object[] array, int oldCap) {
        this.lock.unlock();
        Object[] newArray = null;
        if (this.allocationSpinLock == 0 && ALLOCATIONSPINLOCK.compareAndSet(this, 0, 1)) {
            try {
                int growth = oldCap < 64 ? oldCap + 2 : oldCap >> 1;
                int newCap = ArraysSupport.newLength(oldCap, 1, growth);
                if (this.queue == array) {
                    newArray = new Object[newCap];
                }
            }
            finally {
                this.allocationSpinLock = 0;
            }
        }
        if (newArray == null) {
            Thread.yield();
        }
        this.lock.lock();
        if (newArray != null && this.queue == array) {
            this.queue = newArray;
            System.arraycopy(array, 0, newArray, 0, oldCap);
        }
    }

    private E dequeue() {
        Object[] es = this.queue;
        Object result = this.queue[0];
        if (result != null) {
            int n = --this.size;
            Object x = es[this.size];
            es[n] = null;
            if (n > 0) {
                Comparator<? super E> cmp = this.comparator;
                if (cmp == null) {
                    PriorityBlockingQueue.siftDownComparable(0, x, es, n);
                } else {
                    PriorityBlockingQueue.siftDownUsingComparator(0, x, es, n, cmp);
                }
            }
        }
        return (E)result;
    }

    private static <T> void siftUpComparable(int k, T x, Object[] es) {
        int parent;
        Object e;
        Comparable key = (Comparable)x;
        while (k > 0 && key.compareTo(e = es[parent = k - 1 >>> 1]) < 0) {
            es[k] = e;
            k = parent;
        }
        es[k] = key;
    }

    private static <T> void siftUpUsingComparator(int k, T x, Object[] es, Comparator<? super T> cmp) {
        int parent;
        Object e;
        while (k > 0 && cmp.compare(x, e = es[parent = k - 1 >>> 1]) < 0) {
            es[k] = e;
            k = parent;
        }
        es[k] = x;
    }

    private static <T> void siftDownComparable(int k, T x, Object[] es, int n) {
        Comparable key = (Comparable)x;
        int half = n >>> 1;
        while (k < half) {
            int child = (k << 1) + 1;
            Object c = es[child];
            int right = child + 1;
            if (right < n && ((Comparable)c).compareTo(es[right]) > 0) {
                child = right;
                c = es[child];
            }
            if (key.compareTo(c) <= 0) break;
            es[k] = c;
            k = child;
        }
        es[k] = key;
    }

    private static <T> void siftDownUsingComparator(int k, T x, Object[] es, int n, Comparator<? super T> cmp) {
        int half = n >>> 1;
        while (k < half) {
            int child = (k << 1) + 1;
            Object c = es[child];
            int right = child + 1;
            if (right < n && cmp.compare(c, es[right]) > 0) {
                child = right;
                c = es[child];
            }
            if (cmp.compare(x, c) <= 0) break;
            es[k] = c;
            k = child;
        }
        es[k] = x;
    }

    private void heapify() {
        Object[] es = this.queue;
        int n = this.size;
        Comparator<? super E> cmp = this.comparator;
        if (cmp == null) {
            for (i = (n >>> 1) - 1; i >= 0; --i) {
                PriorityBlockingQueue.siftDownComparable(i, es[i], es, n);
            }
        } else {
            while (i >= 0) {
                PriorityBlockingQueue.siftDownUsingComparator(i, es[i], es, n, cmp);
                --i;
            }
        }
    }

    @Override
    public boolean add(E e) {
        return this.offer(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e) {
        Object[] es;
        int n;
        if (e == null) {
            throw new NullPointerException();
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        while (true) {
            n = this.size;
            es = this.queue;
            int cap = this.queue.length;
            if (n < cap) break;
            this.tryGrow(es, cap);
        }
        try {
            Comparator<? super E> cmp = this.comparator;
            if (cmp == null) {
                PriorityBlockingQueue.siftUpComparable(n, e, es);
            } else {
                PriorityBlockingQueue.siftUpUsingComparator(n, e, es, cmp);
            }
            this.size = n + 1;
            this.notEmpty.signal();
        }
        finally {
            lock.unlock();
        }
        return true;
    }

    @Override
    public void put(E e) {
        this.offer(e);
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) {
        return this.offer(e);
    }

    @Override
    public E poll() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            E e = this.dequeue();
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public E take() throws InterruptedException {
        E result;
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while ((result = this.dequeue()) == null) {
                this.notEmpty.await();
            }
        }
        finally {
            lock.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        E result;
        long nanos = unit.toNanos(timeout);
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while ((result = this.dequeue()) == null && nanos > 0L) {
                nanos = this.notEmpty.awaitNanos(nanos);
            }
        }
        finally {
            lock.unlock();
        }
        return result;
    }

    @Override
    public E peek() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object object2 = this.queue[0];
            return (E)object2;
        }
        finally {
            lock.unlock();
        }
    }

    public Comparator<? super E> comparator() {
        return this.comparator;
    }

    @Override
    public int size() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.size;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    private int indexOf(Object o) {
        if (o != null) {
            Object[] es = this.queue;
            int n = this.size;
            for (int i = 0; i < n; ++i) {
                if (!o.equals(es[i])) continue;
                return i;
            }
        }
        return -1;
    }

    private void removeAt(int i) {
        Object[] es = this.queue;
        int n = this.size - 1;
        if (n == i) {
            es[i] = null;
        } else {
            Object moved = es[n];
            es[n] = null;
            Comparator<? super E> cmp = this.comparator;
            if (cmp == null) {
                PriorityBlockingQueue.siftDownComparable(i, moved, es, n);
            } else {
                PriorityBlockingQueue.siftDownUsingComparator(i, moved, es, n, cmp);
            }
            if (es[i] == moved) {
                if (cmp == null) {
                    PriorityBlockingQueue.siftUpComparable(i, moved, es);
                } else {
                    PriorityBlockingQueue.siftUpUsingComparator(i, moved, es, cmp);
                }
            }
        }
        this.size = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int i = this.indexOf(o);
            if (i == -1) {
                boolean bl = false;
                return bl;
            }
            this.removeAt(i);
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeEq(Object o) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] es = this.queue;
            int n = this.size;
            for (int i = 0; i < n; ++i) {
                if (o != es[i]) continue;
                this.removeAt(i);
                break;
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            boolean bl = this.indexOf(o) != -1;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public String toString() {
        return Helpers.collectionToString(this);
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        return this.drainTo(c, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        Objects.requireNonNull(c);
        if (c == this) {
            throw new IllegalArgumentException();
        }
        if (maxElements <= 0) {
            return 0;
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = Math.min(this.size, maxElements);
            for (int i = 0; i < n; ++i) {
                c.add(this.queue[0]);
                this.dequeue();
            }
            int n2 = n;
            return n2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] es = this.queue;
            int n = this.size;
            for (int i = 0; i < n; ++i) {
                es[i] = null;
            }
            this.size = 0;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Object[] toArray() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] objectArray = Arrays.copyOf(this.queue, this.size);
            return objectArray;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.size;
            if (a.length < n) {
                T[] TArray = Arrays.copyOf(this.queue, this.size, a.getClass());
                return TArray;
            }
            System.arraycopy(this.queue, 0, a, 0, n);
            if (a.length > n) {
                a[n] = null;
            }
            T[] TArray = a;
            return TArray;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr(this.toArray());
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        this.lock.lock();
        try {
            this.q = new PriorityQueue<E>(Math.max(this.size, 1), this.comparator);
            this.q.addAll(this);
            s.defaultWriteObject();
        }
        finally {
            this.q = null;
            this.lock.unlock();
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        try {
            s.defaultReadObject();
            int sz = this.q.size();
            SharedSecrets.getJavaObjectInputStreamAccess().checkArray(s, Object[].class, sz);
            this.queue = new Object[Math.max(1, sz)];
            this.comparator = this.q.comparator();
            this.addAll(this.q);
        }
        finally {
            this.q = null;
        }
    }

    @Override
    public Spliterator<E> spliterator() {
        return new PBQSpliterator();
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        Objects.requireNonNull(filter);
        return this.bulkRemove(filter);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        Objects.requireNonNull(c);
        return this.bulkRemove(e -> c.contains(e));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Objects.requireNonNull(c);
        return this.bulkRemove(e -> !c.contains(e));
    }

    private static long[] nBits(int n) {
        return new long[(n - 1 >> 6) + 1];
    }

    private static void setBit(long[] bits, int i) {
        int n = i >> 6;
        bits[n] = bits[n] | 1L << i;
    }

    private static boolean isClear(long[] bits, int i) {
        return (bits[i >> 6] & 1L << i) == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean bulkRemove(Predicate<? super E> filter) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int i;
            Object[] es = this.queue;
            int end = this.size;
            for (i = 0; i < end && !filter.test(es[i]); ++i) {
            }
            if (i >= end) {
                boolean bl = false;
                return bl;
            }
            int beg = i;
            long[] deathRow = PriorityBlockingQueue.nBits(end - beg);
            deathRow[0] = 1L;
            for (i = beg + 1; i < end; ++i) {
                if (!filter.test(es[i])) continue;
                PriorityBlockingQueue.setBit(deathRow, i - beg);
            }
            int w = beg;
            for (i = beg; i < end; ++i) {
                if (!PriorityBlockingQueue.isClear(deathRow, i - beg)) continue;
                es[w++] = es[i];
            }
            for (i = this.size = w; i < end; ++i) {
                es[i] = null;
            }
            this.heapify();
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEach(Consumer<? super E> action) {
        Objects.requireNonNull(action);
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] es = this.queue;
            int n = this.size;
            for (int i = 0; i < n; ++i) {
                action.accept(es[i]);
            }
        }
        finally {
            lock.unlock();
        }
    }

    static {
        try {
            MethodHandles.Lookup l = MethodHandles.lookup();
            ALLOCATIONSPINLOCK = l.findVarHandle(PriorityBlockingQueue.class, "allocationSpinLock", Integer.TYPE);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    final class Itr
    implements Iterator<E> {
        final Object[] array;
        int cursor;
        int lastRet = -1;

        Itr(Object[] array) {
            this.array = array;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.array.length;
        }

        @Override
        public E next() {
            if (this.cursor >= this.array.length) {
                throw new NoSuchElementException();
            }
            this.lastRet = this.cursor++;
            return this.array[this.lastRet];
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            PriorityBlockingQueue.this.removeEq(this.array[this.lastRet]);
            this.lastRet = -1;
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            int i;
            Objects.requireNonNull(action);
            Object[] es = this.array;
            if (i < es.length) {
                this.lastRet = -1;
                this.cursor = es.length;
                for (i = this.cursor; i < es.length; ++i) {
                    action.accept(es[i]);
                }
                this.lastRet = es.length - 1;
            }
        }
    }

    final class PBQSpliterator
    implements Spliterator<E> {
        Object[] array;
        int index;
        int fence;

        PBQSpliterator() {
        }

        PBQSpliterator(Object[] array, int index, int fence) {
            this.array = array;
            this.index = index;
            this.fence = fence;
        }

        private int getFence() {
            if (this.array == null) {
                this.array = PriorityBlockingQueue.this.toArray();
                this.fence = this.array.length;
            }
            return this.fence;
        }

        public PBQSpliterator trySplit() {
            PBQSpliterator pBQSpliterator;
            int lo = this.index;
            int hi = this.getFence();
            int mid = lo + hi >>> 1;
            if (lo >= mid) {
                pBQSpliterator = null;
            } else {
                this.index = mid;
                PBQSpliterator pBQSpliterator2 = new PBQSpliterator(this.array, lo, this.index);
                pBQSpliterator = pBQSpliterator2;
            }
            return pBQSpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            Objects.requireNonNull(action);
            int hi = this.getFence();
            int lo = this.index;
            Object[] es = this.array;
            this.index = hi;
            for (int i = lo; i < hi; ++i) {
                action.accept(es[i]);
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super E> action) {
            Objects.requireNonNull(action);
            if (this.getFence() > this.index && this.index >= 0) {
                action.accept(this.array[this.index++]);
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return this.getFence() - this.index;
        }

        @Override
        public int characteristics() {
            return 16704;
        }
    }
}

