/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;

public class SynchronousQueue<E>
extends AbstractQueue<E>
implements BlockingQueue<E>,
Serializable {
    private static final long serialVersionUID = -3223113410248163686L;
    static final long SPIN_FOR_TIMEOUT_THRESHOLD = 1023L;
    private volatile transient Transferer<E> transferer;
    private ReentrantLock qlock;
    private WaitQueue waitingProducers;
    private WaitQueue waitingConsumers;

    public SynchronousQueue() {
        this(false);
    }

    public SynchronousQueue(boolean fair) {
        this.transferer = fair ? new TransferQueue() : new TransferStack();
    }

    @Override
    public void put(E e) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        if (this.transferer.transfer(e, false, 0L) == null) {
            Thread.interrupted();
            throw new InterruptedException();
        }
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        if (this.transferer.transfer(e, true, unit.toNanos(timeout)) != null) {
            return true;
        }
        if (!Thread.interrupted()) {
            return false;
        }
        throw new InterruptedException();
    }

    @Override
    public boolean offer(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        return this.transferer.transfer(e, true, 0L) != null;
    }

    @Override
    public E take() throws InterruptedException {
        E e = this.transferer.transfer(null, false, 0L);
        if (e != null) {
            return e;
        }
        Thread.interrupted();
        throw new InterruptedException();
    }

    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        E e = this.transferer.transfer(null, true, unit.toNanos(timeout));
        if (e != null || !Thread.interrupted()) {
            return e;
        }
        throw new InterruptedException();
    }

    @Override
    public E poll() {
        return this.transferer.transfer(null, true, 0L);
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public int remainingCapacity() {
        return 0;
    }

    @Override
    public void clear() {
    }

    @Override
    public boolean contains(Object o) {
        return false;
    }

    @Override
    public boolean remove(Object o) {
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return c.isEmpty();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return false;
    }

    @Override
    public E peek() {
        return null;
    }

    @Override
    public Iterator<E> iterator() {
        return Collections.emptyIterator();
    }

    @Override
    public Spliterator<E> spliterator() {
        return Spliterators.emptySpliterator();
    }

    @Override
    public Object[] toArray() {
        return new Object[0];
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length > 0) {
            a[0] = null;
        }
        return a;
    }

    @Override
    public String toString() {
        return "[]";
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        E e;
        Objects.requireNonNull(c);
        if (c == this) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        while ((e = this.poll()) != null) {
            c.add(e);
            ++n;
        }
        return n;
    }

    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        E e;
        int n;
        Objects.requireNonNull(c);
        if (c == this) {
            throw new IllegalArgumentException();
        }
        for (n = 0; n < maxElements && (e = this.poll()) != null; ++n) {
            c.add(e);
        }
        return n;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        boolean fair = this.transferer instanceof TransferQueue;
        if (fair) {
            this.qlock = new ReentrantLock(true);
            this.waitingProducers = new FifoWaitQueue();
            this.waitingConsumers = new FifoWaitQueue();
        } else {
            this.qlock = new ReentrantLock();
            this.waitingProducers = new LifoWaitQueue();
            this.waitingConsumers = new LifoWaitQueue();
        }
        s.defaultWriteObject();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.transferer = this.waitingProducers instanceof FifoWaitQueue ? new TransferQueue() : new TransferStack();
    }

    static {
        Class<LockSupport> clazz = LockSupport.class;
    }

    static final class TransferQueue<E>
    extends Transferer<E> {
        volatile transient QNode head;
        volatile transient QNode tail;
        volatile transient QNode cleanMe;
        private static final VarHandle QHEAD;
        private static final VarHandle QTAIL;
        private static final VarHandle QCLEANME;

        TransferQueue() {
            QNode h;
            this.head = h = new QNode(null, false);
            this.tail = h;
        }

        void advanceHead(QNode h, QNode nh) {
            if (h == this.head && QHEAD.compareAndSet(this, h, nh)) {
                h.next = h;
            }
        }

        void advanceTail(QNode t, QNode nt) {
            if (this.tail == t) {
                QTAIL.compareAndSet(this, t, nt);
            }
        }

        boolean casCleanMe(QNode cmp, QNode val) {
            return this.cleanMe == cmp && QCLEANME.compareAndSet(this, cmp, val);
        }

        @Override
        E transfer(E e, boolean timed, long nanos) {
            Object x;
            QNode m;
            QNode s = null;
            boolean isData = e != null;
            while (true) {
                QNode t = this.tail;
                QNode h = this.head;
                if (t == null || h == null) continue;
                if (h == t || t.isData == isData) {
                    Object item;
                    if (t != this.tail) continue;
                    QNode tn = t.next;
                    if (tn != null) {
                        this.advanceTail(t, tn);
                        continue;
                    }
                    if (timed && nanos <= 0L) {
                        return null;
                    }
                    if (!t.casNext(null, s != null ? s : new QNode(e, isData))) continue;
                    this.advanceTail(t, s);
                    long deadline = timed ? System.nanoTime() + nanos : 0L;
                    Thread w = Thread.currentThread();
                    int stat = -1;
                    while ((item = s.item) == e) {
                        if (timed && (nanos = deadline - System.nanoTime()) <= 0L || w.isInterrupted()) {
                            if (!s.tryCancel(e)) continue;
                            this.clean(t, s);
                            return null;
                        }
                        item = s.item;
                        if (item != e) break;
                        if (stat <= 0) {
                            if (t.next != s) continue;
                            if (stat < 0 && t.isFulfilled()) {
                                stat = 0;
                                Thread.yield();
                                continue;
                            }
                            stat = 1;
                            s.waiter = w;
                            continue;
                        }
                        if (!timed) {
                            LockSupport.setCurrentBlocker(this);
                            try {
                                ForkJoinPool.managedBlock(s);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            LockSupport.setCurrentBlocker(null);
                            continue;
                        }
                        if (nanos <= 1023L) continue;
                        LockSupport.parkNanos(this, nanos);
                    }
                    if (stat == 1) {
                        s.forgetWaiter();
                    }
                    if (!s.isOffList()) {
                        this.advanceHead(t, s);
                        if (item != null) {
                            s.item = s;
                        }
                    }
                    return (E)(item != null ? item : e);
                }
                m = h.next;
                if (m == null || t != this.tail || h != this.head) continue;
                x = m.item;
                boolean fulfilled = isData == (x == null) && x != m && m.casItem(x, e);
                this.advanceHead(h, m);
                if (fulfilled) break;
            }
            Thread waiter = m.waiter;
            if (waiter != null) {
                LockSupport.unpark(waiter);
            }
            return (E)(x != null ? x : e);
        }

        void clean(QNode pred, QNode s) {
            s.forgetWaiter();
            while (pred.next == s) {
                QNode sn;
                QNode h = this.head;
                QNode hn = h.next;
                if (hn != null && hn.isCancelled()) {
                    this.advanceHead(h, hn);
                    continue;
                }
                QNode t = this.tail;
                if (t == h) {
                    return;
                }
                QNode tn = t.next;
                if (t != this.tail) continue;
                if (tn != null) {
                    this.advanceTail(t, tn);
                    continue;
                }
                if (s != t && ((sn = s.next) == s || pred.casNext(s, sn))) {
                    return;
                }
                QNode dp = this.cleanMe;
                if (dp != null) {
                    QNode dn;
                    QNode d = dp.next;
                    if (d == null || d == dp || !d.isCancelled() || d != t && (dn = d.next) != null && dn != d && dp.casNext(d, dn)) {
                        this.casCleanMe(dp, null);
                    }
                    if (dp != pred) continue;
                    return;
                }
                if (!this.casCleanMe(null, pred)) continue;
                return;
            }
        }

        static {
            try {
                MethodHandles.Lookup l = MethodHandles.lookup();
                QHEAD = l.findVarHandle(TransferQueue.class, "head", QNode.class);
                QTAIL = l.findVarHandle(TransferQueue.class, "tail", QNode.class);
                QCLEANME = l.findVarHandle(TransferQueue.class, "cleanMe", QNode.class);
            }
            catch (ReflectiveOperationException e) {
                throw new ExceptionInInitializerError(e);
            }
        }

        static final class QNode
        implements ForkJoinPool.ManagedBlocker {
            volatile QNode next;
            volatile Object item;
            volatile Thread waiter;
            final boolean isData;
            private static final VarHandle QITEM;
            private static final VarHandle QNEXT;
            private static final VarHandle QWAITER;

            QNode(Object item, boolean isData) {
                this.item = item;
                this.isData = isData;
            }

            boolean casNext(QNode cmp, QNode val) {
                return this.next == cmp && QNEXT.compareAndSet(this, cmp, val);
            }

            boolean casItem(Object cmp, Object val) {
                return this.item == cmp && QITEM.compareAndSet(this, cmp, val);
            }

            boolean tryCancel(Object cmp) {
                return QITEM.compareAndSet(this, cmp, this);
            }

            boolean isCancelled() {
                return this.item == this;
            }

            boolean isOffList() {
                return this.next == this;
            }

            void forgetWaiter() {
                QWAITER.setOpaque(this, null);
            }

            boolean isFulfilled() {
                Object x = this.item;
                return this.isData == (x == null) || x == this;
            }

            @Override
            public final boolean isReleasable() {
                Object x = this.item;
                return this.isData == (x == null) || x == this || Thread.currentThread().isInterrupted();
            }

            @Override
            public final boolean block() {
                while (!this.isReleasable()) {
                    LockSupport.park();
                }
                return true;
            }

            static {
                try {
                    MethodHandles.Lookup l = MethodHandles.lookup();
                    QITEM = l.findVarHandle(QNode.class, "item", Object.class);
                    QNEXT = l.findVarHandle(QNode.class, "next", QNode.class);
                    QWAITER = l.findVarHandle(QNode.class, "waiter", Thread.class);
                }
                catch (ReflectiveOperationException e) {
                    throw new ExceptionInInitializerError(e);
                }
            }
        }
    }

    static final class TransferStack<E>
    extends Transferer<E> {
        static final int REQUEST = 0;
        static final int DATA = 1;
        static final int FULFILLING = 2;
        volatile SNode head;
        private static final VarHandle SHEAD;

        TransferStack() {
        }

        static boolean isFulfilling(int m) {
            return (m & 2) != 0;
        }

        boolean casHead(SNode h, SNode nh) {
            return h == this.head && SHEAD.compareAndSet(this, h, nh);
        }

        static SNode snode(SNode s, Object e, SNode next, int mode) {
            if (s == null) {
                s = new SNode(e);
            }
            s.mode = mode;
            s.next = next;
            return s;
        }

        @Override
        E transfer(E e, boolean timed, long nanos) {
            int mode;
            SNode s = null;
            int n = mode = e == null ? 0 : 1;
            block2: while (true) {
                SNode mn;
                SNode m;
                SNode h;
                if ((h = this.head) == null || h.mode == mode) {
                    Object result;
                    SNode m2;
                    if (timed && nanos <= 0L) {
                        if (h != null && h.isCancelled()) {
                            this.casHead(h, h.next);
                            continue;
                        }
                        return null;
                    }
                    if (!this.casHead(h, s = TransferStack.snode(s, e, h, mode))) continue;
                    long deadline = timed ? System.nanoTime() + nanos : 0L;
                    Thread w = Thread.currentThread();
                    int stat = -1;
                    while ((m2 = s.match) == null) {
                        if (timed && (nanos = deadline - System.nanoTime()) <= 0L || w.isInterrupted()) {
                            if (!s.tryCancel()) continue;
                            this.clean(s);
                            return null;
                        }
                        m2 = s.match;
                        if (m2 != null) break;
                        if (stat <= 0) {
                            if (stat < 0 && h == null && this.head == s) {
                                stat = 0;
                                Thread.yield();
                                continue;
                            }
                            stat = 1;
                            s.waiter = w;
                            continue;
                        }
                        if (!timed) {
                            LockSupport.setCurrentBlocker(this);
                            try {
                                ForkJoinPool.managedBlock(s);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            LockSupport.setCurrentBlocker(null);
                            continue;
                        }
                        if (nanos <= 1023L) continue;
                        LockSupport.parkNanos(this, nanos);
                    }
                    if (stat == 1) {
                        s.forgetWaiter();
                    }
                    Object object2 = result = mode == 0 ? m2.item : s.item;
                    if (h != null && h.next == s) {
                        this.casHead(h, s.next);
                    }
                    return (E)result;
                }
                if (!TransferStack.isFulfilling(h.mode)) {
                    if (h.isCancelled()) {
                        this.casHead(h, h.next);
                        continue;
                    }
                    if (!this.casHead(h, s = TransferStack.snode(s, e, h, 2 | mode))) continue;
                    while (true) {
                        if ((m = s.next) == null) {
                            this.casHead(s, null);
                            s = null;
                            continue block2;
                        }
                        mn = m.next;
                        if (m.tryMatch(s)) {
                            this.casHead(s, mn);
                            return (E)(mode == 0 ? m.item : s.item);
                        }
                        s.casNext(m, mn);
                    }
                }
                m = h.next;
                if (m == null) {
                    this.casHead(h, null);
                    continue;
                }
                mn = m.next;
                if (m.tryMatch(h)) {
                    this.casHead(h, mn);
                    continue;
                }
                h.casNext(m, mn);
            }
        }

        void clean(SNode s) {
            SNode p;
            s.item = null;
            s.forgetWaiter();
            SNode past = s.next;
            if (past != null && past.isCancelled()) {
                past = past.next;
            }
            while ((p = this.head) != null && p != past && p.isCancelled()) {
                this.casHead(p, p.next);
            }
            while (p != null && p != past) {
                SNode n = p.next;
                if (n != null && n.isCancelled()) {
                    p.casNext(n, n.next);
                    continue;
                }
                p = n;
            }
        }

        static {
            try {
                MethodHandles.Lookup l = MethodHandles.lookup();
                SHEAD = l.findVarHandle(TransferStack.class, "head", SNode.class);
            }
            catch (ReflectiveOperationException e) {
                throw new ExceptionInInitializerError(e);
            }
        }

        static final class SNode
        implements ForkJoinPool.ManagedBlocker {
            volatile SNode next;
            volatile SNode match;
            volatile Thread waiter;
            Object item;
            int mode;
            private static final VarHandle SMATCH;
            private static final VarHandle SNEXT;
            private static final VarHandle SWAITER;

            SNode(Object item) {
                this.item = item;
            }

            boolean casNext(SNode cmp, SNode val) {
                return cmp == this.next && SNEXT.compareAndSet(this, cmp, val);
            }

            boolean tryMatch(SNode s) {
                SNode m = this.match;
                if (m == null) {
                    if (SMATCH.compareAndSet(this, null, s)) {
                        Thread w = this.waiter;
                        if (w != null) {
                            LockSupport.unpark(w);
                        }
                        return true;
                    }
                    m = this.match;
                }
                return m == s;
            }

            boolean tryCancel() {
                return SMATCH.compareAndSet(this, null, this);
            }

            boolean isCancelled() {
                return this.match == this;
            }

            @Override
            public final boolean isReleasable() {
                return this.match != null || Thread.currentThread().isInterrupted();
            }

            @Override
            public final boolean block() {
                while (!this.isReleasable()) {
                    LockSupport.park();
                }
                return true;
            }

            void forgetWaiter() {
                SWAITER.setOpaque(this, null);
            }

            static {
                try {
                    MethodHandles.Lookup l = MethodHandles.lookup();
                    SMATCH = l.findVarHandle(SNode.class, "match", SNode.class);
                    SNEXT = l.findVarHandle(SNode.class, "next", SNode.class);
                    SWAITER = l.findVarHandle(SNode.class, "waiter", Thread.class);
                }
                catch (ReflectiveOperationException e) {
                    throw new ExceptionInInitializerError(e);
                }
            }
        }
    }

    static abstract class Transferer<E> {
        Transferer() {
        }

        abstract E transfer(E var1, boolean var2, long var3);
    }

    static class FifoWaitQueue
    extends WaitQueue {
        private static final long serialVersionUID = -3623113410248163686L;

        FifoWaitQueue() {
        }
    }

    static class WaitQueue
    implements Serializable {
        WaitQueue() {
        }
    }

    static class LifoWaitQueue
    extends WaitQueue {
        private static final long serialVersionUID = -3633113410248163686L;

        LifoWaitQueue() {
        }
    }
}

