/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.AccessControlContext;
import java.security.SecureRandom;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import jdk.internal.misc.Unsafe;
import jdk.internal.misc.VM;
import jdk.internal.util.random.RandomSupport;

@RandomSupport.RandomGeneratorProperties(name="ThreadLocalRandom", i=64, j=0, k=0, equidistribution=1)
public class ThreadLocalRandom
extends Random {
    boolean initialized = true;
    private static final long serialVersionUID = -5851777807851030925L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("rnd", Long.TYPE), new ObjectStreamField("initialized", Boolean.TYPE)};
    private static final long GOLDEN_GAMMA = -7046029254386353131L;
    private static final int PROBE_INCREMENT = -1640531527;
    private static final long SEEDER_INCREMENT = -4942790177534073029L;
    static final String BAD_BOUND = "bound must be positive";
    static final String BAD_RANGE = "bound must be greater than origin";
    static final String BAD_SIZE = "size must be non-negative";
    private static final Unsafe U = Unsafe.getUnsafe();
    private static final long SEED = U.objectFieldOffset(Thread.class, "threadLocalRandomSeed");
    private static final long PROBE = U.objectFieldOffset(Thread.class, "threadLocalRandomProbe");
    private static final long SECONDARY = U.objectFieldOffset(Thread.class, "threadLocalRandomSecondarySeed");
    private static final long THREADLOCALS = U.objectFieldOffset(Thread.class, "threadLocals");
    private static final long INHERITABLETHREADLOCALS = U.objectFieldOffset(Thread.class, "inheritableThreadLocals");
    private static final long INHERITEDACCESSCONTROLCONTEXT = U.objectFieldOffset(Thread.class, "inheritedAccessControlContext");
    private static final AtomicInteger probeGenerator = new AtomicInteger();
    private static final ThreadLocalRandom instance = new ThreadLocalRandom();
    private static final AtomicLong seeder = new AtomicLong(RandomSupport.mixMurmur64(System.currentTimeMillis()) ^ RandomSupport.mixMurmur64(System.nanoTime()));

    private static int mix32(long z) {
        z = (z ^ z >>> 33) * -49064778989728563L;
        return (int)((z ^ z >>> 33) * -4265267296055464877L >>> 32);
    }

    private ThreadLocalRandom() {
    }

    static final void localInit() {
        int p = probeGenerator.addAndGet(-1640531527);
        int probe = p == 0 ? 1 : p;
        long seed = RandomSupport.mixMurmur64(seeder.getAndAdd(-4942790177534073029L));
        Thread t = Thread.currentThread();
        U.putLong(t, SEED, seed);
        U.putInt(t, PROBE, probe);
    }

    public static ThreadLocalRandom current() {
        if (U.getInt(Thread.currentThread(), PROBE) == 0) {
            ThreadLocalRandom.localInit();
        }
        return instance;
    }

    @Override
    public void setSeed(long seed) {
        if (this.initialized) {
            throw new UnsupportedOperationException();
        }
    }

    final long nextSeed() {
        Thread t = Thread.currentThread();
        long r = U.getLong(t, SEED) + (t.getId() << 1) + -7046029254386353131L;
        U.putLong(t, SEED, r);
        return r;
    }

    @Override
    protected int next(int bits) {
        return this.nextInt() >>> 32 - bits;
    }

    static final int getProbe() {
        return U.getInt(Thread.currentThread(), PROBE);
    }

    static final int advanceProbe(int probe) {
        probe ^= probe << 13;
        probe ^= probe >>> 17;
        probe ^= probe << 5;
        U.putInt(Thread.currentThread(), PROBE, probe);
        return probe;
    }

    static final int nextSecondarySeed() {
        Thread t = Thread.currentThread();
        int r = U.getInt(t, SECONDARY);
        if (r != 0) {
            r ^= r << 13;
            r ^= r >>> 17;
            r ^= r << 5;
        } else {
            r = ThreadLocalRandom.mix32(seeder.getAndAdd(-4942790177534073029L));
            if (r == 0) {
                r = 1;
            }
        }
        U.putInt(t, SECONDARY, r);
        return r;
    }

    static final void eraseThreadLocals(Thread thread) {
        U.putReference(thread, THREADLOCALS, null);
        U.putReference(thread, INHERITABLETHREADLOCALS, null);
    }

    static final void setInheritedAccessControlContext(Thread thread, AccessControlContext acc) {
        U.putReferenceRelease(thread, INHERITEDACCESSCONTROLCONTEXT, acc);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        ObjectOutputStream.PutField fields = s.putFields();
        fields.put("rnd", U.getLong(Thread.currentThread(), SEED));
        fields.put("initialized", true);
        s.writeFields();
    }

    private Object readResolve() {
        return ThreadLocalRandom.current();
    }

    @Override
    public boolean nextBoolean() {
        return super.nextBoolean();
    }

    @Override
    public int nextInt() {
        return ThreadLocalRandom.mix32(this.nextSeed());
    }

    @Override
    public int nextInt(int bound) {
        return super.nextInt(bound);
    }

    @Override
    public int nextInt(int origin, int bound) {
        return super.nextInt(origin, bound);
    }

    @Override
    public long nextLong() {
        return RandomSupport.mixMurmur64(this.nextSeed());
    }

    @Override
    public long nextLong(long bound) {
        return super.nextLong(bound);
    }

    @Override
    public long nextLong(long origin, long bound) {
        return super.nextLong(origin, bound);
    }

    @Override
    public float nextFloat() {
        return super.nextFloat();
    }

    @Override
    public float nextFloat(float bound) {
        return super.nextFloat(bound);
    }

    @Override
    public float nextFloat(float origin, float bound) {
        return super.nextFloat(origin, bound);
    }

    @Override
    public double nextDouble() {
        return super.nextDouble();
    }

    @Override
    public double nextDouble(double bound) {
        return super.nextDouble(bound);
    }

    @Override
    public double nextDouble(double origin, double bound) {
        return super.nextDouble(origin, bound);
    }

    @Override
    public IntStream ints(long streamSize) {
        return RandomSupport.AbstractSpliteratorGenerator.ints(ThreadLocalRandomProxy.PROXY, streamSize);
    }

    @Override
    public IntStream ints() {
        return RandomSupport.AbstractSpliteratorGenerator.ints(ThreadLocalRandomProxy.PROXY);
    }

    @Override
    public IntStream ints(long streamSize, int randomNumberOrigin, int randomNumberBound) {
        return RandomSupport.AbstractSpliteratorGenerator.ints(ThreadLocalRandomProxy.PROXY, streamSize, randomNumberOrigin, randomNumberBound);
    }

    @Override
    public IntStream ints(int randomNumberOrigin, int randomNumberBound) {
        return RandomSupport.AbstractSpliteratorGenerator.ints(ThreadLocalRandomProxy.PROXY, randomNumberOrigin, randomNumberBound);
    }

    @Override
    public LongStream longs(long streamSize) {
        return RandomSupport.AbstractSpliteratorGenerator.longs(ThreadLocalRandomProxy.PROXY, streamSize);
    }

    @Override
    public LongStream longs() {
        return RandomSupport.AbstractSpliteratorGenerator.longs(ThreadLocalRandomProxy.PROXY);
    }

    @Override
    public LongStream longs(long streamSize, long randomNumberOrigin, long randomNumberBound) {
        return RandomSupport.AbstractSpliteratorGenerator.longs(ThreadLocalRandomProxy.PROXY, streamSize, randomNumberOrigin, randomNumberBound);
    }

    @Override
    public LongStream longs(long randomNumberOrigin, long randomNumberBound) {
        return RandomSupport.AbstractSpliteratorGenerator.longs(ThreadLocalRandomProxy.PROXY, randomNumberOrigin, randomNumberBound);
    }

    @Override
    public DoubleStream doubles(long streamSize) {
        return RandomSupport.AbstractSpliteratorGenerator.doubles(ThreadLocalRandomProxy.PROXY, streamSize);
    }

    @Override
    public DoubleStream doubles() {
        return RandomSupport.AbstractSpliteratorGenerator.doubles(ThreadLocalRandomProxy.PROXY);
    }

    @Override
    public DoubleStream doubles(long streamSize, double randomNumberOrigin, double randomNumberBound) {
        return RandomSupport.AbstractSpliteratorGenerator.doubles(ThreadLocalRandomProxy.PROXY, streamSize, randomNumberOrigin, randomNumberBound);
    }

    @Override
    public DoubleStream doubles(double randomNumberOrigin, double randomNumberBound) {
        return RandomSupport.AbstractSpliteratorGenerator.doubles(ThreadLocalRandomProxy.PROXY, randomNumberOrigin, randomNumberBound);
    }

    static {
        String sec = VM.getSavedProperty("java.util.secureRandomSeed");
        if (Boolean.parseBoolean(sec)) {
            byte[] seedBytes = SecureRandom.getSeed(8);
            long s = (long)seedBytes[0] & 0xFFL;
            for (int i = 1; i < 8; ++i) {
                s = s << 8 | (long)seedBytes[i] & 0xFFL;
            }
            seeder.set(s);
        }
    }

    private static final class ThreadLocalRandomProxy
    extends Random {
        static final Random PROXY = new ThreadLocalRandomProxy();

        private ThreadLocalRandomProxy() {
        }

        @Override
        public int nextInt() {
            return ThreadLocalRandom.current().nextInt();
        }

        @Override
        public long nextLong() {
            return ThreadLocalRandom.current().nextLong();
        }
    }
}

