/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Objects;

public enum TimeUnit {
    NANOSECONDS(1L),
    MICROSECONDS(1000L),
    MILLISECONDS(1000000L),
    SECONDS(1000000000L),
    MINUTES(60000000000L),
    HOURS(3600000000000L),
    DAYS(86400000000000L);

    private static final long NANO_SCALE = 1L;
    private static final long MICRO_SCALE = 1000L;
    private static final long MILLI_SCALE = 1000000L;
    private static final long SECOND_SCALE = 1000000000L;
    private static final long MINUTE_SCALE = 60000000000L;
    private static final long HOUR_SCALE = 3600000000000L;
    private static final long DAY_SCALE = 86400000000000L;
    private final long scale;
    private final long maxNanos;
    private final long maxMicros;
    private final long maxMillis;
    private final long maxSecs;
    private final long microRatio;
    private final int milliRatio;
    private final int secRatio;

    private TimeUnit(long s) {
        long ur;
        this.scale = s;
        this.maxNanos = Long.MAX_VALUE / s;
        this.microRatio = ur = s >= 1000L ? s / 1000L : 1000L / s;
        this.maxMicros = Long.MAX_VALUE / ur;
        long mr = s >= 1000000L ? s / 1000000L : 1000000L / s;
        this.milliRatio = (int)mr;
        this.maxMillis = Long.MAX_VALUE / mr;
        long sr = s >= 1000000000L ? s / 1000000000L : 1000000000L / s;
        this.secRatio = (int)sr;
        this.maxSecs = Long.MAX_VALUE / sr;
    }

    private static long cvt(long d, long dst, long src) {
        if (src == dst) {
            return d;
        }
        if (src < dst) {
            return d / (dst / src);
        }
        long r = src / dst;
        long m = Long.MAX_VALUE / r;
        if (d > m) {
            return Long.MAX_VALUE;
        }
        if (d < -m) {
            return Long.MIN_VALUE;
        }
        return d * r;
    }

    public long convert(long sourceDuration, TimeUnit sourceUnit) {
        switch (this) {
            case NANOSECONDS: {
                return sourceUnit.toNanos(sourceDuration);
            }
            case MICROSECONDS: {
                return sourceUnit.toMicros(sourceDuration);
            }
            case MILLISECONDS: {
                return sourceUnit.toMillis(sourceDuration);
            }
            case SECONDS: {
                return sourceUnit.toSeconds(sourceDuration);
            }
        }
        return TimeUnit.cvt(sourceDuration, this.scale, sourceUnit.scale);
    }

    public long convert(Duration duration) {
        long nanoVal;
        long secs = duration.getSeconds();
        int nano = duration.getNano();
        if (secs < 0L && nano > 0) {
            ++secs;
            nano -= 1000000000;
        }
        if (this == NANOSECONDS) {
            nanoVal = nano;
        } else {
            long s = this.scale;
            if (s < 1000000000L) {
                nanoVal = (long)nano / s;
            } else {
                if (this == SECONDS) {
                    return secs;
                }
                return secs / (long)this.secRatio;
            }
        }
        long val = secs * (long)this.secRatio + nanoVal;
        return secs < this.maxSecs && secs > -this.maxSecs || secs == this.maxSecs && val > 0L || secs == -this.maxSecs && val < 0L ? val : (secs > 0L ? Long.MAX_VALUE : Long.MIN_VALUE);
    }

    public long toNanos(long duration) {
        long s = this.scale;
        if (s == 1L) {
            return duration;
        }
        long m = this.maxNanos;
        if (duration > m) {
            return Long.MAX_VALUE;
        }
        if (duration < -m) {
            return Long.MIN_VALUE;
        }
        return duration * s;
    }

    public long toMicros(long duration) {
        long s = this.scale;
        if (s <= 1000L) {
            return s == 1000L ? duration : duration / this.microRatio;
        }
        long m = this.maxMicros;
        if (duration > m) {
            return Long.MAX_VALUE;
        }
        if (duration < -m) {
            return Long.MIN_VALUE;
        }
        return duration * this.microRatio;
    }

    public long toMillis(long duration) {
        long s = this.scale;
        if (s <= 1000000L) {
            return s == 1000000L ? duration : duration / (long)this.milliRatio;
        }
        long m = this.maxMillis;
        if (duration > m) {
            return Long.MAX_VALUE;
        }
        if (duration < -m) {
            return Long.MIN_VALUE;
        }
        return duration * (long)this.milliRatio;
    }

    public long toSeconds(long duration) {
        long s = this.scale;
        if (s <= 1000000000L) {
            return s == 1000000000L ? duration : duration / (long)this.secRatio;
        }
        long m = this.maxSecs;
        if (duration > m) {
            return Long.MAX_VALUE;
        }
        if (duration < -m) {
            return Long.MIN_VALUE;
        }
        return duration * (long)this.secRatio;
    }

    public long toMinutes(long duration) {
        return TimeUnit.cvt(duration, 60000000000L, this.scale);
    }

    public long toHours(long duration) {
        return TimeUnit.cvt(duration, 3600000000000L, this.scale);
    }

    public long toDays(long duration) {
        return TimeUnit.cvt(duration, 86400000000000L, this.scale);
    }

    private int excessNanos(long d, long m) {
        long s = this.scale;
        if (s == 1L) {
            return (int)(d - m * 1000000L);
        }
        if (s == 1000L) {
            return (int)(d * 1000L - m * 1000000L);
        }
        return 0;
    }

    public void timedWait(Object obj, long timeout) throws InterruptedException {
        if (timeout > 0L) {
            long ms = this.toMillis(timeout);
            int ns = this.excessNanos(timeout, ms);
            obj.wait(ms, ns);
        }
    }

    public void timedJoin(Thread thread, long timeout) throws InterruptedException {
        if (timeout > 0L) {
            long ms = this.toMillis(timeout);
            int ns = this.excessNanos(timeout, ms);
            thread.join(ms, ns);
        }
    }

    public void sleep(long timeout) throws InterruptedException {
        if (timeout > 0L) {
            long ms = this.toMillis(timeout);
            int ns = this.excessNanos(timeout, ms);
            Thread.sleep(ms, ns);
        }
    }

    public ChronoUnit toChronoUnit() {
        switch (this) {
            case NANOSECONDS: {
                return ChronoUnit.NANOS;
            }
            case MICROSECONDS: {
                return ChronoUnit.MICROS;
            }
            case MILLISECONDS: {
                return ChronoUnit.MILLIS;
            }
            case SECONDS: {
                return ChronoUnit.SECONDS;
            }
            case MINUTES: {
                return ChronoUnit.MINUTES;
            }
            case HOURS: {
                return ChronoUnit.HOURS;
            }
            case DAYS: {
                return ChronoUnit.DAYS;
            }
        }
        throw new AssertionError();
    }

    public static TimeUnit of(ChronoUnit chronoUnit) {
        switch (Objects.requireNonNull(chronoUnit, "chronoUnit")) {
            case NANOS: {
                return NANOSECONDS;
            }
            case MICROS: {
                return MICROSECONDS;
            }
            case MILLIS: {
                return MILLISECONDS;
            }
            case SECONDS: {
                return SECONDS;
            }
            case MINUTES: {
                return MINUTES;
            }
            case HOURS: {
                return HOURS;
            }
            case DAYS: {
                return DAYS;
            }
        }
        throw new IllegalArgumentException("No TimeUnit equivalent for " + chronoUnit);
    }
}

