/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.io.Serializable;
import java.util.function.LongBinaryOperator;
import java.util.function.LongUnaryOperator;
import jdk.internal.misc.Unsafe;

public class AtomicLong
extends Number
implements Serializable {
    private static final long serialVersionUID = 1927816293512124184L;
    static final boolean VM_SUPPORTS_LONG_CAS = AtomicLong.VMSupportsCS8();
    private static final Unsafe U = Unsafe.getUnsafe();
    private static final long VALUE = U.objectFieldOffset(AtomicLong.class, "value");
    private volatile long value;

    private static native boolean VMSupportsCS8();

    public AtomicLong(long initialValue) {
        this.value = initialValue;
    }

    public AtomicLong() {
    }

    public final long get() {
        return this.value;
    }

    public final void set(long newValue) {
        U.putLongVolatile(this, VALUE, newValue);
    }

    public final void lazySet(long newValue) {
        U.putLongRelease(this, VALUE, newValue);
    }

    public final long getAndSet(long newValue) {
        return U.getAndSetLong(this, VALUE, newValue);
    }

    public final boolean compareAndSet(long expectedValue, long newValue) {
        return U.compareAndSetLong(this, VALUE, expectedValue, newValue);
    }

    @Deprecated(since="9")
    public final boolean weakCompareAndSet(long expectedValue, long newValue) {
        return U.weakCompareAndSetLongPlain(this, VALUE, expectedValue, newValue);
    }

    public final boolean weakCompareAndSetPlain(long expectedValue, long newValue) {
        return U.weakCompareAndSetLongPlain(this, VALUE, expectedValue, newValue);
    }

    public final long getAndIncrement() {
        return U.getAndAddLong(this, VALUE, 1L);
    }

    public final long getAndDecrement() {
        return U.getAndAddLong(this, VALUE, -1L);
    }

    public final long getAndAdd(long delta) {
        return U.getAndAddLong(this, VALUE, delta);
    }

    public final long incrementAndGet() {
        return U.getAndAddLong(this, VALUE, 1L) + 1L;
    }

    public final long decrementAndGet() {
        return U.getAndAddLong(this, VALUE, -1L) - 1L;
    }

    public final long addAndGet(long delta) {
        return U.getAndAddLong(this, VALUE, delta) + delta;
    }

    public final long getAndUpdate(LongUnaryOperator updateFunction) {
        long prev = this.get();
        long next = 0L;
        boolean haveNext = false;
        while (true) {
            if (!haveNext) {
                next = updateFunction.applyAsLong(prev);
            }
            if (this.weakCompareAndSetVolatile(prev, next)) {
                return prev;
            }
            haveNext = prev == (prev = this.get());
        }
    }

    public final long updateAndGet(LongUnaryOperator updateFunction) {
        long prev = this.get();
        long next = 0L;
        boolean haveNext = false;
        while (true) {
            if (!haveNext) {
                next = updateFunction.applyAsLong(prev);
            }
            if (this.weakCompareAndSetVolatile(prev, next)) {
                return next;
            }
            haveNext = prev == (prev = this.get());
        }
    }

    public final long getAndAccumulate(long x, LongBinaryOperator accumulatorFunction) {
        long prev = this.get();
        long next = 0L;
        boolean haveNext = false;
        while (true) {
            if (!haveNext) {
                next = accumulatorFunction.applyAsLong(prev, x);
            }
            if (this.weakCompareAndSetVolatile(prev, next)) {
                return prev;
            }
            haveNext = prev == (prev = this.get());
        }
    }

    public final long accumulateAndGet(long x, LongBinaryOperator accumulatorFunction) {
        long prev = this.get();
        long next = 0L;
        boolean haveNext = false;
        while (true) {
            if (!haveNext) {
                next = accumulatorFunction.applyAsLong(prev, x);
            }
            if (this.weakCompareAndSetVolatile(prev, next)) {
                return next;
            }
            haveNext = prev == (prev = this.get());
        }
    }

    public String toString() {
        return Long.toString(this.get());
    }

    @Override
    public int intValue() {
        return (int)this.get();
    }

    @Override
    public long longValue() {
        return this.get();
    }

    @Override
    public float floatValue() {
        return this.get();
    }

    @Override
    public double doubleValue() {
        return this.get();
    }

    public final long getPlain() {
        return U.getLong(this, VALUE);
    }

    public final void setPlain(long newValue) {
        U.putLong(this, VALUE, newValue);
    }

    public final long getOpaque() {
        return U.getLongOpaque(this, VALUE);
    }

    public final void setOpaque(long newValue) {
        U.putLongOpaque(this, VALUE, newValue);
    }

    public final long getAcquire() {
        return U.getLongAcquire(this, VALUE);
    }

    public final void setRelease(long newValue) {
        U.putLongRelease(this, VALUE, newValue);
    }

    public final long compareAndExchange(long expectedValue, long newValue) {
        return U.compareAndExchangeLong(this, VALUE, expectedValue, newValue);
    }

    public final long compareAndExchangeAcquire(long expectedValue, long newValue) {
        return U.compareAndExchangeLongAcquire(this, VALUE, expectedValue, newValue);
    }

    public final long compareAndExchangeRelease(long expectedValue, long newValue) {
        return U.compareAndExchangeLongRelease(this, VALUE, expectedValue, newValue);
    }

    public final boolean weakCompareAndSetVolatile(long expectedValue, long newValue) {
        return U.weakCompareAndSetLong(this, VALUE, expectedValue, newValue);
    }

    public final boolean weakCompareAndSetAcquire(long expectedValue, long newValue) {
        return U.weakCompareAndSetLongAcquire(this, VALUE, expectedValue, newValue);
    }

    public final boolean weakCompareAndSetRelease(long expectedValue, long newValue) {
        return U.weakCompareAndSetLongRelease(this, VALUE, expectedValue, newValue);
    }
}

