/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.concurrent.atomic.Striped64;

public class DoubleAdder
extends Striped64
implements Serializable {
    private static final long serialVersionUID = 7249069246863182397L;

    public void add(double x) {
        long b;
        Striped64.Cell[] cs = this.cells;
        if (this.cells != null || !this.casBase(b = this.base, Double.doubleToRawLongBits(Double.longBitsToDouble(b) + x))) {
            long v;
            Striped64.Cell c;
            int m;
            int index = DoubleAdder.getProbe();
            boolean uncontended = true;
            if (cs == null || (m = cs.length - 1) < 0 || (c = cs[index & m]) == null || !(uncontended = c.cas(v = c.value, Double.doubleToRawLongBits(Double.longBitsToDouble(v) + x)))) {
                this.doubleAccumulate(x, null, uncontended, index);
            }
        }
    }

    public double sum() {
        Striped64.Cell[] cs = this.cells;
        double sum = Double.longBitsToDouble(this.base);
        if (cs != null) {
            for (Striped64.Cell c : cs) {
                if (c == null) continue;
                sum += Double.longBitsToDouble(c.value);
            }
        }
        return sum;
    }

    public void reset() {
        Striped64.Cell[] cs = this.cells;
        this.base = 0L;
        if (cs != null) {
            for (Striped64.Cell c : cs) {
                if (c == null) continue;
                c.reset();
            }
        }
    }

    public double sumThenReset() {
        Striped64.Cell[] cs = this.cells;
        double sum = Double.longBitsToDouble(this.getAndSetBase(0L));
        if (cs != null) {
            for (Striped64.Cell c : cs) {
                if (c == null) continue;
                sum += Double.longBitsToDouble(c.getAndSet(0L));
            }
        }
        return sum;
    }

    public String toString() {
        return Double.toString(this.sum());
    }

    @Override
    public double doubleValue() {
        return this.sum();
    }

    @Override
    public long longValue() {
        return (long)this.sum();
    }

    @Override
    public int intValue() {
        return (int)this.sum();
    }

    @Override
    public float floatValue() {
        return (float)this.sum();
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream s) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 7249069246863182397L;
        private final double value;

        SerializationProxy(DoubleAdder a) {
            this.value = a.sum();
        }

        private Object readResolve() {
            DoubleAdder a = new DoubleAdder();
            a.base = Double.doubleToRawLongBits(this.value);
            return a;
        }
    }
}

