/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.concurrent.atomic.Striped64;
import java.util.function.LongBinaryOperator;

public class LongAccumulator
extends Striped64
implements Serializable {
    private static final long serialVersionUID = 7249069246863182397L;
    private final LongBinaryOperator function;
    private final long identity;

    public LongAccumulator(LongBinaryOperator accumulatorFunction, long identity) {
        this.function = accumulatorFunction;
        this.base = this.identity = identity;
    }

    public void accumulate(long x) {
        long b;
        long r;
        Striped64.Cell[] cs = this.cells;
        if (this.cells != null || (r = this.function.applyAsLong(b = this.base, x)) != b && !this.casBase(b, r)) {
            long v;
            Striped64.Cell c;
            int m;
            int index = LongAccumulator.getProbe();
            boolean uncontended = true;
            if (cs == null || (m = cs.length - 1) < 0 || (c = cs[index & m]) == null || !(uncontended = (r = this.function.applyAsLong(v = c.value, x)) == v || c.cas(v, r))) {
                this.longAccumulate(x, this.function, uncontended, index);
            }
        }
    }

    public long get() {
        Striped64.Cell[] cs = this.cells;
        long result = this.base;
        if (cs != null) {
            for (Striped64.Cell c : cs) {
                if (c == null) continue;
                result = this.function.applyAsLong(result, c.value);
            }
        }
        return result;
    }

    public void reset() {
        Striped64.Cell[] cs = this.cells;
        this.base = this.identity;
        if (cs != null) {
            for (Striped64.Cell c : cs) {
                if (c == null) continue;
                c.reset(this.identity);
            }
        }
    }

    public long getThenReset() {
        Striped64.Cell[] cs = this.cells;
        long result = this.getAndSetBase(this.identity);
        if (cs != null) {
            for (Striped64.Cell c : cs) {
                if (c == null) continue;
                long v = c.getAndSet(this.identity);
                result = this.function.applyAsLong(result, v);
            }
        }
        return result;
    }

    public String toString() {
        return Long.toString(this.get());
    }

    @Override
    public long longValue() {
        return this.get();
    }

    @Override
    public int intValue() {
        return (int)this.get();
    }

    @Override
    public float floatValue() {
        return this.get();
    }

    @Override
    public double doubleValue() {
        return this.get();
    }

    private Object writeReplace() {
        return new SerializationProxy(this.get(), this.function, this.identity);
    }

    private void readObject(ObjectInputStream s) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 7249069246863182397L;
        private final long value;
        private final LongBinaryOperator function;
        private final long identity;

        SerializationProxy(long value, LongBinaryOperator function, long identity) {
            this.value = value;
            this.function = function;
            this.identity = identity;
        }

        private Object readResolve() {
            LongAccumulator a = new LongAccumulator(this.function, this.identity);
            a.base = this.value;
            return a;
        }
    }
}

