/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.locks;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractOwnableSynchronizer;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.LockSupport;
import jdk.internal.misc.Unsafe;

public abstract class AbstractQueuedSynchronizer
extends AbstractOwnableSynchronizer
implements Serializable {
    private static final long serialVersionUID = 7373984972572414691L;
    static final int WAITING = 1;
    static final int CANCELLED = Integer.MIN_VALUE;
    static final int COND = 2;
    private volatile transient Node head;
    private volatile transient Node tail;
    private volatile int state;
    private static final Unsafe U = Unsafe.getUnsafe();
    private static final long STATE = U.objectFieldOffset(AbstractQueuedSynchronizer.class, "state");
    private static final long HEAD = U.objectFieldOffset(AbstractQueuedSynchronizer.class, "head");
    private static final long TAIL = U.objectFieldOffset(AbstractQueuedSynchronizer.class, "tail");

    protected AbstractQueuedSynchronizer() {
    }

    protected final int getState() {
        return this.state;
    }

    protected final void setState(int newState) {
        this.state = newState;
    }

    protected final boolean compareAndSetState(int expect, int update) {
        return U.compareAndSetInt(this, STATE, expect, update);
    }

    private boolean casTail(Node c, Node v) {
        return U.compareAndSetReference(this, TAIL, c, v);
    }

    private void tryInitializeHead() {
        ExclusiveNode h = new ExclusiveNode();
        if (U.compareAndSetReference(this, HEAD, null, h)) {
            this.tail = h;
        }
    }

    final void enqueue(Node node) {
        block3: {
            Node t;
            if (node == null) break block3;
            while (true) {
                t = this.tail;
                node.setPrevRelaxed(t);
                if (t == null) {
                    this.tryInitializeHead();
                    continue;
                }
                if (this.casTail(t, node)) break;
            }
            t.next = node;
            if (t.status < 0) {
                LockSupport.unpark(node.waiter);
            }
        }
    }

    final boolean isEnqueued(Node node) {
        Node t = this.tail;
        while (t != null) {
            if (t == node) {
                return true;
            }
            t = t.prev;
        }
        return false;
    }

    private static void signalNext(Node h) {
        Node s;
        if (h != null && (s = h.next) != null && s.status != 0) {
            s.getAndUnsetStatus(1);
            LockSupport.unpark(s.waiter);
        }
    }

    private static void signalNextIfShared(Node h) {
        Node s;
        if (h != null && (s = h.next) != null && s instanceof SharedNode && s.status != 0) {
            s.getAndUnsetStatus(1);
            LockSupport.unpark(s.waiter);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final int acquire(Node node, int arg, boolean shared, boolean interruptible, boolean timed, long time) {
        Thread current = Thread.currentThread();
        int spins = 0;
        int postSpins = 0;
        boolean interrupted = false;
        boolean first = false;
        Node pred = null;
        while (true) {
            if (!first && (pred = node == null ? null : node.prev) != null && !(first = this.head == pred)) {
                if (pred.status < 0) {
                    this.cleanQueue();
                    continue;
                }
                if (pred.prev == null) {
                    Thread.onSpinWait();
                    continue;
                }
            }
            if (first || pred == null) {
                boolean acquired;
                try {
                    acquired = shared ? this.tryAcquireShared(arg) >= 0 : this.tryAcquire(arg);
                }
                catch (Throwable ex) {
                    this.cancelAcquire(node, interrupted, false);
                    throw ex;
                }
                if (acquired) {
                    if (!first) return 1;
                    node.prev = null;
                    this.head = node;
                    pred.next = null;
                    node.waiter = null;
                    if (shared) {
                        AbstractQueuedSynchronizer.signalNextIfShared(node);
                    }
                    if (!interrupted) return 1;
                    current.interrupt();
                    return 1;
                }
            }
            if (node == null) {
                if (shared) {
                    node = new SharedNode();
                    continue;
                }
                node = new ExclusiveNode();
                continue;
            }
            if (pred == null) {
                node.waiter = current;
                Node t = this.tail;
                node.setPrevRelaxed(t);
                if (t == null) {
                    this.tryInitializeHead();
                    continue;
                }
                if (!this.casTail(t, node)) {
                    node.setPrevRelaxed(null);
                    continue;
                }
                t.next = node;
                continue;
            }
            if (first && spins != 0) {
                spins = (byte)(spins - 1);
                Thread.onSpinWait();
                continue;
            }
            if (node.status == 0) {
                node.status = 1;
                continue;
            }
            byte by = (byte)(postSpins << 1 | 1);
            postSpins = by;
            spins = by;
            if (!timed) {
                LockSupport.park(this);
            } else {
                long nanos = time - System.nanoTime();
                if (nanos <= 0L) return this.cancelAcquire(node, interrupted, interruptible);
                LockSupport.parkNanos(this, nanos);
            }
            node.clearStatus();
            if ((interrupted |= Thread.interrupted()) && interruptible) return this.cancelAcquire(node, interrupted, interruptible);
        }
    }

    private void cleanQueue() {
        block0: while (true) {
            Node q = this.tail;
            Node s = null;
            while (true) {
                Node p;
                if (q == null || (p = q.prev) == null) {
                    return;
                }
                if (s != null ? s.prev != q || s.status < 0 : this.tail != q) continue block0;
                if (q.status < 0) {
                    if (!(s == null ? this.casTail(q, p) : s.casPrev(q, p)) || q.prev != p) continue block0;
                    p.casNext(q, s);
                    if (p.prev != null) continue block0;
                    AbstractQueuedSynchronizer.signalNext(p);
                    continue block0;
                }
                Node n = p.next;
                if (n != q) {
                    if (n == null || q.prev != p) continue block0;
                    p.casNext(n, q);
                    if (p.prev != null) continue block0;
                    AbstractQueuedSynchronizer.signalNext(p);
                    continue block0;
                }
                s = q;
                q = q.prev;
            }
            break;
        }
    }

    private int cancelAcquire(Node node, boolean interrupted, boolean interruptible) {
        if (node != null) {
            node.waiter = null;
            node.status = Integer.MIN_VALUE;
            if (node.prev != null) {
                this.cleanQueue();
            }
        }
        if (interrupted) {
            if (interruptible) {
                return Integer.MIN_VALUE;
            }
            Thread.currentThread().interrupt();
        }
        return 0;
    }

    protected boolean tryAcquire(int arg) {
        throw new UnsupportedOperationException();
    }

    protected boolean tryRelease(int arg) {
        throw new UnsupportedOperationException();
    }

    protected int tryAcquireShared(int arg) {
        throw new UnsupportedOperationException();
    }

    protected boolean tryReleaseShared(int arg) {
        throw new UnsupportedOperationException();
    }

    protected boolean isHeldExclusively() {
        throw new UnsupportedOperationException();
    }

    public final void acquire(int arg) {
        if (!this.tryAcquire(arg)) {
            this.acquire(null, arg, false, false, false, 0L);
        }
    }

    public final void acquireInterruptibly(int arg) throws InterruptedException {
        if (Thread.interrupted() || !this.tryAcquire(arg) && this.acquire(null, arg, false, true, false, 0L) < 0) {
            throw new InterruptedException();
        }
    }

    public final boolean tryAcquireNanos(int arg, long nanosTimeout) throws InterruptedException {
        if (!Thread.interrupted()) {
            if (this.tryAcquire(arg)) {
                return true;
            }
            if (nanosTimeout <= 0L) {
                return false;
            }
            int stat = this.acquire(null, arg, false, true, true, System.nanoTime() + nanosTimeout);
            if (stat > 0) {
                return true;
            }
            if (stat == 0) {
                return false;
            }
        }
        throw new InterruptedException();
    }

    public final boolean release(int arg) {
        if (this.tryRelease(arg)) {
            AbstractQueuedSynchronizer.signalNext(this.head);
            return true;
        }
        return false;
    }

    public final void acquireShared(int arg) {
        if (this.tryAcquireShared(arg) < 0) {
            this.acquire(null, arg, true, false, false, 0L);
        }
    }

    public final void acquireSharedInterruptibly(int arg) throws InterruptedException {
        if (Thread.interrupted() || this.tryAcquireShared(arg) < 0 && this.acquire(null, arg, true, true, false, 0L) < 0) {
            throw new InterruptedException();
        }
    }

    public final boolean tryAcquireSharedNanos(int arg, long nanosTimeout) throws InterruptedException {
        if (!Thread.interrupted()) {
            if (this.tryAcquireShared(arg) >= 0) {
                return true;
            }
            if (nanosTimeout <= 0L) {
                return false;
            }
            int stat = this.acquire(null, arg, true, true, true, System.nanoTime() + nanosTimeout);
            if (stat > 0) {
                return true;
            }
            if (stat == 0) {
                return false;
            }
        }
        throw new InterruptedException();
    }

    public final boolean releaseShared(int arg) {
        if (this.tryReleaseShared(arg)) {
            AbstractQueuedSynchronizer.signalNext(this.head);
            return true;
        }
        return false;
    }

    public final boolean hasQueuedThreads() {
        Node p = this.tail;
        Node h = this.head;
        while (p != h && p != null) {
            if (p.status >= 0) {
                return true;
            }
            p = p.prev;
        }
        return false;
    }

    public final boolean hasContended() {
        return this.head != null;
    }

    public final Thread getFirstQueuedThread() {
        Node s;
        Thread first = null;
        Node h = this.head;
        if (h != null && ((s = h.next) == null || (first = s.waiter) == null || s.prev == null)) {
            Node q;
            Node p = this.tail;
            while (p != null && (q = p.prev) != null) {
                Thread w = p.waiter;
                if (w != null) {
                    first = w;
                }
                p = q;
            }
        }
        return first;
    }

    public final boolean isQueued(Thread thread) {
        if (thread == null) {
            throw new NullPointerException();
        }
        Node p = this.tail;
        while (p != null) {
            if (p.waiter == thread) {
                return true;
            }
            p = p.prev;
        }
        return false;
    }

    final boolean apparentlyFirstQueuedIsExclusive() {
        Node s;
        Node h = this.head;
        return h != null && (s = h.next) != null && !(s instanceof SharedNode) && s.waiter != null;
    }

    public final boolean hasQueuedPredecessors() {
        Node s;
        Thread first = null;
        Node h = this.head;
        if (h != null && ((s = h.next) == null || (first = s.waiter) == null || s.prev == null)) {
            first = this.getFirstQueuedThread();
        }
        return first != null && first != Thread.currentThread();
    }

    public final int getQueueLength() {
        int n = 0;
        Node p = this.tail;
        while (p != null) {
            if (p.waiter != null) {
                ++n;
            }
            p = p.prev;
        }
        return n;
    }

    public final Collection<Thread> getQueuedThreads() {
        ArrayList<Thread> list = new ArrayList<Thread>();
        Node p = this.tail;
        while (p != null) {
            Thread t = p.waiter;
            if (t != null) {
                list.add(t);
            }
            p = p.prev;
        }
        return list;
    }

    public final Collection<Thread> getExclusiveQueuedThreads() {
        ArrayList<Thread> list = new ArrayList<Thread>();
        Node p = this.tail;
        while (p != null) {
            Thread t;
            if (!(p instanceof SharedNode) && (t = p.waiter) != null) {
                list.add(t);
            }
            p = p.prev;
        }
        return list;
    }

    public final Collection<Thread> getSharedQueuedThreads() {
        ArrayList<Thread> list = new ArrayList<Thread>();
        Node p = this.tail;
        while (p != null) {
            Thread t;
            if (p instanceof SharedNode && (t = p.waiter) != null) {
                list.add(t);
            }
            p = p.prev;
        }
        return list;
    }

    public String toString() {
        return super.toString() + "[State = " + this.getState() + ", " + (this.hasQueuedThreads() ? "non" : "") + "empty queue]";
    }

    public final boolean owns(ConditionObject condition) {
        return condition.isOwnedBy(this);
    }

    public final boolean hasWaiters(ConditionObject condition) {
        if (!this.owns(condition)) {
            throw new IllegalArgumentException("Not owner");
        }
        return condition.hasWaiters();
    }

    public final int getWaitQueueLength(ConditionObject condition) {
        if (!this.owns(condition)) {
            throw new IllegalArgumentException("Not owner");
        }
        return condition.getWaitQueueLength();
    }

    public final Collection<Thread> getWaitingThreads(ConditionObject condition) {
        if (!this.owns(condition)) {
            throw new IllegalArgumentException("Not owner");
        }
        return condition.getWaitingThreads();
    }

    static {
        Class<LockSupport> clazz = LockSupport.class;
    }

    static final class ExclusiveNode
    extends Node {
        ExclusiveNode() {
        }
    }

    static abstract class Node {
        volatile Node prev;
        volatile Node next;
        Thread waiter;
        volatile int status;
        private static final long STATUS = U.objectFieldOffset(Node.class, "status");
        private static final long NEXT = U.objectFieldOffset(Node.class, "next");
        private static final long PREV = U.objectFieldOffset(Node.class, "prev");

        Node() {
        }

        final boolean casPrev(Node c, Node v) {
            return U.weakCompareAndSetReference(this, PREV, c, v);
        }

        final boolean casNext(Node c, Node v) {
            return U.weakCompareAndSetReference(this, NEXT, c, v);
        }

        final int getAndUnsetStatus(int v) {
            return U.getAndBitwiseAndInt(this, STATUS, ~v);
        }

        final void setPrevRelaxed(Node p) {
            U.putReference(this, PREV, p);
        }

        final void setStatusRelaxed(int s) {
            U.putInt(this, STATUS, s);
        }

        final void clearStatus() {
            U.putIntOpaque(this, STATUS, 0);
        }
    }

    static final class SharedNode
    extends Node {
        SharedNode() {
        }
    }

    public class ConditionObject
    implements Condition,
    Serializable {
        private static final long serialVersionUID = 1173984872572414699L;
        private transient ConditionNode firstWaiter;
        private transient ConditionNode lastWaiter;

        private void doSignal(ConditionNode first, boolean all) {
            while (first != null) {
                ConditionNode next = first.nextWaiter;
                this.firstWaiter = next;
                if (this.firstWaiter == null) {
                    this.lastWaiter = null;
                }
                if ((first.getAndUnsetStatus(2) & 2) != 0) {
                    AbstractQueuedSynchronizer.this.enqueue(first);
                    if (!all) break;
                }
                first = next;
            }
        }

        @Override
        public final void signal() {
            ConditionNode first = this.firstWaiter;
            if (!AbstractQueuedSynchronizer.this.isHeldExclusively()) {
                throw new IllegalMonitorStateException();
            }
            if (first != null) {
                this.doSignal(first, false);
            }
        }

        @Override
        public final void signalAll() {
            ConditionNode first = this.firstWaiter;
            if (!AbstractQueuedSynchronizer.this.isHeldExclusively()) {
                throw new IllegalMonitorStateException();
            }
            if (first != null) {
                this.doSignal(first, true);
            }
        }

        private int enableWait(ConditionNode node) {
            if (AbstractQueuedSynchronizer.this.isHeldExclusively()) {
                node.waiter = Thread.currentThread();
                node.setStatusRelaxed(3);
                ConditionNode last = this.lastWaiter;
                if (last == null) {
                    this.firstWaiter = node;
                } else {
                    last.nextWaiter = node;
                }
                this.lastWaiter = node;
                int savedState = AbstractQueuedSynchronizer.this.getState();
                if (AbstractQueuedSynchronizer.this.release(savedState)) {
                    return savedState;
                }
            }
            node.status = Integer.MIN_VALUE;
            throw new IllegalMonitorStateException();
        }

        private boolean canReacquire(ConditionNode node) {
            return node != null && node.prev != null && AbstractQueuedSynchronizer.this.isEnqueued(node);
        }

        private void unlinkCancelledWaiters(ConditionNode node) {
            if (node == null || node.nextWaiter != null || node == this.lastWaiter) {
                ConditionNode w = this.firstWaiter;
                ConditionNode trail = null;
                while (w != null) {
                    ConditionNode next = w.nextWaiter;
                    if ((w.status & 2) == 0) {
                        w.nextWaiter = null;
                        if (trail == null) {
                            this.firstWaiter = next;
                        } else {
                            trail.nextWaiter = next;
                        }
                        if (next == null) {
                            this.lastWaiter = trail;
                        }
                    } else {
                        trail = w;
                    }
                    w = next;
                }
            }
        }

        @Override
        public final void awaitUninterruptibly() {
            ConditionNode node = new ConditionNode();
            int savedState = this.enableWait(node);
            LockSupport.setCurrentBlocker(this);
            boolean interrupted = false;
            boolean rejected = false;
            while (!this.canReacquire(node)) {
                if (Thread.interrupted()) {
                    interrupted = true;
                    continue;
                }
                if ((node.status & 2) != 0) {
                    try {
                        if (rejected) {
                            node.block();
                            continue;
                        }
                        ForkJoinPool.managedBlock(node);
                    }
                    catch (RejectedExecutionException ex) {
                        rejected = true;
                    }
                    catch (InterruptedException ie) {
                        interrupted = true;
                    }
                    continue;
                }
                Thread.onSpinWait();
            }
            LockSupport.setCurrentBlocker(null);
            node.clearStatus();
            AbstractQueuedSynchronizer.this.acquire(node, savedState, false, false, false, 0L);
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }

        @Override
        public final void await() throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            ConditionNode node = new ConditionNode();
            int savedState = this.enableWait(node);
            LockSupport.setCurrentBlocker(this);
            boolean interrupted = false;
            boolean cancelled = false;
            boolean rejected = false;
            while (!this.canReacquire(node)) {
                if (interrupted |= Thread.interrupted()) {
                    cancelled = (node.getAndUnsetStatus(2) & 2) != 0;
                    if (!cancelled) continue;
                    break;
                }
                if ((node.status & 2) != 0) {
                    try {
                        if (rejected) {
                            node.block();
                            continue;
                        }
                        ForkJoinPool.managedBlock(node);
                    }
                    catch (RejectedExecutionException ex) {
                        rejected = true;
                    }
                    catch (InterruptedException ie) {
                        interrupted = true;
                    }
                    continue;
                }
                Thread.onSpinWait();
            }
            LockSupport.setCurrentBlocker(null);
            node.clearStatus();
            AbstractQueuedSynchronizer.this.acquire(node, savedState, false, false, false, 0L);
            if (interrupted) {
                if (cancelled) {
                    this.unlinkCancelledWaiters(node);
                    throw new InterruptedException();
                }
                Thread.currentThread().interrupt();
            }
        }

        @Override
        public final long awaitNanos(long nanosTimeout) throws InterruptedException {
            long remaining;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            ConditionNode node = new ConditionNode();
            int savedState = this.enableWait(node);
            long nanos = nanosTimeout < 0L ? 0L : nanosTimeout;
            long deadline = System.nanoTime() + nanos;
            boolean cancelled = false;
            boolean interrupted = false;
            while (!this.canReacquire(node)) {
                if ((interrupted |= Thread.interrupted()) || (nanos = deadline - System.nanoTime()) <= 0L) {
                    cancelled = (node.getAndUnsetStatus(2) & 2) != 0;
                    if (!cancelled) continue;
                    break;
                }
                LockSupport.parkNanos(this, nanos);
            }
            node.clearStatus();
            AbstractQueuedSynchronizer.this.acquire(node, savedState, false, false, false, 0L);
            if (cancelled) {
                this.unlinkCancelledWaiters(node);
                if (interrupted) {
                    throw new InterruptedException();
                }
            } else if (interrupted) {
                Thread.currentThread().interrupt();
            }
            return (remaining = deadline - System.nanoTime()) <= nanosTimeout ? remaining : Long.MIN_VALUE;
        }

        @Override
        public final boolean awaitUntil(Date deadline) throws InterruptedException {
            long abstime = deadline.getTime();
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            ConditionNode node = new ConditionNode();
            int savedState = this.enableWait(node);
            boolean cancelled = false;
            boolean interrupted = false;
            while (!this.canReacquire(node)) {
                if ((interrupted |= Thread.interrupted()) || System.currentTimeMillis() >= abstime) {
                    cancelled = (node.getAndUnsetStatus(2) & 2) != 0;
                    if (!cancelled) continue;
                    break;
                }
                LockSupport.parkUntil(this, abstime);
            }
            node.clearStatus();
            AbstractQueuedSynchronizer.this.acquire(node, savedState, false, false, false, 0L);
            if (cancelled) {
                this.unlinkCancelledWaiters(node);
                if (interrupted) {
                    throw new InterruptedException();
                }
            } else if (interrupted) {
                Thread.currentThread().interrupt();
            }
            return !cancelled;
        }

        @Override
        public final boolean await(long time, TimeUnit unit) throws InterruptedException {
            long nanosTimeout = unit.toNanos(time);
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            ConditionNode node = new ConditionNode();
            int savedState = this.enableWait(node);
            long nanos = nanosTimeout < 0L ? 0L : nanosTimeout;
            long deadline = System.nanoTime() + nanos;
            boolean cancelled = false;
            boolean interrupted = false;
            while (!this.canReacquire(node)) {
                if ((interrupted |= Thread.interrupted()) || (nanos = deadline - System.nanoTime()) <= 0L) {
                    cancelled = (node.getAndUnsetStatus(2) & 2) != 0;
                    if (!cancelled) continue;
                    break;
                }
                LockSupport.parkNanos(this, nanos);
            }
            node.clearStatus();
            AbstractQueuedSynchronizer.this.acquire(node, savedState, false, false, false, 0L);
            if (cancelled) {
                this.unlinkCancelledWaiters(node);
                if (interrupted) {
                    throw new InterruptedException();
                }
            } else if (interrupted) {
                Thread.currentThread().interrupt();
            }
            return !cancelled;
        }

        final boolean isOwnedBy(AbstractQueuedSynchronizer sync) {
            return sync == AbstractQueuedSynchronizer.this;
        }

        protected final boolean hasWaiters() {
            if (!AbstractQueuedSynchronizer.this.isHeldExclusively()) {
                throw new IllegalMonitorStateException();
            }
            ConditionNode w = this.firstWaiter;
            while (w != null) {
                if ((w.status & 2) != 0) {
                    return true;
                }
                w = w.nextWaiter;
            }
            return false;
        }

        protected final int getWaitQueueLength() {
            if (!AbstractQueuedSynchronizer.this.isHeldExclusively()) {
                throw new IllegalMonitorStateException();
            }
            int n = 0;
            ConditionNode w = this.firstWaiter;
            while (w != null) {
                if ((w.status & 2) != 0) {
                    ++n;
                }
                w = w.nextWaiter;
            }
            return n;
        }

        protected final Collection<Thread> getWaitingThreads() {
            if (!AbstractQueuedSynchronizer.this.isHeldExclusively()) {
                throw new IllegalMonitorStateException();
            }
            ArrayList<Thread> list = new ArrayList<Thread>();
            ConditionNode w = this.firstWaiter;
            while (w != null) {
                Thread t;
                if ((w.status & 2) != 0 && (t = w.waiter) != null) {
                    list.add(t);
                }
                w = w.nextWaiter;
            }
            return list;
        }
    }

    static final class ConditionNode
    extends Node
    implements ForkJoinPool.ManagedBlocker {
        ConditionNode nextWaiter;

        ConditionNode() {
        }

        @Override
        public final boolean isReleasable() {
            return this.status <= 1 || Thread.currentThread().isInterrupted();
        }

        @Override
        public final boolean block() {
            while (!this.isReleasable()) {
                LockSupport.park();
            }
            return true;
        }
    }
}

