/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.locks;

import jdk.internal.misc.Unsafe;

public class LockSupport {
    private static final Unsafe U = Unsafe.getUnsafe();
    private static final long PARKBLOCKER = U.objectFieldOffset(Thread.class, "parkBlocker");
    private static final long TID = U.objectFieldOffset(Thread.class, "tid");

    private LockSupport() {
    }

    private static void setBlocker(Thread t, Object arg) {
        U.putReferenceOpaque(t, PARKBLOCKER, arg);
    }

    public static void setCurrentBlocker(Object blocker) {
        U.putReferenceOpaque(Thread.currentThread(), PARKBLOCKER, blocker);
    }

    public static void unpark(Thread thread) {
        if (thread != null) {
            U.unpark(thread);
        }
    }

    public static void park(Object blocker) {
        Thread t = Thread.currentThread();
        LockSupport.setBlocker(t, blocker);
        U.park(false, 0L);
        LockSupport.setBlocker(t, null);
    }

    public static void parkNanos(Object blocker, long nanos) {
        if (nanos > 0L) {
            Thread t = Thread.currentThread();
            LockSupport.setBlocker(t, blocker);
            U.park(false, nanos);
            LockSupport.setBlocker(t, null);
        }
    }

    public static void parkUntil(Object blocker, long deadline) {
        Thread t = Thread.currentThread();
        LockSupport.setBlocker(t, blocker);
        U.park(true, deadline);
        LockSupport.setBlocker(t, null);
    }

    public static Object getBlocker(Thread t) {
        if (t == null) {
            throw new NullPointerException();
        }
        return U.getReferenceOpaque(t, PARKBLOCKER);
    }

    public static void park() {
        U.park(false, 0L);
    }

    public static void parkNanos(long nanos) {
        if (nanos > 0L) {
            U.park(false, nanos);
        }
    }

    public static void parkUntil(long deadline) {
        U.park(true, deadline);
    }

    static final long getThreadId(Thread thread) {
        return U.getLong(thread, TID);
    }
}

