/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.jar.Manifest;
import jdk.internal.misc.CDS;
import jdk.internal.vm.annotation.Stable;
import sun.nio.cs.UTF_8;
import sun.util.logging.PlatformLogger;

public class Attributes
implements Map<Object, Object>,
Cloneable {
    protected Map<Object, Object> map;

    public Attributes() {
        this(11);
    }

    public Attributes(int size) {
        this.map = new LinkedHashMap<Object, Object>(size);
    }

    public Attributes(Attributes attr) {
        this.map = new LinkedHashMap<Object, Object>(attr);
    }

    @Override
    public Object get(Object name) {
        return this.map.get(name);
    }

    public String getValue(String name) {
        return (String)this.get(Name.of(name));
    }

    public String getValue(Name name) {
        return (String)this.get(name);
    }

    @Override
    public Object put(Object name, Object value) {
        return this.map.put((Name)name, (String)value);
    }

    public String putValue(String name, String value) {
        return (String)this.put(Name.of(name), value);
    }

    @Override
    public Object remove(Object name) {
        return this.map.remove(name);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public boolean containsKey(Object name) {
        return this.map.containsKey(name);
    }

    @Override
    public void putAll(Map<?, ?> attr) {
        if (!Attributes.class.isInstance(attr)) {
            throw new ClassCastException();
        }
        for (Map.Entry<?, ?> me : attr.entrySet()) {
            this.put(me.getKey(), me.getValue());
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<Object> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.map.equals(o);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    public Object clone() {
        return new Attributes(this);
    }

    void write(DataOutputStream out) throws IOException {
        StringBuilder buffer = new StringBuilder(72);
        for (Map.Entry<Object, Object> e : this.entrySet()) {
            buffer.setLength(0);
            buffer.append(e.getKey().toString());
            buffer.append(": ");
            buffer.append(e.getValue());
            Manifest.println72(out, buffer.toString());
        }
        Manifest.println(out);
    }

    void writeMain(DataOutputStream out) throws IOException {
        StringBuilder buffer = new StringBuilder(72);
        String vername = Name.MANIFEST_VERSION.toString();
        String version = this.getValue(vername);
        if (version == null) {
            vername = Name.SIGNATURE_VERSION.toString();
            version = this.getValue(vername);
        }
        if (version != null) {
            buffer.append(vername);
            buffer.append(": ");
            buffer.append(version);
            out.write(buffer.toString().getBytes(UTF_8.INSTANCE));
            Manifest.println(out);
        }
        for (Map.Entry<Object, Object> e : this.entrySet()) {
            String name = ((Name)e.getKey()).toString();
            if (version == null || name.equalsIgnoreCase(vername)) continue;
            buffer.setLength(0);
            buffer.append(name);
            buffer.append(": ");
            buffer.append(e.getValue());
            Manifest.println72(out, buffer.toString());
        }
        Manifest.println(out);
    }

    void read(Manifest.FastInputStream is, byte[] lbuf) throws IOException {
        this.read(is, lbuf, null, 0);
    }

    int read(Manifest.FastInputStream is, byte[] lbuf, String filename, int lineNumber) throws IOException {
        int len;
        String name = null;
        ByteArrayOutputStream fullLine = new ByteArrayOutputStream();
        while ((len = is.readLine(lbuf)) != -1) {
            String value;
            boolean lineContinued = false;
            byte c = lbuf[--len];
            ++lineNumber;
            if (c != 10 && c != 13) {
                throw new IOException("line too long (" + Manifest.getErrorPosition(filename, lineNumber) + ")");
            }
            if (len > 0 && lbuf[len - 1] == 13) {
                --len;
            }
            if (len == 0) break;
            int i = 0;
            if (lbuf[0] == 32) {
                if (name == null) {
                    throw new IOException("misplaced continuation line (" + Manifest.getErrorPosition(filename, lineNumber) + ")");
                }
                lineContinued = true;
                fullLine.write(lbuf, 1, len - 1);
                if (is.peek() == 32) continue;
                value = fullLine.toString(UTF_8.INSTANCE);
                fullLine.reset();
            } else {
                while (lbuf[i++] != 58) {
                    if (i < len) continue;
                    throw new IOException("invalid header field (" + Manifest.getErrorPosition(filename, lineNumber) + ")");
                }
                if (lbuf[i++] != 32) {
                    throw new IOException("invalid header field (" + Manifest.getErrorPosition(filename, lineNumber) + ")");
                }
                name = new String(lbuf, 0, i - 2, UTF_8.INSTANCE);
                if (is.peek() == 32) {
                    fullLine.reset();
                    fullLine.write(lbuf, i, len - i);
                    continue;
                }
                value = new String(lbuf, i, len - i, UTF_8.INSTANCE);
            }
            try {
                if (this.putValue(name, value) == null || lineContinued) continue;
                PlatformLogger.getLogger("java.util.jar").warning("Duplicate name in Manifest: " + name + ".\nEnsure that the manifest does not have duplicate entries, and\nthat blank lines separate individual sections in both your\nmanifest and in the META-INF/MANIFEST.MF entry in the jar file.");
            }
            catch (IllegalArgumentException e) {
                throw new IOException("invalid header field name: " + name + " (" + Manifest.getErrorPosition(filename, lineNumber) + ")");
            }
        }
        return lineNumber;
    }

    public static class Name {
        private final String name;
        private final int hashCode;
        @Stable
        private static Map<String, Name> KNOWN_NAMES;
        public static final Name MANIFEST_VERSION;
        public static final Name SIGNATURE_VERSION;
        public static final Name CONTENT_TYPE;
        public static final Name CLASS_PATH;
        public static final Name MAIN_CLASS;
        public static final Name SEALED;
        public static final Name EXTENSION_LIST;
        public static final Name EXTENSION_NAME;
        @Deprecated
        public static final Name EXTENSION_INSTALLATION;
        public static final Name IMPLEMENTATION_TITLE;
        public static final Name IMPLEMENTATION_VERSION;
        public static final Name IMPLEMENTATION_VENDOR;
        @Deprecated
        public static final Name IMPLEMENTATION_VENDOR_ID;
        @Deprecated
        public static final Name IMPLEMENTATION_URL;
        public static final Name SPECIFICATION_TITLE;
        public static final Name SPECIFICATION_VERSION;
        public static final Name SPECIFICATION_VENDOR;
        public static final Name MULTI_RELEASE;

        static final Name of(String name) {
            Name n = KNOWN_NAMES.get(name);
            if (n != null) {
                return n;
            }
            return new Name(name);
        }

        public Name(String name) {
            this.hashCode = this.hash(name);
            this.name = name.intern();
        }

        private final int hash(String name) {
            Objects.requireNonNull(name, "name");
            int len = name.length();
            if (len > 70 || len == 0) {
                throw new IllegalArgumentException(name);
            }
            int h = 0;
            for (int i = 0; i < len; ++i) {
                char c = name.charAt(i);
                if (c >= 'a' && c <= 'z') {
                    h = h * 31 + (c - 32);
                    continue;
                }
                if (c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_' || c == '-') {
                    h = h * 31 + c;
                    continue;
                }
                throw new IllegalArgumentException(name);
            }
            return h;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Name)) return false;
            Name other = (Name)o;
            if (!other.name.equalsIgnoreCase(this.name)) return false;
            return true;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return this.name;
        }

        private static void addName(Map<String, Name> names, Name name) {
            names.put(name.name, name);
        }

        static {
            CDS.initializeFromArchive(Name.class);
            if (KNOWN_NAMES == null) {
                MANIFEST_VERSION = new Name("Manifest-Version");
                SIGNATURE_VERSION = new Name("Signature-Version");
                CONTENT_TYPE = new Name("Content-Type");
                CLASS_PATH = new Name("Class-Path");
                MAIN_CLASS = new Name("Main-Class");
                SEALED = new Name("Sealed");
                EXTENSION_LIST = new Name("Extension-List");
                EXTENSION_NAME = new Name("Extension-Name");
                EXTENSION_INSTALLATION = new Name("Extension-Installation");
                IMPLEMENTATION_TITLE = new Name("Implementation-Title");
                IMPLEMENTATION_VERSION = new Name("Implementation-Version");
                IMPLEMENTATION_VENDOR = new Name("Implementation-Vendor");
                IMPLEMENTATION_VENDOR_ID = new Name("Implementation-Vendor-Id");
                IMPLEMENTATION_URL = new Name("Implementation-URL");
                SPECIFICATION_TITLE = new Name("Specification-Title");
                SPECIFICATION_VERSION = new Name("Specification-Version");
                SPECIFICATION_VENDOR = new Name("Specification-Vendor");
                MULTI_RELEASE = new Name("Multi-Release");
                HashMap<String, Name> names = new HashMap<String, Name>(64);
                Name.addName(names, MANIFEST_VERSION);
                Name.addName(names, SIGNATURE_VERSION);
                Name.addName(names, CONTENT_TYPE);
                Name.addName(names, CLASS_PATH);
                Name.addName(names, MAIN_CLASS);
                Name.addName(names, SEALED);
                Name.addName(names, EXTENSION_LIST);
                Name.addName(names, EXTENSION_NAME);
                Name.addName(names, EXTENSION_INSTALLATION);
                Name.addName(names, IMPLEMENTATION_TITLE);
                Name.addName(names, IMPLEMENTATION_VERSION);
                Name.addName(names, IMPLEMENTATION_VENDOR);
                Name.addName(names, IMPLEMENTATION_VENDOR_ID);
                Name.addName(names, IMPLEMENTATION_URL);
                Name.addName(names, SPECIFICATION_TITLE);
                Name.addName(names, SPECIFICATION_VERSION);
                Name.addName(names, SPECIFICATION_VENDOR);
                Name.addName(names, MULTI_RELEASE);
                Name.addName(names, new Name("Add-Exports"));
                Name.addName(names, new Name("Add-Opens"));
                Name.addName(names, new Name("Launcher-Agent-Class"));
                Name.addName(names, new Name("JavaFX-Application-Class"));
                Name.addName(names, new Name("Name"));
                Name.addName(names, new Name("Created-By"));
                Name.addName(names, new Name("SHA1-Digest"));
                Name.addName(names, new Name("SHA-256-Digest"));
                KNOWN_NAMES = Map.copyOf(names);
            } else {
                MANIFEST_VERSION = KNOWN_NAMES.get("Manifest-Version");
                SIGNATURE_VERSION = KNOWN_NAMES.get("Signature-Version");
                CONTENT_TYPE = KNOWN_NAMES.get("Content-Type");
                CLASS_PATH = KNOWN_NAMES.get("Class-Path");
                MAIN_CLASS = KNOWN_NAMES.get("Main-Class");
                SEALED = KNOWN_NAMES.get("Sealed");
                EXTENSION_LIST = KNOWN_NAMES.get("Extension-List");
                EXTENSION_NAME = KNOWN_NAMES.get("Extension-Name");
                EXTENSION_INSTALLATION = KNOWN_NAMES.get("Extension-Installation");
                IMPLEMENTATION_TITLE = KNOWN_NAMES.get("Implementation-Title");
                IMPLEMENTATION_VERSION = KNOWN_NAMES.get("Implementation-Version");
                IMPLEMENTATION_VENDOR = KNOWN_NAMES.get("Implementation-Vendor");
                IMPLEMENTATION_VENDOR_ID = KNOWN_NAMES.get("Implementation-Vendor-Id");
                IMPLEMENTATION_URL = KNOWN_NAMES.get("Implementation-URL");
                SPECIFICATION_TITLE = KNOWN_NAMES.get("Specification-Title");
                SPECIFICATION_VERSION = KNOWN_NAMES.get("Specification-Version");
                SPECIFICATION_VENDOR = KNOWN_NAMES.get("Specification-Vendor");
                MULTI_RELEASE = KNOWN_NAMES.get("Multi-Release");
            }
        }
    }
}

