/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarVerifier;
import sun.nio.cs.UTF_8;
import sun.security.util.SecurityProperties;

public class Manifest
implements Cloneable {
    private final Attributes attr = new Attributes();
    private final Map<String, Attributes> entries = new HashMap<String, Attributes>();
    private final JarVerifier jv;

    public Manifest() {
        this.jv = null;
    }

    public Manifest(InputStream is) throws IOException {
        this(null, is, null);
    }

    Manifest(InputStream is, String jarFilename) throws IOException {
        this(null, is, jarFilename);
    }

    Manifest(JarVerifier jv, InputStream is, String jarFilename) throws IOException {
        this.read(is, jarFilename);
        this.jv = jv;
    }

    public Manifest(Manifest man) {
        this.attr.putAll((Map<?, ?>)man.getMainAttributes());
        this.entries.putAll(man.getEntries());
        this.jv = man.jv;
    }

    public Attributes getMainAttributes() {
        return this.attr;
    }

    public Map<String, Attributes> getEntries() {
        return this.entries;
    }

    public Attributes getAttributes(String name) {
        return this.getEntries().get(name);
    }

    Attributes getTrustedAttributes(String name) {
        Attributes result = this.getAttributes(name);
        if (result != null && this.jv != null && !this.jv.isTrustedManifestEntry(name)) {
            throw new SecurityException("Untrusted manifest entry: " + name);
        }
        return result;
    }

    public void clear() {
        this.attr.clear();
        this.entries.clear();
    }

    public void write(OutputStream out) throws IOException {
        DataOutputStream dos = new DataOutputStream(out);
        this.attr.writeMain(dos);
        StringBuilder buffer = this.entries.isEmpty() ? null : new StringBuilder(72);
        for (Map.Entry<String, Attributes> e : this.entries.entrySet()) {
            buffer.setLength(0);
            buffer.append("Name: ");
            buffer.append(e.getKey());
            Manifest.println72(dos, buffer.toString());
            e.getValue().write(dos);
        }
        dos.flush();
    }

    @Deprecated(since="13")
    static void make72Safe(StringBuffer line) {
        int length = line.length();
        for (int index = 72; index < length; index += 74, length += 3) {
            line.insert(index, "\r\n ");
        }
    }

    static void println72(OutputStream out, String line) throws IOException {
        if (!line.isEmpty()) {
            byte[] lineBytes = line.getBytes(UTF_8.INSTANCE);
            int length = lineBytes.length;
            out.write(lineBytes[0]);
            int pos = 1;
            while (length - pos > 71) {
                out.write(lineBytes, pos, 71);
                pos += 71;
                Manifest.println(out);
                out.write(32);
            }
            out.write(lineBytes, pos, length - pos);
        }
        Manifest.println(out);
    }

    static void println(OutputStream out) throws IOException {
        out.write(13);
        out.write(10);
    }

    static String getErrorPosition(String filename, int lineNumber) {
        if (filename == null || !SecurityProperties.INCLUDE_JAR_NAME_IN_EXCEPTIONS) {
            return "line " + lineNumber;
        }
        return "manifest of " + filename + ":" + lineNumber;
    }

    public void read(InputStream is) throws IOException {
        this.read(is, null);
    }

    private void read(InputStream is, String jarFilename) throws IOException {
        int len;
        FastInputStream fis = new FastInputStream(is);
        byte[] lbuf = new byte[512];
        int lineNumber = this.attr.read(fis, lbuf, jarFilename, 0);
        int ecount = 0;
        int acount = 0;
        int asize = 2;
        String name = null;
        boolean skipEmptyLines = true;
        byte[] lastline = null;
        while ((len = fis.readLine(lbuf)) != -1) {
            Attributes attr;
            byte c = lbuf[--len];
            ++lineNumber;
            if (c != 10 && c != 13) {
                throw new IOException("manifest line too long (" + Manifest.getErrorPosition(jarFilename, lineNumber) + ")");
            }
            if (len > 0 && lbuf[len - 1] == 13) {
                --len;
            }
            if (len == 0 && skipEmptyLines) continue;
            skipEmptyLines = false;
            if (name == null) {
                name = this.parseName(lbuf, len);
                if (name == null) {
                    throw new IOException("invalid manifest format (" + Manifest.getErrorPosition(jarFilename, lineNumber) + ")");
                }
                if (fis.peek() == 32) {
                    lastline = new byte[len - 6];
                    System.arraycopy(lbuf, 6, lastline, 0, len - 6);
                    continue;
                }
            } else {
                byte[] buf = new byte[lastline.length + len - 1];
                System.arraycopy(lastline, 0, buf, 0, lastline.length);
                System.arraycopy(lbuf, 1, buf, lastline.length, len - 1);
                if (fis.peek() == 32) {
                    lastline = buf;
                    continue;
                }
                name = new String(buf, 0, buf.length, UTF_8.INSTANCE);
                lastline = null;
            }
            if ((attr = this.getAttributes(name)) == null) {
                attr = new Attributes(asize);
                this.entries.put(name, attr);
            }
            lineNumber = attr.read(fis, lbuf, jarFilename, lineNumber);
            asize = Math.max(2, (acount += attr.size()) / ++ecount);
            name = null;
            skipEmptyLines = true;
        }
    }

    private String parseName(byte[] lbuf, int len) {
        if (this.toLower(lbuf[0]) == 110 && this.toLower(lbuf[1]) == 97 && this.toLower(lbuf[2]) == 109 && this.toLower(lbuf[3]) == 101 && lbuf[4] == 58 && lbuf[5] == 32) {
            return new String(lbuf, 6, len - 6, UTF_8.INSTANCE);
        }
        return null;
    }

    private int toLower(int c) {
        return c >= 65 && c <= 90 ? 97 + (c - 65) : c;
    }

    public boolean equals(Object o) {
        Manifest m;
        return o instanceof Manifest && this.attr.equals((m = (Manifest)o).getMainAttributes()) && this.entries.equals(m.getEntries());
    }

    public int hashCode() {
        return this.attr.hashCode() + this.entries.hashCode();
    }

    public Object clone() {
        return new Manifest(this);
    }

    static class FastInputStream
    extends FilterInputStream {
        private byte[] buf;
        private int count = 0;
        private int pos = 0;

        FastInputStream(InputStream in) {
            this(in, 8192);
        }

        FastInputStream(InputStream in, int size) {
            super(in);
            this.buf = new byte[size];
        }

        @Override
        public int read() throws IOException {
            if (this.pos >= this.count) {
                this.fill();
                if (this.pos >= this.count) {
                    return -1;
                }
            }
            return Byte.toUnsignedInt(this.buf[this.pos++]);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int avail = this.count - this.pos;
            if (avail <= 0) {
                if (len >= this.buf.length) {
                    return this.in.read(b, off, len);
                }
                this.fill();
                avail = this.count - this.pos;
                if (avail <= 0) {
                    return -1;
                }
            }
            if (len > avail) {
                len = avail;
            }
            System.arraycopy(this.buf, this.pos, b, off, len);
            this.pos += len;
            return len;
        }

        public int readLine(byte[] b, int off, int len) throws IOException {
            int total;
            int n;
            byte[] tbuf = this.buf;
            for (total = 0; total < len; total += n) {
                int avail = this.count - this.pos;
                if (avail <= 0) {
                    this.fill();
                    avail = this.count - this.pos;
                    if (avail <= 0) {
                        return -1;
                    }
                }
                if ((n = len - total) > avail) {
                    n = avail;
                }
                int tpos = this.pos;
                int maxpos = tpos + n;
                int c = 0;
                while (tpos < maxpos && (c = tbuf[tpos++]) != 10 && c != 13) {
                }
                if (c == 13 && tpos < maxpos && tbuf[tpos] == 10) {
                    ++tpos;
                }
                n = tpos - this.pos;
                System.arraycopy(tbuf, this.pos, b, off, n);
                off += n;
                this.pos = tpos;
                c = tbuf[tpos - 1];
                if (c == 10) break;
                if (c != 13) continue;
                if (this.count != this.pos) break;
                this.fill();
                if (this.pos >= this.count || tbuf[this.pos] != 10) break;
                if (total < len) {
                    b[off++] = 10;
                    ++total;
                } else {
                    b[off - 1] = 10;
                }
                ++this.pos;
                break;
            }
            return total;
        }

        public byte peek() throws IOException {
            if (this.pos == this.count) {
                this.fill();
            }
            if (this.pos == this.count) {
                return -1;
            }
            return this.buf[this.pos];
        }

        public int readLine(byte[] b) throws IOException {
            return this.readLine(b, 0, b.length);
        }

        @Override
        public long skip(long n) throws IOException {
            if (n <= 0L) {
                return 0L;
            }
            long avail = this.count - this.pos;
            if (avail <= 0L) {
                return this.in.skip(n);
            }
            if (n > avail) {
                n = avail;
            }
            this.pos = (int)((long)this.pos + n);
            return n;
        }

        @Override
        public int available() throws IOException {
            return this.count - this.pos + this.in.available();
        }

        @Override
        public void close() throws IOException {
            if (this.in != null) {
                this.in.close();
                this.in = null;
                this.buf = null;
            }
        }

        private void fill() throws IOException {
            this.pos = 0;
            this.count = 0;
            int n = this.in.read(this.buf, 0, this.buf.length);
            if (n > 0) {
                this.count = n;
            }
        }
    }
}

