/*
 * Decompiled with CFR 0.152.
 */
package java.util.random;

import java.util.Objects;
import java.util.random.RandomGeneratorFactory;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import jdk.internal.util.random.RandomSupport;

public interface RandomGenerator {
    public static RandomGenerator of(String name) {
        Objects.requireNonNull(name);
        return RandomGeneratorFactory.of(name, RandomGenerator.class);
    }

    public static RandomGenerator getDefault() {
        return RandomGenerator.of("L32X64MixRandom");
    }

    default public boolean isDeprecated() {
        return this.getClass().isAnnotationPresent(Deprecated.class);
    }

    default public DoubleStream doubles() {
        return DoubleStream.generate(this::nextDouble).sequential();
    }

    default public DoubleStream doubles(double randomNumberOrigin, double randomNumberBound) {
        RandomSupport.checkRange(randomNumberOrigin, randomNumberBound);
        return DoubleStream.generate(() -> this.nextDouble(randomNumberOrigin, randomNumberBound)).sequential();
    }

    default public DoubleStream doubles(long streamSize) {
        RandomSupport.checkStreamSize(streamSize);
        return this.doubles().limit(streamSize);
    }

    default public DoubleStream doubles(long streamSize, double randomNumberOrigin, double randomNumberBound) {
        RandomSupport.checkStreamSize(streamSize);
        RandomSupport.checkRange(randomNumberOrigin, randomNumberBound);
        return this.doubles(randomNumberOrigin, randomNumberBound).limit(streamSize);
    }

    default public IntStream ints() {
        return IntStream.generate(this::nextInt).sequential();
    }

    default public IntStream ints(int randomNumberOrigin, int randomNumberBound) {
        RandomSupport.checkRange(randomNumberOrigin, randomNumberBound);
        return IntStream.generate(() -> this.nextInt(randomNumberOrigin, randomNumberBound)).sequential();
    }

    default public IntStream ints(long streamSize) {
        RandomSupport.checkStreamSize(streamSize);
        return this.ints().limit(streamSize);
    }

    default public IntStream ints(long streamSize, int randomNumberOrigin, int randomNumberBound) {
        RandomSupport.checkStreamSize(streamSize);
        RandomSupport.checkRange(randomNumberOrigin, randomNumberBound);
        return this.ints(randomNumberOrigin, randomNumberBound).limit(streamSize);
    }

    default public LongStream longs() {
        return LongStream.generate(this::nextLong).sequential();
    }

    default public LongStream longs(long randomNumberOrigin, long randomNumberBound) {
        RandomSupport.checkRange(randomNumberOrigin, randomNumberBound);
        return LongStream.generate(() -> this.nextLong(randomNumberOrigin, randomNumberBound)).sequential();
    }

    default public LongStream longs(long streamSize) {
        RandomSupport.checkStreamSize(streamSize);
        return this.longs().limit(streamSize);
    }

    default public LongStream longs(long streamSize, long randomNumberOrigin, long randomNumberBound) {
        RandomSupport.checkStreamSize(streamSize);
        RandomSupport.checkRange(randomNumberOrigin, randomNumberBound);
        return this.longs(randomNumberOrigin, randomNumberBound).limit(streamSize);
    }

    default public boolean nextBoolean() {
        return this.nextInt() < 0;
    }

    default public void nextBytes(byte[] bytes) {
        int i = 0;
        int len = bytes.length;
        int words = len >> 3;
        while (words-- > 0) {
            long rnd = this.nextLong();
            int n = 8;
            while (n-- > 0) {
                bytes[i++] = (byte)rnd;
                rnd >>>= 8;
            }
        }
        if (i < len) {
            long rnd = this.nextLong();
            while (i < len) {
                bytes[i++] = (byte)rnd;
                rnd >>>= 8;
            }
        }
    }

    default public float nextFloat() {
        return (float)(this.nextInt() >>> 8) * 5.9604645E-8f;
    }

    default public float nextFloat(float bound) {
        RandomSupport.checkBound(bound);
        return RandomSupport.boundedNextFloat(this, bound);
    }

    default public float nextFloat(float origin, float bound) {
        RandomSupport.checkRange(origin, bound);
        return RandomSupport.boundedNextFloat(this, origin, bound);
    }

    default public double nextDouble() {
        return (double)(this.nextLong() >>> 11) * (double)1.110223E-16f;
    }

    default public double nextDouble(double bound) {
        RandomSupport.checkBound(bound);
        return RandomSupport.boundedNextDouble(this, bound);
    }

    default public double nextDouble(double origin, double bound) {
        RandomSupport.checkRange(origin, bound);
        return RandomSupport.boundedNextDouble(this, origin, bound);
    }

    default public int nextInt() {
        return (int)(this.nextLong() >>> 32);
    }

    default public int nextInt(int bound) {
        RandomSupport.checkBound(bound);
        return RandomSupport.boundedNextInt(this, bound);
    }

    default public int nextInt(int origin, int bound) {
        RandomSupport.checkRange(origin, bound);
        return RandomSupport.boundedNextInt(this, origin, bound);
    }

    public long nextLong();

    default public long nextLong(long bound) {
        RandomSupport.checkBound(bound);
        return RandomSupport.boundedNextLong(this, bound);
    }

    default public long nextLong(long origin, long bound) {
        RandomSupport.checkRange(origin, bound);
        return RandomSupport.boundedNextLong(this, origin, bound);
    }

    default public double nextGaussian() {
        return RandomSupport.computeNextGaussian(this);
    }

    default public double nextGaussian(double mean, double stddev) {
        if (stddev < 0.0) {
            throw new IllegalArgumentException("standard deviation must be non-negative");
        }
        return mean + stddev * RandomSupport.computeNextGaussian(this);
    }

    default public double nextExponential() {
        return RandomSupport.computeNextExponential(this);
    }

    public static interface ArbitrarilyJumpableGenerator
    extends LeapableGenerator {
        public static ArbitrarilyJumpableGenerator of(String name) {
            Objects.requireNonNull(name);
            return RandomGeneratorFactory.of(name, ArbitrarilyJumpableGenerator.class);
        }

        @Override
        public ArbitrarilyJumpableGenerator copy();

        public void jumpPowerOfTwo(int var1);

        public void jump(double var1);

        @Override
        default public void jump() {
            this.jump(this.jumpDistance());
        }

        default public Stream<ArbitrarilyJumpableGenerator> jumps(double distance) {
            return (Stream)Stream.generate(() -> this.copyAndJump(distance)).sequential();
        }

        default public Stream<ArbitrarilyJumpableGenerator> jumps(long streamSize, double distance) {
            return this.jumps(distance).limit(streamSize);
        }

        @Override
        default public void leap() {
            this.jump(this.leapDistance());
        }

        default public ArbitrarilyJumpableGenerator copyAndJump(double distance) {
            ArbitrarilyJumpableGenerator result = this.copy();
            this.jump(distance);
            return result;
        }
    }

    public static interface LeapableGenerator
    extends JumpableGenerator {
        public static LeapableGenerator of(String name) {
            Objects.requireNonNull(name);
            return RandomGeneratorFactory.of(name, LeapableGenerator.class);
        }

        @Override
        public LeapableGenerator copy();

        public void leap();

        public double leapDistance();

        default public Stream<JumpableGenerator> leaps() {
            return (Stream)Stream.generate(this::copyAndLeap).sequential();
        }

        default public Stream<JumpableGenerator> leaps(long streamSize) {
            return this.leaps().limit(streamSize);
        }

        default public JumpableGenerator copyAndLeap() {
            LeapableGenerator result = this.copy();
            this.leap();
            return result;
        }
    }

    public static interface JumpableGenerator
    extends StreamableGenerator {
        public static JumpableGenerator of(String name) {
            Objects.requireNonNull(name);
            return RandomGeneratorFactory.of(name, JumpableGenerator.class);
        }

        public JumpableGenerator copy();

        public void jump();

        public double jumpDistance();

        default public Stream<RandomGenerator> jumps() {
            return (Stream)Stream.generate(this::copyAndJump).sequential();
        }

        default public Stream<RandomGenerator> jumps(long streamSize) {
            return this.jumps().limit(streamSize);
        }

        @Override
        default public Stream<RandomGenerator> rngs() {
            return this.jumps();
        }

        @Override
        default public Stream<RandomGenerator> rngs(long streamSize) {
            return this.jumps(streamSize);
        }

        default public RandomGenerator copyAndJump() {
            JumpableGenerator result = this.copy();
            this.jump();
            return result;
        }
    }

    public static interface SplittableGenerator
    extends StreamableGenerator {
        public static SplittableGenerator of(String name) {
            Objects.requireNonNull(name);
            return RandomGeneratorFactory.of(name, SplittableGenerator.class);
        }

        public SplittableGenerator split();

        public SplittableGenerator split(SplittableGenerator var1);

        default public Stream<SplittableGenerator> splits() {
            return this.splits(this);
        }

        public Stream<SplittableGenerator> splits(long var1);

        public Stream<SplittableGenerator> splits(SplittableGenerator var1);

        public Stream<SplittableGenerator> splits(long var1, SplittableGenerator var3);

        @Override
        default public Stream<RandomGenerator> rngs() {
            return this.splits().map(x -> x);
        }

        @Override
        default public Stream<RandomGenerator> rngs(long streamSize) {
            return this.splits(streamSize).map(x -> x);
        }
    }

    public static interface StreamableGenerator
    extends RandomGenerator {
        public static StreamableGenerator of(String name) {
            Objects.requireNonNull(name);
            return RandomGeneratorFactory.of(name, StreamableGenerator.class);
        }

        public Stream<RandomGenerator> rngs();

        default public Stream<RandomGenerator> rngs(long streamSize) {
            RandomSupport.checkStreamSize(streamSize);
            return this.rngs().limit(streamSize);
        }
    }
}

