/*
 * Decompiled with CFR 0.152.
 */
package java.util.random;

import java.lang.reflect.Constructor;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.random.RandomGenerator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdk.internal.util.random.RandomSupport;

public final class RandomGeneratorFactory<T extends RandomGenerator> {
    private final ServiceLoader.Provider<? extends RandomGenerator> provider;
    private volatile RandomSupport.RandomGeneratorProperties properties;
    private volatile Constructor<T> ctor;
    private Constructor<T> ctorLong;
    private Constructor<T> ctorBytes;

    private RandomGeneratorFactory(ServiceLoader.Provider<? extends RandomGenerator> provider) {
        this.provider = provider;
    }

    private static Map<String, ServiceLoader.Provider<? extends RandomGenerator>> getFactoryMap() {
        return FactoryMapHolder.FACTORY_MAP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RandomSupport.RandomGeneratorProperties getProperties() {
        if (this.properties == null) {
            ServiceLoader.Provider<? extends RandomGenerator> provider = this.provider;
            synchronized (provider) {
                if (this.properties == null) {
                    this.properties = this.provider.type().getDeclaredAnnotation(RandomSupport.RandomGeneratorProperties.class);
                    Objects.requireNonNull(this.properties, this.provider.type() + " missing annotation");
                }
            }
        }
        return this.properties;
    }

    private boolean isSubclass(Class<? extends RandomGenerator> category) {
        return RandomGeneratorFactory.isSubclass(category, this.provider);
    }

    private static boolean isSubclass(Class<? extends RandomGenerator> category, ServiceLoader.Provider<? extends RandomGenerator> provider) {
        return provider != null && category.isAssignableFrom(provider.type());
    }

    private static ServiceLoader.Provider<? extends RandomGenerator> findProvider(String name, Class<? extends RandomGenerator> category) throws IllegalArgumentException {
        Map<String, ServiceLoader.Provider<RandomGenerator>> fm = RandomGeneratorFactory.getFactoryMap();
        ServiceLoader.Provider<RandomGenerator> provider = fm.get(name);
        if (provider == null) {
            throw new IllegalArgumentException("No implementation of the random number generator algorithm \"" + name + "\" is available");
        }
        if (!RandomGeneratorFactory.isSubclass(category, provider)) {
            throw new IllegalArgumentException("The random number generator algorithm \"" + name + "\" is not implemented with the interface \"" + category.getSimpleName() + "\"");
        }
        return provider;
    }

    static <T extends RandomGenerator> T of(String name, Class<T> category) throws IllegalArgumentException {
        RandomGenerator uncheckedRandomGenerator = RandomGeneratorFactory.findProvider(name, category).get();
        return (T)uncheckedRandomGenerator;
    }

    static <T extends RandomGenerator> RandomGeneratorFactory<T> factoryOf(String name, Class<T> category) throws IllegalArgumentException {
        ServiceLoader.Provider<RandomGenerator> uncheckedProvider = RandomGeneratorFactory.findProvider(name, category);
        return new RandomGeneratorFactory<T>(uncheckedProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getConstructors(Class<? extends RandomGenerator> randomGeneratorClass) {
        if (this.ctor == null) {
            ServiceLoader.Provider<? extends RandomGenerator> provider = this.provider;
            synchronized (provider) {
                if (this.ctor == null) {
                    PrivilegedExceptionAction<Constructor[]> ctorAction = randomGeneratorClass::getConstructors;
                    try {
                        Constructor[] ctors = AccessController.doPrivileged(ctorAction);
                        Constructor tmpCtor = null;
                        Constructor tmpCtorLong = null;
                        Constructor tmpCtorBytes = null;
                        for (Constructor ctorGeneric : ctors) {
                            Constructor ctorSpecific = ctorGeneric;
                            Class<?>[] parameterTypes = ctorSpecific.getParameterTypes();
                            if (parameterTypes.length == 0) {
                                tmpCtor = ctorSpecific;
                                continue;
                            }
                            if (parameterTypes.length != 1) continue;
                            Class<?> argType = parameterTypes[0];
                            if (argType == Long.TYPE) {
                                tmpCtorLong = ctorSpecific;
                                continue;
                            }
                            if (argType != byte[].class) continue;
                            tmpCtorBytes = ctorSpecific;
                        }
                        if (tmpCtor == null) {
                            throw new IllegalStateException("Random algorithm " + this.name() + " is missing a default constructor");
                        }
                        this.ctorBytes = tmpCtorBytes;
                        this.ctorLong = tmpCtorLong;
                        this.ctor = tmpCtor;
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private void ensureConstructors() {
        this.getConstructors(this.provider.type());
    }

    public static <T extends RandomGenerator> RandomGeneratorFactory<T> of(String name) {
        Objects.requireNonNull(name);
        RandomGeneratorFactory<RandomGenerator> factory = RandomGeneratorFactory.factoryOf(name, RandomGenerator.class);
        return factory;
    }

    public static RandomGeneratorFactory<RandomGenerator> getDefault() {
        return RandomGeneratorFactory.factoryOf("L32X64MixRandom", RandomGenerator.class);
    }

    public static Stream<RandomGeneratorFactory<RandomGenerator>> all() {
        Map<String, ServiceLoader.Provider<RandomGenerator>> fm = RandomGeneratorFactory.getFactoryMap();
        return fm.values().stream().filter(p -> !p.type().isAnnotationPresent(Deprecated.class) && p.type().isAnnotationPresent(RandomSupport.RandomGeneratorProperties.class)).map(RandomGeneratorFactory::new);
    }

    public String name() {
        return this.provider.type().getSimpleName();
    }

    public String group() {
        return this.getProperties().group();
    }

    public int stateBits() {
        RandomSupport.RandomGeneratorProperties properties = this.getProperties();
        int i = properties.i();
        int k = properties.k();
        return i == 0 && k == 0 ? Integer.MAX_VALUE : i + k;
    }

    public int equidistribution() {
        return this.getProperties().equidistribution();
    }

    public BigInteger period() {
        RandomSupport.RandomGeneratorProperties properties = this.getProperties();
        int i = properties.i();
        int j = properties.j();
        int k = properties.k();
        if (i == 0 && j == 0 && k == 0) {
            return BigInteger.ZERO;
        }
        return BigInteger.ONE.shiftLeft(i).subtract(BigInteger.valueOf(j)).shiftLeft(k);
    }

    public boolean isStatistical() {
        return !this.getProperties().isStochastic();
    }

    public boolean isStochastic() {
        return this.getProperties().isStochastic();
    }

    public boolean isHardware() {
        return this.getProperties().isHardware();
    }

    public boolean isArbitrarilyJumpable() {
        return this.isSubclass(RandomGenerator.ArbitrarilyJumpableGenerator.class);
    }

    public boolean isJumpable() {
        return this.isSubclass(RandomGenerator.JumpableGenerator.class);
    }

    public boolean isLeapable() {
        return this.isSubclass(RandomGenerator.LeapableGenerator.class);
    }

    public boolean isSplittable() {
        return this.isSubclass(RandomGenerator.SplittableGenerator.class);
    }

    public boolean isStreamable() {
        return this.isSubclass(RandomGenerator.StreamableGenerator.class);
    }

    public boolean isDeprecated() {
        return this.provider.type().isAnnotationPresent(Deprecated.class);
    }

    public T create() {
        try {
            this.ensureConstructors();
            return (T)((RandomGenerator)this.ctor.newInstance(new Object[0]));
        }
        catch (Exception ex) {
            throw new IllegalStateException("Random algorithm " + this.name() + " is missing a default constructor", ex);
        }
    }

    public T create(long seed) {
        try {
            this.ensureConstructors();
            return (T)((RandomGenerator)this.ctorLong.newInstance(seed));
        }
        catch (Exception ex) {
            return this.create();
        }
    }

    public T create(byte[] seed) {
        Objects.requireNonNull(seed, "seed must not be null");
        try {
            this.ensureConstructors();
            return (T)((RandomGenerator)this.ctorBytes.newInstance(new Object[]{seed}));
        }
        catch (Exception ex) {
            return this.create();
        }
    }

    private static class FactoryMapHolder {
        static final Map<String, ServiceLoader.Provider<? extends RandomGenerator>> FACTORY_MAP = FactoryMapHolder.createFactoryMap();

        private FactoryMapHolder() {
        }

        private static Map<String, ServiceLoader.Provider<? extends RandomGenerator>> createFactoryMap() {
            return ServiceLoader.load(RandomGenerator.class).stream().filter(p -> !p.type().isInterface()).collect(Collectors.toMap(p -> p.type().getSimpleName(), Function.identity()));
        }
    }
}

