/*
 * Decompiled with CFR 0.152.
 */
package java.util.regex;

import java.util.Objects;
import java.util.regex.EmojiData;

final class Grapheme {
    private static final int OTHER = 0;
    private static final int CR = 1;
    private static final int LF = 2;
    private static final int CONTROL = 3;
    private static final int EXTEND = 4;
    private static final int ZWJ = 5;
    private static final int RI = 6;
    private static final int PREPEND = 7;
    private static final int SPACINGMARK = 8;
    private static final int L = 9;
    private static final int V = 10;
    private static final int T = 11;
    private static final int LV = 12;
    private static final int LVT = 13;
    private static final int EXTENDED_PICTOGRAPHIC = 14;
    private static final int FIRST_TYPE = 0;
    private static final int LAST_TYPE = 14;
    private static boolean[][] rules;
    private static final int SYLLABLE_BASE = 44032;
    private static final int LCOUNT = 19;
    private static final int VCOUNT = 21;
    private static final int TCOUNT = 28;
    private static final int NCOUNT = 588;
    private static final int SCOUNT = 11172;

    Grapheme() {
    }

    static int nextBoundary(CharSequence src, int off, int limit) {
        int ret;
        int ch1;
        boolean gb11;
        Objects.checkFromToIndex(off, limit, src.length());
        int ch0 = Character.codePointAt(src, off);
        int t0 = Grapheme.getType(ch0);
        int riCount = t0 == 6 ? 1 : 0;
        boolean bl = gb11 = t0 == 14;
        for (ret = off + Character.charCount(ch0); ret < limit; ret += Character.charCount(ch1)) {
            ch1 = Character.codePointAt(src, ret);
            int t1 = Grapheme.getType(ch1);
            if (!(gb11 && t0 == 5 && t1 == 14 || riCount % 2 == 1 && t0 == 6 && t1 == 6 || !rules[t0][t1])) {
                if (ret > off) break;
                gb11 = t1 == 14;
                riCount = 0;
            }
            riCount += t1 == 6 ? 1 : 0;
            t0 = t1;
        }
        return ret;
    }

    private static boolean isExcludedSpacingMark(int cp) {
        return cp == 4139 || cp == 4140 || cp == 4152 || cp >= 4194 && cp <= 4196 || cp >= 4194 && cp <= 4205 || cp == 4227 || cp >= 4231 && cp <= 4236 || cp == 4239 || cp >= 4250 && cp <= 4252 || cp == 6753 || cp == 6755 || cp == 6756 || cp == 43643 || cp == 43645;
    }

    private static int getType(int cp) {
        if (cp < 127) {
            if (cp < 32) {
                if (cp == 13) {
                    return 1;
                }
                if (cp == 10) {
                    return 2;
                }
                return 3;
            }
            return 0;
        }
        if (EmojiData.isExtendedPictographic(cp)) {
            return 14;
        }
        int type = Character.getType(cp);
        switch (type) {
            case 0: {
                if (cp == 888) {
                    return 0;
                }
            }
            case 13: 
            case 14: 
            case 15: 
            case 19: {
                return 3;
            }
            case 16: {
                if (cp == 8204 || cp >= 917536 && cp <= 917631) {
                    return 4;
                }
                if (cp == 8205) {
                    return 5;
                }
                if (cp >= 1536 && cp <= 1541 || cp == 1757 || cp == 1807 || cp == 2274 || cp == 69821 || cp == 69837) {
                    return 7;
                }
                return 3;
            }
            case 6: 
            case 7: {
                return 4;
            }
            case 8: {
                if (Grapheme.isExcludedSpacingMark(cp)) {
                    return 0;
                }
                return 8;
            }
            case 28: {
                if (cp >= 127462 && cp <= 127487) {
                    return 6;
                }
                return 0;
            }
            case 4: 
            case 27: {
                if (cp == 65438 || cp == 65439 || cp >= 127995 && cp <= 127999) {
                    return 4;
                }
                return 0;
            }
            case 5: {
                if (cp == 3635 || cp == 3763) {
                    return 8;
                }
                if (cp >= 4352 && cp <= 4607) {
                    if (cp <= 4447) {
                        return 9;
                    }
                    if (cp <= 4519) {
                        return 10;
                    }
                    return 11;
                }
                int sindex = cp - 44032;
                if (sindex >= 0 && sindex < 11172) {
                    if (sindex % 28 == 0) {
                        return 12;
                    }
                    return 13;
                }
                if (cp >= 43360 && cp <= 43388) {
                    return 9;
                }
                if (cp >= 55216 && cp <= 55238) {
                    return 10;
                }
                if (cp >= 55243 && cp <= 55291) {
                    return 11;
                }
                switch (cp) {
                    case 3406: 
                    case 70082: 
                    case 70083: 
                    case 71999: 
                    case 72001: 
                    case 72250: 
                    case 72324: 
                    case 72325: 
                    case 72326: 
                    case 72327: 
                    case 72328: 
                    case 72329: 
                    case 73030: {
                        return 7;
                    }
                }
            }
        }
        return 0;
    }

    static {
        int j;
        int i;
        rules = new boolean[15][15];
        for (i = 0; i <= 14; ++i) {
            for (j = 0; j <= 14; ++j) {
                Grapheme.rules[i][j] = true;
            }
        }
        Grapheme.rules[9][9] = false;
        Grapheme.rules[9][10] = false;
        Grapheme.rules[9][12] = false;
        Grapheme.rules[9][13] = false;
        Grapheme.rules[12][10] = false;
        Grapheme.rules[12][11] = false;
        Grapheme.rules[10][10] = false;
        Grapheme.rules[10][11] = false;
        Grapheme.rules[13][11] = false;
        Grapheme.rules[11][11] = false;
        for (i = 0; i <= 14; ++i) {
            Grapheme.rules[i][4] = false;
            Grapheme.rules[i][5] = false;
            Grapheme.rules[i][8] = false;
            Grapheme.rules[7][i] = false;
        }
        for (i = 0; i <= 14; ++i) {
            for (j = 1; j <= 3; ++j) {
                Grapheme.rules[i][j] = true;
                Grapheme.rules[j][i] = true;
            }
        }
        Grapheme.rules[1][2] = false;
        Grapheme.rules[14][4] = false;
        Grapheme.rules[14][5] = false;
    }
}

