/*
 * Decompiled with CFR 0.152.
 */
package java.util.spi;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.security.AccessController;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.StreamSupport;

public interface ToolProvider {
    public String name();

    public int run(PrintWriter var1, PrintWriter var2, String ... var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public int run(PrintStream out, PrintStream err, String ... args) {
        Objects.requireNonNull(out);
        Objects.requireNonNull(err);
        Objects.requireNonNull(args);
        for (String arg : args) {
            Objects.requireNonNull(arg);
        }
        PrintWriter outWriter = new PrintWriter(out);
        PrintWriter errWriter = new PrintWriter(err);
        try {
            try {
                int n = this.run(outWriter, errWriter, args);
                outWriter.flush();
                return n;
            }
            catch (Throwable throwable) {
                outWriter.flush();
                throw throwable;
            }
        }
        finally {
            errWriter.flush();
        }
    }

    public static Optional<ToolProvider> findFirst(String name) {
        Objects.requireNonNull(name);
        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        return AccessController.doPrivileged(() -> {
            ServiceLoader<ToolProvider> sl = ServiceLoader.load(ToolProvider.class, systemClassLoader);
            return StreamSupport.stream(sl.spliterator(), false).filter(p -> p.name().equals(name)).findFirst();
        });
    }
}

