/*
 * Decompiled with CFR 0.152.
 */
package java.util.stream;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.LongConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.AbstractPipeline;
import java.util.stream.Collector;
import java.util.stream.DistinctOps;
import java.util.stream.DoublePipeline;
import java.util.stream.DoubleStream;
import java.util.stream.FindOps;
import java.util.stream.ForEachOps;
import java.util.stream.IntPipeline;
import java.util.stream.IntStream;
import java.util.stream.LongPipeline;
import java.util.stream.LongStream;
import java.util.stream.MatchOps;
import java.util.stream.Node;
import java.util.stream.Nodes;
import java.util.stream.PipelineHelper;
import java.util.stream.ReduceOps;
import java.util.stream.Sink;
import java.util.stream.SliceOps;
import java.util.stream.SortedOps;
import java.util.stream.Stream;
import java.util.stream.StreamOpFlag;
import java.util.stream.StreamShape;
import java.util.stream.StreamSpliterators;
import java.util.stream.WhileOps;
import jdk.internal.access.SharedSecrets;

abstract class ReferencePipeline<P_IN, P_OUT>
extends AbstractPipeline<P_IN, P_OUT, Stream<P_OUT>>
implements Stream<P_OUT> {
    ReferencePipeline(Supplier<? extends Spliterator<?>> source, int sourceFlags, boolean parallel) {
        super(source, sourceFlags, parallel);
    }

    ReferencePipeline(Spliterator<?> source, int sourceFlags, boolean parallel) {
        super(source, sourceFlags, parallel);
    }

    ReferencePipeline(AbstractPipeline<?, P_IN, ?> upstream, int opFlags) {
        super(upstream, opFlags);
    }

    @Override
    final StreamShape getOutputShape() {
        return StreamShape.REFERENCE;
    }

    @Override
    final <P_IN> Node<P_OUT> evaluateToNode(PipelineHelper<P_OUT> helper, Spliterator<P_IN> spliterator, boolean flattenTree, IntFunction<P_OUT[]> generator) {
        return Nodes.collect(helper, spliterator, flattenTree, generator);
    }

    @Override
    final <P_IN> Spliterator<P_OUT> wrap(PipelineHelper<P_OUT> ph, Supplier<Spliterator<P_IN>> supplier, boolean isParallel) {
        return new StreamSpliterators.WrappingSpliterator<P_IN, P_OUT>(ph, supplier, isParallel);
    }

    @Override
    final Spliterator<P_OUT> lazySpliterator(Supplier<? extends Spliterator<P_OUT>> supplier) {
        return new StreamSpliterators.DelegatingSpliterator(supplier);
    }

    @Override
    final boolean forEachWithCancel(Spliterator<P_OUT> spliterator, Sink<P_OUT> sink) {
        boolean cancelled;
        while (!(cancelled = sink.cancellationRequested()) && spliterator.tryAdvance(sink)) {
        }
        return cancelled;
    }

    @Override
    final Node.Builder<P_OUT> makeNodeBuilder(long exactSizeIfKnown, IntFunction<P_OUT[]> generator) {
        return Nodes.builder(exactSizeIfKnown, generator);
    }

    @Override
    public final Iterator<P_OUT> iterator() {
        return Spliterators.iterator(this.spliterator());
    }

    @Override
    public Stream<P_OUT> unordered() {
        if (!this.isOrdered()) {
            return this;
        }
        return new StatelessOp<P_OUT, P_OUT>(this, StreamShape.REFERENCE, StreamOpFlag.NOT_ORDERED){

            @Override
            Sink<P_OUT> opWrapSink(int flags, Sink<P_OUT> sink) {
                return sink;
            }
        };
    }

    @Override
    public final Stream<P_OUT> filter(final Predicate<? super P_OUT> predicate) {
        Objects.requireNonNull(predicate);
        return new StatelessOp<P_OUT, P_OUT>(this, StreamShape.REFERENCE, StreamOpFlag.NOT_SIZED){

            @Override
            Sink<P_OUT> opWrapSink(int flags, Sink<P_OUT> sink) {
                return new Sink.ChainedReference<P_OUT, P_OUT>(sink){

                    @Override
                    public void begin(long size) {
                        this.downstream.begin(-1L);
                    }

                    @Override
                    public void accept(P_OUT u) {
                        if (predicate.test(u)) {
                            this.downstream.accept(u);
                        }
                    }
                };
            }
        };
    }

    @Override
    public final <R> Stream<R> map(final Function<? super P_OUT, ? extends R> mapper) {
        Objects.requireNonNull(mapper);
        return new StatelessOp<P_OUT, R>(this, StreamShape.REFERENCE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT){

            @Override
            Sink<P_OUT> opWrapSink(int flags, Sink<R> sink) {
                return new Sink.ChainedReference<P_OUT, R>(sink){

                    @Override
                    public void accept(P_OUT u) {
                        this.downstream.accept(mapper.apply(u));
                    }
                };
            }
        };
    }

    @Override
    public final IntStream mapToInt(final ToIntFunction<? super P_OUT> mapper) {
        Objects.requireNonNull(mapper);
        return new IntPipeline.StatelessOp<P_OUT>(this, StreamShape.REFERENCE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT){

            @Override
            Sink<P_OUT> opWrapSink(int flags, Sink<Integer> sink) {
                return new Sink.ChainedReference<P_OUT, Integer>(sink){

                    @Override
                    public void accept(P_OUT u) {
                        this.downstream.accept(mapper.applyAsInt(u));
                    }
                };
            }
        };
    }

    @Override
    public final LongStream mapToLong(final ToLongFunction<? super P_OUT> mapper) {
        Objects.requireNonNull(mapper);
        return new LongPipeline.StatelessOp<P_OUT>(this, StreamShape.REFERENCE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT){

            @Override
            Sink<P_OUT> opWrapSink(int flags, Sink<Long> sink) {
                return new Sink.ChainedReference<P_OUT, Long>(sink){

                    @Override
                    public void accept(P_OUT u) {
                        this.downstream.accept(mapper.applyAsLong(u));
                    }
                };
            }
        };
    }

    @Override
    public final DoubleStream mapToDouble(final ToDoubleFunction<? super P_OUT> mapper) {
        Objects.requireNonNull(mapper);
        return new DoublePipeline.StatelessOp<P_OUT>(this, StreamShape.REFERENCE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT){

            @Override
            Sink<P_OUT> opWrapSink(int flags, Sink<Double> sink) {
                return new Sink.ChainedReference<P_OUT, Double>(sink){

                    @Override
                    public void accept(P_OUT u) {
                        this.downstream.accept(mapper.applyAsDouble(u));
                    }
                };
            }
        };
    }

    @Override
    public final <R> Stream<R> flatMap(final Function<? super P_OUT, ? extends Stream<? extends R>> mapper) {
        Objects.requireNonNull(mapper);
        return new StatelessOp<P_OUT, R>(this, StreamShape.REFERENCE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT | StreamOpFlag.NOT_SIZED){

            @Override
            Sink<P_OUT> opWrapSink(int flags, Sink<R> sink) {
                return new Sink.ChainedReference<P_OUT, R>(sink){
                    boolean cancellationRequestedCalled;

                    @Override
                    public void begin(long size) {
                        this.downstream.begin(-1L);
                    }

                    @Override
                    public void accept(P_OUT u) {
                        try (Stream result = (Stream)mapper.apply(u);){
                            if (result != null) {
                                if (!this.cancellationRequestedCalled) {
                                    ((Stream)result.sequential()).forEach(this.downstream);
                                } else {
                                    Spliterator s = ((Stream)result.sequential()).spliterator();
                                    while (!this.downstream.cancellationRequested() && s.tryAdvance(this.downstream)) {
                                    }
                                }
                            }
                        }
                    }

                    @Override
                    public boolean cancellationRequested() {
                        this.cancellationRequestedCalled = true;
                        return this.downstream.cancellationRequested();
                    }
                };
            }
        };
    }

    @Override
    public final IntStream flatMapToInt(final Function<? super P_OUT, ? extends IntStream> mapper) {
        Objects.requireNonNull(mapper);
        return new IntPipeline.StatelessOp<P_OUT>(this, StreamShape.REFERENCE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT | StreamOpFlag.NOT_SIZED){

            @Override
            Sink<P_OUT> opWrapSink(int flags, Sink<Integer> sink) {
                return new Sink.ChainedReference<P_OUT, Integer>(sink){
                    boolean cancellationRequestedCalled;
                    IntConsumer downstreamAsInt;
                    {
                        this.downstreamAsInt = this.downstream::accept;
                    }

                    @Override
                    public void begin(long size) {
                        this.downstream.begin(-1L);
                    }

                    @Override
                    public void accept(P_OUT u) {
                        try (IntStream result = (IntStream)mapper.apply(u);){
                            if (result != null) {
                                if (!this.cancellationRequestedCalled) {
                                    result.sequential().forEach(this.downstreamAsInt);
                                } else {
                                    Spliterator.OfInt s = result.sequential().spliterator();
                                    while (!this.downstream.cancellationRequested() && s.tryAdvance(this.downstreamAsInt)) {
                                    }
                                }
                            }
                        }
                    }

                    @Override
                    public boolean cancellationRequested() {
                        this.cancellationRequestedCalled = true;
                        return this.downstream.cancellationRequested();
                    }
                };
            }
        };
    }

    @Override
    public final DoubleStream flatMapToDouble(final Function<? super P_OUT, ? extends DoubleStream> mapper) {
        Objects.requireNonNull(mapper);
        return new DoublePipeline.StatelessOp<P_OUT>(this, StreamShape.REFERENCE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT | StreamOpFlag.NOT_SIZED){

            @Override
            Sink<P_OUT> opWrapSink(int flags, Sink<Double> sink) {
                return new Sink.ChainedReference<P_OUT, Double>(sink){
                    boolean cancellationRequestedCalled;
                    DoubleConsumer downstreamAsDouble;
                    {
                        this.downstreamAsDouble = this.downstream::accept;
                    }

                    @Override
                    public void begin(long size) {
                        this.downstream.begin(-1L);
                    }

                    @Override
                    public void accept(P_OUT u) {
                        try (DoubleStream result = (DoubleStream)mapper.apply(u);){
                            if (result != null) {
                                if (!this.cancellationRequestedCalled) {
                                    result.sequential().forEach(this.downstreamAsDouble);
                                } else {
                                    Spliterator.OfDouble s = result.sequential().spliterator();
                                    while (!this.downstream.cancellationRequested() && s.tryAdvance(this.downstreamAsDouble)) {
                                    }
                                }
                            }
                        }
                    }

                    @Override
                    public boolean cancellationRequested() {
                        this.cancellationRequestedCalled = true;
                        return this.downstream.cancellationRequested();
                    }
                };
            }
        };
    }

    @Override
    public final LongStream flatMapToLong(final Function<? super P_OUT, ? extends LongStream> mapper) {
        Objects.requireNonNull(mapper);
        return new LongPipeline.StatelessOp<P_OUT>(this, StreamShape.REFERENCE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT | StreamOpFlag.NOT_SIZED){

            @Override
            Sink<P_OUT> opWrapSink(int flags, Sink<Long> sink) {
                return new Sink.ChainedReference<P_OUT, Long>(sink){
                    boolean cancellationRequestedCalled;
                    LongConsumer downstreamAsLong;
                    {
                        this.downstreamAsLong = this.downstream::accept;
                    }

                    @Override
                    public void begin(long size) {
                        this.downstream.begin(-1L);
                    }

                    @Override
                    public void accept(P_OUT u) {
                        try (LongStream result = (LongStream)mapper.apply(u);){
                            if (result != null) {
                                if (!this.cancellationRequestedCalled) {
                                    result.sequential().forEach(this.downstreamAsLong);
                                } else {
                                    Spliterator.OfLong s = result.sequential().spliterator();
                                    while (!this.downstream.cancellationRequested() && s.tryAdvance(this.downstreamAsLong)) {
                                    }
                                }
                            }
                        }
                    }

                    @Override
                    public boolean cancellationRequested() {
                        this.cancellationRequestedCalled = true;
                        return this.downstream.cancellationRequested();
                    }
                };
            }
        };
    }

    @Override
    public final <R> Stream<R> mapMulti(final BiConsumer<? super P_OUT, ? super Consumer<R>> mapper) {
        Objects.requireNonNull(mapper);
        return new StatelessOp<P_OUT, R>(this, StreamShape.REFERENCE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT | StreamOpFlag.NOT_SIZED){

            @Override
            Sink<P_OUT> opWrapSink(int flags, Sink<R> sink) {
                return new Sink.ChainedReference<P_OUT, R>(sink){

                    @Override
                    public void begin(long size) {
                        this.downstream.begin(-1L);
                    }

                    @Override
                    public void accept(P_OUT u) {
                        mapper.accept(u, this.downstream);
                    }
                };
            }
        };
    }

    @Override
    public final IntStream mapMultiToInt(final BiConsumer<? super P_OUT, ? super IntConsumer> mapper) {
        Objects.requireNonNull(mapper);
        return new IntPipeline.StatelessOp<P_OUT>(this, StreamShape.REFERENCE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT | StreamOpFlag.NOT_SIZED){

            @Override
            Sink<P_OUT> opWrapSink(int flags, Sink<Integer> sink) {
                return new Sink.ChainedReference<P_OUT, Integer>(sink){

                    @Override
                    public void begin(long size) {
                        this.downstream.begin(-1L);
                    }

                    @Override
                    public void accept(P_OUT u) {
                        mapper.accept(u, (IntConsumer)((Object)this.downstream));
                    }
                };
            }
        };
    }

    @Override
    public final LongStream mapMultiToLong(final BiConsumer<? super P_OUT, ? super LongConsumer> mapper) {
        Objects.requireNonNull(mapper);
        return new LongPipeline.StatelessOp<P_OUT>(this, StreamShape.REFERENCE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT | StreamOpFlag.NOT_SIZED){

            @Override
            Sink<P_OUT> opWrapSink(int flags, Sink<Long> sink) {
                return new Sink.ChainedReference<P_OUT, Long>(sink){

                    @Override
                    public void begin(long size) {
                        this.downstream.begin(-1L);
                    }

                    @Override
                    public void accept(P_OUT u) {
                        mapper.accept(u, (LongConsumer)((Object)this.downstream));
                    }
                };
            }
        };
    }

    @Override
    public final DoubleStream mapMultiToDouble(final BiConsumer<? super P_OUT, ? super DoubleConsumer> mapper) {
        Objects.requireNonNull(mapper);
        return new DoublePipeline.StatelessOp<P_OUT>(this, StreamShape.REFERENCE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT | StreamOpFlag.NOT_SIZED){

            @Override
            Sink<P_OUT> opWrapSink(int flags, Sink<Double> sink) {
                return new Sink.ChainedReference<P_OUT, Double>(sink){

                    @Override
                    public void begin(long size) {
                        this.downstream.begin(-1L);
                    }

                    @Override
                    public void accept(P_OUT u) {
                        mapper.accept(u, (DoubleConsumer)((Object)this.downstream));
                    }
                };
            }
        };
    }

    @Override
    public final Stream<P_OUT> peek(final Consumer<? super P_OUT> action) {
        Objects.requireNonNull(action);
        return new StatelessOp<P_OUT, P_OUT>(this, StreamShape.REFERENCE, 0){

            @Override
            Sink<P_OUT> opWrapSink(int flags, Sink<P_OUT> sink) {
                return new Sink.ChainedReference<P_OUT, P_OUT>(sink){

                    @Override
                    public void accept(P_OUT u) {
                        action.accept(u);
                        this.downstream.accept(u);
                    }
                };
            }
        };
    }

    @Override
    public final Stream<P_OUT> distinct() {
        return DistinctOps.makeRef(this);
    }

    @Override
    public final Stream<P_OUT> sorted() {
        return SortedOps.makeRef(this);
    }

    @Override
    public final Stream<P_OUT> sorted(Comparator<? super P_OUT> comparator) {
        return SortedOps.makeRef(this, comparator);
    }

    @Override
    public final Stream<P_OUT> limit(long maxSize) {
        if (maxSize < 0L) {
            throw new IllegalArgumentException(Long.toString(maxSize));
        }
        return SliceOps.makeRef(this, 0L, maxSize);
    }

    @Override
    public final Stream<P_OUT> skip(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException(Long.toString(n));
        }
        if (n == 0L) {
            return this;
        }
        return SliceOps.makeRef(this, n, -1L);
    }

    @Override
    public final Stream<P_OUT> takeWhile(Predicate<? super P_OUT> predicate) {
        return WhileOps.makeTakeWhileRef(this, predicate);
    }

    @Override
    public final Stream<P_OUT> dropWhile(Predicate<? super P_OUT> predicate) {
        return WhileOps.makeDropWhileRef(this, predicate);
    }

    @Override
    public void forEach(Consumer<? super P_OUT> action) {
        this.evaluate(ForEachOps.makeRef(action, false));
    }

    @Override
    public void forEachOrdered(Consumer<? super P_OUT> action) {
        this.evaluate(ForEachOps.makeRef(action, true));
    }

    @Override
    public final <A> A[] toArray(IntFunction<A[]> generator) {
        IntFunction<T[]> rawGenerator = generator;
        return Nodes.flatten(this.evaluateToArrayNode(rawGenerator), rawGenerator).asArray(rawGenerator);
    }

    @Override
    public final Object[] toArray() {
        return this.toArray(Object[]::new);
    }

    @Override
    public List<P_OUT> toList() {
        return SharedSecrets.getJavaUtilCollectionAccess().listFromTrustedArrayNullsAllowed(this.toArray());
    }

    @Override
    public final boolean anyMatch(Predicate<? super P_OUT> predicate) {
        return this.evaluate(MatchOps.makeRef(predicate, MatchOps.MatchKind.ANY));
    }

    @Override
    public final boolean allMatch(Predicate<? super P_OUT> predicate) {
        return this.evaluate(MatchOps.makeRef(predicate, MatchOps.MatchKind.ALL));
    }

    @Override
    public final boolean noneMatch(Predicate<? super P_OUT> predicate) {
        return this.evaluate(MatchOps.makeRef(predicate, MatchOps.MatchKind.NONE));
    }

    @Override
    public final Optional<P_OUT> findFirst() {
        return this.evaluate(FindOps.makeRef(true));
    }

    @Override
    public final Optional<P_OUT> findAny() {
        return this.evaluate(FindOps.makeRef(false));
    }

    @Override
    public final P_OUT reduce(P_OUT identity, BinaryOperator<P_OUT> accumulator) {
        return this.evaluate(ReduceOps.makeRef(identity, accumulator, accumulator));
    }

    @Override
    public final Optional<P_OUT> reduce(BinaryOperator<P_OUT> accumulator) {
        return this.evaluate(ReduceOps.makeRef(accumulator));
    }

    @Override
    public final <R> R reduce(R identity, BiFunction<R, ? super P_OUT, R> accumulator, BinaryOperator<R> combiner) {
        return this.evaluate(ReduceOps.makeRef(identity, accumulator, combiner));
    }

    @Override
    public final <R, A> R collect(Collector<? super P_OUT, A, R> collector) {
        Object container;
        if (this.isParallel() && collector.characteristics().contains((Object)Collector.Characteristics.CONCURRENT) && (!this.isOrdered() || collector.characteristics().contains((Object)Collector.Characteristics.UNORDERED))) {
            container = collector.supplier().get();
            BiConsumer accumulator = collector.accumulator();
            this.forEach((Consumer<? super P_OUT>)((Consumer<Object>)u -> accumulator.accept(container, (Object)u)));
        } else {
            container = this.evaluate(ReduceOps.makeRef(collector));
        }
        return (R)(collector.characteristics().contains((Object)Collector.Characteristics.IDENTITY_FINISH) ? container : collector.finisher().apply(container));
    }

    @Override
    public final <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super P_OUT> accumulator, BiConsumer<R, R> combiner) {
        return this.evaluate(ReduceOps.makeRef(supplier, accumulator, combiner));
    }

    @Override
    public final Optional<P_OUT> max(Comparator<? super P_OUT> comparator) {
        return this.reduce((BinaryOperator<P_OUT>)BinaryOperator.maxBy(comparator));
    }

    @Override
    public final Optional<P_OUT> min(Comparator<? super P_OUT> comparator) {
        return this.reduce((BinaryOperator<P_OUT>)BinaryOperator.minBy(comparator));
    }

    @Override
    public final long count() {
        return this.evaluate(ReduceOps.makeRefCounting());
    }

    static abstract class StatefulOp<E_IN, E_OUT>
    extends ReferencePipeline<E_IN, E_OUT> {
        StatefulOp(AbstractPipeline<?, E_IN, ?> upstream, StreamShape inputShape, int opFlags) {
            super(upstream, opFlags);
            assert (upstream.getOutputShape() == inputShape);
        }

        @Override
        final boolean opIsStateful() {
            return true;
        }

        @Override
        abstract <P_IN> Node<E_OUT> opEvaluateParallel(PipelineHelper<E_OUT> var1, Spliterator<P_IN> var2, IntFunction<E_OUT[]> var3);
    }

    static abstract class StatelessOp<E_IN, E_OUT>
    extends ReferencePipeline<E_IN, E_OUT> {
        StatelessOp(AbstractPipeline<?, E_IN, ?> upstream, StreamShape inputShape, int opFlags) {
            super(upstream, opFlags);
            assert (upstream.getOutputShape() == inputShape);
        }

        @Override
        final boolean opIsStateful() {
            return false;
        }
    }

    static class Head<E_IN, E_OUT>
    extends ReferencePipeline<E_IN, E_OUT> {
        Head(Supplier<? extends Spliterator<?>> source, int sourceFlags, boolean parallel) {
            super(source, sourceFlags, parallel);
        }

        Head(Spliterator<?> source, int sourceFlags, boolean parallel) {
            super(source, sourceFlags, parallel);
        }

        @Override
        final boolean opIsStateful() {
            throw new UnsupportedOperationException();
        }

        @Override
        final Sink<E_IN> opWrapSink(int flags, Sink<E_OUT> sink) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void forEach(Consumer<? super E_OUT> action) {
            if (!this.isParallel()) {
                this.sourceStageSpliterator().forEachRemaining(action);
            } else {
                super.forEach(action);
            }
        }

        @Override
        public void forEachOrdered(Consumer<? super E_OUT> action) {
            if (!this.isParallel()) {
                this.sourceStageSpliterator().forEachRemaining(action);
            } else {
                super.forEachOrdered(action);
            }
        }
    }
}

