/*
 * Decompiled with CFR 0.152.
 */
package java.util.stream;

import java.util.EnumMap;
import java.util.Map;
import java.util.Spliterator;

enum StreamOpFlag {
    DISTINCT(0, StreamOpFlag.set(Type.SPLITERATOR).set(Type.STREAM).setAndClear(Type.OP)),
    SORTED(1, StreamOpFlag.set(Type.SPLITERATOR).set(Type.STREAM).setAndClear(Type.OP)),
    ORDERED(2, StreamOpFlag.set(Type.SPLITERATOR).set(Type.STREAM).setAndClear(Type.OP).clear(Type.TERMINAL_OP).clear(Type.UPSTREAM_TERMINAL_OP)),
    SIZED(3, StreamOpFlag.set(Type.SPLITERATOR).set(Type.STREAM).clear(Type.OP)),
    SHORT_CIRCUIT(12, StreamOpFlag.set(Type.OP).set(Type.TERMINAL_OP)),
    SIZE_ADJUSTING(13, StreamOpFlag.set(Type.OP));

    private static final int SET_BITS = 1;
    private static final int CLEAR_BITS = 2;
    private static final int PRESERVE_BITS = 3;
    private final Map<Type, Integer> maskTable;
    private final int bitPosition;
    private final int set;
    private final int clear;
    private final int preserve;
    static final int SPLITERATOR_CHARACTERISTICS_MASK;
    static final int STREAM_MASK;
    static final int OP_MASK;
    static final int TERMINAL_OP_MASK;
    static final int UPSTREAM_TERMINAL_OP_MASK;
    private static final int FLAG_MASK;
    private static final int FLAG_MASK_IS;
    private static final int FLAG_MASK_NOT;
    static final int INITIAL_OPS_VALUE;
    static final int IS_DISTINCT;
    static final int NOT_DISTINCT;
    static final int IS_SORTED;
    static final int NOT_SORTED;
    static final int IS_ORDERED;
    static final int NOT_ORDERED;
    static final int IS_SIZED;
    static final int NOT_SIZED;
    static final int IS_SHORT_CIRCUIT;
    static final int IS_SIZE_ADJUSTING;

    private static MaskBuilder set(Type t) {
        return new MaskBuilder(new EnumMap<Type, Integer>(Type.class)).set(t);
    }

    private StreamOpFlag(int position, MaskBuilder maskBuilder) {
        this.maskTable = maskBuilder.build();
        this.bitPosition = position *= 2;
        this.set = 1 << position;
        this.clear = 2 << position;
        this.preserve = 3 << position;
    }

    int set() {
        return this.set;
    }

    int clear() {
        return this.clear;
    }

    boolean isStreamFlag() {
        return this.maskTable.get((Object)Type.STREAM) > 0;
    }

    boolean isKnown(int flags) {
        return (flags & this.preserve) == this.set;
    }

    boolean isCleared(int flags) {
        return (flags & this.preserve) == this.clear;
    }

    boolean isPreserved(int flags) {
        return (flags & this.preserve) == this.preserve;
    }

    boolean canSet(Type t) {
        return (this.maskTable.get((Object)t) & 1) > 0;
    }

    private static int createMask(Type t) {
        int mask = 0;
        for (StreamOpFlag flag : StreamOpFlag.values()) {
            mask |= flag.maskTable.get((Object)t) << flag.bitPosition;
        }
        return mask;
    }

    private static int createFlagMask() {
        int mask = 0;
        for (StreamOpFlag flag : StreamOpFlag.values()) {
            mask |= flag.preserve;
        }
        return mask;
    }

    private static int getMask(int flags) {
        return flags == 0 ? FLAG_MASK : ~(flags | (FLAG_MASK_IS & flags) << 1 | (FLAG_MASK_NOT & flags) >> 1);
    }

    static int combineOpFlags(int newStreamOrOpFlags, int prevCombOpFlags) {
        return prevCombOpFlags & StreamOpFlag.getMask(newStreamOrOpFlags) | newStreamOrOpFlags;
    }

    static int toStreamFlags(int combOpFlags) {
        return ~combOpFlags >> 1 & FLAG_MASK_IS & combOpFlags;
    }

    static int toCharacteristics(int streamFlags) {
        return streamFlags & SPLITERATOR_CHARACTERISTICS_MASK;
    }

    static int fromCharacteristics(Spliterator<?> spliterator) {
        int characteristics = spliterator.characteristics();
        if ((characteristics & 4) != 0 && spliterator.getComparator() != null) {
            return characteristics & SPLITERATOR_CHARACTERISTICS_MASK & 0xFFFFFFFB;
        }
        return characteristics & SPLITERATOR_CHARACTERISTICS_MASK;
    }

    static int fromCharacteristics(int characteristics) {
        return characteristics & SPLITERATOR_CHARACTERISTICS_MASK;
    }

    static {
        SPLITERATOR_CHARACTERISTICS_MASK = StreamOpFlag.createMask(Type.SPLITERATOR);
        STREAM_MASK = StreamOpFlag.createMask(Type.STREAM);
        OP_MASK = StreamOpFlag.createMask(Type.OP);
        TERMINAL_OP_MASK = StreamOpFlag.createMask(Type.TERMINAL_OP);
        UPSTREAM_TERMINAL_OP_MASK = StreamOpFlag.createMask(Type.UPSTREAM_TERMINAL_OP);
        FLAG_MASK = StreamOpFlag.createFlagMask();
        FLAG_MASK_IS = STREAM_MASK;
        FLAG_MASK_NOT = STREAM_MASK << 1;
        INITIAL_OPS_VALUE = FLAG_MASK_IS | FLAG_MASK_NOT;
        IS_DISTINCT = StreamOpFlag.DISTINCT.set;
        NOT_DISTINCT = StreamOpFlag.DISTINCT.clear;
        IS_SORTED = StreamOpFlag.SORTED.set;
        NOT_SORTED = StreamOpFlag.SORTED.clear;
        IS_ORDERED = StreamOpFlag.ORDERED.set;
        NOT_ORDERED = StreamOpFlag.ORDERED.clear;
        IS_SIZED = StreamOpFlag.SIZED.set;
        NOT_SIZED = StreamOpFlag.SIZED.clear;
        IS_SHORT_CIRCUIT = StreamOpFlag.SHORT_CIRCUIT.set;
        IS_SIZE_ADJUSTING = StreamOpFlag.SIZE_ADJUSTING.set;
    }

    private static class MaskBuilder {
        final Map<Type, Integer> map;

        MaskBuilder(Map<Type, Integer> map) {
            this.map = map;
        }

        MaskBuilder mask(Type t, Integer i) {
            this.map.put(t, i);
            return this;
        }

        MaskBuilder set(Type t) {
            return this.mask(t, 1);
        }

        MaskBuilder clear(Type t) {
            return this.mask(t, 2);
        }

        MaskBuilder setAndClear(Type t) {
            return this.mask(t, 3);
        }

        Map<Type, Integer> build() {
            for (Type t : Type.values()) {
                this.map.putIfAbsent(t, 0);
            }
            return this.map;
        }
    }

    static enum Type {
        SPLITERATOR,
        STREAM,
        OP,
        TERMINAL_OP,
        UPSTREAM_TERMINAL_OP;

    }
}

