/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.lang.ref.Cleaner;
import java.lang.ref.Reference;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.util.Objects;
import java.util.zip.ZipUtils;
import jdk.internal.ref.CleanerFactory;
import sun.nio.ch.DirectBuffer;

public class Deflater {
    private final DeflaterZStreamRef zsRef;
    private ByteBuffer input = ZipUtils.defaultBuf;
    private byte[] inputArray;
    private int inputPos;
    private int inputLim;
    private int level;
    private int strategy;
    private boolean setParams;
    private boolean finish;
    private boolean finished;
    private long bytesRead;
    private long bytesWritten;
    public static final int DEFLATED = 8;
    public static final int NO_COMPRESSION = 0;
    public static final int BEST_SPEED = 1;
    public static final int BEST_COMPRESSION = 9;
    public static final int DEFAULT_COMPRESSION = -1;
    public static final int FILTERED = 1;
    public static final int HUFFMAN_ONLY = 2;
    public static final int DEFAULT_STRATEGY = 0;
    public static final int NO_FLUSH = 0;
    public static final int SYNC_FLUSH = 2;
    public static final int FULL_FLUSH = 3;
    private static final int FINISH = 4;

    public Deflater(int level, boolean nowrap) {
        this.level = level;
        this.strategy = 0;
        this.zsRef = new DeflaterZStreamRef(this, Deflater.init(level, 0, nowrap));
    }

    public Deflater(int level) {
        this(level, false);
    }

    public Deflater() {
        this(-1, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInput(byte[] input, int off, int len) {
        if (off < 0 || len < 0 || off > input.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        DeflaterZStreamRef deflaterZStreamRef = this.zsRef;
        synchronized (deflaterZStreamRef) {
            this.input = null;
            this.inputArray = input;
            this.inputPos = off;
            this.inputLim = off + len;
        }
    }

    public void setInput(byte[] input) {
        this.setInput(input, 0, input.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInput(ByteBuffer input) {
        Objects.requireNonNull(input);
        DeflaterZStreamRef deflaterZStreamRef = this.zsRef;
        synchronized (deflaterZStreamRef) {
            this.input = input;
            this.inputArray = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDictionary(byte[] dictionary, int off, int len) {
        if (off < 0 || len < 0 || off > dictionary.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        DeflaterZStreamRef deflaterZStreamRef = this.zsRef;
        synchronized (deflaterZStreamRef) {
            this.ensureOpen();
            Deflater.setDictionary(this.zsRef.address(), dictionary, off, len);
        }
    }

    public void setDictionary(byte[] dictionary) {
        this.setDictionary(dictionary, 0, dictionary.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDictionary(ByteBuffer dictionary) {
        DeflaterZStreamRef deflaterZStreamRef = this.zsRef;
        synchronized (deflaterZStreamRef) {
            int position = dictionary.position();
            int remaining = Math.max(dictionary.limit() - position, 0);
            this.ensureOpen();
            if (dictionary.isDirect()) {
                long address = ((DirectBuffer)((Object)dictionary)).address();
                try {
                    Deflater.setDictionaryBuffer(this.zsRef.address(), address + (long)position, remaining);
                }
                finally {
                    Reference.reachabilityFence(dictionary);
                }
            } else {
                byte[] array = ZipUtils.getBufferArray(dictionary);
                int offset = ZipUtils.getBufferOffset(dictionary);
                Deflater.setDictionary(this.zsRef.address(), array, offset + position, remaining);
            }
            dictionary.position(position + remaining);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStrategy(int strategy) {
        switch (strategy) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        DeflaterZStreamRef deflaterZStreamRef = this.zsRef;
        synchronized (deflaterZStreamRef) {
            if (this.strategy != strategy) {
                this.strategy = strategy;
                this.setParams = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLevel(int level) {
        if ((level < 0 || level > 9) && level != -1) {
            throw new IllegalArgumentException("invalid compression level");
        }
        DeflaterZStreamRef deflaterZStreamRef = this.zsRef;
        synchronized (deflaterZStreamRef) {
            if (this.level != level) {
                this.level = level;
                this.setParams = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean needsInput() {
        DeflaterZStreamRef deflaterZStreamRef = this.zsRef;
        synchronized (deflaterZStreamRef) {
            ByteBuffer input = this.input;
            return input == null ? this.inputLim == this.inputPos : !input.hasRemaining();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        DeflaterZStreamRef deflaterZStreamRef = this.zsRef;
        synchronized (deflaterZStreamRef) {
            this.finish = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean finished() {
        DeflaterZStreamRef deflaterZStreamRef = this.zsRef;
        synchronized (deflaterZStreamRef) {
            return this.finished;
        }
    }

    public int deflate(byte[] output, int off, int len) {
        return this.deflate(output, off, len, 0);
    }

    public int deflate(byte[] output) {
        return this.deflate(output, 0, output.length, 0);
    }

    public int deflate(ByteBuffer output) {
        return this.deflate(output, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deflate(byte[] output, int off, int len, int flush) {
        if (off < 0 || len < 0 || off > output.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (flush != 0 && flush != 2 && flush != 3) {
            throw new IllegalArgumentException();
        }
        DeflaterZStreamRef deflaterZStreamRef = this.zsRef;
        synchronized (deflaterZStreamRef) {
            long result;
            int inputPos;
            this.ensureOpen();
            ByteBuffer input = this.input;
            if (this.finish) {
                flush = 4;
            }
            int params = this.setParams ? 1 | this.strategy << 1 | this.level << 3 : 0;
            if (input == null) {
                inputPos = this.inputPos;
                result = this.deflateBytesBytes(this.zsRef.address(), this.inputArray, inputPos, this.inputLim - inputPos, output, off, len, flush, params);
            } else {
                inputPos = input.position();
                int inputRem = Math.max(input.limit() - inputPos, 0);
                if (input.isDirect()) {
                    try {
                        long inputAddress = ((DirectBuffer)((Object)input)).address();
                        result = this.deflateBufferBytes(this.zsRef.address(), inputAddress + (long)inputPos, inputRem, output, off, len, flush, params);
                    }
                    finally {
                        Reference.reachabilityFence(input);
                    }
                } else {
                    byte[] inputArray = ZipUtils.getBufferArray(input);
                    int inputOffset = ZipUtils.getBufferOffset(input);
                    result = this.deflateBytesBytes(this.zsRef.address(), inputArray, inputOffset + inputPos, inputRem, output, off, len, flush, params);
                }
            }
            int read = (int)(result & Integer.MAX_VALUE);
            int written = (int)(result >>> 31 & Integer.MAX_VALUE);
            if ((result >>> 62 & 1L) != 0L) {
                this.finished = true;
            }
            if (params != 0 && (result >>> 63 & 1L) == 0L) {
                this.setParams = false;
            }
            if (input != null) {
                input.position(inputPos + read);
            } else {
                this.inputPos = inputPos + read;
            }
            this.bytesWritten += (long)written;
            this.bytesRead += (long)read;
            return written;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deflate(ByteBuffer output, int flush) {
        if (output.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        if (flush != 0 && flush != 2 && flush != 3) {
            throw new IllegalArgumentException();
        }
        DeflaterZStreamRef deflaterZStreamRef = this.zsRef;
        synchronized (deflaterZStreamRef) {
            long result;
            int inputPos;
            this.ensureOpen();
            ByteBuffer input = this.input;
            if (this.finish) {
                flush = 4;
            }
            int params = this.setParams ? 1 | this.strategy << 1 | this.level << 3 : 0;
            int outputPos = output.position();
            int outputRem = Math.max(output.limit() - outputPos, 0);
            if (input == null) {
                inputPos = this.inputPos;
                if (output.isDirect()) {
                    long outputAddress = ((DirectBuffer)((Object)output)).address();
                    try {
                        result = this.deflateBytesBuffer(this.zsRef.address(), this.inputArray, inputPos, this.inputLim - inputPos, outputAddress + (long)outputPos, outputRem, flush, params);
                    }
                    finally {
                        Reference.reachabilityFence(output);
                    }
                } else {
                    byte[] outputArray = ZipUtils.getBufferArray(output);
                    int outputOffset = ZipUtils.getBufferOffset(output);
                    result = this.deflateBytesBytes(this.zsRef.address(), this.inputArray, inputPos, this.inputLim - inputPos, outputArray, outputOffset + outputPos, outputRem, flush, params);
                }
            } else {
                inputPos = input.position();
                int inputRem = Math.max(input.limit() - inputPos, 0);
                if (input.isDirect()) {
                    long inputAddress = ((DirectBuffer)((Object)input)).address();
                    try {
                        if (output.isDirect()) {
                            long outputAddress = (long)outputPos + ((DirectBuffer)((Object)output)).address();
                            try {
                                result = this.deflateBufferBuffer(this.zsRef.address(), inputAddress + (long)inputPos, inputRem, outputAddress, outputRem, flush, params);
                            }
                            finally {
                                Reference.reachabilityFence(output);
                            }
                        }
                        byte[] outputArray = ZipUtils.getBufferArray(output);
                        int outputOffset = ZipUtils.getBufferOffset(output);
                        result = this.deflateBufferBytes(this.zsRef.address(), inputAddress + (long)inputPos, inputRem, outputArray, outputOffset + outputPos, outputRem, flush, params);
                    }
                    finally {
                        Reference.reachabilityFence(input);
                    }
                } else {
                    byte[] inputArray = ZipUtils.getBufferArray(input);
                    int inputOffset = ZipUtils.getBufferOffset(input);
                    if (output.isDirect()) {
                        long outputAddress = ((DirectBuffer)((Object)output)).address();
                        try {
                            result = this.deflateBytesBuffer(this.zsRef.address(), inputArray, inputOffset + inputPos, inputRem, outputAddress + (long)outputPos, outputRem, flush, params);
                        }
                        finally {
                            Reference.reachabilityFence(output);
                        }
                    } else {
                        byte[] outputArray = ZipUtils.getBufferArray(output);
                        int outputOffset = ZipUtils.getBufferOffset(output);
                        result = this.deflateBytesBytes(this.zsRef.address(), inputArray, inputOffset + inputPos, inputRem, outputArray, outputOffset + outputPos, outputRem, flush, params);
                    }
                }
            }
            int read = (int)(result & Integer.MAX_VALUE);
            int written = (int)(result >>> 31 & Integer.MAX_VALUE);
            if ((result >>> 62 & 1L) != 0L) {
                this.finished = true;
            }
            if (params != 0 && (result >>> 63 & 1L) == 0L) {
                this.setParams = false;
            }
            if (input != null) {
                input.position(inputPos + read);
            } else {
                this.inputPos = inputPos + read;
            }
            output.position(outputPos + written);
            this.bytesWritten += (long)written;
            this.bytesRead += (long)read;
            return written;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAdler() {
        DeflaterZStreamRef deflaterZStreamRef = this.zsRef;
        synchronized (deflaterZStreamRef) {
            this.ensureOpen();
            return Deflater.getAdler(this.zsRef.address());
        }
    }

    public int getTotalIn() {
        return (int)this.getBytesRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBytesRead() {
        DeflaterZStreamRef deflaterZStreamRef = this.zsRef;
        synchronized (deflaterZStreamRef) {
            this.ensureOpen();
            return this.bytesRead;
        }
    }

    public int getTotalOut() {
        return (int)this.getBytesWritten();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBytesWritten() {
        DeflaterZStreamRef deflaterZStreamRef = this.zsRef;
        synchronized (deflaterZStreamRef) {
            this.ensureOpen();
            return this.bytesWritten;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        DeflaterZStreamRef deflaterZStreamRef = this.zsRef;
        synchronized (deflaterZStreamRef) {
            this.ensureOpen();
            Deflater.reset(this.zsRef.address());
            this.finish = false;
            this.finished = false;
            this.input = ZipUtils.defaultBuf;
            this.inputArray = null;
            this.bytesWritten = 0L;
            this.bytesRead = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end() {
        DeflaterZStreamRef deflaterZStreamRef = this.zsRef;
        synchronized (deflaterZStreamRef) {
            this.zsRef.clean();
            this.input = ZipUtils.defaultBuf;
        }
    }

    private void ensureOpen() {
        assert (Thread.holdsLock(this.zsRef));
        if (this.zsRef.address() == 0L) {
            throw new NullPointerException("Deflater has been closed");
        }
    }

    private static native long init(int var0, int var1, boolean var2);

    private static native void setDictionary(long var0, byte[] var2, int var3, int var4);

    private static native void setDictionaryBuffer(long var0, long var2, int var4);

    private native long deflateBytesBytes(long var1, byte[] var3, int var4, int var5, byte[] var6, int var7, int var8, int var9, int var10);

    private native long deflateBytesBuffer(long var1, byte[] var3, int var4, int var5, long var6, int var8, int var9, int var10);

    private native long deflateBufferBytes(long var1, long var3, int var5, byte[] var6, int var7, int var8, int var9, int var10);

    private native long deflateBufferBuffer(long var1, long var3, int var5, long var6, int var8, int var9, int var10);

    private static native int getAdler(long var0);

    private static native void reset(long var0);

    private static native void end(long var0);

    static {
        ZipUtils.loadLibrary();
    }

    static class DeflaterZStreamRef
    implements Runnable {
        private long address;
        private final Cleaner.Cleanable cleanable;

        private DeflaterZStreamRef(Deflater owner, long addr) {
            this.cleanable = owner != null ? CleanerFactory.cleaner().register(owner, this) : null;
            this.address = addr;
        }

        long address() {
            return this.address;
        }

        void clean() {
            this.cleanable.clean();
        }

        @Override
        public synchronized void run() {
            long addr = this.address;
            this.address = 0L;
            if (addr != 0L) {
                Deflater.end(addr);
            }
        }
    }
}

