/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class GZIPOutputStream
extends DeflaterOutputStream {
    protected CRC32 crc = new CRC32();
    private static final int GZIP_MAGIC = 35615;
    private static final int TRAILER_SIZE = 8;
    private static final byte OS_UNKNOWN = -1;

    public GZIPOutputStream(OutputStream out, int size) throws IOException {
        this(out, size, false);
    }

    public GZIPOutputStream(OutputStream out, int size, boolean syncFlush) throws IOException {
        super(out, out != null ? new Deflater(-1, true) : null, size, syncFlush);
        this.usesDefaultDeflater = true;
        this.writeHeader();
        this.crc.reset();
    }

    public GZIPOutputStream(OutputStream out) throws IOException {
        this(out, 512, false);
    }

    public GZIPOutputStream(OutputStream out, boolean syncFlush) throws IOException {
        this(out, 512, syncFlush);
    }

    @Override
    public synchronized void write(byte[] buf, int off, int len) throws IOException {
        super.write(buf, off, len);
        this.crc.update(buf, off, len);
    }

    @Override
    public void finish() throws IOException {
        if (!this.def.finished()) {
            this.def.finish();
            while (!this.def.finished()) {
                int len = this.def.deflate(this.buf, 0, this.buf.length);
                if (this.def.finished() && len <= this.buf.length - 8) {
                    this.writeTrailer(this.buf, len);
                    this.out.write(this.buf, 0, len += 8);
                    return;
                }
                if (len <= 0) continue;
                this.out.write(this.buf, 0, len);
            }
            byte[] trailer = new byte[8];
            this.writeTrailer(trailer, 0);
            this.out.write(trailer);
        }
    }

    private void writeHeader() throws IOException {
        this.out.write(new byte[]{31, -117, 8, 0, 0, 0, 0, 0, 0, -1});
    }

    private void writeTrailer(byte[] buf, int offset) throws IOException {
        this.writeInt((int)this.crc.getValue(), buf, offset);
        this.writeInt(this.def.getTotalIn(), buf, offset + 4);
    }

    private void writeInt(int i, byte[] buf, int offset) throws IOException {
        this.writeShort(i & 0xFFFF, buf, offset);
        this.writeShort(i >> 16 & 0xFFFF, buf, offset + 2);
    }

    private void writeShort(int s, byte[] buf, int offset) throws IOException {
        buf[offset] = (byte)(s & 0xFF);
        buf[offset + 1] = (byte)(s >> 8 & 0xFF);
    }
}

