/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.lang.ref.Cleaner;
import java.lang.ref.Reference;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.util.Objects;
import java.util.zip.DataFormatException;
import java.util.zip.ZipUtils;
import jdk.internal.ref.CleanerFactory;
import sun.nio.ch.DirectBuffer;

public class Inflater {
    private final InflaterZStreamRef zsRef;
    private ByteBuffer input = ZipUtils.defaultBuf;
    private byte[] inputArray;
    private int inputPos;
    private int inputLim;
    private boolean finished;
    private boolean needDict;
    private long bytesRead;
    private long bytesWritten;
    private int inputConsumed;
    private int outputConsumed;

    public Inflater(boolean nowrap) {
        this.zsRef = new InflaterZStreamRef(this, Inflater.init(nowrap));
    }

    public Inflater() {
        this(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInput(byte[] input, int off, int len) {
        if (off < 0 || len < 0 || off > input.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        InflaterZStreamRef inflaterZStreamRef = this.zsRef;
        synchronized (inflaterZStreamRef) {
            this.input = null;
            this.inputArray = input;
            this.inputPos = off;
            this.inputLim = off + len;
        }
    }

    public void setInput(byte[] input) {
        this.setInput(input, 0, input.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInput(ByteBuffer input) {
        Objects.requireNonNull(input);
        InflaterZStreamRef inflaterZStreamRef = this.zsRef;
        synchronized (inflaterZStreamRef) {
            this.input = input;
            this.inputArray = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDictionary(byte[] dictionary, int off, int len) {
        if (off < 0 || len < 0 || off > dictionary.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        InflaterZStreamRef inflaterZStreamRef = this.zsRef;
        synchronized (inflaterZStreamRef) {
            this.ensureOpen();
            Inflater.setDictionary(this.zsRef.address(), dictionary, off, len);
            this.needDict = false;
        }
    }

    public void setDictionary(byte[] dictionary) {
        this.setDictionary(dictionary, 0, dictionary.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDictionary(ByteBuffer dictionary) {
        InflaterZStreamRef inflaterZStreamRef = this.zsRef;
        synchronized (inflaterZStreamRef) {
            int position = dictionary.position();
            int remaining = Math.max(dictionary.limit() - position, 0);
            this.ensureOpen();
            if (dictionary.isDirect()) {
                long address = ((DirectBuffer)((Object)dictionary)).address();
                try {
                    Inflater.setDictionaryBuffer(this.zsRef.address(), address + (long)position, remaining);
                }
                finally {
                    Reference.reachabilityFence(dictionary);
                }
            } else {
                byte[] array = ZipUtils.getBufferArray(dictionary);
                int offset = ZipUtils.getBufferOffset(dictionary);
                Inflater.setDictionary(this.zsRef.address(), array, offset + position, remaining);
            }
            dictionary.position(position + remaining);
            this.needDict = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRemaining() {
        InflaterZStreamRef inflaterZStreamRef = this.zsRef;
        synchronized (inflaterZStreamRef) {
            ByteBuffer input = this.input;
            return input == null ? this.inputLim - this.inputPos : input.remaining();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean needsInput() {
        InflaterZStreamRef inflaterZStreamRef = this.zsRef;
        synchronized (inflaterZStreamRef) {
            ByteBuffer input = this.input;
            return input == null ? this.inputLim == this.inputPos : !input.hasRemaining();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean needsDictionary() {
        InflaterZStreamRef inflaterZStreamRef = this.zsRef;
        synchronized (inflaterZStreamRef) {
            return this.needDict;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean finished() {
        InflaterZStreamRef inflaterZStreamRef = this.zsRef;
        synchronized (inflaterZStreamRef) {
            return this.finished;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int inflate(byte[] output, int off, int len) throws DataFormatException {
        if (off < 0 || len < 0 || off > output.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        InflaterZStreamRef inflaterZStreamRef = this.zsRef;
        synchronized (inflaterZStreamRef) {
            long result;
            int inputPos;
            ByteBuffer input;
            block19: {
                this.ensureOpen();
                input = this.input;
                try {
                    if (input == null) {
                        inputPos = this.inputPos;
                        try {
                            result = this.inflateBytesBytes(this.zsRef.address(), this.inputArray, inputPos, this.inputLim - inputPos, output, off, len);
                            break block19;
                        }
                        catch (DataFormatException e) {
                            this.inputPos = inputPos + this.inputConsumed;
                            throw e;
                        }
                    }
                    inputPos = input.position();
                    try {
                        int inputRem = Math.max(input.limit() - inputPos, 0);
                        if (input.isDirect()) {
                            try {
                                long inputAddress = ((DirectBuffer)((Object)input)).address();
                                result = this.inflateBufferBytes(this.zsRef.address(), inputAddress + (long)inputPos, inputRem, output, off, len);
                                break block19;
                            }
                            finally {
                                Reference.reachabilityFence(input);
                            }
                        }
                        byte[] inputArray = ZipUtils.getBufferArray(input);
                        int inputOffset = ZipUtils.getBufferOffset(input);
                        result = this.inflateBytesBytes(this.zsRef.address(), inputArray, inputOffset + inputPos, inputRem, output, off, len);
                    }
                    catch (DataFormatException e) {
                        input.position(inputPos + this.inputConsumed);
                        throw e;
                    }
                }
                catch (DataFormatException e) {
                    this.bytesRead += (long)this.inputConsumed;
                    this.inputConsumed = 0;
                    int written = this.outputConsumed;
                    this.bytesWritten += (long)written;
                    this.outputConsumed = 0;
                    throw e;
                }
            }
            int read = (int)(result & Integer.MAX_VALUE);
            int written = (int)(result >>> 31 & Integer.MAX_VALUE);
            if ((result >>> 62 & 1L) != 0L) {
                this.finished = true;
            }
            if ((result >>> 63 & 1L) != 0L) {
                this.needDict = true;
            }
            if (input != null) {
                input.position(inputPos + read);
            } else {
                this.inputPos = inputPos + read;
            }
            this.bytesWritten += (long)written;
            this.bytesRead += (long)read;
            return written;
        }
    }

    public int inflate(byte[] output) throws DataFormatException {
        return this.inflate(output, 0, output.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int inflate(ByteBuffer output) throws DataFormatException {
        if (output.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        InflaterZStreamRef inflaterZStreamRef = this.zsRef;
        synchronized (inflaterZStreamRef) {
            long result;
            int inputPos;
            int outputPos;
            ByteBuffer input;
            block31: {
                this.ensureOpen();
                input = this.input;
                outputPos = output.position();
                int outputRem = Math.max(output.limit() - outputPos, 0);
                try {
                    if (input == null) {
                        inputPos = this.inputPos;
                        try {
                            if (output.isDirect()) {
                                long outputAddress = ((DirectBuffer)((Object)output)).address();
                                try {
                                    result = this.inflateBytesBuffer(this.zsRef.address(), this.inputArray, inputPos, this.inputLim - inputPos, outputAddress + (long)outputPos, outputRem);
                                    break block31;
                                }
                                finally {
                                    Reference.reachabilityFence(output);
                                }
                            }
                            byte[] outputArray = ZipUtils.getBufferArray(output);
                            int outputOffset = ZipUtils.getBufferOffset(output);
                            result = this.inflateBytesBytes(this.zsRef.address(), this.inputArray, inputPos, this.inputLim - inputPos, outputArray, outputOffset + outputPos, outputRem);
                            break block31;
                        }
                        catch (DataFormatException e) {
                            this.inputPos = inputPos + this.inputConsumed;
                            throw e;
                        }
                    }
                    inputPos = input.position();
                    int inputRem = Math.max(input.limit() - inputPos, 0);
                    try {
                        if (input.isDirect()) {
                            long inputAddress = ((DirectBuffer)((Object)input)).address();
                            try {
                                if (output.isDirect()) {
                                    long outputAddress = ((DirectBuffer)((Object)output)).address();
                                    try {
                                        result = this.inflateBufferBuffer(this.zsRef.address(), inputAddress + (long)inputPos, inputRem, outputAddress + (long)outputPos, outputRem);
                                        break block31;
                                    }
                                    finally {
                                        Reference.reachabilityFence(output);
                                    }
                                }
                                byte[] outputArray = ZipUtils.getBufferArray(output);
                                int outputOffset = ZipUtils.getBufferOffset(output);
                                result = this.inflateBufferBytes(this.zsRef.address(), inputAddress + (long)inputPos, inputRem, outputArray, outputOffset + outputPos, outputRem);
                                break block31;
                            }
                            finally {
                                Reference.reachabilityFence(input);
                            }
                        }
                        byte[] inputArray = ZipUtils.getBufferArray(input);
                        int inputOffset = ZipUtils.getBufferOffset(input);
                        if (output.isDirect()) {
                            long outputAddress = ((DirectBuffer)((Object)output)).address();
                            try {
                                result = this.inflateBytesBuffer(this.zsRef.address(), inputArray, inputOffset + inputPos, inputRem, outputAddress + (long)outputPos, outputRem);
                                break block31;
                            }
                            finally {
                                Reference.reachabilityFence(output);
                            }
                        }
                        byte[] outputArray = ZipUtils.getBufferArray(output);
                        int outputOffset = ZipUtils.getBufferOffset(output);
                        result = this.inflateBytesBytes(this.zsRef.address(), inputArray, inputOffset + inputPos, inputRem, outputArray, outputOffset + outputPos, outputRem);
                    }
                    catch (DataFormatException e) {
                        input.position(inputPos + this.inputConsumed);
                        throw e;
                    }
                }
                catch (DataFormatException e) {
                    this.bytesRead += (long)this.inputConsumed;
                    this.inputConsumed = 0;
                    int written = this.outputConsumed;
                    output.position(outputPos + written);
                    this.bytesWritten += (long)written;
                    this.outputConsumed = 0;
                    throw e;
                }
            }
            int read = (int)(result & Integer.MAX_VALUE);
            int written = (int)(result >>> 31 & Integer.MAX_VALUE);
            if ((result >>> 62 & 1L) != 0L) {
                this.finished = true;
            }
            if ((result >>> 63 & 1L) != 0L) {
                this.needDict = true;
            }
            if (input != null) {
                input.position(inputPos + read);
            } else {
                this.inputPos = inputPos + read;
            }
            output.position(outputPos + written);
            this.bytesWritten += (long)written;
            this.bytesRead += (long)read;
            return written;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAdler() {
        InflaterZStreamRef inflaterZStreamRef = this.zsRef;
        synchronized (inflaterZStreamRef) {
            this.ensureOpen();
            return Inflater.getAdler(this.zsRef.address());
        }
    }

    public int getTotalIn() {
        return (int)this.getBytesRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBytesRead() {
        InflaterZStreamRef inflaterZStreamRef = this.zsRef;
        synchronized (inflaterZStreamRef) {
            this.ensureOpen();
            return this.bytesRead;
        }
    }

    public int getTotalOut() {
        return (int)this.getBytesWritten();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBytesWritten() {
        InflaterZStreamRef inflaterZStreamRef = this.zsRef;
        synchronized (inflaterZStreamRef) {
            this.ensureOpen();
            return this.bytesWritten;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        InflaterZStreamRef inflaterZStreamRef = this.zsRef;
        synchronized (inflaterZStreamRef) {
            this.ensureOpen();
            Inflater.reset(this.zsRef.address());
            this.input = ZipUtils.defaultBuf;
            this.inputArray = null;
            this.finished = false;
            this.needDict = false;
            this.bytesWritten = 0L;
            this.bytesRead = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end() {
        InflaterZStreamRef inflaterZStreamRef = this.zsRef;
        synchronized (inflaterZStreamRef) {
            this.zsRef.clean();
            this.input = ZipUtils.defaultBuf;
            this.inputArray = null;
        }
    }

    private void ensureOpen() {
        assert (Thread.holdsLock(this.zsRef));
        if (this.zsRef.address() == 0L) {
            throw new NullPointerException("Inflater has been closed");
        }
    }

    private static native void initIDs();

    private static native long init(boolean var0);

    private static native void setDictionary(long var0, byte[] var2, int var3, int var4);

    private static native void setDictionaryBuffer(long var0, long var2, int var4);

    private native long inflateBytesBytes(long var1, byte[] var3, int var4, int var5, byte[] var6, int var7, int var8) throws DataFormatException;

    private native long inflateBytesBuffer(long var1, byte[] var3, int var4, int var5, long var6, int var8) throws DataFormatException;

    private native long inflateBufferBytes(long var1, long var3, int var5, byte[] var6, int var7, int var8) throws DataFormatException;

    private native long inflateBufferBuffer(long var1, long var3, int var5, long var6, int var8) throws DataFormatException;

    private static native int getAdler(long var0);

    private static native void reset(long var0);

    private static native void end(long var0);

    static {
        ZipUtils.loadLibrary();
        Inflater.initIDs();
    }

    static class InflaterZStreamRef
    implements Runnable {
        private long address;
        private final Cleaner.Cleanable cleanable;

        private InflaterZStreamRef(Inflater owner, long addr) {
            this.cleanable = owner != null ? CleanerFactory.cleaner().register(owner, this) : null;
            this.address = addr;
        }

        long address() {
            return this.address;
        }

        void clean() {
            this.cleanable.clean();
        }

        @Override
        public synchronized void run() {
            long addr = this.address;
            this.address = 0L;
            if (addr != 0L) {
                Inflater.end(addr);
            }
        }
    }
}

