/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.ZipException;

public class InflaterOutputStream
extends FilterOutputStream {
    protected final Inflater inf;
    protected final byte[] buf;
    private final byte[] wbuf = new byte[1];
    private boolean usesDefaultInflater = false;
    private boolean closed = false;

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }

    public InflaterOutputStream(OutputStream out) {
        this(out, out != null ? new Inflater() : null);
        this.usesDefaultInflater = true;
    }

    public InflaterOutputStream(OutputStream out, Inflater infl) {
        this(out, infl, 512);
    }

    public InflaterOutputStream(OutputStream out, Inflater infl, int bufLen) {
        super(out);
        if (out == null) {
            throw new NullPointerException("Null output");
        }
        if (infl == null) {
            throw new NullPointerException("Null inflater");
        }
        if (bufLen <= 0) {
            throw new IllegalArgumentException("Buffer size < 1");
        }
        this.inf = infl;
        this.buf = new byte[bufLen];
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            try {
                this.finish();
            }
            finally {
                this.out.close();
                this.closed = true;
            }
        }
    }

    @Override
    public void flush() throws IOException {
        this.ensureOpen();
        if (!this.inf.finished()) {
            try {
                int n;
                while (!this.inf.finished() && !this.inf.needsInput() && (n = this.inf.inflate(this.buf, 0, this.buf.length)) >= 1) {
                    this.out.write(this.buf, 0, n);
                }
                super.flush();
            }
            catch (DataFormatException ex) {
                String msg = ex.getMessage();
                if (msg == null) {
                    msg = "Invalid ZLIB data format";
                }
                throw new ZipException(msg);
            }
        }
    }

    public void finish() throws IOException {
        this.ensureOpen();
        this.flush();
        if (this.usesDefaultInflater) {
            this.inf.end();
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.wbuf[0] = (byte)b;
        this.write(this.wbuf, 0, 1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        if (b == null) {
            throw new NullPointerException("Null buffer for read");
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        try {
            do {
                int n;
                if (this.inf.needsInput()) {
                    this.inf.setInput(b, off, len);
                    len = 0;
                }
                do {
                    if ((n = this.inf.inflate(this.buf, 0, this.buf.length)) <= 0) continue;
                    this.out.write(this.buf, 0, n);
                } while (n > 0);
                if (!this.inf.needsDictionary()) continue;
                throw new ZipException("ZLIB dictionary missing");
            } while (!this.inf.finished() && len != 0);
        }
        catch (DataFormatException ex) {
            String msg = ex.getMessage();
            if (msg == null) {
                msg = "Invalid ZLIB data format";
            }
            throw new ZipException(msg);
        }
    }
}

