/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.UncheckedIOException;
import java.lang.ref.Cleaner;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterators;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipCoder;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipUtils;
import jdk.internal.access.JavaUtilJarAccess;
import jdk.internal.access.JavaUtilZipFileAccess;
import jdk.internal.access.SharedSecrets;
import jdk.internal.misc.VM;
import jdk.internal.perf.PerfCounter;
import jdk.internal.ref.CleanerFactory;
import jdk.internal.vm.annotation.Stable;
import sun.nio.cs.UTF_8;
import sun.security.util.SignatureFileVerifier;

public class ZipFile
implements ZipConstants,
Closeable {
    private final String name;
    private volatile boolean closeRequested;
    @Stable
    private final CleanableResource res;
    private static final int STORED = 0;
    private static final int DEFLATED = 8;
    public static final int OPEN_READ = 1;
    public static final int OPEN_DELETE = 4;
    private String lastEntryName;
    private int lastEntryPos;
    private static boolean isWindows;

    public ZipFile(String name) throws IOException {
        this(new File(name), 1);
    }

    public ZipFile(File file, int mode) throws IOException {
        this(file, mode, UTF_8.INSTANCE);
    }

    public ZipFile(File file) throws ZipException, IOException {
        this(file, 1);
    }

    public ZipFile(File file, int mode, Charset charset) throws IOException {
        if ((mode & 1) == 0 || (mode & 0xFFFFFFFA) != 0) {
            throw new IllegalArgumentException("Illegal mode: 0x" + Integer.toHexString(mode));
        }
        String name = file.getPath();
        file = new File(name);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkRead(name);
            if ((mode & 4) != 0) {
                sm.checkDelete(name);
            }
        }
        Objects.requireNonNull(charset, "charset");
        this.name = name;
        long t0 = System.nanoTime();
        this.res = new CleanableResource(this, ZipCoder.get(charset), file, mode);
        PerfCounter.getZipFileOpenTime().addElapsedTimeFrom(t0);
        PerfCounter.getZipFileCount().increment();
    }

    public ZipFile(String name, Charset charset) throws IOException {
        this(new File(name), 1, charset);
    }

    public ZipFile(File file, Charset charset) throws IOException {
        this(file, 1, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getComment() {
        ZipFile zipFile = this;
        synchronized (zipFile) {
            this.ensureOpen();
            if (this.res.zsrc.comment == null) {
                return null;
            }
            return this.res.zsrc.zc.toString(this.res.zsrc.comment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipEntry getEntry(String name) {
        Objects.requireNonNull(name, "name");
        ZipEntry entry = null;
        ZipFile zipFile = this;
        synchronized (zipFile) {
            this.ensureOpen();
            int pos = this.res.zsrc.getEntryPos(name, true);
            if (pos != -1) {
                entry = this.getZipEntry(name, pos);
            }
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream(ZipEntry entry) throws IOException {
        Objects.requireNonNull(entry, "entry");
        Source zsrc = this.res.zsrc;
        Set<InputStream> istreams = this.res.istreams;
        ZipFile zipFile = this;
        synchronized (zipFile) {
            this.ensureOpen();
            int pos = Objects.equals(this.lastEntryName, entry.name) ? this.lastEntryPos : zsrc.getEntryPos(entry.name, false);
            if (pos == -1) {
                return null;
            }
            ZipFileInputStream in = new ZipFileInputStream(zsrc.cen, pos);
            switch (ZipUtils.CENHOW(zsrc.cen, pos)) {
                case 0: {
                    Set<InputStream> set = istreams;
                    synchronized (set) {
                        istreams.add(in);
                    }
                    return in;
                }
                case 8: {
                    long size = ZipUtils.CENLEN(zsrc.cen, pos) + 2L;
                    if (size > 65536L) {
                        size = 8192L;
                    }
                    if (size <= 0L) {
                        size = 4096L;
                    }
                    ZipFileInflaterInputStream is = new ZipFileInflaterInputStream(in, this.res, (int)size);
                    Set<InputStream> set = istreams;
                    synchronized (set) {
                        istreams.add(is);
                    }
                    return is;
                }
            }
            throw new ZipException("invalid compression method");
        }
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration<? extends ZipEntry> entries() {
        ZipFile zipFile = this;
        synchronized (zipFile) {
            this.ensureOpen();
            return new ZipEntryIterator(this.res.zsrc.total);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Enumeration<JarEntry> jarEntries() {
        ZipFile zipFile = this;
        synchronized (zipFile) {
            this.ensureOpen();
            return new ZipEntryIterator<JarEntry>(this.res.zsrc.total);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<? extends ZipEntry> stream() {
        ZipFile zipFile = this;
        synchronized (zipFile) {
            this.ensureOpen();
            return StreamSupport.stream(new EntrySpliterator<ZipEntry>(0, this.res.zsrc.total, pos -> this.getZipEntry(null, pos)), false);
        }
    }

    private String getEntryName(int pos) {
        byte[] cen = this.res.zsrc.cen;
        int nlen = ZipUtils.CENNAM(cen, pos);
        ZipCoder zc = this.res.zsrc.zipCoderForPos(pos);
        return zc.toString(cen, pos + 46, nlen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Stream<String> entryNameStream() {
        ZipFile zipFile = this;
        synchronized (zipFile) {
            this.ensureOpen();
            return StreamSupport.stream(new EntrySpliterator<String>(0, this.res.zsrc.total, this::getEntryName), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Stream<JarEntry> jarStream() {
        ZipFile zipFile = this;
        synchronized (zipFile) {
            this.ensureOpen();
            return StreamSupport.stream(new EntrySpliterator<JarEntry>(0, this.res.zsrc.total, pos -> (JarEntry)this.getZipEntry(null, pos)), false);
        }
    }

    private ZipEntry getZipEntry(String name, int pos) {
        int start;
        byte[] cen = this.res.zsrc.cen;
        int nlen = ZipUtils.CENNAM(cen, pos);
        int elen = ZipUtils.CENEXT(cen, pos);
        int clen = ZipUtils.CENCOM(cen, pos);
        ZipCoder zc = this.res.zsrc.zipCoderForPos(pos);
        if (name != null) {
            if (nlen > 0 && !name.isEmpty() && zc.hasTrailingSlash(cen, pos + 46 + nlen) && !name.endsWith("/")) {
                name = name + '/';
            }
        } else {
            name = zc.toString(cen, pos + 46, nlen);
        }
        ZipEntry e = this instanceof JarFile ? Source.JUJA.entryFor((JarFile)this, name) : new ZipEntry(name);
        e.flag = ZipUtils.CENFLG(cen, pos);
        e.xdostime = ZipUtils.CENTIM(cen, pos);
        e.crc = ZipUtils.CENCRC(cen, pos);
        e.size = ZipUtils.CENLEN(cen, pos);
        e.csize = ZipUtils.CENSIZ(cen, pos);
        e.method = ZipUtils.CENHOW(cen, pos);
        if (ZipUtils.CENVEM_FA(cen, pos) == 3) {
            e.extraAttributes = ZipUtils.CENATX_PERMS(cen, pos) & 0xFFFF;
        }
        if (elen != 0) {
            start = pos + 46 + nlen;
            e.setExtra0(Arrays.copyOfRange(cen, start, start + elen), true, false);
        }
        if (clen != 0) {
            start = pos + 46 + nlen + elen;
            e.comment = zc.toString(cen, start, clen);
        }
        this.lastEntryName = e.name;
        this.lastEntryPos = pos;
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        ZipFile zipFile = this;
        synchronized (zipFile) {
            this.ensureOpen();
            return this.res.zsrc.total;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.closeRequested) {
            return;
        }
        this.closeRequested = true;
        ZipFile zipFile = this;
        synchronized (zipFile) {
            try {
                this.res.clean();
            }
            catch (UncheckedIOException ioe) {
                throw ioe.getCause();
            }
        }
    }

    private void ensureOpen() {
        if (this.closeRequested) {
            throw new IllegalStateException("zip file closed");
        }
        if (this.res.zsrc == null) {
            throw new IllegalStateException("The object is not initialized.");
        }
    }

    private void ensureOpenOrZipException() throws IOException {
        if (this.closeRequested) {
            throw new ZipException("ZipFile closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getManifestAndSignatureRelatedFiles() {
        ZipFile zipFile = this;
        synchronized (zipFile) {
            this.ensureOpen();
            Source zsrc = this.res.zsrc;
            int[] metanames = zsrc.signatureMetaNames;
            ArrayList<String> files = null;
            if (zsrc.manifestPos >= 0) {
                files = new ArrayList<String>();
                files.add(this.getEntryName(zsrc.manifestPos));
            }
            if (metanames != null) {
                if (files == null) {
                    files = new ArrayList();
                }
                for (int i = 0; i < metanames.length; ++i) {
                    files.add(this.getEntryName(metanames[i]));
                }
            }
            return files == null ? List.of() : files;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getManifestNum() {
        ZipFile zipFile = this;
        synchronized (zipFile) {
            this.ensureOpen();
            return this.res.zsrc.manifestNum;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getManifestName(boolean onlyIfSignatureRelatedFiles) {
        ZipFile zipFile = this;
        synchronized (zipFile) {
            this.ensureOpen();
            Source zsrc = this.res.zsrc;
            int pos = zsrc.manifestPos;
            if (!(pos < 0 || onlyIfSignatureRelatedFiles && zsrc.signatureMetaNames == null)) {
                return this.getEntryName(pos);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] getMetaInfVersions() {
        ZipFile zipFile = this;
        synchronized (zipFile) {
            this.ensureOpen();
            return this.res.zsrc.metaVersions;
        }
    }

    static {
        SharedSecrets.setJavaUtilZipFileAccess(new JavaUtilZipFileAccess(){

            @Override
            public boolean startsWithLocHeader(ZipFile zip) {
                return zip.res.zsrc.startsWithLoc;
            }

            @Override
            public List<String> getManifestAndSignatureRelatedFiles(JarFile jar) {
                return jar.getManifestAndSignatureRelatedFiles();
            }

            @Override
            public int getManifestNum(JarFile jar) {
                return jar.getManifestNum();
            }

            @Override
            public String getManifestName(JarFile jar, boolean onlyIfHasSignatureRelatedFiles) {
                return jar.getManifestName(onlyIfHasSignatureRelatedFiles);
            }

            @Override
            public int[] getMetaInfVersions(JarFile jar) {
                return jar.getMetaInfVersions();
            }

            @Override
            public Enumeration<JarEntry> entries(ZipFile zip) {
                return zip.jarEntries();
            }

            @Override
            public Stream<JarEntry> stream(ZipFile zip) {
                return zip.jarStream();
            }

            @Override
            public Stream<String> entryNameStream(ZipFile zip) {
                return zip.entryNameStream();
            }

            @Override
            public int getExtraAttributes(ZipEntry ze) {
                return ze.extraAttributes;
            }

            @Override
            public void setExtraAttributes(ZipEntry ze, int extraAttrs) {
                ze.extraAttributes = extraAttrs;
            }
        });
        isWindows = VM.getSavedProperty("os.name").contains("Windows");
    }

    private static class CleanableResource
    implements Runnable {
        final Set<InputStream> istreams;
        Deque<Inflater> inflaterCache;
        final Cleaner.Cleanable cleanable;
        Source zsrc;

        CleanableResource(ZipFile zf, ZipCoder zc, File file, int mode) throws IOException {
            this.cleanable = CleanerFactory.cleaner().register(zf, this);
            this.istreams = Collections.newSetFromMap(new WeakHashMap());
            this.inflaterCache = new ArrayDeque<Inflater>();
            this.zsrc = Source.get(file, (mode & 4) != 0, zc);
        }

        void clean() {
            this.cleanable.clean();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Inflater getInflater() {
            Deque<Inflater> deque = this.inflaterCache;
            synchronized (deque) {
                Inflater inf = this.inflaterCache.poll();
                if (inf != null) {
                    return inf;
                }
            }
            return new Inflater(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void releaseInflater(Inflater inf) {
            Deque<Inflater> inflaters = this.inflaterCache;
            if (inflaters != null) {
                Deque<Inflater> deque = inflaters;
                synchronized (deque) {
                    if (inflaters == this.inflaterCache) {
                        inf.reset();
                        inflaters.add(inf);
                        return;
                    }
                }
            }
            inf.end();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object2;
            IOException ioe = null;
            Deque<Inflater> inflaters = this.inflaterCache;
            if (inflaters != null) {
                object2 = inflaters;
                synchronized (object2) {
                    Inflater inf;
                    while ((inf = inflaters.poll()) != null) {
                        inf.end();
                    }
                    this.inflaterCache = null;
                }
            }
            if (this.istreams != null) {
                object2 = this.istreams;
                synchronized (object2) {
                    if (!this.istreams.isEmpty()) {
                        InputStream[] copy = this.istreams.toArray(new InputStream[0]);
                        this.istreams.clear();
                        for (InputStream is : copy) {
                            try {
                                is.close();
                            }
                            catch (IOException e) {
                                if (ioe == null) {
                                    ioe = e;
                                    continue;
                                }
                                ioe.addSuppressed(e);
                            }
                        }
                    }
                }
            }
            if (this.zsrc != null) {
                object2 = this.zsrc;
                synchronized (object2) {
                    try {
                        Source.release(this.zsrc);
                        this.zsrc = null;
                    }
                    catch (IOException e) {
                        if (ioe == null) {
                            ioe = e;
                        }
                        ioe.addSuppressed(e);
                    }
                }
            }
            if (ioe != null) {
                throw new UncheckedIOException(ioe);
            }
        }
    }

    private static class Source {
        private static final JavaUtilJarAccess JUJA = SharedSecrets.javaUtilJarAccess();
        private static final int META_INF_LEN = 9;
        private static final int[] EMPTY_META_VERSIONS = new int[0];
        private final Key key;
        @Stable
        private final ZipCoder zc;
        private int refs = 1;
        private RandomAccessFile zfile;
        private byte[] cen;
        private long locpos;
        private byte[] comment;
        private int manifestPos = -1;
        private int manifestNum = 0;
        private int[] signatureMetaNames;
        private int[] metaVersions;
        private final boolean startsWithLoc;
        private int[] entries;
        private static final int ZIP_ENDCHAIN = -1;
        private int total;
        private int[] table;
        private int tablelen;
        private static final HashMap<Key, Source> files = new HashMap();
        private static final int BUF_SIZE = 8192;

        private int checkAndAddEntry(int pos, int index) throws ZipException {
            int nlen;
            int entryPos;
            byte[] cen = this.cen;
            if (ZipUtils.CENSIG(cen, pos) != 33639248L) {
                Source.zerror("invalid CEN header (bad signature)");
            }
            int method = ZipUtils.CENHOW(cen, pos);
            int flag = ZipUtils.CENFLG(cen, pos);
            if ((flag & 1) != 0) {
                Source.zerror("invalid CEN header (encrypted entry)");
            }
            if (method != 0 && method != 8) {
                Source.zerror("invalid CEN header (bad compression method: " + method + ")");
            }
            if ((entryPos = pos + 46) + (nlen = ZipUtils.CENNAM(cen, pos)) > cen.length - 22) {
                Source.zerror("invalid CEN header (bad header size)");
            }
            try {
                ZipCoder zcp = this.zipCoderForPos(pos);
                int hash = zcp.checkedHash(cen, entryPos, nlen);
                int hsh = (hash & Integer.MAX_VALUE) % this.tablelen;
                int next = this.table[hsh];
                this.table[hsh] = index;
                this.entries[index++] = hash;
                this.entries[index++] = next;
                this.entries[index] = pos;
            }
            catch (Exception e) {
                Source.zerror("invalid CEN header (bad entry name)");
            }
            return nlen;
        }

        private int getEntryHash(int index) {
            return this.entries[index];
        }

        private int getEntryNext(int index) {
            return this.entries[index + 1];
        }

        private int getEntryPos(int index) {
            return this.entries[index + 2];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static Source get(File file, boolean toDelete, ZipCoder zc) throws IOException {
            Source src;
            Key key;
            try {
                key = new Key(file, Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]), zc);
            }
            catch (InvalidPathException ipe) {
                throw new IOException(ipe);
            }
            HashMap<Key, Source> hashMap = files;
            synchronized (hashMap) {
                src = files.get(key);
                if (src != null) {
                    ++src.refs;
                    return src;
                }
            }
            src = new Source(key, toDelete, zc);
            hashMap = files;
            synchronized (hashMap) {
                if (files.containsKey(key)) {
                    src.close();
                    src = files.get(key);
                    ++src.refs;
                    return src;
                }
                files.put(key, src);
                return src;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void release(Source src) throws IOException {
            HashMap<Key, Source> hashMap = files;
            synchronized (hashMap) {
                if (src != null && --src.refs == 0) {
                    files.remove(src.key);
                    src.close();
                }
            }
        }

        private Source(Key key, boolean toDelete, ZipCoder zc) throws IOException {
            this.zc = zc;
            this.key = key;
            if (toDelete) {
                if (isWindows) {
                    this.zfile = SharedSecrets.getJavaIORandomAccessFileAccess().openAndDelete(key.file, "r");
                } else {
                    this.zfile = new RandomAccessFile(key.file, "r");
                    key.file.delete();
                }
            } else {
                this.zfile = new RandomAccessFile(key.file, "r");
            }
            try {
                this.initCEN(-1);
                byte[] buf = new byte[4];
                this.readFullyAt(buf, 0, 4, 0L);
                this.startsWithLoc = ZipUtils.LOCSIG(buf) == 67324752L;
            }
            catch (IOException x) {
                try {
                    this.zfile.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw x;
            }
        }

        private void close() throws IOException {
            this.zfile.close();
            this.zfile = null;
            this.cen = null;
            this.entries = null;
            this.table = null;
            this.manifestPos = -1;
            this.manifestNum = 0;
            this.signatureMetaNames = null;
            this.metaVersions = EMPTY_META_VERSIONS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final int readFullyAt(byte[] buf, int off, int len, long pos) throws IOException {
            RandomAccessFile randomAccessFile = this.zfile;
            synchronized (randomAccessFile) {
                int n;
                this.zfile.seek(pos);
                for (int N = len; N > 0; N -= n) {
                    n = Math.min(8192, N);
                    this.zfile.readFully(buf, off, n);
                    off += n;
                }
                return len;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final int readAt(byte[] buf, int off, int len, long pos) throws IOException {
            RandomAccessFile randomAccessFile = this.zfile;
            synchronized (randomAccessFile) {
                this.zfile.seek(pos);
                return this.zfile.read(buf, off, len);
            }
        }

        private End findEND() throws IOException {
            long ziplen = this.zfile.length();
            if (ziplen <= 0L) {
                Source.zerror("zip file is empty");
            }
            End end = new End();
            byte[] buf = new byte[128];
            long minHDR = ziplen - 65557L > 0L ? ziplen - 65557L : 0L;
            long minPos = minHDR - (long)(buf.length - 22);
            for (long pos = ziplen - (long)buf.length; pos >= minPos; pos -= (long)(buf.length - 22)) {
                int len;
                int off = 0;
                if (pos < 0L) {
                    off = (int)(-pos);
                    Arrays.fill(buf, 0, off, (byte)0);
                }
                if (this.readFullyAt(buf, off, len = buf.length - off, pos + (long)off) != len) {
                    Source.zerror("zip END header not found");
                }
                for (int i = buf.length - 22; i >= 0; --i) {
                    if (buf[i + 0] != 80 || buf[i + 1] != 75 || buf[i + 2] != 5 || buf[i + 3] != 6) continue;
                    byte[] endbuf = Arrays.copyOfRange(buf, i, i + 22);
                    end.centot = ZipUtils.ENDTOT(endbuf);
                    end.cenlen = ZipUtils.ENDSIZ(endbuf);
                    end.cenoff = ZipUtils.ENDOFF(endbuf);
                    end.endpos = pos + (long)i;
                    int comlen = ZipUtils.ENDCOM(endbuf);
                    if (end.endpos + 22L + (long)comlen != ziplen) {
                        byte[] sbuf = new byte[4];
                        long cenpos = end.endpos - end.cenlen;
                        long locpos = cenpos - end.cenoff;
                        if (cenpos < 0L || locpos < 0L || this.readFullyAt(sbuf, 0, sbuf.length, cenpos) != 4 || ZipUtils.GETSIG(sbuf) != 33639248L || this.readFullyAt(sbuf, 0, sbuf.length, locpos) != 4 || ZipUtils.GETSIG(sbuf) != 67324752L) continue;
                    }
                    if (comlen > 0) {
                        this.comment = new byte[comlen];
                        if (this.readFullyAt(this.comment, 0, comlen, end.endpos + 22L) != comlen) {
                            Source.zerror("zip comment read failed");
                        }
                    }
                    try {
                        byte[] loc64 = new byte[20];
                        if (end.endpos < 20L || this.readFullyAt(loc64, 0, loc64.length, end.endpos - 20L) != loc64.length || ZipUtils.GETSIG(loc64) != 117853008L) {
                            return end;
                        }
                        byte[] end64buf = new byte[56];
                        long end64pos = ZipUtils.ZIP64_LOCOFF(loc64);
                        if (this.readFullyAt(end64buf, 0, end64buf.length, end64pos) != end64buf.length || ZipUtils.GETSIG(end64buf) != 101075792L) {
                            return end;
                        }
                        long cenlen64 = ZipUtils.ZIP64_ENDSIZ(end64buf);
                        long cenoff64 = ZipUtils.ZIP64_ENDOFF(end64buf);
                        long centot64 = ZipUtils.ZIP64_ENDTOT(end64buf);
                        if (cenlen64 != end.cenlen && end.cenlen != 0xFFFFFFFFL || cenoff64 != end.cenoff && end.cenoff != 0xFFFFFFFFL || centot64 != (long)end.centot && end.centot != 65535) {
                            return end;
                        }
                        end.cenlen = cenlen64;
                        end.cenoff = cenoff64;
                        end.centot = (int)centot64;
                        end.endpos = end64pos;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return end;
                }
            }
            throw new ZipException("zip END header not found");
        }

        private void initCEN(int knownTotal) throws IOException {
            int tablelen;
            byte[] cen;
            if (knownTotal == -1) {
                End end = this.findEND();
                if (end.endpos == 0L) {
                    this.locpos = 0L;
                    this.total = 0;
                    this.entries = new int[0];
                    this.cen = null;
                    return;
                }
                if (end.cenlen > end.endpos) {
                    Source.zerror("invalid END header (bad central directory size)");
                }
                long cenpos = end.endpos - end.cenlen;
                this.locpos = cenpos - end.cenoff;
                if (this.locpos < 0L) {
                    Source.zerror("invalid END header (bad central directory offset)");
                }
                if ((long)this.readFullyAt(cen = (this.cen = new byte[(int)(end.cenlen + 22L)]), 0, cen.length, cenpos) != end.cenlen + 22L) {
                    Source.zerror("read CEN tables failed");
                }
                this.total = end.centot;
            } else {
                cen = this.cen;
                this.total = knownTotal;
            }
            int entriesLength = this.total * 3;
            this.entries = new int[entriesLength];
            this.tablelen = tablelen = this.total / 2 | 1;
            int[] table = new int[tablelen];
            this.table = table;
            Arrays.fill(table, -1);
            ArrayList<Integer> signatureNames = null;
            TreeSet<Integer> metaVersionsSet = null;
            int idx = 0;
            int pos = 0;
            int entryPos = 46;
            int limit = cen.length - 22;
            this.manifestNum = 0;
            while (entryPos <= limit) {
                if (idx >= entriesLength) {
                    this.initCEN(Source.countCENHeaders(cen, limit));
                    return;
                }
                int nlen = this.checkAndAddEntry(pos, idx);
                idx += 3;
                if (Source.isMetaName(cen, entryPos, nlen)) {
                    if (this.isManifestName(entryPos + 9, nlen - 9)) {
                        this.manifestPos = pos;
                        ++this.manifestNum;
                    } else {
                        int version;
                        if (this.isSignatureRelated(entryPos, nlen)) {
                            if (signatureNames == null) {
                                signatureNames = new ArrayList<Integer>(4);
                            }
                            signatureNames.add(pos);
                        }
                        if ((version = this.getMetaVersion(entryPos + 9, nlen - 9)) > 0) {
                            if (metaVersionsSet == null) {
                                metaVersionsSet = new TreeSet<Integer>();
                            }
                            metaVersionsSet.add(version);
                        }
                    }
                }
                pos = this.nextEntryPos(pos, entryPos, nlen);
                entryPos = pos + 46;
            }
            this.total = idx / 3;
            if (signatureNames != null) {
                int len = signatureNames.size();
                this.signatureMetaNames = new int[len];
                for (int j = 0; j < len; ++j) {
                    this.signatureMetaNames[j] = (Integer)signatureNames.get(j);
                }
            }
            if (metaVersionsSet != null) {
                this.metaVersions = new int[metaVersionsSet.size()];
                int c = 0;
                for (Integer version : metaVersionsSet) {
                    this.metaVersions[c++] = version;
                }
            } else {
                this.metaVersions = EMPTY_META_VERSIONS;
            }
            if (pos + 22 != cen.length) {
                Source.zerror("invalid CEN header (bad header size)");
            }
        }

        private int nextEntryPos(int pos, int entryPos, int nlen) {
            return entryPos + nlen + ZipUtils.CENCOM(this.cen, pos) + ZipUtils.CENEXT(this.cen, pos);
        }

        private static void zerror(String msg) throws ZipException {
            throw new ZipException(msg);
        }

        private int getEntryPos(String name, boolean addSlash) {
            if (this.total == 0) {
                return -1;
            }
            int hsh = ZipCoder.hash(name);
            int idx = this.table[(hsh & Integer.MAX_VALUE) % this.tablelen];
            while (idx != -1) {
                if (this.getEntryHash(idx) == hsh) {
                    int pos = this.getEntryPos(idx);
                    try {
                        ZipCoder zc = this.zipCoderForPos(pos);
                        String entry = zc.toString(this.cen, pos + 46, ZipUtils.CENNAM(this.cen, pos));
                        int entryLen = entry.length();
                        int nameLen = name.length();
                        if (entryLen == nameLen && entry.equals(name) || addSlash && nameLen + 1 == entryLen && entry.startsWith(name) && entry.charAt(entryLen - 1) == '/') {
                            return pos;
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                idx = this.getEntryNext(idx);
            }
            return -1;
        }

        private ZipCoder zipCoderForPos(int pos) {
            if (this.zc.isUTF8()) {
                return this.zc;
            }
            if ((ZipUtils.CENFLG(this.cen, pos) & 0x800) != 0) {
                return ZipCoder.UTF8;
            }
            return this.zc;
        }

        private static boolean isMetaName(byte[] name, int off, int len) {
            return len > 9 && name[off + len - 1] != 47 && (name[off++] | 0x20) == 109 && (name[off++] | 0x20) == 101 && (name[off++] | 0x20) == 116 && (name[off++] | 0x20) == 97 && name[off++] == 45 && (name[off++] | 0x20) == 105 && (name[off++] | 0x20) == 110 && (name[off++] | 0x20) == 102 && name[off] == 47;
        }

        private boolean isManifestName(int off, int len) {
            byte[] name = this.cen;
            return len == 11 && (name[off++] | 0x20) == 109 && (name[off++] | 0x20) == 97 && (name[off++] | 0x20) == 110 && (name[off++] | 0x20) == 105 && (name[off++] | 0x20) == 102 && (name[off++] | 0x20) == 101 && (name[off++] | 0x20) == 115 && (name[off++] | 0x20) == 116 && name[off++] == 46 && (name[off++] | 0x20) == 109 && (name[off] | 0x20) == 102;
        }

        private boolean isSignatureRelated(int off, int len) {
            boolean signatureRelated = false;
            byte[] name = this.cen;
            if (name[off + len - 3] == 46) {
                int b1 = name[off + len - 2] | 0x20;
                int b2 = name[off + len - 1] | 0x20;
                if (b1 == 101 && b2 == 99 || b1 == 115 && b2 == 102) {
                    signatureRelated = true;
                }
            } else if (name[off + len - 4] == 46) {
                int b1 = name[off + len - 3] | 0x20;
                int b2 = name[off + len - 2] | 0x20;
                int b3 = name[off + len - 1] | 0x20;
                if ((b1 == 114 || b1 == 100) && b2 == 115 && b3 == 97) {
                    signatureRelated = true;
                }
            }
            assert (signatureRelated == SignatureFileVerifier.isBlockOrSF(new String(name, off, len, UTF_8.INSTANCE).toUpperCase(Locale.ENGLISH)));
            return signatureRelated;
        }

        private int getMetaVersion(int off, int len) {
            byte[] name = this.cen;
            int nend = off + len;
            if (len <= 10 || name[off + len - 1] == 47 || (name[off++] | 0x20) != 118 || (name[off++] | 0x20) != 101 || (name[off++] | 0x20) != 114 || (name[off++] | 0x20) != 115 || (name[off++] | 0x20) != 105 || (name[off++] | 0x20) != 111 || (name[off++] | 0x20) != 110 || (name[off++] | 0x20) != 115 || name[off++] != 47) {
                return 0;
            }
            int version = 0;
            while (off < nend) {
                byte c;
                if ((c = name[off++]) == 47) {
                    return version;
                }
                if (c < 48 || c > 57) {
                    return 0;
                }
                if ((version = version * 10 + c - 48) > 0) continue;
                return 0;
            }
            return 0;
        }

        private static int countCENHeaders(byte[] cen, int size) {
            int count = 0;
            int p = 0;
            while (p + 46 <= size) {
                ++count;
                p += 46 + ZipUtils.CENNAM(cen, p) + ZipUtils.CENEXT(cen, p) + ZipUtils.CENCOM(cen, p);
            }
            return count;
        }

        private static class Key {
            final BasicFileAttributes attrs;
            File file;
            final boolean utf8;

            public Key(File file, BasicFileAttributes attrs, ZipCoder zc) {
                this.attrs = attrs;
                this.file = file;
                this.utf8 = zc.isUTF8();
            }

            public int hashCode() {
                long t = this.utf8 ? 0L : Long.MAX_VALUE;
                return (int)((t += this.attrs.lastModifiedTime().toMillis()) ^ t >>> 32) + this.file.hashCode();
            }

            public boolean equals(Object obj) {
                if (obj instanceof Key) {
                    Key key = (Key)obj;
                    if (key.utf8 != this.utf8) {
                        return false;
                    }
                    if (!this.attrs.lastModifiedTime().equals(key.attrs.lastModifiedTime())) {
                        return false;
                    }
                    Object fk = this.attrs.fileKey();
                    if (fk != null) {
                        return fk.equals(key.attrs.fileKey());
                    }
                    return this.file.equals(key.file);
                }
                return false;
            }
        }

        private static class End {
            int centot;
            long cenlen;
            long cenoff;
            long endpos;

            private End() {
            }
        }
    }

    private class ZipFileInputStream
    extends InputStream {
        private volatile boolean closeRequested;
        private long pos;
        private long startingPos;
        protected long rem;
        protected long size;

        ZipFileInputStream(byte[] cen, int cenpos) {
            this.rem = ZipUtils.CENSIZ(cen, cenpos);
            this.size = ZipUtils.CENLEN(cen, cenpos);
            this.pos = ZipUtils.CENOFF(cen, cenpos);
            if (this.rem == 0xFFFFFFFFL || this.size == 0xFFFFFFFFL || this.pos == 0xFFFFFFFFL) {
                this.checkZIP64(cen, cenpos);
            }
            this.pos = -(this.pos + ZipFile.this.res.zsrc.locpos);
        }

        private void checkZIP64(byte[] cen, int cenpos) {
            int off = cenpos + 46 + ZipUtils.CENNAM(cen, cenpos);
            int end = off + ZipUtils.CENEXT(cen, cenpos);
            while (off + 4 < end) {
                int sz;
                int tag = ZipUtils.get16(cen, off);
                if ((off += 4) + (sz = ZipUtils.get16(cen, off + 2)) > end) break;
                if (tag == 1) {
                    if (this.size == 0xFFFFFFFFL) {
                        if (sz < 8 || off + 8 > end) break;
                        this.size = ZipUtils.get64(cen, off);
                        sz -= 8;
                        off += 8;
                    }
                    if (this.rem == 0xFFFFFFFFL) {
                        if (sz < 8 || off + 8 > end) break;
                        this.rem = ZipUtils.get64(cen, off);
                        sz -= 8;
                        off += 8;
                    }
                    if (this.pos != 0xFFFFFFFFL || sz < 8 || off + 8 > end) break;
                    this.pos = ZipUtils.get64(cen, off);
                    sz -= 8;
                    off += 8;
                    break;
                }
                off += sz;
            }
        }

        private long initDataOffset() throws IOException {
            if (this.pos <= 0L) {
                byte[] loc = new byte[30];
                this.pos = -this.pos;
                int len = ZipFile.this.res.zsrc.readFullyAt(loc, 0, loc.length, this.pos);
                if (len != 30) {
                    throw new ZipException("ZipFile error reading zip file");
                }
                if (ZipUtils.LOCSIG(loc) != 67324752L) {
                    throw new ZipException("ZipFile invalid LOC header (bad signature)");
                }
                this.pos += (long)(30 + ZipUtils.LOCNAM(loc) + ZipUtils.LOCEXT(loc));
                this.startingPos = this.pos;
            }
            return this.pos;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            ZipFile zipFile = ZipFile.this;
            synchronized (zipFile) {
                ZipFile.this.ensureOpenOrZipException();
                this.initDataOffset();
                if (this.rem == 0L) {
                    return -1;
                }
                if ((long)len > this.rem) {
                    len = (int)this.rem;
                }
                if (len <= 0) {
                    return 0;
                }
                if ((len = ZipFile.this.res.zsrc.readAt(b, off, len, this.pos)) > 0) {
                    this.pos += (long)len;
                    this.rem -= (long)len;
                }
            }
            if (this.rem == 0L) {
                this.close();
            }
            return len;
        }

        @Override
        public int read() throws IOException {
            byte[] b = new byte[1];
            if (this.read(b, 0, 1) == 1) {
                return b[0] & 0xFF;
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long skip(long n) throws IOException {
            ZipFile zipFile = ZipFile.this;
            synchronized (zipFile) {
                this.initDataOffset();
                long newPos = this.pos + n;
                if (n > 0L) {
                    if (newPos < 0L || n > this.rem) {
                        n = this.rem;
                    }
                } else if (newPos < this.startingPos) {
                    n = this.startingPos - this.pos;
                }
                this.pos += n;
                this.rem -= n;
            }
            if (this.rem == 0L) {
                this.close();
            }
            return n;
        }

        @Override
        public int available() {
            return this.rem > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.rem;
        }

        public long size() {
            return this.size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            if (this.closeRequested) {
                return;
            }
            this.closeRequested = true;
            this.rem = 0L;
            Set<InputStream> set = ZipFile.this.res.istreams;
            synchronized (set) {
                ZipFile.this.res.istreams.remove(this);
            }
        }
    }

    private class ZipFileInflaterInputStream
    extends InflaterInputStream {
        private volatile boolean closeRequested;
        private boolean eof;
        private final Cleaner.Cleanable cleanable;

        ZipFileInflaterInputStream(ZipFileInputStream zfin, CleanableResource res, int size) {
            this(zfin, res, res.getInflater(), size);
        }

        private ZipFileInflaterInputStream(ZipFileInputStream zfin, CleanableResource res, Inflater inf, int size) {
            super(zfin, inf, size);
            this.eof = false;
            this.cleanable = CleanerFactory.cleaner().register(this, new InflaterCleanupAction(inf, res));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            if (this.closeRequested) {
                return;
            }
            this.closeRequested = true;
            super.close();
            Set<InputStream> set = ZipFile.this.res.istreams;
            synchronized (set) {
                ZipFile.this.res.istreams.remove(this);
            }
            this.cleanable.clean();
        }

        @Override
        protected void fill() throws IOException {
            if (this.eof) {
                throw new EOFException("Unexpected end of ZLIB input stream");
            }
            this.len = this.in.read(this.buf, 0, this.buf.length);
            if (this.len == -1) {
                this.buf[0] = 0;
                this.len = 1;
                this.eof = true;
            }
            this.inf.setInput(this.buf, 0, this.len);
        }

        @Override
        public int available() throws IOException {
            if (this.closeRequested) {
                return 0;
            }
            long avail = ((ZipFileInputStream)this.in).size() - this.inf.getBytesWritten();
            return avail > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)avail;
        }
    }

    private class ZipEntryIterator<T extends ZipEntry>
    implements Enumeration<T>,
    Iterator<T> {
        private int i = 0;
        private final int entryCount;

        public ZipEntryIterator(int entryCount) {
            this.entryCount = entryCount;
        }

        @Override
        public boolean hasMoreElements() {
            return this.hasNext();
        }

        @Override
        public boolean hasNext() {
            return this.i < this.entryCount;
        }

        @Override
        public T nextElement() {
            return (T)this.next();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T next() {
            ZipFile zipFile = ZipFile.this;
            synchronized (zipFile) {
                ZipFile.this.ensureOpen();
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return (T)ZipFile.this.getZipEntry(null, ZipFile.this.res.zsrc.getEntryPos(this.i++ * 3));
            }
        }

        @Override
        public Iterator<T> asIterator() {
            return this;
        }
    }

    private class EntrySpliterator<T>
    extends Spliterators.AbstractSpliterator<T> {
        private int index;
        private final int fence;
        private final IntFunction<T> gen;

        EntrySpliterator(int index, int fence, IntFunction<T> gen) {
            super(fence, 1297);
            this.index = index;
            this.fence = fence;
            this.gen = gen;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.index >= 0 && this.index < this.fence) {
                ZipFile zipFile = ZipFile.this;
                synchronized (zipFile) {
                    ZipFile.this.ensureOpen();
                    action.accept(this.gen.apply(ZipFile.this.res.zsrc.getEntryPos(this.index++ * 3)));
                }
                return true;
            }
            return false;
        }
    }

    private static class InflaterCleanupAction
    implements Runnable {
        private final Inflater inf;
        private final CleanableResource res;

        InflaterCleanupAction(Inflater inf, CleanableResource res) {
            this.inf = inf;
            this.res = res;
        }

        @Override
        public void run() {
            this.res.releaseInflater(this.inf);
        }
    }
}

