/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.nio.ByteBuffer;
import java.nio.file.attribute.FileTime;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import jdk.internal.loader.BootLoader;
import jdk.internal.misc.Unsafe;

class ZipUtils {
    private static final long WINDOWS_EPOCH_IN_MICROSECONDS = -11644473600000000L;
    public static final long WINDOWS_TIME_NOT_AVAILABLE = Long.MIN_VALUE;
    static final ByteBuffer defaultBuf = ByteBuffer.allocate(0);
    public static final long UPPER_UNIXTIME_BOUND = Integer.MAX_VALUE;
    static final int FILE_ATTRIBUTES_UNIX = 3;
    static final int VERSION_MADE_BY_BASE_UNIX = 768;
    static final long END_MAXLEN = 65557L;
    static final int READBLOCKSZ = 128;
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final long byteBufferArrayOffset = unsafe.objectFieldOffset(ByteBuffer.class, "hb");
    private static final long byteBufferOffsetOffset = unsafe.objectFieldOffset(ByteBuffer.class, "offset");

    ZipUtils() {
    }

    public static final FileTime winTimeToFileTime(long wtime) {
        return FileTime.from(wtime / 10L + -11644473600000000L, TimeUnit.MICROSECONDS);
    }

    public static final long fileTimeToWinTime(FileTime ftime) {
        return (ftime.to(TimeUnit.MICROSECONDS) - -11644473600000000L) * 10L;
    }

    public static final FileTime unixTimeToFileTime(long utime) {
        return FileTime.from(utime, TimeUnit.SECONDS);
    }

    public static final long fileTimeToUnixTime(FileTime ftime) {
        return ftime.to(TimeUnit.SECONDS);
    }

    public static long dosToJavaTime(long dtime) {
        int year = (int)((dtime >> 25 & 0x7FL) + 1980L);
        int month = (int)(dtime >> 21 & 0xFL);
        int day = (int)(dtime >> 16 & 0x1FL);
        int hour = (int)(dtime >> 11 & 0x1FL);
        int minute = (int)(dtime >> 5 & 0x3FL);
        int second = (int)(dtime << 1 & 0x3EL);
        if (month > 0 && month < 13 && day > 0 && hour < 24 && minute < 60 && second < 60) {
            try {
                LocalDateTime ldt = LocalDateTime.of(year, month, day, hour, minute, second);
                return TimeUnit.MILLISECONDS.convert(ldt.toEpochSecond(ZoneId.systemDefault().getRules().getOffset(ldt)), TimeUnit.SECONDS);
            }
            catch (DateTimeException dateTimeException) {
                // empty catch block
            }
        }
        return ZipUtils.overflowDosToJavaTime(year, month, day, hour, minute, second);
    }

    private static long overflowDosToJavaTime(int year, int month, int day, int hour, int minute, int second) {
        return new Date(year - 1900, month - 1, day, hour, minute, second).getTime();
    }

    public static long extendedDosToJavaTime(long xdostime) {
        long time = ZipUtils.dosToJavaTime(xdostime);
        return time + (xdostime >> 32);
    }

    private static long javaToDosTime(LocalDateTime ldt) {
        int year = ldt.getYear() - 1980;
        return (long)(year << 25 | ldt.getMonthValue() << 21 | ldt.getDayOfMonth() << 16 | ldt.getHour() << 11 | ldt.getMinute() << 5 | ldt.getSecond() >> 1) & 0xFFFFFFFFL;
    }

    static long javaToExtendedDosTime(long time) {
        LocalDateTime ldt = ZipUtils.javaEpochToLocalDateTime(time);
        if (ldt.getYear() >= 1980) {
            return ZipUtils.javaToDosTime(ldt) + (time % 2000L << 32);
        }
        return 0x210000L;
    }

    static LocalDateTime javaEpochToLocalDateTime(long time) {
        Instant instant = Instant.ofEpochMilli(time);
        return LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
    }

    public static final int get16(byte[] b, int off) {
        return b[off] & 0xFF | (b[off + 1] & 0xFF) << 8;
    }

    public static final long get32(byte[] b, int off) {
        return ((long)ZipUtils.get16(b, off) | (long)ZipUtils.get16(b, off + 2) << 16) & 0xFFFFFFFFL;
    }

    public static final long get64(byte[] b, int off) {
        return ZipUtils.get32(b, off) | ZipUtils.get32(b, off + 4) << 32;
    }

    public static final int get32S(byte[] b, int off) {
        return ZipUtils.get16(b, off) | ZipUtils.get16(b, off + 2) << 16;
    }

    static final int CH(byte[] b, int n) {
        return b[n] & 0xFF;
    }

    static final int SH(byte[] b, int n) {
        return b[n] & 0xFF | (b[n + 1] & 0xFF) << 8;
    }

    static final long LG(byte[] b, int n) {
        return (long)(ZipUtils.SH(b, n) | ZipUtils.SH(b, n + 2) << 16) & 0xFFFFFFFFL;
    }

    static final long LL(byte[] b, int n) {
        return ZipUtils.LG(b, n) | ZipUtils.LG(b, n + 4) << 32;
    }

    static final long GETSIG(byte[] b) {
        return ZipUtils.LG(b, 0);
    }

    static final long LOCSIG(byte[] b) {
        return ZipUtils.LG(b, 0);
    }

    static final int LOCVER(byte[] b) {
        return ZipUtils.SH(b, 4);
    }

    static final int LOCFLG(byte[] b) {
        return ZipUtils.SH(b, 6);
    }

    static final int LOCHOW(byte[] b) {
        return ZipUtils.SH(b, 8);
    }

    static final long LOCTIM(byte[] b) {
        return ZipUtils.LG(b, 10);
    }

    static final long LOCCRC(byte[] b) {
        return ZipUtils.LG(b, 14);
    }

    static final long LOCSIZ(byte[] b) {
        return ZipUtils.LG(b, 18);
    }

    static final long LOCLEN(byte[] b) {
        return ZipUtils.LG(b, 22);
    }

    static final int LOCNAM(byte[] b) {
        return ZipUtils.SH(b, 26);
    }

    static final int LOCEXT(byte[] b) {
        return ZipUtils.SH(b, 28);
    }

    static final long EXTCRC(byte[] b) {
        return ZipUtils.LG(b, 4);
    }

    static final long EXTSIZ(byte[] b) {
        return ZipUtils.LG(b, 8);
    }

    static final long EXTLEN(byte[] b) {
        return ZipUtils.LG(b, 12);
    }

    static final int ENDSUB(byte[] b) {
        return ZipUtils.SH(b, 8);
    }

    static final int ENDTOT(byte[] b) {
        return ZipUtils.SH(b, 10);
    }

    static final long ENDSIZ(byte[] b) {
        return ZipUtils.LG(b, 12);
    }

    static final long ENDOFF(byte[] b) {
        return ZipUtils.LG(b, 16);
    }

    static final int ENDCOM(byte[] b) {
        return ZipUtils.SH(b, 20);
    }

    static final int ENDCOM(byte[] b, int off) {
        return ZipUtils.SH(b, off + 20);
    }

    static final long ZIP64_ENDTOD(byte[] b) {
        return ZipUtils.LL(b, 24);
    }

    static final long ZIP64_ENDTOT(byte[] b) {
        return ZipUtils.LL(b, 32);
    }

    static final long ZIP64_ENDSIZ(byte[] b) {
        return ZipUtils.LL(b, 40);
    }

    static final long ZIP64_ENDOFF(byte[] b) {
        return ZipUtils.LL(b, 48);
    }

    static final long ZIP64_LOCOFF(byte[] b) {
        return ZipUtils.LL(b, 8);
    }

    static final long CENSIG(byte[] b, int pos) {
        return ZipUtils.LG(b, pos + 0);
    }

    static final int CENVEM(byte[] b, int pos) {
        return ZipUtils.SH(b, pos + 4);
    }

    static final int CENVEM_FA(byte[] b, int pos) {
        return ZipUtils.CH(b, pos + 5);
    }

    static final int CENVER(byte[] b, int pos) {
        return ZipUtils.SH(b, pos + 6);
    }

    static final int CENFLG(byte[] b, int pos) {
        return ZipUtils.SH(b, pos + 8);
    }

    static final int CENHOW(byte[] b, int pos) {
        return ZipUtils.SH(b, pos + 10);
    }

    static final long CENTIM(byte[] b, int pos) {
        return ZipUtils.LG(b, pos + 12);
    }

    static final long CENCRC(byte[] b, int pos) {
        return ZipUtils.LG(b, pos + 16);
    }

    static final long CENSIZ(byte[] b, int pos) {
        return ZipUtils.LG(b, pos + 20);
    }

    static final long CENLEN(byte[] b, int pos) {
        return ZipUtils.LG(b, pos + 24);
    }

    static final int CENNAM(byte[] b, int pos) {
        return ZipUtils.SH(b, pos + 28);
    }

    static final int CENEXT(byte[] b, int pos) {
        return ZipUtils.SH(b, pos + 30);
    }

    static final int CENCOM(byte[] b, int pos) {
        return ZipUtils.SH(b, pos + 32);
    }

    static final int CENDSK(byte[] b, int pos) {
        return ZipUtils.SH(b, pos + 34);
    }

    static final int CENATT(byte[] b, int pos) {
        return ZipUtils.SH(b, pos + 36);
    }

    static final long CENATX(byte[] b, int pos) {
        return ZipUtils.LG(b, pos + 38);
    }

    static final int CENATX_PERMS(byte[] b, int pos) {
        return ZipUtils.SH(b, pos + 40);
    }

    static final long CENOFF(byte[] b, int pos) {
        return ZipUtils.LG(b, pos + 42);
    }

    static void loadLibrary() {
        BootLoader.loadLibrary("zip");
    }

    static byte[] getBufferArray(ByteBuffer byteBuffer) {
        return (byte[])unsafe.getReference(byteBuffer, byteBufferArrayOffset);
    }

    static int getBufferOffset(ByteBuffer byteBuffer) {
        return unsafe.getInt(byteBuffer, byteBufferOffsetOffset);
    }
}

