/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NullCipher;
import javax.crypto.ShortBufferException;

public class CipherInputStream
extends FilterInputStream {
    private Cipher cipher;
    private InputStream input;
    private byte[] ibuffer = new byte[512];
    private boolean done = false;
    private byte[] obuffer = null;
    private int ostart = 0;
    private int ofinish = 0;
    private boolean closed = false;

    private void ensureCapacity(int inLen) {
        int minLen = this.cipher.getOutputSize(inLen);
        if (this.obuffer == null || this.obuffer.length < minLen) {
            this.obuffer = new byte[minLen];
        }
        this.ostart = 0;
        this.ofinish = 0;
    }

    private int getMoreData() throws IOException {
        if (this.done) {
            return -1;
        }
        int readin = this.input.read(this.ibuffer);
        if (readin == -1) {
            this.done = true;
            this.ensureCapacity(0);
            try {
                this.ofinish = this.cipher.doFinal(this.obuffer, 0);
            }
            catch (BadPaddingException | IllegalBlockSizeException | ShortBufferException e) {
                throw new IOException(e);
            }
            if (this.ofinish == 0) {
                return -1;
            }
            return this.ofinish;
        }
        this.ensureCapacity(readin);
        try {
            this.ofinish = this.cipher.update(this.ibuffer, 0, readin, this.obuffer, this.ostart);
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (ShortBufferException e) {
            throw new IOException(e);
        }
        return this.ofinish;
    }

    public CipherInputStream(InputStream is, Cipher c) {
        super(is);
        this.input = is;
        this.cipher = c;
    }

    protected CipherInputStream(InputStream is) {
        super(is);
        this.input = is;
        this.cipher = new NullCipher();
    }

    @Override
    public int read() throws IOException {
        if (this.ostart >= this.ofinish) {
            int i = 0;
            while (i == 0) {
                i = this.getMoreData();
            }
            if (i == -1) {
                return -1;
            }
        }
        return this.obuffer[this.ostart++] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.ostart >= this.ofinish) {
            int i = 0;
            while (i == 0) {
                i = this.getMoreData();
            }
            if (i == -1) {
                return -1;
            }
        }
        if (len <= 0) {
            return 0;
        }
        int available = this.ofinish - this.ostart;
        if (len < available) {
            available = len;
        }
        if (b != null) {
            System.arraycopy(this.obuffer, this.ostart, b, off, available);
        }
        this.ostart += available;
        return available;
    }

    @Override
    public long skip(long n) throws IOException {
        int available = this.ofinish - this.ostart;
        if (n > (long)available) {
            n = available;
        }
        if (n < 0L) {
            return 0L;
        }
        this.ostart = (int)((long)this.ostart + n);
        return n;
    }

    @Override
    public int available() throws IOException {
        return this.ofinish - this.ostart;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.input.close();
        if (!this.done) {
            this.ensureCapacity(0);
            try {
                this.cipher.doFinal(this.obuffer, 0);
            }
            catch (BadPaddingException | IllegalBlockSizeException | ShortBufferException generalSecurityException) {
                // empty catch block
            }
        }
        this.obuffer = null;
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

