/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NullCipher;
import javax.crypto.ShortBufferException;

public class CipherOutputStream
extends FilterOutputStream {
    private Cipher cipher;
    private OutputStream output;
    private byte[] ibuffer = new byte[1];
    private byte[] obuffer = null;
    private boolean closed = false;

    private void ensureCapacity(int inLen) {
        int minLen = this.cipher.getOutputSize(inLen);
        if (this.obuffer == null || this.obuffer.length < minLen) {
            this.obuffer = new byte[minLen];
        }
    }

    public CipherOutputStream(OutputStream os, Cipher c) {
        super(os);
        this.output = os;
        this.cipher = c;
    }

    protected CipherOutputStream(OutputStream os) {
        super(os);
        this.output = os;
        this.cipher = new NullCipher();
    }

    @Override
    public void write(int b) throws IOException {
        this.ibuffer[0] = (byte)b;
        this.ensureCapacity(1);
        try {
            int ostored = this.cipher.update(this.ibuffer, 0, 1, this.obuffer);
            if (ostored > 0) {
                this.output.write(this.obuffer, 0, ostored);
            }
        }
        catch (ShortBufferException sbe) {
            throw new IOException(sbe);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.ensureCapacity(len);
        try {
            int ostored = this.cipher.update(b, off, len, this.obuffer);
            if (ostored > 0) {
                this.output.write(this.obuffer, 0, ostored);
            }
        }
        catch (ShortBufferException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void flush() throws IOException {
        this.output.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.ensureCapacity(0);
        try {
            int ostored = this.cipher.doFinal(this.obuffer, 0);
            if (ostored > 0) {
                this.output.write(this.obuffer, 0, ostored);
            }
        }
        catch (BadPaddingException | IllegalBlockSizeException | ShortBufferException generalSecurityException) {
            // empty catch block
        }
        this.obuffer = null;
        try {
            this.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.output.close();
    }
}

