/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.Provider;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.CryptoAllPermission;
import javax.crypto.CryptoPermissions;
import javax.crypto.ProviderVerifier;
import sun.security.jca.GetInstance;
import sun.security.util.Debug;

final class JceSecurity {
    private static final Debug debug = Debug.getInstance("jca");
    private static CryptoPermissions defaultPolicy = null;
    private static CryptoPermissions exemptPolicy = null;
    private static final Map<IdentityWrapper, Object> verificationResults = new ConcurrentHashMap<IdentityWrapper, Object>();
    private static final Map<Provider, Object> verifyingProviders = new IdentityHashMap<Provider, Object>();
    private static final boolean isRestricted;
    private static final Object PROVIDER_VERIFIED;
    private static final URL NULL_URL;
    private static final Map<Class<?>, URL> codeBaseCacheRef;

    private JceSecurity() {
    }

    static GetInstance.Instance getInstance(String type, Class<?> clazz, String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        Provider.Service s = GetInstance.getService(type, algorithm, provider);
        Exception ve = JceSecurity.getVerificationResult(s.getProvider());
        if (ve != null) {
            String msg = "JCE cannot authenticate the provider " + provider;
            throw (NoSuchProviderException)new NoSuchProviderException(msg).initCause(ve);
        }
        return GetInstance.getInstance(s, clazz);
    }

    static GetInstance.Instance getInstance(String type, Class<?> clazz, String algorithm, Provider provider) throws NoSuchAlgorithmException {
        Provider.Service s = GetInstance.getService(type, algorithm, provider);
        Exception ve = JceSecurity.getVerificationResult(provider);
        if (ve != null) {
            String msg = "JCE cannot authenticate the provider " + provider.getName();
            throw new SecurityException(msg, ve);
        }
        return GetInstance.getInstance(s, clazz);
    }

    static GetInstance.Instance getInstance(String type, Class<?> clazz, String algorithm) throws NoSuchAlgorithmException {
        List<Provider.Service> services = GetInstance.getServices(type, algorithm);
        NoSuchAlgorithmException failure = null;
        for (Provider.Service s : services) {
            if (!JceSecurity.canUseProvider(s.getProvider())) continue;
            try {
                GetInstance.Instance instance = GetInstance.getInstance(s, clazz);
                return instance;
            }
            catch (NoSuchAlgorithmException e) {
                failure = e;
            }
        }
        throw new NoSuchAlgorithmException("Algorithm " + algorithm + " not available", failure);
    }

    static CryptoPermissions verifyExemptJar(URL codeBase) throws Exception {
        ProviderVerifier pv = new ProviderVerifier(codeBase, true);
        pv.verify();
        return pv.getPermissions();
    }

    static void verifyProvider(URL codeBase, Provider p) throws Exception {
        ProviderVerifier pv = new ProviderVerifier(codeBase, p, false);
        pv.verify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static Exception getVerificationResult(Provider p) {
        IdentityWrapper pKey = new IdentityWrapper(p);
        Object o = verificationResults.get(pKey);
        if (o == null) {
            Class<JceSecurity> clazz = JceSecurity.class;
            // MONITORENTER : javax.crypto.JceSecurity.class
            o = verificationResults.get(pKey);
            if (o == null) {
                if (verifyingProviders.get(p) != null) {
                    // MONITOREXIT : clazz
                    return new NoSuchProviderException("Recursion during verification");
                }
                try {
                    verifyingProviders.put(p, Boolean.FALSE);
                    URL providerURL = JceSecurity.getCodeBase(p.getClass());
                    JceSecurity.verifyProvider(providerURL, p);
                    o = PROVIDER_VERIFIED;
                }
                catch (Exception e) {
                    o = e;
                }
                finally {
                    verifyingProviders.remove(p);
                }
                verificationResults.put(pKey, o);
                if (debug != null) {
                    debug.println("Provider " + p.getName() + " verification result: " + o);
                }
            }
            // MONITOREXIT : clazz
        }
        if (o == PROVIDER_VERIFIED) {
            return null;
        }
        Exception exception = (Exception)o;
        return exception;
    }

    static boolean canUseProvider(Provider p) {
        return JceSecurity.getVerificationResult(p) == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static URL getCodeBase(final Class<?> clazz) {
        Map<Class<?>, URL> map = codeBaseCacheRef;
        synchronized (map) {
            URL url = codeBaseCacheRef.get(clazz);
            if (url == null) {
                url = AccessController.doPrivileged(new PrivilegedAction<URL>(){

                    @Override
                    public URL run() {
                        CodeSource cs;
                        ProtectionDomain pd = clazz.getProtectionDomain();
                        if (pd != null && (cs = pd.getCodeSource()) != null) {
                            return cs.getLocation();
                        }
                        return NULL_URL;
                    }
                });
                codeBaseCacheRef.put(clazz, url);
            }
            return url == NULL_URL ? null : url;
        }
    }

    /*
     * Exception decompiling
     */
    private static void setupJurisdictionPolicies() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static CryptoPermissions getDefaultPolicy() {
        return defaultPolicy;
    }

    static CryptoPermissions getExemptPolicy() {
        return exemptPolicy;
    }

    static boolean isRestricted() {
        return isRestricted;
    }

    static {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Void run() throws Exception {
                    JceSecurity.setupJurisdictionPolicies();
                    return null;
                }
            });
            isRestricted = !defaultPolicy.implies(CryptoAllPermission.INSTANCE);
        }
        catch (Exception e) {
            throw new SecurityException("Can not initialize cryptographic mechanism", e);
        }
        PROVIDER_VERIFIED = Boolean.TRUE;
        try {
            NULL_URL = new URL("http://null.oracle.com/");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        codeBaseCacheRef = new WeakHashMap();
    }

    private static final class IdentityWrapper {
        final Provider obj;

        IdentityWrapper(Provider obj) {
            this.obj = obj;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IdentityWrapper)) {
                return false;
            }
            return this.obj == ((IdentityWrapper)o).obj;
        }

        public int hashCode() {
            return System.identityHashCode(this.obj);
        }
    }
}

