/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.cert.Certificate;
import java.util.jar.JarEntry;
import java.util.jar.JarException;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import javax.crypto.CryptoPermissions;

final class ProviderVerifier {
    private URL jarURL;
    private Provider provider;
    private boolean savePerms;
    private CryptoPermissions appPerms = null;

    ProviderVerifier(URL jarURL, boolean savePerms) {
        this(jarURL, null, savePerms);
    }

    ProviderVerifier(URL jarURL, Provider provider, boolean savePerms) {
        this.jarURL = jarURL;
        this.provider = provider;
        this.savePerms = savePerms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void verify() throws IOException {
        block10: {
            if (!this.savePerms) {
                return;
            }
            final URL url = this.jarURL.getProtocol().equalsIgnoreCase("jar") ? this.jarURL : new URL("jar:" + this.jarURL.toString() + "!/");
            try (ZipFile jf = null;){
                try {
                    JarFile tmp = AccessController.doPrivileged(new PrivilegedExceptionAction<JarFile>(){

                        @Override
                        public JarFile run() throws Exception {
                            JarURLConnection conn = (JarURLConnection)url.openConnection();
                            conn.setUseCaches(false);
                            return conn.getJarFile();
                        }
                    });
                    jf = tmp;
                }
                catch (PrivilegedActionException pae) {
                    throw new SecurityException("Cannot load " + url.toString(), pae.getCause());
                }
                if (jf == null) break block10;
                JarEntry je = ((JarFile)jf).getJarEntry("cryptoPerms");
                if (je == null) {
                    throw new JarException("Can not find cryptoPerms");
                }
                try {
                    this.appPerms = new CryptoPermissions();
                    this.appPerms.load(((JarFile)jf).getInputStream(je));
                }
                catch (Exception ex) {
                    JarException jex = new JarException("Cannot load/parse" + this.jarURL.toString());
                    jex.initCause(ex);
                    throw jex;
                }
            }
        }
    }

    static void verifyPolicySigned(Certificate[] certs) throws Exception {
    }

    static boolean isTrustedCryptoProvider(Provider provider) {
        return false;
    }

    CryptoPermissions getPermissions() {
        return this.appPerms;
    }
}

