/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.crypto.JceSecurity;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import sun.security.jca.GetInstance;

public class SecretKeyFactory {
    private Provider provider;
    private final String algorithm;
    private volatile SecretKeyFactorySpi spi;
    private final Object lock = new Object();
    private Iterator<Provider.Service> serviceIterator;

    protected SecretKeyFactory(SecretKeyFactorySpi keyFacSpi, Provider provider, String algorithm) {
        this.spi = keyFacSpi;
        this.provider = provider;
        this.algorithm = algorithm;
    }

    private SecretKeyFactory(String algorithm) throws NoSuchAlgorithmException {
        this.algorithm = algorithm;
        List<Provider.Service> list = GetInstance.getServices("SecretKeyFactory", algorithm);
        this.serviceIterator = list.iterator();
        if (this.nextSpi(null) == null) {
            throw new NoSuchAlgorithmException(algorithm + " SecretKeyFactory not available");
        }
    }

    public static final SecretKeyFactory getInstance(String algorithm) throws NoSuchAlgorithmException {
        Objects.requireNonNull(algorithm, "null algorithm name");
        return new SecretKeyFactory(algorithm);
    }

    public static final SecretKeyFactory getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        Objects.requireNonNull(algorithm, "null algorithm name");
        GetInstance.Instance instance = JceSecurity.getInstance("SecretKeyFactory", SecretKeyFactorySpi.class, algorithm, provider);
        return new SecretKeyFactory((SecretKeyFactorySpi)instance.impl, instance.provider, algorithm);
    }

    public static final SecretKeyFactory getInstance(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        Objects.requireNonNull(algorithm, "null algorithm name");
        GetInstance.Instance instance = JceSecurity.getInstance("SecretKeyFactory", SecretKeyFactorySpi.class, algorithm, provider);
        return new SecretKeyFactory((SecretKeyFactorySpi)instance.impl, instance.provider, algorithm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Provider getProvider() {
        Object object2 = this.lock;
        synchronized (object2) {
            this.serviceIterator = null;
            return this.provider;
        }
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SecretKeyFactorySpi nextSpi(SecretKeyFactorySpi oldSpi) {
        Object object2 = this.lock;
        synchronized (object2) {
            if (oldSpi != null && oldSpi != this.spi) {
                return this.spi;
            }
            if (this.serviceIterator == null) {
                return null;
            }
            while (this.serviceIterator.hasNext()) {
                Provider.Service s = this.serviceIterator.next();
                if (!JceSecurity.canUseProvider(s.getProvider())) continue;
                try {
                    Object obj = s.newInstance(null);
                    if (!(obj instanceof SecretKeyFactorySpi)) continue;
                    SecretKeyFactorySpi spi = (SecretKeyFactorySpi)obj;
                    this.provider = s.getProvider();
                    this.spi = spi;
                    return spi;
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                }
            }
            this.serviceIterator = null;
            return null;
        }
    }

    public final SecretKey generateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        if (this.serviceIterator == null) {
            return this.spi.engineGenerateSecret(keySpec);
        }
        Exception failure = null;
        SecretKeyFactorySpi mySpi = this.spi;
        while (true) {
            try {
                return mySpi.engineGenerateSecret(keySpec);
            }
            catch (Exception e) {
                if (failure != null) continue;
                failure = e;
                if ((mySpi = this.nextSpi(mySpi)) != null) continue;
                if (failure instanceof InvalidKeySpecException) {
                    throw (InvalidKeySpecException)failure;
                }
                throw new InvalidKeySpecException("Could not generate secret key", failure);
            }
            break;
        }
    }

    public final KeySpec getKeySpec(SecretKey key, Class<?> keySpec) throws InvalidKeySpecException {
        if (this.serviceIterator == null) {
            return this.spi.engineGetKeySpec(key, keySpec);
        }
        Exception failure = null;
        SecretKeyFactorySpi mySpi = this.spi;
        while (true) {
            try {
                return mySpi.engineGetKeySpec(key, keySpec);
            }
            catch (Exception e) {
                if (failure != null) continue;
                failure = e;
                if ((mySpi = this.nextSpi(mySpi)) != null) continue;
                if (failure instanceof InvalidKeySpecException) {
                    throw (InvalidKeySpecException)failure;
                }
                throw new InvalidKeySpecException("Could not get key spec", failure);
            }
            break;
        }
    }

    public final SecretKey translateKey(SecretKey key) throws InvalidKeyException {
        if (this.serviceIterator == null) {
            return this.spi.engineTranslateKey(key);
        }
        Exception failure = null;
        SecretKeyFactorySpi mySpi = this.spi;
        while (true) {
            try {
                return mySpi.engineTranslateKey(key);
            }
            catch (Exception e) {
                if (failure != null) continue;
                failure = e;
                if ((mySpi = this.nextSpi(mySpi)) != null) continue;
                if (failure instanceof InvalidKeyException) {
                    throw (InvalidKeyException)failure;
                }
                throw new InvalidKeyException("Could not translate key", failure);
            }
            break;
        }
    }
}

