/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

public class SSLEngineResult {
    private final Status status;
    private final HandshakeStatus handshakeStatus;
    private final int bytesConsumed;
    private final int bytesProduced;
    private final long sequenceNumber;

    public SSLEngineResult(Status status, HandshakeStatus handshakeStatus, int bytesConsumed, int bytesProduced) {
        this(status, handshakeStatus, bytesConsumed, bytesProduced, -1L);
    }

    public SSLEngineResult(Status status, HandshakeStatus handshakeStatus, int bytesConsumed, int bytesProduced, long sequenceNumber) {
        if (status == null || handshakeStatus == null || bytesConsumed < 0 || bytesProduced < 0) {
            throw new IllegalArgumentException("Invalid Parameter(s)");
        }
        this.status = status;
        this.handshakeStatus = handshakeStatus;
        this.bytesConsumed = bytesConsumed;
        this.bytesProduced = bytesProduced;
        this.sequenceNumber = sequenceNumber;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final HandshakeStatus getHandshakeStatus() {
        return this.handshakeStatus;
    }

    public final int bytesConsumed() {
        return this.bytesConsumed;
    }

    public final int bytesProduced() {
        return this.bytesProduced;
    }

    public final long sequenceNumber() {
        return this.sequenceNumber;
    }

    public String toString() {
        return "Status = " + (Object)((Object)this.status) + " HandshakeStatus = " + (Object)((Object)this.handshakeStatus) + "\nbytesConsumed = " + this.bytesConsumed + " bytesProduced = " + this.bytesProduced + (this.sequenceNumber == -1L ? "" : " sequenceNumber = " + Long.toUnsignedString(this.sequenceNumber));
    }

    public static enum Status {
        BUFFER_UNDERFLOW,
        BUFFER_OVERFLOW,
        OK,
        CLOSED;

    }

    public static enum HandshakeStatus {
        NOT_HANDSHAKING,
        FINISHED,
        NEED_TASK,
        NEED_WRAP,
        NEED_UNWRAP,
        NEED_UNWRAP_AGAIN;

    }
}

