/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import java.security.NoSuchAlgorithmException;
import javax.net.ServerSocketFactory;
import javax.net.ssl.DefaultSSLServerSocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;

public abstract class SSLServerSocketFactory
extends ServerSocketFactory {
    protected SSLServerSocketFactory() {
    }

    public static ServerSocketFactory getDefault() {
        if (DefaultFactoryHolder.defaultFactory != null) {
            return DefaultFactoryHolder.defaultFactory;
        }
        try {
            return SSLContext.getDefault().getServerSocketFactory();
        }
        catch (UnsupportedOperationException | NoSuchAlgorithmException e) {
            return new DefaultSSLServerSocketFactory(e);
        }
    }

    public abstract String[] getDefaultCipherSuites();

    public abstract String[] getSupportedCipherSuites();

    private static final class DefaultFactoryHolder {
        private static final SSLServerSocketFactory defaultFactory;

        private DefaultFactoryHolder() {
        }

        private static void log(String msg) {
            if (SSLSocketFactory.DEBUG) {
                System.out.println(msg);
            }
        }

        static {
            SSLServerSocketFactory mediator = null;
            String clsName = SSLSocketFactory.getSecurityProperty("ssl.ServerSocketFactory.provider");
            if (clsName != null) {
                DefaultFactoryHolder.log("setting up default SSLServerSocketFactory");
                try {
                    Class<?> cls;
                    block5: {
                        cls = null;
                        try {
                            cls = Class.forName(clsName);
                        }
                        catch (ClassNotFoundException e) {
                            ClassLoader cl = ClassLoader.getSystemClassLoader();
                            if (cl == null) break block5;
                            cls = cl.loadClass(clsName);
                        }
                    }
                    DefaultFactoryHolder.log("class " + clsName + " is loaded");
                    mediator = (SSLServerSocketFactory)cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    DefaultFactoryHolder.log("instantiated an instance of class " + clsName);
                }
                catch (Exception e) {
                    DefaultFactoryHolder.log("SSLServerSocketFactory instantiation failed: " + e);
                    mediator = new DefaultSSLServerSocketFactory(e);
                }
            }
            defaultFactory = mediator;
        }
    }
}

